/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.dialogs;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.gui.dialogs.IPatternValidation;
import com.blixx.boom.gui.dialogs.ShowMessageDialog;
import com.blixx.boom.gui.utils.PatternMatching;
import com.blixx.log.RTLogger;
import com.blixx.shared.PatternB;
import com.blixx.shared.PatternMatchResult;
import com.blixx.shared.utils.HelperThread;
import java.text.DecimalFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class HelperJob
extends UIJob {
    TableItem m_ti = null;
    Table m_table = null;
    int m_row = 0;
    PatternB m_patternObj = null;
    IPatternValidation m_gp = null;
    String m_dialog = null;
    DecimalFormat m_formatter = new DecimalFormat("###,###");
    int m_seqNo = 0;

    public HelperJob(String name, TableItem ti, PatternB pattern) {
        super(name);
        this.m_ti = ti;
        this.m_patternObj = pattern;
    }

    public HelperJob(String name, TableItem ti, PatternB pattern, int seq) {
        super(name);
        this.m_ti = ti;
        this.m_patternObj = pattern;
        this.m_seqNo = seq;
    }

    public HelperJob(String name, int row, Table table, PatternB pattern, IPatternValidation main, String dialog) {
        super(name);
        this.m_row = row;
        this.m_table = table;
        this.m_patternObj = pattern;
        this.m_gp = main;
        this.m_dialog = dialog;
    }

    @Override
    public IStatus runInUIThread(IProgressMonitor monitor) {
        String expectedPattern = null;
        try {
            if (this.m_patternObj == null) {
                throw new RuntimeException("Pattern is not set");
            }
            if (this.m_gp != null) {
                expectedPattern = this.m_patternObj.getOvPattern();
                if (expectedPattern.startsWith("java=")) {
                    expectedPattern = this.m_patternObj.getJavaPattern();
                }
                if (this.m_gp.isCanceled() || !this.m_gp.getPattern().equals(expectedPattern)) {
                    ProgressBar pb = this.m_gp.getProgressBar();
                    if (pb != null) {
                        pb.setSelection(0);
                        pb.setEnabled(false);
                    }
                    this.m_gp.setStopped();
                    return Status.OK_STATUS;
                }
                ProgressBar pb = this.m_gp.getProgressBar();
                if (pb != null) {
                    pb.setSelection(this.m_row);
                }
            }
            if (this.m_table != null) {
                this.m_ti = this.m_table.getItem(this.m_row);
            }
            String line = this.m_ti.getText(PatternMatching.COLUMN_TEXT);
            HelperThread ht = new HelperThread(this.m_patternObj, line);
            ht.start();
            int count = 0;
            while (!ht.m_finished && count < 3000) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
                ++count;
            }
            if (!ht.m_finished) {
                RTLogger.print(5, "Interrupt pattern matching. " + expectedPattern);
                ht.interrupt();
                ht.m_processingTime = -1L;
                this.m_ti.setText(PatternMatching.COLUMN_PROCESSING_TIME, this.m_formatter.format(ht.m_processingTime));
                ShowMessageDialog sb = new ShowMessageDialog(Display.getCurrent().getActiveShell(), "Timeout", "Pattern matching takes more than 3 sec! \nPlease simplify the pattern \nor reduce number of capturing groups.", line, null, this.m_table != null, "Continue");
                sb.open();
                if (sb.getReturnCode() != 0) {
                    if (this.m_gp != null) {
                        ProgressBar pb = this.m_gp.getProgressBar();
                        if (pb != null) {
                            pb.setSelection(0);
                            pb.setEnabled(false);
                        }
                        this.m_gp.setStopped();
                    }
                    return Status.OK_STATUS;
                }
                this.m_ti.setData(PatternMatchResult.class.getName(), null);
            } else {
                this.m_ti.setData(PatternMatchResult.class.getName(), (Object)ht.m_match);
            }
            long pTime = ht.m_processingTime;
            if (this.m_seqNo != 0) {
                if (ht.m_match != null && ht.m_match.isMatch()) {
                    String seqNr = Integer.toString(this.m_seqNo);
                    String seqNrs = this.m_ti.getText(PatternMatching.COLUMN_PROCESSING_TIME);
                    StringBuffer sb = new StringBuffer();
                    if (seqNrs != "") {
                        if (seqNrs.contains(seqNr)) {
                            sb.append(seqNrs);
                        } else {
                            sb.append(seqNrs).append(",").append(seqNr);
                        }
                    } else {
                        sb.append(seqNr);
                    }
                    String sbString = sb.toString();
                    this.m_ti.setText(PatternMatching.COLUMN_PROCESSING_TIME, sbString);
                }
            } else {
                this.m_ti.setText(PatternMatching.COLUMN_PROCESSING_TIME, this.m_formatter.format(pTime));
            }
            if (ht.m_match != null && ht.m_match.isMatch()) {
                this.m_ti.setImage(0, BMUI.IMAGE_ACCEPT_GREEN);
            } else if (this.m_seqNo != 0) {
                String seqNrs = this.m_ti.getText(PatternMatching.COLUMN_PROCESSING_TIME);
                if (seqNrs != "") {
                    this.m_ti.setImage(0, BMUI.IMAGE_ACCEPT_GREEN);
                } else {
                    this.m_ti.setImage(0, BMUI.IMAGE_CANCEL_ROUND);
                }
            } else {
                this.m_ti.setImage(0, BMUI.IMAGE_CANCEL_ROUND);
            }
            if (this.m_table != null && this.m_row < this.m_table.getItemCount() - 1) {
                HelperJob hj = new HelperJob(this.getName(), this.m_row + 1, this.m_table, this.m_patternObj, this.m_gp, this.m_dialog);
                Repository.getUIJobManager().schedule(hj);
            } else if (this.m_gp != null) {
                ProgressBar pb = this.m_gp.getProgressBar();
                if (pb != null) {
                    pb.setSelection(0);
                    pb.setEnabled(false);
                }
                this.m_gp.setStopped();
            }
        }
        catch (Throwable throwable) {}
        return Status.OK_STATUS;
    }
}

