/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.dialogs;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.EventStatus;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.dialogs.HotspotTableProvider;
import com.blixx.boom.gui.dialogs.IRefreshable;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.utils.HotSpotChart;
import com.blixx.boom.gui.views.MessagesView;
import com.blixx.log.RTLogger;
import com.blixx.shared.SEvent;
import com.blixx.shared.utils.HashMapArray;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class HotSpotDialog2
implements DisposeListener,
SelectionListener,
ShellListener,
IRefreshable,
MouseListener {
    private static final String TOTAL_HOSTS = " hosts";
    private static final String TOTAL_HOST = " host";
    private static final String ONTOP = "ONTOP";
    public static final Color COLOR_WARNING = new Color(139, 163, 199);
    public static final Color COLOR_MINOR = new Color(249, 249, 50);
    public static final Color COLOR_MAJOR = new Color(237, 125, 44);
    public static final Color COLOR_RED = new Color(255, 11, 11);
    private Shell m_shell;
    private Shell m_parentshell;
    private LinkedHashMap<String, List<Integer>> hostsDatasetN;
    private LinkedHashMap<String, List<Integer>> appsDatasetN;
    private LinkedHashMap<String, List<Integer>> objectssDatasetN;
    private LinkedHashMap<String, List<Integer>> msggrpsDatasetN;
    private boolean m_isOnTOP = true;
    private Table m_typeA_table = null;
    private Table m_typeK_table = null;
    private TableViewer m_tv_typeA = null;
    private TableViewer m_tv_typeK = null;
    private HotspotTableProvider m_tableProvider_typeA = null;
    private HotspotTableProvider m_tableProvider_typeK = null;
    private Composite m_availabilityComp;
    private Composite m_kpi_comp;
    private SashForm m_sashForm;
    private ScrolledComposite m_sc_A;
    private ScrolledComposite m_sc_K;
    private ScrolledComposite m_sc = null;
    private Composite m_chartsLeft = null;
    private Composite m_comp1 = null;
    private Composite m_comp2 = null;
    private Composite m_comp_cairo = null;
    private Composite m_typeA_mainComp = null;
    private Composite m_typeA_row = null;
    private Composite m_typeK_mainComp = null;
    private Composite m_typeK_row = null;
    private Label m_top5_label = null;
    private Label m_label = null;
    private Label m_typeA_l1 = null;
    private Label m_typeA_l2 = null;
    private Label m_typeA_line = null;
    private Label m_typeA_total = null;
    private Label m_typeK_l1 = null;
    private Label m_typeK_l2 = null;
    private Label m_typeK_line = null;
    private Label m_typeK_total = null;
    private Button m_onTop_check = null;
    private Button m_typeA_checkSev = null;
    private Button m_typeK_checkSev = null;
    private Group m_typeA_grp = null;
    private Group m_typeK_grp = null;
    private GUIDisplayElements m_gde = null;
    private static String AV = "AV";
    private static String KPI = "KPI";
    private boolean m_AV_displayUnknown = false;
    private boolean m_AV_displayNormal = false;
    private boolean m_AV_displayWarning = true;
    private boolean m_AV_displayMinor = true;
    private boolean m_AV_displayMajor = true;
    private boolean m_AV_displayCritical = true;
    private boolean m_KPI_displayUnknown = false;
    private boolean m_KPI_displayNormal = false;
    private boolean m_KPI_displayWarning = true;
    private boolean m_KPI_displayMinor = true;
    private boolean m_KPI_displayMajor = true;
    private boolean m_KPI_displayCritical = true;
    private static String m_AV_unknown = "m_AV_unknown";
    private static String m_AV_normal = "m_AV_normal";
    private static String m_AV_warning = "m_AV_warning";
    private static String m_AV_minor = "m_AV_minor";
    private static String m_AV_major = "m_AV_major";
    private static String m_AV_critical = "m_AV_critical";
    private static String m_KPI_unknown = "m_KPI_unknown";
    private static String m_KPI_normal = "m_KPI_normal";
    private static String m_KPI_warning = "m_KPI_warning";
    private static String m_KPI_minor = "m_KPI_minor";
    private static String m_KPI_major = "m_KPI_major";
    private static String m_KPI_critical = "m_KPI_critical";
    public static String TV_TYPE = "TV_TYPE";
    private static HotSpotDialog2 m_instance = null;
    public int m_maxColCount = 100;
    private int m_maxElemTypeA_remember = 0;
    private int m_maxElemTypeK_remember = 0;

    private HotSpotDialog2() {
    }

    public static synchronized HotSpotDialog2 getHotSpotDialog2(Shell parentShell, boolean isOnTOP, List<Boolean> list) {
        if (m_instance != null && HotSpotDialog2.m_instance.m_shell != null && !HotSpotDialog2.m_instance.m_shell.isDisposed()) {
            return m_instance;
        }
        m_instance = new HotSpotDialog2();
        int style = 1265;
        if (isOnTOP) {
            style |= 0x4000;
        }
        HotSpotDialog2.m_instance.m_shell = new Shell(Display.getCurrent().getActiveShell(), style);
        HotSpotDialog2.m_instance.m_shell.setLayout((Layout)new GridLayout(1, false));
        HotSpotDialog2.m_instance.m_shell.setSize(760, 460);
        HotSpotDialog2.m_instance.m_shell.setText(" HotSpot");
        HotSpotDialog2.m_instance.m_shell.setImage(BMUI.IMAGE_HOTSPOT);
        HotSpotDialog2.m_instance.m_shell.setBackground(BMUI.color_grey);
        HotSpotDialog2.m_instance.m_parentshell = parentShell;
        HotSpotDialog2.m_instance.m_isOnTOP = isOnTOP;
        if (list != null) {
            HotSpotDialog2.m_instance.m_AV_displayUnknown = list.get(0);
            HotSpotDialog2.m_instance.m_AV_displayNormal = list.get(1);
            HotSpotDialog2.m_instance.m_AV_displayWarning = list.get(2);
            HotSpotDialog2.m_instance.m_AV_displayMinor = list.get(3);
            HotSpotDialog2.m_instance.m_AV_displayMajor = list.get(4);
            HotSpotDialog2.m_instance.m_AV_displayCritical = list.get(5);
            HotSpotDialog2.m_instance.m_KPI_displayUnknown = list.get(6);
            HotSpotDialog2.m_instance.m_KPI_displayNormal = list.get(7);
            HotSpotDialog2.m_instance.m_KPI_displayWarning = list.get(8);
            HotSpotDialog2.m_instance.m_KPI_displayMinor = list.get(9);
            HotSpotDialog2.m_instance.m_KPI_displayMajor = list.get(10);
            HotSpotDialog2.m_instance.m_KPI_displayCritical = list.get(11);
        }
        HotSpotDialog2.m_instance.m_shell.setLayout((Layout)new FormLayout());
        RTLogger.print(4, "Hotspot open 1.0");
        m_instance.createDialogArea((Composite)HotSpotDialog2.m_instance.m_shell);
        return m_instance;
    }

    protected Control createDialogArea(Composite parent) {
        this.m_gde = new GUIDisplayElements();
        this.m_sashForm = new SashForm(parent, 256);
        this.m_sashForm.setLayout((Layout)new FillLayout());
        FormData formFill0 = new FormData();
        formFill0.top = new FormAttachment(0, 1);
        formFill0.left = new FormAttachment(0, 1);
        formFill0.bottom = new FormAttachment(100, -1);
        formFill0.right = new FormAttachment(100, -1);
        this.m_sashForm.setLayoutData((Object)formFill0);
        formFill0.width = 1000;
        formFill0.height = 650;
        this.m_sc = new ScrolledComposite((Composite)this.m_sashForm, 768);
        this.m_sc.setAlwaysShowScrollBars(false);
        this.m_sc.setExpandHorizontal(true);
        this.m_sc.setExpandVertical(true);
        this.m_sc.setLayout((Layout)new GridLayout());
        this.m_chartsLeft = new Composite((Composite)this.m_sc, 2048);
        GridLayout gl = new GridLayout(1, false);
        this.m_chartsLeft.setLayout((Layout)gl);
        this.m_chartsLeft.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.m_chartsLeft.setBackground(BMUI.color_white);
        try {
            this.createDialogContent(this.m_chartsLeft);
        }
        catch (Throwable throwable) {}
        this.m_sc.setContent((Control)this.m_chartsLeft);
        this.m_sc.setMinSize(this.m_chartsLeft.computeSize(-1, -1, true));
        long start = System.currentTimeMillis();
        this.getTypeAStatus((Composite)this.m_sashForm);
        RTLogger.print(6, "Hotspot createTable A takes: " + (System.currentTimeMillis() - start) + "ms");
        start = System.currentTimeMillis();
        this.getTypeKStatus((Composite)this.m_sashForm);
        RTLogger.print(6, "Hotspot createTable K takes: " + (System.currentTimeMillis() - start) + "ms");
        start = System.currentTimeMillis();
        this.refresh();
        RTLogger.print(6, "Hotspot initial setInput of both tables takes: " + (System.currentTimeMillis() - start) + "ms");
        return parent;
    }

    public void createDialogContent(Composite parent) {
        this.m_top5_label = new Label(parent, 0);
        this.m_top5_label.setText("top 5 hosts");
        this.m_top5_label.setBackground(BMUI.color_white);
        this.m_top5_label.setFont(BMUI.font_arial8_bold);
        GridData gridData = new GridData(768);
        gridData.heightHint = 100;
        Composite hosts = this.getHostsChart(parent);
        hosts.setLayoutData((Object)gridData);
        this.m_top5_label = new Label(parent, 0);
        this.m_top5_label.setBackground(BMUI.color_white);
        this.m_top5_label.setText("top 5 applications");
        this.m_top5_label.setFont(BMUI.font_arial8_bold);
        Composite apps = this.getAppsChart(parent);
        apps.setLayoutData((Object)gridData);
        this.m_top5_label = new Label(parent, 0);
        this.m_top5_label.setBackground(BMUI.color_white);
        this.m_top5_label.setText("top 5 objects");
        this.m_top5_label.setFont(BMUI.font_arial8_bold);
        Composite objs = this.getObjectsChart(parent);
        objs.setLayoutData((Object)gridData);
        this.m_top5_label = new Label(parent, 0);
        this.m_top5_label.setText("top 5 groups");
        this.m_top5_label.setBackground(BMUI.color_white);
        this.m_top5_label.setFont(BMUI.font_arial8_bold);
        Composite mgs = this.getMsgGrpsChart(parent);
        mgs.setLayoutData((Object)gridData);
        this.m_comp_cairo = new Composite(parent, 0);
        this.m_comp_cairo.setBackground(BMUI.color_white);
        this.m_comp_cairo.setLayoutData((Object)new GridData(1, 1024, true, true, 1, 1));
        this.m_comp_cairo.setLayout((Layout)new GridLayout(3, false));
        Button check = this.m_gde.addCheckbox(this.m_comp_cairo, ONTOP, "Always on top", this.m_isOnTOP, this);
        check.setBackground(BMUI.color_white);
        Repository.getEventProvider().registerRefreshable(this, true);
    }

    public void getTypeAStatus(Composite parent) {
        this.m_typeA_mainComp = new Composite(parent, 0);
        this.m_typeA_mainComp.setLayout((Layout)new GridLayout(1, false));
        this.m_typeA_mainComp.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.m_typeA_mainComp.setBackground(BMUI.color_light_yellow);
        this.m_typeA_l1 = new Label(this.m_typeA_mainComp, 0);
        this.m_typeA_l1.setText("Availability Matrix");
        this.m_typeA_l1.setFont(BMUI.font_arial8_bold);
        this.m_typeA_l1.setBackground(BMUI.color_light_yellow);
        this.m_typeA_line = new Label(this.m_typeA_mainComp, 259);
        this.m_typeA_line.setForeground(BMUI.color_darkGrey2);
        this.m_typeA_line.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.m_sc_A = new ScrolledComposite(this.m_typeA_mainComp, 0x10000300);
        this.m_sc_A.setAlwaysShowScrollBars(false);
        this.m_sc_A.setExpandHorizontal(true);
        this.m_sc_A.setExpandVertical(true);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 1;
        gridLayout.horizontalSpacing = 1;
        gridLayout.marginHeight = 1;
        gridLayout.marginWidth = 1;
        this.m_sc_A.setLayout((Layout)gridLayout);
        this.m_sc_A.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_availabilityComp = new Composite((Composite)this.m_sc_A, 0);
        this.m_availabilityComp.setLayout((Layout)gridLayout);
        this.m_availabilityComp.setLayoutData((Object)new GridData(4, 128, true, false));
        this.m_availabilityComp.setBackground(BMUI.color_light_yellow);
        this.m_sc_A.setContent((Control)this.m_availabilityComp);
        this.m_sc_A.setMinSize(this.m_availabilityComp.computeSize(-1, -1, true));
        this.createTypeAStatusTable(this.m_availabilityComp);
        this.m_typeA_total = new Label(this.m_typeA_mainComp, 0);
        int hostCount = this.m_typeA_table.getItemCount();
        this.m_typeA_total.setText(" " + hostCount + (hostCount == 1 ? TOTAL_HOST : TOTAL_HOSTS));
        this.m_typeA_total.setFont(BMUI.font_arial7_bold);
        this.m_typeA_total.setBackground(BMUI.color_light_yellow);
        this.m_typeA_total.setLayoutData((Object)new GridData(4, 128, true, false));
        this.m_typeA_grp = new Group(this.m_typeA_mainComp, 0);
        this.m_typeA_grp.setText(" Select Severity: ");
        GridData gridData = new GridData(1, 1024, true, false);
        gridData.verticalIndent = 10;
        this.m_typeA_grp.setLayoutData((Object)gridData);
        this.m_typeA_grp.setLayout((Layout)new GridLayout(3, false));
        this.m_typeA_grp.setBackground(BMUI.color_light_yellow);
        this.m_typeA_grp.setForeground(BMUI.defaultForeground);
        GUIDisplayElements gde = new GUIDisplayElements();
        this.m_typeA_checkSev = gde.addCheckbox((Composite)this.m_typeA_grp, m_AV_unknown, "unknown", this.m_AV_displayUnknown, 1, 1, 1, BMUI.IMAGE_UNKNOWN, this);
        this.m_typeA_checkSev.setBackground(BMUI.color_light_yellow);
        this.m_typeA_checkSev = gde.addCheckbox((Composite)this.m_typeA_grp, m_AV_normal, "normal", this.m_AV_displayNormal, 1, 1, 1, BMUI.IMAGE_NORMAL, this);
        this.m_typeA_checkSev.setBackground(BMUI.color_light_yellow);
        this.m_typeA_checkSev = gde.addCheckbox((Composite)this.m_typeA_grp, m_AV_warning, "warning", this.m_AV_displayWarning, 1, 1, 1, BMUI.IMAGE_WARNING, this);
        this.m_typeA_checkSev.setBackground(BMUI.color_light_yellow);
        this.m_typeA_checkSev = gde.addCheckbox((Composite)this.m_typeA_grp, m_AV_minor, "minor", this.m_AV_displayMinor, 1, 1, 1, BMUI.IMAGE_MINOR, this);
        this.m_typeA_checkSev.setBackground(BMUI.color_light_yellow);
        this.m_typeA_checkSev = gde.addCheckbox((Composite)this.m_typeA_grp, m_AV_major, "major", this.m_AV_displayMajor, 1, 1, 1, BMUI.IMAGE_MAJOR, this);
        this.m_typeA_checkSev.setBackground(BMUI.color_light_yellow);
        this.m_typeA_checkSev = gde.addCheckbox((Composite)this.m_typeA_grp, m_AV_critical, "critical", this.m_AV_displayCritical, 1, 1, 1, BMUI.IMAGE_CRITICAL, this);
        this.m_typeA_checkSev.setBackground(BMUI.color_light_yellow);
    }

    public void createTypeAStatusTable(Composite parent) {
        this.m_typeA_table = new Table(parent, 268438276);
        this.m_typeA_table.setHeaderVisible(false);
        this.m_typeA_table.setLinesVisible(false);
        this.m_typeA_table.setBackground(BMUI.color_light_yellow);
        GridData gdData = new GridData(4, 4, true, true);
        gdData.widthHint = 300;
        gdData.heightHint = 500;
        this.m_typeA_table.setLayoutData((Object)gdData);
        this.m_typeA_table.addMouseListener((MouseListener)this);
        this.m_tv_typeA = new TableViewer(this.m_typeA_table);
        this.m_tv_typeA.setData(TV_TYPE, (Object)AV);
        this.m_tableProvider_typeA = new HotspotTableProvider(this, this.m_tv_typeA);
        this.m_tv_typeA.setContentProvider((IContentProvider)this.m_tableProvider_typeA);
        this.m_tv_typeA.setLabelProvider((IBaseLabelProvider)this.m_tableProvider_typeA);
        TableColumn col1 = new TableColumn(this.m_typeA_table, 16384);
        col1.setWidth(0);
        TableColumn col2 = new TableColumn(this.m_typeA_table, 16384);
        col2.setWidth(130);
        int i = 0;
        while (i < this.m_maxColCount) {
            TableColumn column = new TableColumn(this.m_typeA_table, 16384);
            column.setWidth(0);
            column.setAlignment(16384);
            ++i;
        }
        this.m_typeA_table.setToolTipText("");
        final Listener labelListener = new Listener(){

            public void handleEvent(Event event) {
                Label label = (Label)event.widget;
                Shell shell = label.getShell();
                switch (event.type) {
                    case 3: {
                        Event e = new Event();
                        e.item = (TableItem)label.getData("_TABLEITEM");
                        HotSpotDialog2.this.m_typeA_table.setSelection(new TableItem[]{(TableItem)e.item});
                        HotSpotDialog2.this.m_typeA_table.notifyListeners(13, e);
                    }
                    case 7: {
                        shell.dispose();
                    }
                }
            }
        };
        Listener tableListener = new Listener(){
            Shell tooltip_shell = null;
            Label label = null;

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 1: 
                    case 12: {
                        if (this.tooltip_shell == null) break;
                        this.tooltip_shell.dispose();
                        this.tooltip_shell = null;
                        this.label = null;
                        break;
                    }
                    case 5: {
                        if (this.tooltip_shell == null) break;
                        this.tooltip_shell.dispose();
                        this.tooltip_shell = null;
                        this.label = null;
                        break;
                    }
                    case 32: {
                        TreeMap<Integer, List<Object>> statusList;
                        HotspotTableProvider.HotspotTableObject to;
                        TableItem item = HotSpotDialog2.this.m_typeA_table.getItem(new Point(5, event.y));
                        int columnIndex = HotSpotDialog2.this.getColumnIndex(HotSpotDialog2.this.m_typeA_table, event.x);
                        if (item == null) {
                            return;
                        }
                        String tooltip = null;
                        if (item != null && columnIndex == 1) {
                            to = (HotspotTableProvider.HotspotTableObject)item.getData();
                            tooltip = to.getIPAddress();
                        } else if (item != null && columnIndex > 1 && (statusList = (to = (HotspotTableProvider.HotspotTableObject)item.getData()).getStatusTooltipList()) != null && columnIndex - 2 < statusList.size()) {
                            List<Object> list = statusList.get(columnIndex - 2);
                            tooltip = (String)list.get(1);
                        }
                        if (tooltip == null) {
                            return;
                        }
                        if (this.tooltip_shell != null && !this.tooltip_shell.isDisposed()) {
                            this.tooltip_shell.dispose();
                        }
                        this.tooltip_shell = new Shell(HotSpotDialog2.this.m_shell, 16388);
                        this.tooltip_shell.setLayout((Layout)new FillLayout());
                        this.label = new Label((Composite)this.tooltip_shell, 0);
                        this.label.setForeground(HotSpotDialog2.this.m_shell.getDisplay().getSystemColor(28));
                        this.label.setBackground(HotSpotDialog2.this.m_shell.getDisplay().getSystemColor(29));
                        this.label.setData("_TABLEITEM", (Object)item);
                        this.label.setText(tooltip);
                        this.label.addListener(7, labelListener);
                        this.label.addListener(3, labelListener);
                        Point size = this.tooltip_shell.computeSize(-1, -1);
                        Rectangle rect = item.getBounds(0);
                        Point pt = HotSpotDialog2.this.m_typeA_table.toDisplay(rect.x, rect.y);
                        this.tooltip_shell.setBounds(pt.x + event.x + 10, pt.y + 10, size.x, size.y);
                        this.tooltip_shell.setVisible(true);
                    }
                }
            }
        };
        this.m_typeA_table.addListener(1, tableListener);
        this.m_typeA_table.addListener(5, tableListener);
        this.m_typeA_table.addListener(32, tableListener);
    }

    public void getTypeKStatus(Composite parent) {
        this.m_typeK_mainComp = new Composite(parent, 0);
        this.m_typeK_mainComp.setLayout((Layout)new GridLayout(1, false));
        this.m_typeK_mainComp.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.m_typeK_mainComp.setBackground(BMUI.color_white);
        this.m_typeK_l1 = new Label(this.m_typeK_mainComp, 0);
        this.m_typeK_l1.setText("KPI Matrix");
        this.m_typeK_l1.setFont(BMUI.font_arial8_bold);
        this.m_typeK_l1.setBackground(BMUI.color_white);
        this.m_typeK_line = new Label(this.m_typeK_mainComp, 258);
        this.m_typeK_line.setForeground(BMUI.color_darkGrey2);
        this.m_typeK_line.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.m_sc_K = new ScrolledComposite(this.m_typeK_mainComp, 768);
        this.m_sc_K.setAlwaysShowScrollBars(false);
        this.m_sc_K.setExpandHorizontal(true);
        this.m_sc_K.setExpandVertical(true);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 1;
        gridLayout.horizontalSpacing = 1;
        gridLayout.marginHeight = 1;
        gridLayout.marginWidth = 1;
        this.m_sc_K.setLayout((Layout)gridLayout);
        this.m_sc_K.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_kpi_comp = new Composite((Composite)this.m_sc_K, 0);
        this.m_kpi_comp.setLayout((Layout)gridLayout);
        this.m_kpi_comp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_kpi_comp.setBackground(BMUI.color_white);
        this.m_sc_K.setContent((Control)this.m_kpi_comp);
        this.m_sc_K.setMinSize(this.m_kpi_comp.computeSize(-1, -1, true));
        this.createTypeKStatusTable(this.m_kpi_comp);
        this.m_typeK_total = new Label(this.m_typeK_mainComp, 0);
        int hostCount = this.m_typeK_table.getItemCount();
        this.m_typeK_total.setText(" " + hostCount + (hostCount == 1 ? TOTAL_HOST : TOTAL_HOSTS));
        this.m_typeK_total.setFont(BMUI.font_arial7_bold);
        this.m_typeK_total.setBackground(BMUI.color_white);
        this.m_typeK_total.setLayoutData((Object)new GridData(4, 128, true, false));
        this.m_typeK_grp = new Group(this.m_typeK_mainComp, 0);
        this.m_typeK_grp.setText(" Select Severity: ");
        GridData gridData = new GridData(1, 1024, true, false);
        gridData.verticalIndent = 10;
        this.m_typeK_grp.setLayoutData((Object)gridData);
        this.m_typeK_grp.setLayout((Layout)new GridLayout(3, false));
        this.m_typeK_grp.setBackground(BMUI.color_white);
        GUIDisplayElements gde = new GUIDisplayElements();
        this.m_typeK_checkSev = gde.addCheckbox((Composite)this.m_typeK_grp, m_KPI_unknown, "unknown", this.m_KPI_displayUnknown, 1, 1, 1, BMUI.IMAGE_UNKNOWN, this);
        this.m_typeK_checkSev.setBackground(BMUI.color_white);
        this.m_typeK_checkSev = gde.addCheckbox((Composite)this.m_typeK_grp, m_KPI_normal, "normal", this.m_KPI_displayNormal, 1, 1, 1, BMUI.IMAGE_NORMAL, this);
        this.m_typeK_checkSev.setBackground(BMUI.color_white);
        this.m_typeK_checkSev = gde.addCheckbox((Composite)this.m_typeK_grp, m_KPI_warning, "warning", this.m_KPI_displayWarning, 1, 1, 1, BMUI.IMAGE_WARNING, this);
        this.m_typeK_checkSev.setBackground(BMUI.color_white);
        this.m_typeK_checkSev = gde.addCheckbox((Composite)this.m_typeK_grp, m_KPI_minor, "minor", this.m_KPI_displayMinor, 1, 1, 1, BMUI.IMAGE_MINOR, this);
        this.m_typeK_checkSev.setBackground(BMUI.color_white);
        this.m_typeK_checkSev = gde.addCheckbox((Composite)this.m_typeK_grp, m_KPI_major, "major", this.m_KPI_displayMajor, 1, 1, 1, BMUI.IMAGE_MAJOR, this);
        this.m_typeK_checkSev.setBackground(BMUI.color_white);
        this.m_typeK_checkSev = gde.addCheckbox((Composite)this.m_typeK_grp, m_KPI_critical, "critical", this.m_KPI_displayCritical, 1, 1, 1, BMUI.IMAGE_CRITICAL, this);
        this.m_typeK_checkSev.setBackground(BMUI.color_white);
    }

    public void createTypeKStatusTable(Composite parent) {
        this.m_typeK_table = new Table(parent, 268438276);
        this.m_typeK_table.setHeaderVisible(false);
        this.m_typeK_table.setLinesVisible(false);
        this.m_typeK_table.setBackground(BMUI.color_white);
        GridData gdData = new GridData(4, 4, true, true);
        gdData.widthHint = 300;
        gdData.heightHint = 500;
        this.m_typeK_table.setLayoutData((Object)gdData);
        this.m_typeK_table.addMouseListener((MouseListener)this);
        this.m_tv_typeK = new TableViewer(this.m_typeK_table);
        this.m_tv_typeK.setData(TV_TYPE, (Object)KPI);
        this.m_tableProvider_typeK = new HotspotTableProvider(this, this.m_tv_typeK);
        this.m_tv_typeK.setContentProvider((IContentProvider)this.m_tableProvider_typeK);
        this.m_tv_typeK.setLabelProvider((IBaseLabelProvider)this.m_tableProvider_typeK);
        TableColumn col1 = new TableColumn(this.m_typeK_table, 16384);
        col1.setWidth(0);
        TableColumn col2 = new TableColumn(this.m_typeK_table, 16384);
        col2.setWidth(130);
        int i = 0;
        while (i < this.m_maxColCount) {
            TableColumn column = new TableColumn(this.m_typeK_table, 16384);
            column.setWidth(0);
            column.setAlignment(16384);
            ++i;
        }
        this.m_typeK_table.setToolTipText("");
        final Listener labelListener = new Listener(){

            public void handleEvent(Event event) {
                Label label = (Label)event.widget;
                Shell shell = label.getShell();
                switch (event.type) {
                    case 3: {
                        Event e = new Event();
                        e.item = (TableItem)label.getData("_TABLEITEM");
                        HotSpotDialog2.this.m_typeK_table.setSelection(new TableItem[]{(TableItem)e.item});
                        HotSpotDialog2.this.m_typeK_table.notifyListeners(13, e);
                    }
                    case 7: {
                        shell.dispose();
                    }
                }
            }
        };
        Listener tableListener = new Listener(){
            Shell tooltip_shell = null;
            Label label = null;

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 1: 
                    case 12: {
                        if (this.tooltip_shell == null) break;
                        this.tooltip_shell.dispose();
                        this.tooltip_shell = null;
                        this.label = null;
                        break;
                    }
                    case 5: {
                        if (this.tooltip_shell == null) break;
                        this.tooltip_shell.dispose();
                        this.tooltip_shell = null;
                        this.label = null;
                        break;
                    }
                    case 32: {
                        TreeMap<Integer, List<Object>> statusList;
                        HotspotTableProvider.HotspotTableObject to;
                        TableItem item = HotSpotDialog2.this.m_typeK_table.getItem(new Point(5, event.y));
                        int columnIndex = HotSpotDialog2.this.getColumnIndex(HotSpotDialog2.this.m_typeK_table, event.x);
                        if (item == null) {
                            return;
                        }
                        String tooltip = null;
                        if (item != null && columnIndex == 0) {
                            to = (HotspotTableProvider.HotspotTableObject)item.getData();
                            tooltip = to.getIPAddress();
                        } else if (item != null && columnIndex > 0 && (statusList = (to = (HotspotTableProvider.HotspotTableObject)item.getData()).getStatusTooltipList()) != null && columnIndex - 1 < statusList.size()) {
                            List<Object> list = statusList.get(columnIndex - 1);
                            tooltip = (String)list.get(1);
                        }
                        if (tooltip == null) {
                            return;
                        }
                        if (this.tooltip_shell != null && !this.tooltip_shell.isDisposed()) {
                            this.tooltip_shell.dispose();
                        }
                        this.tooltip_shell = new Shell(HotSpotDialog2.this.m_shell, 16388);
                        this.tooltip_shell.setLayout((Layout)new FillLayout());
                        this.label = new Label((Composite)this.tooltip_shell, 0);
                        this.label.setForeground(HotSpotDialog2.this.m_shell.getDisplay().getSystemColor(28));
                        this.label.setBackground(HotSpotDialog2.this.m_shell.getDisplay().getSystemColor(29));
                        this.label.setData("_TABLEITEM", (Object)item);
                        this.label.setText(tooltip);
                        this.label.addListener(7, labelListener);
                        this.label.addListener(3, labelListener);
                        Point size = this.tooltip_shell.computeSize(-1, -1);
                        Rectangle rect = item.getBounds(0);
                        Point pt = HotSpotDialog2.this.m_typeK_table.toDisplay(rect.x, rect.y);
                        this.tooltip_shell.setBounds(pt.x + event.x + 10, pt.y + 10, size.x, size.y);
                        this.tooltip_shell.setVisible(true);
                    }
                }
            }
        };
        this.m_typeK_table.addListener(1, tableListener);
        this.m_typeK_table.addListener(5, tableListener);
        this.m_typeK_table.addListener(32, tableListener);
    }

    public boolean displayEvent(String type, SEvent event) {
        boolean display = false;
        int severity = event.getSeverityInt();
        if (severity < 0) {
            severity += 6;
        }
        switch (severity) {
            case 0: {
                if ((!type.equals(AV) || !this.m_AV_displayUnknown) && (!type.equals(KPI) || !this.m_KPI_displayUnknown)) break;
                display = true;
                break;
            }
            case 1: {
                if ((!type.equals(AV) || !this.m_AV_displayNormal) && (!type.equals(KPI) || !this.m_KPI_displayNormal)) break;
                display = true;
                break;
            }
            case 2: {
                if ((!type.equals(AV) || !this.m_AV_displayWarning) && (!type.equals(KPI) || !this.m_KPI_displayWarning)) break;
                display = true;
                break;
            }
            case 3: {
                if ((!type.equals(AV) || !this.m_AV_displayMinor) && (!type.equals(KPI) || !this.m_KPI_displayMinor)) break;
                display = true;
                break;
            }
            case 4: {
                if ((!type.equals(AV) || !this.m_AV_displayMajor) && (!type.equals(KPI) || !this.m_KPI_displayMajor)) break;
                display = true;
                break;
            }
            case 5: {
                if ((!type.equals(AV) || !this.m_AV_displayCritical) && (!type.equals(KPI) || !this.m_KPI_displayCritical)) break;
                display = true;
            }
        }
        return display;
    }

    public Composite getHostsChart(Composite parent) {
        this.refreshHostsDataset();
        HotSpotChart hosts = new HotSpotChart(parent, 0, this.hostsDatasetN);
        return hosts;
    }

    public Composite getAppsChart(Composite parent) {
        this.appsDatasetN = this.refreshDataset(this.appsDatasetN, Repository.getEventsSummary().getApplications());
        HotSpotChart appsChart = new HotSpotChart(parent, 0, this.appsDatasetN);
        return appsChart;
    }

    public Composite getObjectsChart(Composite parent) {
        this.objectssDatasetN = this.refreshDataset(this.objectssDatasetN, Repository.getEventsSummary().getObjects());
        HotSpotChart objChart = new HotSpotChart(parent, 0, this.objectssDatasetN);
        return objChart;
    }

    public Composite getMsgGrpsChart(Composite parent) {
        this.msggrpsDatasetN = this.refreshDataset(this.msggrpsDatasetN, Repository.getEventsSummary().getObjects());
        HotSpotChart grpChart = new HotSpotChart(parent, 0, this.msggrpsDatasetN);
        return grpChart;
    }

    @Override
    public void refresh() {
        this.refresh(true, true);
    }

    public void refresh(boolean typeA, boolean typeK) {
        int hostCount;
        TableColumn col;
        int i;
        int maxElements;
        long start;
        this.refreshHostsDataset();
        this.appsDatasetN = this.refreshDataset(this.appsDatasetN, Repository.getEventsSummary().getApplications());
        this.objectssDatasetN = this.refreshDataset(this.objectssDatasetN, Repository.getEventsSummary().getObjects());
        this.msggrpsDatasetN = this.refreshDataset(this.msggrpsDatasetN, Repository.getEventsSummary().getMsgGrps());
        if (typeA) {
            start = System.currentTimeMillis();
            this.m_tv_typeA.setInput((Object)this.m_tableProvider_typeA.getElements(null));
            maxElements = this.m_tableProvider_typeA.getMaxElements();
            if (maxElements > this.m_maxElemTypeA_remember) {
                i = this.m_maxElemTypeA_remember + 2;
                while (i < maxElements + 2) {
                    col = this.m_typeA_table.getColumn(i);
                    col.setWidth(20);
                    ++i;
                }
            } else if (maxElements < this.m_maxElemTypeA_remember) {
                i = maxElements + 2;
                while (i < this.m_maxElemTypeA_remember + 2) {
                    col = this.m_typeA_table.getColumn(i);
                    col.setWidth(0);
                    ++i;
                }
            }
            RTLogger.print(6, "Hotspot setInput A (refresh) takes: " + (System.currentTimeMillis() - start) + "ms");
            hostCount = this.m_typeA_table.getItemCount();
            this.m_typeA_total.setText(" " + hostCount + (hostCount == 1 ? TOTAL_HOST : TOTAL_HOSTS));
            this.m_maxElemTypeA_remember = maxElements;
            this.m_typeA_table.setSelection(0);
        }
        if (typeK) {
            start = System.currentTimeMillis();
            this.m_tv_typeK.setInput((Object)this.m_tableProvider_typeK.getElements(null));
            maxElements = this.m_tableProvider_typeK.getMaxElements();
            if (maxElements > this.m_maxElemTypeK_remember) {
                i = this.m_maxElemTypeK_remember + 2;
                while (i < maxElements + 2) {
                    col = this.m_typeK_table.getColumn(i);
                    col.setWidth(20);
                    ++i;
                }
            } else if (maxElements < this.m_maxElemTypeK_remember) {
                i = maxElements + 2;
                while (i < this.m_maxElemTypeK_remember + 2) {
                    col = this.m_typeK_table.getColumn(i);
                    col.setWidth(0);
                    ++i;
                }
            }
            RTLogger.print(6, "Hotspot setInput K (refresh) takes: " + (System.currentTimeMillis() - start) + "ms");
            hostCount = this.m_typeK_table.getItemCount();
            this.m_typeK_total.setText(" " + hostCount + (hostCount == 1 ? TOTAL_HOST : TOTAL_HOSTS));
            this.m_maxElemTypeK_remember = maxElements;
            this.m_typeK_table.setSelection(0);
        }
    }

    public void refreshHostsDataset() {
        HashMapArray<String, Integer> hosts = Repository.getEventsSummary().getHosts();
        TreeMap<String, List> totalKey = new TreeMap<String, List>();
        HashMap<String, Integer> temp = new HashMap<String, Integer>();
        for (String key : hosts.keySet()) {
            ArrayList<Integer> sevs = new ArrayList<Integer>(hosts.getArray(key));
            String[] arr = key.split("\u25ba");
            String hostName = arr[0];
            int total = 1000000;
            int i = 2;
            while (i < sevs.size()) {
                total += ((Integer)sevs.get(i)).intValue();
                ++i;
            }
            if (temp.containsKey(hostName)) {
                Integer saved = (Integer)temp.get(hostName);
                temp.put(hostName, total + saved - 1000000);
            } else {
                temp.put(hostName, total);
            }
            if (totalKey.containsKey(hostName)) {
                List saved = (List)totalKey.get(hostName);
                int i2 = 0;
                while (i2 < 6) {
                    saved.set(i2, (Integer)saved.get(i2) + (Integer)sevs.get(i2));
                    ++i2;
                }
                continue;
            }
            totalKey.put(hostName, sevs);
        }
        for (String hostN : temp.keySet()) {
            Integer total = (Integer)temp.get(hostN);
            List saved = (List)totalKey.remove(hostN);
            totalKey.put("" + total + '\u25ba' + hostN, saved);
        }
        ArrayList al = new ArrayList(totalKey.keySet());
        Collections.reverse(al);
        Iterator itT = al.iterator();
        if (this.hostsDatasetN == null) {
            this.hostsDatasetN = new LinkedHashMap();
        } else {
            this.hostsDatasetN.clear();
        }
        int count = 5;
        while (itT.hasNext() && count > 0) {
            String total = (String)itT.next();
            String host = total.split("\u25ba")[1];
            try {
                List sevs = (List)totalKey.get(total);
                this.hostsDatasetN.put(host, sevs);
            }
            catch (RuntimeException e) {
                RTLogger.print(5, total, e);
            }
            --count;
        }
    }

    public LinkedHashMap<String, List<Integer>> refreshDataset(LinkedHashMap<String, List<Integer>> appsDataset, HashMapArray<String, Integer> array) {
        TreeMap<String, List<Integer>> totalKey = new TreeMap<String, List<Integer>>();
        for (String key : array.keySet()) {
            List<Integer> sevs = array.getArray(key);
            int total = 1000000;
            int i = 2;
            while (i < sevs.size()) {
                total += sevs.get(i).intValue();
                ++i;
            }
            totalKey.put("" + total + '\u25ba' + key, sevs);
        }
        ArrayList al = new ArrayList(totalKey.keySet());
        Collections.reverse(al);
        Iterator itT = al.iterator();
        if (appsDataset == null) {
            appsDataset = new LinkedHashMap();
        } else {
            appsDataset.clear();
        }
        int count = 5;
        while (itT.hasNext() && count > 0) {
            String total = (String)itT.next();
            String[] arr = total.split("\u25ba");
            if (arr.length < 2) {
                --count;
                continue;
            }
            String apppOrOther = arr[1];
            List sevs = (List)totalKey.get(total);
            appsDataset.put(apppOrOther, sevs);
            --count;
        }
        return appsDataset;
    }

    public void open() {
        this.m_shell.pack();
        this.m_shell.open();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() instanceof Button) {
            Button b = (Button)e.getSource();
            String data = (String)b.getData();
            long start = System.currentTimeMillis();
            if (data == ONTOP) {
                ArrayList<Boolean> list = new ArrayList<Boolean>();
                list.add(this.m_AV_displayUnknown);
                list.add(this.m_AV_displayNormal);
                list.add(this.m_AV_displayWarning);
                list.add(this.m_AV_displayMinor);
                list.add(this.m_AV_displayMajor);
                list.add(this.m_AV_displayCritical);
                list.add(this.m_KPI_displayUnknown);
                list.add(this.m_KPI_displayNormal);
                list.add(this.m_KPI_displayWarning);
                list.add(this.m_KPI_displayMinor);
                list.add(this.m_KPI_displayMajor);
                list.add(this.m_KPI_displayCritical);
                m_instance = null;
                boolean isOnTop = b.getSelection();
                this.m_shell.dispose();
                HotSpotDialog2 hsd = HotSpotDialog2.getHotSpotDialog2(this.m_parentshell, isOnTop, list);
                hsd.open();
            } else if (data.equals(m_AV_unknown)) {
                this.m_AV_displayUnknown = b.getSelection();
                this.refresh(true, false);
            } else if (data.equals(m_AV_normal)) {
                this.m_AV_displayNormal = b.getSelection();
                this.refresh(true, false);
            } else if (data.equals(m_AV_warning)) {
                this.m_AV_displayWarning = b.getSelection();
                this.refresh(true, false);
            } else if (data.equals(m_AV_minor)) {
                this.m_AV_displayMinor = b.getSelection();
                this.refresh(true, false);
            } else if (data.equals(m_AV_major)) {
                this.m_AV_displayMajor = b.getSelection();
                this.refresh(true, false);
            } else if (data.equals(m_AV_critical)) {
                this.m_AV_displayCritical = b.getSelection();
                this.refresh(true, false);
            } else if (data.equals(m_KPI_unknown)) {
                this.m_KPI_displayUnknown = b.getSelection();
                this.refresh(false, true);
            } else if (data.equals(m_KPI_normal)) {
                this.m_KPI_displayNormal = b.getSelection();
                this.refresh(false, true);
            } else if (data.equals(m_KPI_warning)) {
                this.m_KPI_displayWarning = b.getSelection();
                this.refresh(false, true);
            } else if (data.equals(m_KPI_minor)) {
                this.m_KPI_displayMinor = b.getSelection();
                this.refresh(false, true);
            } else if (data.equals(m_KPI_major)) {
                this.m_KPI_displayMajor = b.getSelection();
                this.refresh(false, true);
            } else if (data.equals(m_KPI_critical)) {
                this.m_KPI_displayCritical = b.getSelection();
                this.refresh(false, true);
            }
            RTLogger.print(6, "Hotspot change severities takes: " + (System.currentTimeMillis() - start) + "ms");
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
        if (e.button == 1) {
            Table t = (Table)e.getSource();
            TableItem item = t.getItem(new Point(5, e.y));
            int columnIndex = this.getColumnIndex(t, e.x);
            if (columnIndex > 1) {
                HotspotTableProvider.HotspotTableObject to = (HotspotTableProvider.HotspotTableObject)item.getData();
                Integer typeA = 0;
                Integer typeK = 0;
                if (to.getType().equals(AV)) {
                    typeA = 1;
                } else if (to.getType().equals(KPI)) {
                    typeK = 1;
                }
                TreeMap<Integer, List<Object>> statusList = to.getStatusTooltipList();
                if (statusList != null && columnIndex - 2 < statusList.size()) {
                    List<Object> list = statusList.get(columnIndex - 2);
                    EventStatus st = (EventStatus)list.get(0);
                    SEvent event = Repository.getEventProvider().getEvent(st.m_id);
                    String host = to.getIPAddress();
                    String apps = event.getApplication();
                    String obj = event.getObject();
                    String mon = event.getMonitor();
                    String title = "";
                    if (typeA > 0) {
                        title = String.valueOf(title) + "!";
                    }
                    if (typeK > 0) {
                        title = String.valueOf(title) + "^";
                    }
                    if (host != null) {
                        title = String.valueOf(title) + host;
                    }
                    if (apps != null) {
                        title = String.valueOf(title) + ":" + apps;
                    }
                    if (obj != null) {
                        title = String.valueOf(title) + ":" + obj;
                    }
                    if (mon != null) {
                        if (mon.equals("Availability")) {
                            mon = null;
                        } else {
                            title = String.valueOf(title) + ":" + mon;
                        }
                    }
                    MessagesView.showMessagesForHotSpot(title, host, apps, null, obj, mon, typeA, typeK);
                }
            }
        }
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
    }

    public int getColumnIndex(Table t, int position) {
        int colIndex = -1;
        int start = 0;
        int end = 0;
        LinkedHashMap<Integer, Integer> m = new LinkedHashMap<Integer, Integer>();
        TableColumn[] colList = t.getColumns();
        int index = 0;
        while (index < t.getColumnCount()) {
            m.put(index, colList[index].getWidth());
            ++index;
        }
        index = 0;
        while (index < m.size()) {
            if (index > 0) {
                start += Integer.valueOf(((Integer)m.get(index - 1)).toString()).intValue();
            }
            end = start + Integer.valueOf(((Integer)m.get(index)).toString());
            if (position >= start && position <= end) {
                colIndex = index;
                break;
            }
            ++index;
        }
        return colIndex;
    }

    public void widgetDisposed(DisposeEvent e) {
        try {
            this.m_availabilityComp.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_kpi_comp.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_sashForm.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_sc_A.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_sc_K.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_sc.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_chartsLeft.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_comp1.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_comp2.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_comp_cairo.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_typeA_mainComp.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_typeA_row.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_typeK_mainComp.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_typeK_row.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_top5_label.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_label.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_typeA_l1.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_typeA_total.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_typeA_l2.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_typeA_line.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_typeK_l1.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_typeK_total.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_typeK_l2.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_typeK_line.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_onTop_check.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_typeA_checkSev = null;
        }
        catch (Throwable throwable) {}
        try {
            this.m_typeK_checkSev.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_typeA_grp.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_typeK_grp.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_shell.dispose();
        }
        catch (Throwable throwable) {}
    }

    public void shellActivated(ShellEvent e) {
        this.m_shell.moveAbove(null);
    }

    public void shellClosed(ShellEvent e) {
        Repository.getEventProvider().unregisterRefreshable(this, true);
        this.m_shell.dispose();
    }

    public void shellDeactivated(ShellEvent e) {
    }

    public void shellDeiconified(ShellEvent e) {
    }

    public void shellIconified(ShellEvent e) {
    }
}

