/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.dialogs;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.EventStatus;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.dialogs.HotSpotDialog2;
import com.blixx.boom.gui.utils.EventStatusComparator;
import com.blixx.shared.SEvent;
import com.blixx.shared.utils.TreeMapSortedSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public class HotspotTableProvider
implements IStructuredContentProvider,
ITableLabelProvider {
    private HotSpotDialog2 m_hsd = null;
    private ArrayList<HotspotTableObject> m_elements = null;
    private TableViewer m_tv = null;
    private static EventStatusComparator m_es_comarator = new EventStatusComparator();
    private static String AV = "AV";
    private static String KPI = "KPI";
    public static String TV_TYPE = "TV_TYPE";
    private boolean m_init = true;
    private int m_maxElements = 0;
    private String m_longestHostname = "";
    private String m_type = null;

    public HotspotTableProvider(HotSpotDialog2 hsd, TableViewer tv) {
        this.m_hsd = hsd;
        this.m_tv = tv;
        this.m_type = (String)this.m_tv.getData(TV_TYPE);
        this.m_elements = this.collectElements();
        this.m_init = false;
    }

    public Object[] getElements(Object inputElement) {
        if (!this.m_init) {
            this.m_elements = this.collectElements();
        }
        return this.m_elements.toArray();
    }

    public ArrayList<HotspotTableObject> collectElements() {
        ArrayList<HotspotTableObject> collected_elements = new ArrayList<HotspotTableObject>();
        TreeMapSortedSet typeSet = null;
        if (this.m_type.equals(AV)) {
            typeSet = Repository.getEventsSummary().getTypeA();
        } else if (this.m_type.equals(KPI)) {
            typeSet = Repository.getEventsSummary().getTypeK();
        } else {
            return collected_elements;
        }
        Iterator haoKeys = typeSet.keySet().iterator();
        TreeMap hostList = new TreeMap();
        while (haoKeys.hasNext()) {
            String key = (String)haoKeys.next();
            String[] arr = key.split("\u25ba");
            Object o = hostList.get(arr[0]);
            try {
                EventStatus st = (EventStatus)typeSet.getArray(key).last();
                if (o == null) {
                    ArrayList<EventStatus> list = new ArrayList<EventStatus>();
                    list.add(st);
                    hostList.put(arr[0], list);
                    continue;
                }
                ((List)o).add(st);
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
        this.m_maxElements = 0;
        this.m_longestHostname = "";
        for (String key : hostList.keySet()) {
            List elements = (List)hostList.get(key);
            if (elements == null) continue;
            ArrayList<EventStatus> statusList = new ArrayList<EventStatus>();
            Collections.sort(elements, m_es_comarator);
            Iterator itElements = elements.iterator();
            int count = 0;
            while (itElements.hasNext() && count < this.m_hsd.m_maxColCount) {
                EventStatus st = (EventStatus)itElements.next();
                SEvent event = Repository.getEventProvider().getActive(st.m_id);
                if (event == null || !this.m_hsd.displayEvent(this.m_type, event)) continue;
                statusList.add(st);
                ++count;
            }
            if (statusList.size() == 0) continue;
            if (count > this.m_maxElements) {
                this.m_maxElements = count;
            }
            if (key.length() > this.m_longestHostname.length()) {
                this.m_longestHostname = key;
            }
            HotspotTableObject to = new HotspotTableObject();
            HotspotTableObject tableObj = to.createTableObject(this.m_type, key, statusList);
            collected_elements.add(tableObj);
        }
        return collected_elements;
    }

    public int getMaxElements() {
        return this.m_maxElements;
    }

    public int getLongestHostname() {
        int length = this.m_longestHostname.length();
        return length;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Image getColumnImage(Object element, int columnIndex) {
        HotspotTableObject to;
        TreeMap<Integer, List<Object>> statusTooltipList;
        Image image = null;
        if (columnIndex == 0 || columnIndex == 1) {
            return null;
        }
        if (element instanceof HotspotTableObject && (statusTooltipList = (to = (HotspotTableObject)element).getStatusTooltipList()) != null && columnIndex - 2 < statusTooltipList.size()) {
            List<Object> list = statusTooltipList.get(columnIndex - 2);
            EventStatus st = (EventStatus)list.get(0);
            image = BMUI.getIcon(st.m_severity);
        }
        return image;
    }

    public String getColumnText(Object element, int columnIndex) {
        String text = "";
        if (columnIndex > 1) {
            return null;
        }
        if (columnIndex == 1 && element instanceof HotspotTableObject) {
            HotspotTableObject to = (HotspotTableObject)element;
            text = to.getIPAddress();
        }
        return text;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public class HotspotTableObject {
        public TreeMap<Integer, List<Object>> m_statusTooltipList = new TreeMap();
        public String m_type = null;
        public String m_ip = null;

        public HotspotTableObject createTableObject(String type, String ip, ArrayList<EventStatus> statusList) {
            HotspotTableObject item = new HotspotTableObject();
            item.m_type = type;
            item.m_ip = ip;
            int index = 0;
            for (EventStatus st : statusList) {
                SEvent event = Repository.getEventProvider().getEvent(st.m_id);
                StringBuffer status = new StringBuffer();
                status.append("App: ").append(event.getApplication());
                status.append("\nObj: ").append(event.getObject());
                if (event.getMonitor() != null && event.getMonitor().length() > 0) {
                    status.append("\nSource: ").append(event.getMonitor());
                } else {
                    status.append("\nSource: ").append(event.getSource());
                }
                status.append(" \nText: ").append(event.getText());
                String tooltip = status.toString();
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(st);
                list.add(tooltip);
                item.m_statusTooltipList.put(index, list);
                ++index;
            }
            return item;
        }

        public String getIPAddress() {
            return this.m_ip;
        }

        public TreeMap<Integer, List<Object>> getStatusTooltipList() {
            return this.m_statusTooltipList;
        }

        public String getType() {
            return this.m_type;
        }
    }
}

