/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.dialogs;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.views.actions.InstallMPI;
import com.blixx.shared.utils.GroupTreeObject;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ImportMPIDialog
extends Dialog
implements SelectionListener {
    private static final String UPDATE_TREE_STRUCTURE_POL = "UPDATE_TREE_STRUCTURE_POL";
    private static final String OVERWR_POL = "OVERWR_POL";
    private static final String OVERWR_PKG = "OVERWR_PKG";
    private static final String OVERWR_ASN = "OVERWR_ASN";
    private static final String OVERWR_ACT = "OVERWR_ACT";
    private static final String MERGE_ACT = "MERGE_ACT";
    private GUIDisplayElements m_gde = null;
    private InstallMPI m_impi = null;
    private Button m_overwrite_act_btn = null;
    private Button m_merge_act_btn = null;
    private Button m_updatePath_btn = null;
    public boolean m_updateTreeStructure_pol = false;
    public boolean m_overwrite_policies = false;
    public boolean m_overwrite_packages = false;
    public boolean m_overwrite_actions = false;
    public boolean m_merge_actions = false;
    public boolean m_overwrite_assignments = false;

    public ImportMPIDialog(Shell parentShell, InstallMPI impi) {
        super(parentShell);
        this.setShellStyle(1040);
        this.m_gde = new GUIDisplayElements();
        this.m_impi = impi;
    }

    protected Control createDialogArea(Composite parent) {
        int ii;
        this.getShell().setText("  Import MPI");
        this.getShell().setImage(BMUI.IMAGE_IMPORT);
        this.m_gde.centerShell(parent.getShell(), Display.getCurrent());
        Composite compMain = (Composite)super.createDialogArea(parent);
        compMain.setLayout((Layout)new GridLayout(2, false));
        Composite compLeft = new Composite(compMain, 0);
        compLeft.setLayout((Layout)new GridLayout(2, false));
        compLeft.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Group grp_pol = new Group(compLeft, 32);
        grp_pol.setText("Import Policies");
        grp_pol.setLayout((Layout)new GridLayout(2, false));
        grp_pol.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Text pol = this.m_gde.addInputFieldMultiLine((Composite)grp_pol, "POLICIES", null, this.m_impi.m_msg_policies, 1, 2, 100, 400, 0, 0, null);
        ((GridData)pol.getLayoutData()).verticalAlignment = 4;
        ((GridData)pol.getLayoutData()).grabExcessVerticalSpace = true;
        StringBuffer sb1 = new StringBuffer();
        sb1.append(pol.getText()).append("\n");
        sb1.append("To import: ").append(this.m_impi.m_policies.size()).append(" Policies").append("\n");
        Collections.sort(this.m_impi.m_policies);
        int i = 0;
        while (i < this.m_impi.m_policies.size()) {
            GroupTreeObject gtol = this.m_impi.m_policies.get(i);
            sb1.append("   ").append(gtol.getName()).append("\n");
            ++i;
        }
        if (this.m_impi.m_missingImportFiles.size() > 0) {
            sb1.append("Skip Import for ").append(this.m_impi.m_missingImportFiles.size()).append(" Policies!").append(" (Import files are missing, but do exist on the server!)").append('\n');
            ii = 0;
            while (ii < this.m_impi.m_missingImportFiles.size()) {
                sb1.append("   ").append(this.m_impi.m_missingImportFiles.get(ii)).append('\n');
                ++ii;
            }
        }
        if (this.m_impi.m_missingImportAndSrvFiles.size() > 0) {
            sb1.append("Skip Import for ").append(this.m_impi.m_missingImportAndSrvFiles.size()).append(" Poicies (import/server files do not exist):").append('\n');
            ii = 0;
            while (ii < this.m_impi.m_missingImportAndSrvFiles.size()) {
                sb1.append("   ").append(this.m_impi.m_missingImportAndSrvFiles.get(ii)).append('\n');
                ++ii;
            }
        }
        pol.setText(sb1.toString().replace('\r', ' '));
        pol.setEditable(false);
        Button chkb1 = this.m_gde.addCheckbox((Composite)grp_pol, OVERWR_POL, "Overwrite", false, this);
        chkb1.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.m_updatePath_btn = this.m_gde.addCheckbox((Composite)grp_pol, UPDATE_TREE_STRUCTURE_POL, "Update Path", false, this);
        this.m_updatePath_btn.setEnabled(false);
        this.m_updatePath_btn.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.m_gde.addTextField((Composite)grp_pol, null, "", 1, 1, 0, 0, null);
        if (this.m_impi.m_msg_policies.indexOf("Nothing to import") != -1) {
            chkb1.setEnabled(false);
            this.m_updatePath_btn.setEnabled(false);
        } else if (this.m_impi.m_msg_policies.indexOf("Ready to Import.") != -1) {
            chkb1.setEnabled(false);
            this.m_updatePath_btn.setEnabled(false);
            pol.setBackground(BMUI.color_light_green);
        } else {
            pol.setBackground(BMUI.color_light_yellow);
        }
        Group grp_pkg = new Group(compLeft, 32);
        grp_pkg.setText("Import Packages");
        grp_pkg.setLayout((Layout)new GridLayout(2, false));
        grp_pkg.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Text pkg = this.m_gde.addInputFieldMultiLine((Composite)grp_pkg, "PACKAGES", null, this.m_impi.m_msg_packages, 1, 2, 100, 400, 0, 0, null);
        ((GridData)pkg.getLayoutData()).verticalAlignment = 4;
        ((GridData)pkg.getLayoutData()).grabExcessVerticalSpace = true;
        StringBuffer sb2 = new StringBuffer();
        sb2.append(pkg.getText()).append("\n");
        sb2.append("To import: ").append(this.m_impi.m_packages.size()).append(" binary packages").append("\n");
        Collections.sort(this.m_impi.m_packages);
        int i2 = 0;
        while (i2 < this.m_impi.m_packages.size()) {
            sb2.append("   ").append(this.m_impi.m_packages.get(i2)).append("\n");
            ++i2;
        }
        pkg.setText(sb2.toString().replace('\r', ' '));
        pkg.setEditable(false);
        Button chkb2 = this.m_gde.addCheckbox((Composite)grp_pkg, OVERWR_PKG, "Overwrite", false, this);
        if (this.m_impi.m_msg_packages.indexOf("Nothing to import") != -1) {
            chkb2.setEnabled(false);
        } else if (this.m_impi.m_msg_packages.indexOf("Ready to Import.") != -1) {
            pkg.setBackground(BMUI.color_light_green);
            chkb2.setEnabled(false);
        } else {
            pkg.setBackground(BMUI.color_light_yellow);
        }
        Group grp_asn = new Group(compLeft, 32);
        grp_asn.setText("Import Assignments");
        grp_asn.setLayout((Layout)new GridLayout(2, false));
        grp_asn.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Text asn = this.m_gde.addInputFieldMultiLine((Composite)grp_asn, "ASSIGNMENTS", null, "", 1, 1, 100, 400, 0, 0, null);
        ((GridData)asn.getLayoutData()).verticalAlignment = 4;
        ((GridData)asn.getLayoutData()).grabExcessVerticalSpace = true;
        StringBuffer sb3 = new StringBuffer();
        if (this.m_impi.m_removedAsnLinks.size() > 0 || this.m_impi.m_notRemovedAsnLinks_err.size() > 0) {
            if (this.m_impi.m_msg_assignments.indexOf("CONFLICTS found!") == -1) {
                this.m_impi.m_msg_assignments = "Ready to Import. WARNINGS found!";
                sb3.append("Ready to Import. WARNINGS found!").append("\n");
            }
            if (this.m_impi.m_removedAsnLinks.size() > 0) {
                sb3.append("Broken links detected (will be skipped): ").append('\n');
                int count = 0;
                while (count < this.m_impi.m_removedAsnLinks.size()) {
                    sb3.append("   ").append(this.m_impi.m_removedAsnLinks.get(count)).append('\n');
                    ++count;
                }
            }
        } else {
            sb3.append(this.m_impi.m_msg_assignments).append("\n");
        }
        sb3.append("To import: ").append(this.m_impi.m_assignments.size()).append(" Assignment Groups").append("\n");
        Collections.sort(this.m_impi.m_assignments);
        int i3 = 0;
        while (i3 < this.m_impi.m_assignments.size()) {
            sb3.append("   ").append(this.m_impi.m_assignments.get(i3).getName()).append("\n");
            ++i3;
        }
        if (this.m_impi.m_asnAlreadyExist.size() > 0) {
            sb3.append("Skip Import of ").append(this.m_impi.m_asnAlreadyExist.size()).append(" Assignment Groups (do already exist): ").append("\n");
            i3 = 0;
            while (i3 < this.m_impi.m_asnAlreadyExist.size()) {
                sb3.append("   ").append(this.m_impi.m_asnAlreadyExist.get(i3)).append("\n");
                ++i3;
            }
        }
        asn.setText(sb3.toString().replace('\r', ' '));
        asn.setEditable(false);
        if (this.m_impi.m_msg_assignments.indexOf("Nothing to import") == -1) {
            if (this.m_impi.m_msg_assignments.indexOf("Ready to Import. WARNINGS found!") != -1) {
                asn.setBackground(BMUI.color_light_yellow);
            } else if (this.m_impi.m_msg_assignments.indexOf("Ready to Import.") != -1) {
                asn.setBackground(BMUI.color_light_green);
            } else {
                asn.setBackground(BMUI.color_light_yellow);
            }
        }
        Group grp_act = new Group(compLeft, 32);
        grp_act.setText("Import Actions");
        grp_act.setLayout((Layout)new GridLayout(2, false));
        grp_act.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Text act = this.m_gde.addInputFieldMultiLine((Composite)grp_act, "ACTIONS", null, this.m_impi.m_msg_actions, 1, 2, 100, 400, 0, 0, null);
        ((GridData)act.getLayoutData()).verticalAlignment = 4;
        ((GridData)act.getLayoutData()).grabExcessVerticalSpace = true;
        StringBuffer sb4 = new StringBuffer();
        sb4.append(act.getText()).append("\n");
        sb4.append("To import: ").append(this.m_impi.m_actionGroups.size()).append(" Action groups.").append("\n");
        ArrayList<String> list = new ArrayList<String>(this.m_impi.m_actionGroups.keySet());
        Collections.sort(list);
        int i4 = 0;
        while (i4 < list.size()) {
            sb4.append("   ").append(list.get(i4)).append("\n");
            ++i4;
        }
        act.setText(sb4.toString().replace('\r', ' '));
        act.setEditable(false);
        Composite chckComp = new Composite((Composite)grp_act, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.verticalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.horizontalSpacing = 10;
        chckComp.setLayout((Layout)gl);
        chckComp.setLayoutData((Object)new GridData(131072, 128, false, false));
        this.m_overwrite_act_btn = this.m_gde.addCheckbox(chckComp, OVERWR_ACT, "Overwrite", false, this);
        this.m_merge_act_btn = this.m_gde.addCheckbox(chckComp, MERGE_ACT, "Merge", false, this);
        if (this.m_impi.m_msg_actions.indexOf("Nothing to import") != -1) {
            this.m_overwrite_act_btn.setEnabled(false);
            this.m_merge_act_btn.setEnabled(false);
        } else if (this.m_impi.m_msg_actions.indexOf("Ready to Import.") != -1) {
            this.m_overwrite_act_btn.setEnabled(false);
            this.m_merge_act_btn.setEnabled(false);
            act.setBackground(BMUI.color_light_green);
        } else {
            act.setBackground(BMUI.color_light_yellow);
        }
        Group grp_nod = new Group(compLeft, 32);
        grp_nod.setText("Import Node Groups");
        grp_nod.setLayout((Layout)new GridLayout(3, false));
        grp_nod.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Text nod = this.m_gde.addInputFieldMultiLine((Composite)grp_nod, "NODEGROUPS", null, this.m_impi.m_msg_nodegroups, 1, 2, 100, 400, 0, 0, null);
        ((GridData)nod.getLayoutData()).verticalAlignment = 4;
        ((GridData)nod.getLayoutData()).grabExcessVerticalSpace = true;
        StringBuffer sb5 = new StringBuffer();
        sb5.append(nod.getText()).append("\n");
        sb5.append("To import: ").append(this.m_impi.m_nodegroups.size()).append(" Node Groups.").append("\n");
        Collections.sort(this.m_impi.m_nodegroups);
        int i5 = 0;
        while (i5 < this.m_impi.m_nodegroups.size()) {
            sb5.append("   ").append(this.m_impi.m_nodegroups.get(i5).getName()).append("\n");
            ++i5;
        }
        nod.setText(sb5.toString().replace('\r', ' '));
        nod.setEditable(false);
        if (this.m_impi.m_msg_nodegroups.indexOf("Nothing to import") == -1) {
            if (this.m_impi.m_msg_nodegroups.indexOf("Ready to Import.") != -1) {
                nod.setBackground(BMUI.color_light_green);
            } else {
                nod.setBackground(BMUI.color_light_yellow);
            }
        }
        return compMain;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button b = super.createButton(parent, id, label, defaultButton);
        if (this.m_impi.packagesDir == null && this.m_impi.policiesDir == null && this.m_impi.actionsDir == null && this.m_impi.nodegroupsDir == null && label.equals("OK")) {
            b.setEnabled(false);
        }
        return b;
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() instanceof Button) {
            Button b = (Button)e.getSource();
            String value = (String)b.getData();
            if (value.equals(OVERWR_ACT)) {
                this.m_overwrite_actions = b.getSelection();
                if (this.m_overwrite_actions) {
                    this.m_merge_act_btn.setSelection(false);
                    this.m_merge_actions = false;
                }
            } else if (value.equals(MERGE_ACT)) {
                this.m_merge_actions = b.getSelection();
                if (this.m_merge_actions) {
                    this.m_overwrite_act_btn.setSelection(false);
                    this.m_overwrite_actions = false;
                }
            } else if (value.equals(OVERWR_PKG)) {
                this.m_overwrite_packages = b.getSelection();
            } else if (value.equals(OVERWR_POL)) {
                this.m_overwrite_policies = b.getSelection();
                if (this.m_overwrite_policies) {
                    this.m_gde.enableField(this.m_updatePath_btn, true);
                } else {
                    this.m_updatePath_btn.setSelection(false);
                    this.m_gde.enableField(this.m_updatePath_btn, false);
                }
            } else if (value.equals(OVERWR_ASN)) {
                this.m_overwrite_assignments = b.getSelection();
            } else if (value.equals(UPDATE_TREE_STRUCTURE_POL)) {
                this.m_updateTreeStructure_pol = b.getSelection();
            }
        }
    }
}

