/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.dialogs;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ImportMPIPropertiesDialog
extends StatusDialog
implements DisposeListener,
SelectionListener {
    private GUIDisplayElements m_gui = null;
    private Composite m_mainComp = null;
    private Text m_tempDir_field = null;
    private static String DETECT_DUPS = "DETECT_DUPS";
    private static String DEDUP_KEYONLY = "DEDUP_KEYONLY";
    private static String NO_DEDUP = "NO_DEDUP";
    private static String TEMP_DIR = "TEMP_DIR";
    private static String BROWSE = "BROWSE";
    private String m_tmpDir = null;
    private int m_dedupFlag = 2;

    public ImportMPIPropertiesDialog(Shell parentShell, String tempDir) {
        super(parentShell);
        this.setTitle("   Set Import Properties");
        this.setImage(BMUI.IMAGE_PRODUCT);
        this.m_tmpDir = tempDir;
        if (this.m_tmpDir == null) {
            this.m_tmpDir = "";
        }
        this.m_gui = new GUIDisplayElements();
    }

    public ImportMPIPropertiesDialog(Shell parentShell) {
        super(parentShell);
        this.setTitle("   Set Import Properties");
        this.setImage(BMUI.IMAGE_PRODUCT);
        this.m_gui = new GUIDisplayElements();
    }

    protected Control createDialogArea(Composite parent) {
        this.m_mainComp = new Composite(parent, 0);
        this.m_mainComp.addDisposeListener((DisposeListener)this);
        GridLayout gl = new GridLayout(1, false);
        gl.verticalSpacing = 10;
        this.m_mainComp.setLayout((Layout)gl);
        this.m_mainComp.setLayoutData((Object)new GridData(4, 4, true, true));
        Group m_dedup_grp = new Group(this.m_mainComp, 0);
        m_dedup_grp.setText("Set De-Duplication Properties");
        gl = new GridLayout(3, false);
        gl.horizontalSpacing = 10;
        m_dedup_grp.setLayout((Layout)gl);
        m_dedup_grp.setLayoutData((Object)new GridData(4, 4, true, false));
        this.m_gui.addRadioButton((Composite)m_dedup_grp, DETECT_DUPS, "Detect Duplicates", true, 1, 1, 1, 1, this);
        this.m_gui.addRadioButton((Composite)m_dedup_grp, DEDUP_KEYONLY, "De-Duplicate KeyOnly", false, 1, 1, 1, 1, this);
        this.m_gui.addRadioButton((Composite)m_dedup_grp, NO_DEDUP, "No De-Duplication", false, 1, 1, 1, 1, this);
        if (this.m_tmpDir != null) {
            Group m_tmpdir_grp = new Group(this.m_mainComp, 0);
            m_tmpdir_grp.setText("Set Temp Directory");
            m_tmpdir_grp.setLayout((Layout)new GridLayout(3, false));
            m_tmpdir_grp.setLayoutData((Object)new GridData(4, 4, true, false));
            this.m_tempDir_field = this.m_gui.addInputFieldSingle((Composite)m_tmpdir_grp, TEMP_DIR, "Temp Directory: ", this.m_tmpDir, 1, 1, 1, 1, 450, null);
            this.m_gui.addButton((Composite)m_tmpdir_grp, BROWSE, " Browse ", true, this);
        }
        return parent;
    }

    public void browseTempDir() {
        if (this.m_tmpDir == null) {
            return;
        }
        DirectoryDialog fd = new DirectoryDialog(Display.getCurrent().getActiveShell());
        if (this.m_tmpDir != null) {
            fd.setFilterPath(this.m_tmpDir);
        }
        fd.setText("   Select Temp Directory");
        fd.setMessage("Select a directory");
        String dirName = fd.open();
        if (dirName != null && dirName.length() > 0) {
            this.m_tmpDir = dirName;
            this.m_tempDir_field.setText(this.m_tmpDir);
        }
    }

    public int getdedupFlag() {
        return this.m_dedupFlag;
    }

    public String getTempDir() {
        return this.m_tmpDir;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "OK", true);
        this.getButton(0).setFocus();
        this.createButton(parent, 1, "CANCEL", false);
        this.getButton(1).setEnabled(true);
    }

    public void widgetDisposed(DisposeEvent e) {
        try {
            this.m_mainComp.dispose();
        }
        catch (Throwable throwable) {}
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() instanceof Button) {
            Button b = (Button)e.getSource();
            String name = (String)b.getData();
            if (name.equals(DETECT_DUPS)) {
                this.m_dedupFlag = 2;
            } else if (name.equals(DEDUP_KEYONLY)) {
                this.m_dedupFlag = 1;
            } else if (name.equals(NO_DEDUP)) {
                this.m_dedupFlag = 0;
            } else if (name.equals(BROWSE)) {
                this.browseTempDir();
            }
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            super.okPressed();
        } else if (buttonId == 1) {
            super.cancelPressed();
        }
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    protected void okPressed() {
        super.okPressed();
    }
}

