/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.dialogs;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.snmp.MIBTableProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class MIBSelectionDialog
extends StatusDialog {
    private Table m_table;
    private TableViewer m_tableViewer = null;
    private GUIDisplayElements m_gui = new GUIDisplayElements();
    private Composite m_compMain = null;
    private Label m_total = null;
    private Label m_label = null;
    private Button m_selectAll_check = null;
    private int m_hight = 70;
    private boolean m_showCancelBtn = true;
    private boolean m_displayImage = true;
    private boolean m_displayCheckbox = false;
    private static String SELECT_ALL = "SELECT_ALL";
    private List<String> m_all_MIBs_sorted = new LinkedList<String>();
    private List<String> m_selected_MIBs_orig = new LinkedList<String>();
    private List<String> m_selected_MIBs_changed = new ArrayList<String>();

    public MIBSelectionDialog(Shell parentShell, Collection<String> MIBsSorted) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x80 | 0x400);
        this.setTitle("  All loaded MIBs");
        this.setImage(BMUI.IMAGE_PRODUCT);
        this.m_all_MIBs_sorted = new ArrayList<String>(MIBsSorted);
        if (this.m_all_MIBs_sorted.size() > 0) {
            this.m_hight = 450;
        }
        this.m_showCancelBtn = false;
    }

    public MIBSelectionDialog(Shell parentShell, Collection<String> allMIBsSorted, Collection<String> selectedMIBs) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x80 | 0x400);
        this.setTitle("  Select MIBs");
        this.setImage(BMUI.IMAGE_PRODUCT);
        this.m_displayImage = true;
        this.m_displayCheckbox = true;
        this.m_all_MIBs_sorted = new ArrayList<String>(allMIBsSorted);
        this.m_selected_MIBs_orig = new ArrayList<String>(selectedMIBs);
        if (this.m_all_MIBs_sorted.size() > 0) {
            this.m_hight = 450;
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.m_compMain = new Composite(parent, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginRight = 15;
        gl.marginLeft = 15;
        gl.marginTop = 10;
        this.m_compMain.setLayout((Layout)gl);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 450;
        gd.heightHint = this.m_hight;
        this.m_compMain.setLayoutData((Object)gd);
        if (this.m_all_MIBs_sorted.size() == 0) {
            this.createHeader("No MIBs loaded!");
            this.m_showCancelBtn = false;
        } else {
            this.createHeader("Available MIBs:");
            this.createTable();
            this.createFooter();
        }
        return parent;
    }

    private void createTable() {
        int style = 2816;
        if (this.m_displayCheckbox) {
            style = 2848;
        }
        this.m_table = new Table(this.m_compMain, style);
        this.m_table.setHeaderVisible(false);
        this.m_table.setLinesVisible(false);
        this.m_table.setLayout((Layout)new GridLayout());
        this.m_table.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        if (this.m_displayCheckbox) {
            this.m_table.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    TableItem ti = (TableItem)event.item;
                    String mibName = ti.getText(0);
                    if (ti.getChecked()) {
                        if (!MIBSelectionDialog.this.m_selected_MIBs_changed.contains(mibName)) {
                            MIBSelectionDialog.this.m_selected_MIBs_changed.add(ti.getText(0));
                        }
                    } else {
                        MIBSelectionDialog.this.m_selected_MIBs_changed.remove(mibName);
                    }
                    MIBSelectionDialog.this.updateFooter();
                }
            });
        }
        TableColumn col1 = new TableColumn(this.m_table, 32);
        col1.setWidth(400);
        this.m_tableViewer = new TableViewer(this.m_table);
        MIBTableProvider mibTableProvider = new MIBTableProvider(this.m_tableViewer, this.m_displayImage, this.m_all_MIBs_sorted);
        this.m_tableViewer.setContentProvider((IContentProvider)mibTableProvider);
        this.m_tableViewer.setLabelProvider((IBaseLabelProvider)mibTableProvider);
        this.m_tableViewer.setInput((Object)mibTableProvider.getElements(null));
        mibTableProvider.setTableSelection(this.m_selected_MIBs_orig, this.m_selected_MIBs_changed);
    }

    private void selectAll() {
        ArrayList<String> allMibs = new ArrayList<String>();
        TableItem[] items = this.m_table.getItems();
        int i = 0;
        while (i < items.length) {
            TableItem ti = items[i];
            String mibName = ti.getText(0);
            allMibs.add(mibName);
            if (!ti.getChecked()) {
                ti.setChecked(true);
                if (!this.m_selected_MIBs_changed.contains(mibName)) {
                    this.m_selected_MIBs_changed.add(mibName);
                }
            }
            ++i;
        }
        this.m_selected_MIBs_changed.clear();
        this.m_selected_MIBs_changed.addAll(allMibs);
    }

    private void deselectAll() {
        TableItem[] items = this.m_table.getItems();
        int i = 0;
        while (i < items.length) {
            TableItem ti = items[i];
            if (ti.getChecked()) {
                ti.setChecked(false);
            }
            ++i;
        }
        this.m_selected_MIBs_changed.clear();
    }

    private void createHeader(String header) {
        this.m_label = this.m_gui.addTextField(this.m_compMain, null, header, 2, 1, 1, 1, null);
        ((GridData)this.m_label.getLayoutData()).horizontalAlignment = 16384;
        ((GridData)this.m_label.getLayoutData()).horizontalIndent = 5;
    }

    private void createFooter() {
        if (this.m_displayCheckbox) {
            this.m_total = this.m_gui.addTextField(this.m_compMain, null, "Selected " + this.m_selected_MIBs_changed.size() + "/Total " + this.m_all_MIBs_sorted.size(), 1, 1, 1, 1, null);
            ((GridData)this.m_total.getLayoutData()).horizontalAlignment = 16384;
            ((GridData)this.m_total.getLayoutData()).horizontalIndent = 5;
            this.m_selectAll_check = this.m_gui.addCheckbox(this.m_compMain, SELECT_ALL, "Select All", false, null);
            if (this.m_table.getItemCount() == this.m_selected_MIBs_orig.size()) {
                this.m_selectAll_check.setSelection(true);
            }
            GridData gd = new GridData(131072, 128, false, false);
            gd.verticalIndent = 3;
            this.m_selectAll_check.setLayoutData((Object)gd);
            this.m_selectAll_check.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (MIBSelectionDialog.this.m_selectAll_check.getSelection()) {
                        MIBSelectionDialog.this.selectAll();
                    } else {
                        MIBSelectionDialog.this.deselectAll();
                    }
                    MIBSelectionDialog.this.updateFooter();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.m_label = this.m_gui.addTextField(this.m_compMain, null, "All related Symbols will be automatically selected!", 2, 1, 1, 1, null);
            ((GridData)this.m_label.getLayoutData()).horizontalAlignment = 16384;
            ((GridData)this.m_label.getLayoutData()).horizontalIndent = 5;
        } else {
            this.m_total = this.m_gui.addTextField(this.m_compMain, null, "Total " + this.m_all_MIBs_sorted.size(), 2, 1, 1, 1, null);
            ((GridData)this.m_total.getLayoutData()).horizontalAlignment = 16384;
            ((GridData)this.m_total.getLayoutData()).horizontalIndent = 5;
        }
    }

    private void updateFooter() {
        this.m_total.setText("Selected " + this.m_selected_MIBs_changed.size() + "/Total " + this.m_all_MIBs_sorted.size());
        this.m_total.pack(true);
    }

    public List<String> getSelection() {
        return this.m_selected_MIBs_changed;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 3, "OK", false);
        if (this.m_showCancelBtn) {
            this.createButton(parent, 1, "Cancel", false);
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1) {
            super.cancelPressed();
        } else if (buttonId == 3) {
            super.okPressed();
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        try {
            this.m_compMain.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_label.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_total.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_selectAll_check.dispose();
        }
        catch (Throwable throwable) {}
    }
}

