/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.dialogs;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.EventStorageOutage;
import com.blixx.boom.engine.EventStorageUtils;
import com.blixx.boom.engine.ITableBrowserProvider;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClient;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.engine.UIJobManager;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.dialogs.ISEventUpdateListener;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.views.PolicyView;
import com.blixx.boom.gui.views.actions.AcknowledgeAction;
import com.blixx.boom.gui.views.actions.AddIndicationConditionAction;
import com.blixx.boom.gui.views.actions.AgentRemoteAction;
import com.blixx.boom.gui.views.actions.AgentRemoteActionOnSelected;
import com.blixx.boom.gui.views.actions.ArchiveMessagesAction;
import com.blixx.boom.gui.views.actions.ManageDialogAction;
import com.blixx.boom.gui.views.actions.OpenBrowserAction;
import com.blixx.boom.gui.views.actions.PushIndi2NotiAction;
import com.blixx.boom.gui.views.actions.ReopenMessagesAction;
import com.blixx.shared.SEvent;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.SupportedVariablesS;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.custom.PaintObjectEvent;
import org.eclipse.swt.custom.PaintObjectListener;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.Section;

public class MessageDetailsDialog
implements ShellListener,
SelectionListener,
ModifyListener,
Listener,
ISEventUpdateListener {
    private static final String ADD_ANNOTATION_ACTION = "Add Annotation";
    private static final String LOAD_ANNOTATIONS_ACTION = "Reload Annotations";
    public SEvent m_se = null;
    private String m_autoClosed_ID = null;
    private GUIDisplayElements m_guiElements = null;
    private Shell m_shell;
    public Text m_opAction_text;
    public static String EXECUTE_ACTION = "execute_action";
    public static String RELOAD_ADVICE_ACTION = "Reload Advice";
    private Control dialogArea;
    private int origDialogSize = 0;
    private ScrolledComposite scrolledComponent;
    private Text m_newAnnot;
    private Button m_addAnnotationButton;
    private Composite m_annotationArea = null;
    private Button loadButton;
    private Composite m_sectionClient = null;
    private StyledText m_advice_field = null;
    int[] offsets;
    Control[] controls;
    int MARGIN = 1;
    private static Pattern m_urlPattern = Pattern.compile("((?:http|ftp|sftp)[s]*://[^\\s]+[^\\s.])");
    private ITableBrowserProvider m_eventStorage = null;
    private Button m_closeIndi_btn = null;
    private Button m_reopenIndi_btn = null;
    private Button m_addCondition_btn = null;
    private Button m_sendAsNotification_btn = null;
    private Button m_runActionOnSelected_btn = null;
    private Button m_archiveIndi_btn = null;
    private AcknowledgeAction m_action_closeIndi = null;
    private ReopenMessagesAction m_action_reopenIndi = null;
    private AddIndicationConditionAction m_action_addIndiCond = null;
    private PushIndi2NotiAction m_action_pusIndi2Notification = null;
    private AgentRemoteActionOnSelected m_action_runOnSelected = null;
    private ArchiveMessagesAction m_action_archiveMsg = null;
    private static String BTN_CLOSE_INDI = "BTN_CLOSE_INDI";
    private static String BTN_REOPEN = "BTN_REOPEN";
    private static String BTN_ADD_COND = "BTN_ADD_COND";
    private static String BTN_PUSH_INDI2NOTIFICATIOM = "BTN_PUSH_INDI2NOTIFICATIOM";
    private static String BTN_RUN_ON_SELECTED = "BTN_RUN_ON_SELECTED";
    private static String BTN_ARCHIVE_INDI = "BTN_ARCHIVE_INDI";
    private AtomicBoolean m_refreshRunning = new AtomicBoolean(false);

    public MessageDetailsDialog(Shell parentShell, SEvent se, ITableBrowserProvider es) {
        this.m_eventStorage = es;
        this.m_shell = new Shell(Display.getCurrent(), 1265);
        this.m_se = se;
        this.setTitles();
        this.m_shell.addShellListener((ShellListener)this);
        this.m_shell.setData((Object)this.createContents((Composite)this.m_shell));
        this.m_guiElements.openShellInActiveMonitor(this.m_shell);
        Repository.getEventProvider().registerSEventUpdateLitener(this);
    }

    protected Control createContents(Composite parent) {
        this.m_guiElements = new GUIDisplayElements();
        GridLayout gl = new GridLayout(1, false);
        gl.verticalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        parent.setLayout((Layout)gl);
        this.createButtonSection(parent);
        this.scrolledComponent = new ScrolledComposite(parent, 768);
        this.scrolledComponent.setAlwaysShowScrollBars(false);
        this.scrolledComponent.setExpandHorizontal(true);
        this.scrolledComponent.setExpandVertical(true);
        this.scrolledComponent.setLayout((Layout)new GridLayout(1, false));
        this.scrolledComponent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.dialogArea = this.createDialogArea((Composite)this.scrolledComponent);
        this.scrolledComponent.setContent(this.dialogArea);
        this.scrolledComponent.setMinSize(this.dialogArea.computeSize(-1, -1, true));
        return this.scrolledComponent;
    }

    public void setTitles() {
        this.m_shell.setImage(BMUI.getIcon(this.m_se.getSeverityInt()));
        String title = " " + this.m_se.getText().substring(0, Math.min(100, this.m_se.getText().length())) + "...";
        this.m_shell.setText(title.replace('\n', ' '));
    }

    public String getTitle() {
        return this.m_shell.getText();
    }

    public void activate() {
        if (this.m_shell != null) {
            this.m_shell.setActive();
            if (this.m_shell.getMinimized()) {
                this.m_shell.setMinimized(false);
            }
        }
    }

    private boolean isOutage() {
        return this.m_eventStorage != null && this.m_eventStorage.getType() == 1;
    }

    protected Control createDialogArea(Composite scrolledComposite) {
        SEventFwd sef;
        Label label = null;
        Font font_bold = BMUI.font_arial8_bold;
        Font font_normal = BMUI.font_arial8;
        Composite composite = new Composite(scrolledComposite, 0);
        GridLayout gridLayout = new GridLayout(6, false);
        gridLayout.marginRight = 12;
        gridLayout.marginLeft = 12;
        gridLayout.marginBottom = 0;
        gridLayout.marginTop = 0;
        gridLayout.horizontalSpacing = 10;
        composite.setLayout((Layout)gridLayout);
        int severityInt = this.m_se.getSeverityInt();
        if (severityInt < 0) {
            severityInt += 6;
        }
        if (this.m_se instanceof SEventFwd) {
            SEventFwd sef2 = (SEventFwd)this.m_se;
            String user = "";
            String date = "";
            if (sef2.getT5() != null && sef2.getT5().length() > 0) {
                String[] arr = sef2.getT5().split("\n");
                user = arr[0];
                try {
                    date = BMUI.m_sdf.format(new Date(Long.parseLong(arr[1])));
                }
                catch (Throwable throwable) {}
            }
            String res = user;
            if (date.length() > 0) {
                res = String.valueOf(res) + " (" + date + ')';
            }
            Label sev = this.m_guiElements.addTextField(composite, "Severity: ", this.m_se.getSeverity(), 2, 1, 12, 0, font_normal);
            sev.setBackground(BMUI.getColor(severityInt));
            this.m_guiElements.addTextReadOnly(composite, "Owned By: ", res, 2, 1, 0, 0, null, font_normal);
        } else {
            Label sev = this.m_guiElements.addTextField(composite, "Severity: ", this.m_se.getSeverity(), 5, 1, 12, 0, font_normal);
            sev.setBackground(BMUI.getColor(severityInt));
        }
        this.m_guiElements.addTextReadOnly(composite, "UUID: ", this.m_se.getID(), 2, 1, 0, 0, null, font_normal);
        this.m_guiElements.addTextField(composite, null, "", 1, 1, 1, 0, null);
        Composite compCheckbox = new Composite(composite, 0);
        gridLayout = new GridLayout(4, false);
        gridLayout.horizontalSpacing = 10;
        compCheckbox.setLayout((Layout)gridLayout);
        GridData gdData = new GridData(256);
        gdData.horizontalSpan = 2;
        gdData.horizontalAlignment = 16384;
        compCheckbox.setLayoutData((Object)gdData);
        Label image_checkbox = new Label(compCheckbox, 1);
        image_checkbox.setImage(this.m_se.getTypeK() == 1 ? BMUI.IMAGE_COMBO_CHECKED : BMUI.IMAGE_COMBO_UNCHECKED);
        label = this.m_guiElements.addTextField(compCheckbox, null, "KPI Metric", 1, 1, 1, 0, null);
        image_checkbox = new Label(compCheckbox, 1);
        image_checkbox.setImage(this.m_se.getTypeA() == 1 ? BMUI.IMAGE_COMBO_CHECKED : BMUI.IMAGE_COMBO_UNCHECKED);
        label = this.m_guiElements.addTextField(compCheckbox, null, "Availability Metric", 1, 1, 1, 0, null);
        this.m_guiElements.addTextReadOnly(composite, "Host: ", this.m_se.getNode(), 2, 1, 0, 0, null, font_bold);
        this.m_guiElements.addTextReadOnly(composite, "Application: ", this.m_se.getApplication(), 2, 1, 0, 0, null, font_bold);
        this.m_guiElements.addTextReadOnly(composite, "AGENT Host: ", this.m_se.getAgentNode(), 2, 1, 0, 0, null, font_normal);
        this.m_guiElements.addTextReadOnly(composite, "Group: ", this.m_se.getGroup(), 2, 1, 0, 0, null, font_bold);
        if (this.m_se instanceof SEventFwd) {
            SEventFwd sef3 = (SEventFwd)this.m_se;
            this.m_guiElements.addTextReadOnly(composite, "Agent ID: ", sef3.getT1(), 2, 1, 0, 0, null, font_normal);
            this.m_guiElements.addTextReadOnly(composite, "Slave Server: ", sef3.getSrv(), 2, 1, 0, 0, null, font_normal);
            if (this.m_eventStorage != null && this.m_eventStorage.getEventProvider() instanceof EventStorageOutage) {
                String outage_policy_id = sef3.getT8();
                this.m_guiElements.addTextReadOnly(composite, "Maintenance Policy ID: ", outage_policy_id, 2, 1, 0, 0, null, font_normal);
                Label ll = new Label(composite, 0);
                GridData gdData2 = new GridData(256);
                gdData2.horizontalSpan = 3;
                gdData2.horizontalAlignment = 16384;
                ll.setLayoutData((Object)gdData2);
            }
        }
        this.m_guiElements.addTextReadOnly(composite, "Object: ", this.m_se.getObject(), 5, 1, 0, 0, null, font_bold);
        this.m_guiElements.addTextReadOnly(composite, "Key: ", this.m_se.getKeyConfigured(), 5, 1, 0, 0, null, font_bold);
        this.m_guiElements.addTextReadOnly(composite, "Close Mask: ", this.m_se.getCloseMask(), 5, 1, 0, 0, null, font_bold);
        this.m_guiElements.addTextReadOnly(composite, "Auto Action: ", this.m_se.getAutoAction(), 2, 1, 0, 0, null, font_normal);
        String aahost = this.m_se.getAutoActionNode();
        int chp = aahost.indexOf(124);
        if (chp != -1) {
            aahost = aahost.substring(0, chp);
        }
        this.m_guiElements.addTextReadOnly(composite, "AA Host: ", aahost, 2, 1, 0, 0, null, font_normal);
        int startAAonDupl = 0;
        if (this.m_se instanceof SEventFwd) {
            SEventFwd sef4 = (SEventFwd)this.m_se;
            startAAonDupl = sef4.getAA_DuplicateTrigger();
        }
        if (startAAonDupl > 0) {
            new Label(composite, 0);
            Label ll = new Label(composite, 0);
            ll.setText("Auto Action starts on duplicate: " + startAAonDupl);
            GridData gdData2 = new GridData(256);
            gdData2.horizontalSpan = 5;
            gdData2.horizontalAlignment = 16384;
            ll.setLayoutData((Object)gdData2);
        }
        String opAction = this.m_se.getOpAction().trim();
        this.m_guiElements.addTextReadOnly(composite, "Operator Action: ", opAction, 4, 1, 0, 0, null, font_normal);
        Button button = this.m_guiElements.addButton(composite, EXECUTE_ACTION, " Execute ", true, 70, 20, 0, this);
        if (opAction == null || opAction.length() == 0 || Repository.getInstance().getRights(1005) < 3) {
            this.m_guiElements.enableField(button, false);
        }
        Text text = this.m_guiElements.addInputFieldMultiLineNoWrap(composite, "p5_msg_text", "Text: ", this.m_se.getText(), 5, 1, 80, 120, 0, 0, null);
        text.setEditable(false);
        text.setBackground(BMUI.color_white);
        GridData gd = (GridData)text.getLayoutData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        text.setFocus();
        label = this.m_guiElements.addTextField(composite, null, "Source: ", 1, 1, 5, 0, font_normal);
        Image icon = null;
        label = null;
        if (this.m_se.getSource().startsWith("Monitor")) {
            icon = BMUI.IMAGE_MON;
            label = new Label(composite, 1);
        } else if (this.m_se.getSource().startsWith("Message")) {
            icon = BMUI.IMAGE_MSG;
            label = new Label(composite, 1);
        }
        if (label != null) {
            label.setImage(icon);
            label.setData((Object)this.m_se.getSource());
            label.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent e) {
                    if (Repository.getInstance().getRights(1001) < 2) {
                        return;
                    }
                    PolicyView.displayPolicyEXT(MessageDetailsDialog.this.m_se);
                }
            });
            this.m_guiElements.addTextReadOnly(composite, null, this.m_se.getSource(), 1, 1, 0, 0, null, font_normal);
        } else {
            this.m_guiElements.addTextReadOnly(composite, null, this.m_se.getSource(), 2, 1, 0, 0, null, font_normal);
        }
        String agentFirstTime = BMUI.m_sdf.format(new Date(this.m_se.getFirstTime()));
        this.m_guiElements.addTextReadOnly(composite, "First submit: ", agentFirstTime, 2, 1, 0, 0, null, font_bold);
        String state = "Unknown";
        switch (this.m_se.getState()) {
            case 'A': {
                state = "Auto Closed Message";
                break;
            }
            case 'O': {
                state = "Closed By Operator";
                break;
            }
            case '-': {
                state = "Active";
                break;
            }
            case 'D': {
                state = "Archived";
                break;
            }
        }
        this.m_guiElements.addTextReadOnly(composite, "State: ", state, 2, 1, 0, 0, null, font_bold);
        String agentTime = BMUI.m_sdf.format(new Date(this.m_se.getTime()));
        this.m_guiElements.addTextReadOnly(composite, "Last duplicate: ", agentTime, 2, 1, 0, 0, null, font_bold);
        Label dup = this.m_guiElements.addTextField(composite, "Duplicates: ", "" + this.m_se.getDuplicates(), 2, 1, 5, 0, font_normal);
        if (this.m_se.getDuplicates() > 10) {
            dup.setFont(font_bold);
        }
        String srvTime = BMUI.m_sdf.format(new Date(this.m_se.getSTime()));
        this.m_guiElements.addTextReadOnly(composite, "Server received: ", srvTime, 2, 1, 0, 0, null, font_normal);
        if (this.m_se.getSource().startsWith("Monitor")) {
            SEventFwd sef5;
            Label value = this.m_guiElements.addTextField(composite, "Value: ", "" + this.m_se.getValue(), 5, 1, 5, 0, font_normal);
            value.setFont(font_bold);
            if (this.m_se instanceof SEventFwd && (sef5 = (SEventFwd)this.m_se).getTFA() > 0L) {
                Label valueFA = this.m_guiElements.addTextField(composite, "End value: ", "" + sef5.getVFA(), 2, 1, 5, 0, font_normal);
                valueFA.setFont(font_bold);
                String srvTimeFA = BMUI.m_sdf.format(new Date(sef5.getTFA()));
                this.m_guiElements.addTextReadOnly(composite, "Alert finished: ", srvTimeFA, 2, 1, 0, 0, null, font_normal);
            }
        }
        if (this.m_se instanceof SEventFwd && (sef = (SEventFwd)this.m_se).getT3() != null && sef.getT3().length() > 0) {
            Label ii = new Label(composite, 0);
            ii.setText("Instruction: ");
            Link link = new Link(composite, 0);
            link.setText("<a href=\"" + sef.getT3() + "\">" + sef.getT3() + "</a>");
            link.setBackground(BMUI.color_grey);
            link.addListener(13, (Listener)this);
            link.pack();
            GridData gdLabel = new GridData();
            gdLabel.horizontalSpan = 5;
            link.setLayoutData((Object)gdLabel);
        }
        this.customAttributeSection(composite);
        this.helpSection(composite);
        this.createAnnotationArea(composite);
        this.createNotificationSection(composite);
        return composite;
    }

    private void customAttributeSection(Composite composite) {
        if (this.m_se instanceof SEventFwd) {
            SEventFwd sef = (SEventFwd)this.m_se;
            Section section = BMUI.getFormToolkit(Display.getCurrent()).createSection(composite, 514);
            section.setLayoutData((Object)new GridData(4, 128, true, false, 6, 1));
            Composite sectionClient = BMUI.getFormToolkit(Display.getCurrent()).createComposite((Composite)section, 64);
            GridLayout gdLayout = new GridLayout(3, false);
            gdLayout.horizontalSpacing = 2;
            sectionClient.setLayout((Layout)gdLayout);
            int countAttr = 0;
            int i = 0;
            while (i < 15) {
                String CAName = "CA" + (i + 1);
                String str = sef.m_CustomAttributes.get(CAName);
                if (str != null) {
                    String name = "";
                    String value = "";
                    int indexOf_EQ = str.indexOf(61);
                    if (indexOf_EQ != -1) {
                        name = str.substring(0, indexOf_EQ);
                        value = str.substring(indexOf_EQ + 1);
                    } else {
                        name = str;
                        value = "";
                    }
                    Label nl = new Label(sectionClient, 0);
                    nl.setText("(" + CAName + ") " + name);
                    this.m_guiElements.addInputFieldMultiLine(sectionClient, CAName, "", value, 1, 1, 45, 120, 0, 0, null);
                    ++countAttr;
                }
                ++i;
            }
            section.setText("Custom Attributes (" + countAttr + ")");
            section.setClient((Control)sectionClient);
            section.addExpansionListener(new IExpansionListener(){

                public void expansionStateChanged(ExpansionEvent e) {
                    MessageDetailsDialog.this.scrolledComponent.layout(true);
                    MessageDetailsDialog.this.scrolledComponent.setMinSize(MessageDetailsDialog.this.dialogArea.computeSize(-1, -1));
                    MessageDetailsDialog.this.m_shell.layout(true, true);
                }

                public void expansionStateChanging(ExpansionEvent e) {
                }
            });
        }
    }

    private void helpSection(Composite composite) {
        String help2 = Repository.getInstance().getHelp(this.m_se.getInstructionID());
        Section section = BMUI.getFormToolkit(Display.getCurrent()).createSection(composite, 514);
        if (help2 != null && help2.length() > 0) {
            section.setText("Advice +");
        } else {
            section.setText("Advice");
        }
        section.setLayoutData((Object)new GridData(4, 128, true, false, 6, 1));
        this.m_sectionClient = BMUI.getFormToolkit(Display.getCurrent()).createComposite((Composite)section, 64);
        GridLayout gdLayout = new GridLayout(1, false);
        this.m_sectionClient.setLayout((Layout)gdLayout);
        Button reload = this.m_guiElements.addButton(this.m_sectionClient, RELOAD_ADVICE_ACTION, " Reload Advice ", true, 100, 20, 5, this);
        reload.setImage(BMUI.IMAGE_REFRESH);
        this.m_advice_field = new StyledText(this.m_sectionClient, 2882);
        this.m_advice_field.setEditable(false);
        GridData gd = new GridData(4, 4, true, true, 1, 1);
        gd.widthHint = 100;
        gd.heightHint = 100;
        this.m_advice_field.setLayoutData((Object)gd);
        String advice = SupportedVariablesS.prepareString(this.m_se, Repository.getInstance().getHelp(this.m_se.getInstructionID()));
        if (advice != null) {
            this.m_advice_field.setText(advice);
            this.lookupURLs(advice);
        }
        section.setClient((Control)this.m_sectionClient);
        section.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanged(ExpansionEvent e) {
                MessageDetailsDialog.this.scrolledComponent.layout(true);
                MessageDetailsDialog.this.scrolledComponent.setMinSize(MessageDetailsDialog.this.dialogArea.computeSize(-1, -1));
                MessageDetailsDialog.this.m_shell.layout(true, true);
            }

            public void expansionStateChanging(ExpansionEvent e) {
            }
        });
    }

    private void createNotificationSection(Composite composite) {
        SEventFwd sef;
        String t6;
        if (this.m_se instanceof SEventFwd && (t6 = (sef = (SEventFwd)this.m_se).getT6()) != null && t6.length() > 0) {
            Section section = BMUI.getFormToolkit(Display.getCurrent()).createSection(composite, 514);
            section.setText("Notifications");
            section.setLayoutData((Object)new GridData(4, 128, true, false, 6, 1));
            Composite sectionClient = BMUI.getFormToolkit(Display.getCurrent()).createComposite((Composite)section, 64);
            GridLayout gdLayout = new GridLayout(2, false);
            gdLayout.horizontalSpacing = 2;
            sectionClient.setLayout((Layout)gdLayout);
            this.m_guiElements.addMultiLineFieldReadOnlyWrap(sectionClient, "NOTIFICATIONS", "Scheduled: ", EventStorageUtils.getText(sef, 32), 1, 1, 100, 100, 1, 1);
            section.setClient((Control)sectionClient);
            section.addExpansionListener(new IExpansionListener(){

                public void expansionStateChanged(ExpansionEvent e) {
                    MessageDetailsDialog.this.scrolledComponent.layout(true);
                    MessageDetailsDialog.this.scrolledComponent.setMinSize(MessageDetailsDialog.this.dialogArea.computeSize(-1, -1));
                    MessageDetailsDialog.this.m_shell.layout(true, true);
                }

                public void expansionStateChanging(ExpansionEvent e) {
                }
            });
        }
    }

    private void createButtonSection(Composite composite) {
        ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
        this.m_action_closeIndi = new AcknowledgeAction(this.m_se, this.isOutage());
        this.m_action_reopenIndi = new ReopenMessagesAction(this.m_se, this.isOutage());
        this.m_action_addIndiCond = new AddIndicationConditionAction(this.m_se);
        this.m_action_pusIndi2Notification = new PushIndi2NotiAction(this.m_shell, this.m_se);
        this.m_action_runOnSelected = new AgentRemoteActionOnSelected(this.m_shell, this.m_se);
        this.m_action_archiveMsg = new ArchiveMessagesAction(this.m_se, this.isOutage());
        int numCols = 5;
        if (this.m_action_addIndiCond.isEnabled()) {
            numCols = 6;
        }
        Composite comp = new Composite(composite, 0);
        GridLayout gl = new GridLayout(numCols, false);
        gl.marginWidth = 10;
        gl.marginHeight = 10;
        comp.setLayout((Layout)gl);
        comp.setLayoutData((Object)new GridData(16384, 4, false, false));
        Composite compLine = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        compLine.setLayout((Layout)gridLayout);
        compLine.setLayoutData((Object)new GridData(4, 128, true, false));
        Label line = new Label(compLine, 259);
        line.setForeground(BMUI.color_darkGrey2);
        line.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        if (this.m_action_addIndiCond.isEnabled()) {
            this.m_addCondition_btn = this.m_guiElements.addButton(comp, BTN_ADD_COND, "Add Condition", true, 90, 20, 0, this);
            this.m_addCondition_btn.setImage(sharedImages.getImage("IMG_OBJ_ADD"));
        }
        this.m_sendAsNotification_btn = this.m_guiElements.addButton(comp, BTN_PUSH_INDI2NOTIFICATIOM, "Send as Notification", this.m_action_pusIndi2Notification.isEnabled(), 90, 20, 0, this);
        this.m_sendAsNotification_btn.setImage(BMUI.IMAGE_NOTIFICATION_16x16);
        this.m_runActionOnSelected_btn = this.m_guiElements.addButton(comp, BTN_RUN_ON_SELECTED, "Run Action", this.m_action_runOnSelected.isEnabled(), 90, 20, 0, this);
        this.m_runActionOnSelected_btn.setImage(BMUI.IMAGE_ACTION);
        this.m_archiveIndi_btn = this.m_guiElements.addButton(comp, BTN_ARCHIVE_INDI, "Archive Indication", this.m_action_archiveMsg.isEnabled(), 90, 20, 0, this);
        this.m_archiveIndi_btn.setImage(BMUI.IMAGE_ARCH);
        this.m_closeIndi_btn = this.m_guiElements.addButton(comp, BTN_CLOSE_INDI, "Close Indication", this.m_action_closeIndi.isEnabled(), 90, 20, 0, this);
        this.m_reopenIndi_btn = this.m_guiElements.addButton(comp, BTN_REOPEN, "Reopen Indication", this.m_action_reopenIndi.isEnabled(), 90, 20, 0, this);
    }

    private void checkButtonSection() {
        this.m_action_closeIndi = new AcknowledgeAction(this.m_se, this.isOutage());
        this.m_action_reopenIndi = new ReopenMessagesAction(this.m_se, this.isOutage());
        this.m_action_addIndiCond = new AddIndicationConditionAction(this.m_se);
        this.m_action_pusIndi2Notification = new PushIndi2NotiAction(this.m_shell, this.m_se);
        this.m_action_runOnSelected = new AgentRemoteActionOnSelected(this.m_shell, this.m_se);
        this.m_action_archiveMsg = new ArchiveMessagesAction(this.m_se, this.isOutage());
        this.m_guiElements.enableField(this.m_closeIndi_btn, this.m_action_closeIndi.isEnabled());
        this.m_guiElements.enableField(this.m_reopenIndi_btn, this.m_action_reopenIndi.isEnabled());
        this.m_guiElements.enableField(this.m_addCondition_btn, this.m_action_addIndiCond.isEnabled());
        this.m_guiElements.enableField(this.m_sendAsNotification_btn, this.m_action_pusIndi2Notification.isEnabled());
        this.m_guiElements.enableField(this.m_runActionOnSelected_btn, this.m_action_runOnSelected.isEnabled());
        this.m_guiElements.enableField(this.m_archiveIndi_btn, this.m_action_archiveMsg.isEnabled());
    }

    private void lookupURLs(String advice) {
        if (advice == null || advice.length() < 7) {
            return;
        }
        try {
            Control[] ctrls;
            Control[] controlArray = ctrls = this.m_advice_field.getChildren();
            int n = ctrls.length;
            int n2 = 0;
            while (n2 < n) {
                Control ctrl = controlArray[n2];
                try {
                    ctrl.dispose();
                }
                catch (Throwable throwable) {}
                ++n2;
            }
        }
        catch (Throwable throwable) {}
        Matcher m = m_urlPattern.matcher(advice);
        ArrayList<String> urls = new ArrayList<String>();
        while (m.find()) {
            String url = m.group();
            urls.add(url);
        }
        this.controls = new Control[urls.size()];
        int i = 0;
        while (i < urls.size()) {
            this.controls[i] = this.createLink((String)urls.get(i));
            ++i;
        }
        this.offsets = new int[this.controls.length];
        int lastOffset = 0;
        int i2 = 0;
        while (i2 < this.controls.length) {
            int offset;
            String url = (String)urls.get(i2);
            this.offsets[i2] = offset = advice.indexOf(url, lastOffset);
            this.addControl(this.m_advice_field, this.controls[i2], this.offsets[i2], url);
            lastOffset = offset + 1;
            ++i2;
        }
        this.m_advice_field.addPaintObjectListener(new PaintObjectListener(){

            public void paintObject(PaintObjectEvent event) {
                StyleRange style = event.style;
                int start = style.start;
                int i = 0;
                while (i < MessageDetailsDialog.this.offsets.length) {
                    int offset = MessageDetailsDialog.this.offsets[i];
                    if (start == offset) {
                        Point pt = MessageDetailsDialog.this.controls[i].getSize();
                        int x = event.x + MessageDetailsDialog.this.MARGIN;
                        int y = event.y + event.ascent - 11 * pt.y / 12;
                        MessageDetailsDialog.this.controls[i].setLocation(x, y);
                        break;
                    }
                    ++i;
                }
            }
        });
    }

    private void createAnnotationArea(Composite composite) {
        Section section = BMUI.getFormToolkit(Display.getCurrent()).createSection(composite, 514);
        if (!this.m_se.getAnnotationFlag()) {
            section.setText("Annotations");
        } else {
            section.setText("Annotations +");
        }
        GridData gdText1 = new GridData(1808);
        gdText1.horizontalSpan = 6;
        gdText1.verticalSpan = 1;
        gdText1.verticalAlignment = 1;
        section.setLayoutData((Object)gdText1);
        Composite clientSection = BMUI.getFormToolkit(Display.getCurrent()).createComposite((Composite)section, 0);
        GridLayout gdLayout = new GridLayout(1, false);
        gdLayout.marginLeft = 10;
        gdLayout.horizontalSpacing = 2;
        clientSection.setLayout((Layout)gdLayout);
        section.setClient((Control)clientSection);
        this.m_addAnnotationButton = this.m_guiElements.addButton(clientSection, ADD_ANNOTATION_ACTION, " Add Annotation ", true, this);
        this.m_addAnnotationButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.m_addAnnotationButton.setImage(BMUI.IMAGE_ADD);
        this.m_newAnnot = this.m_guiElements.addInputFieldMultiLine(clientSection, "New_annot", null, "", 1, 1, 60, 120, 0, 0, null);
        this.m_newAnnot.setBackground(BMUI.color_lightYellow);
        this.m_newAnnot.setForeground(BMUI.color_blue);
        this.loadButton = this.m_guiElements.addButton(clientSection, LOAD_ANNOTATIONS_ACTION, LOAD_ANNOTATIONS_ACTION, true, this);
        GridData gd = new GridData(16384, 0x1000000, false, false);
        gd.verticalIndent = 5;
        this.loadButton.setLayoutData((Object)gd);
        this.loadButton.setImage(BMUI.IMAGE_REFRESH);
        this.m_annotationArea = new Composite(clientSection, 2048);
        GridData gdText = new GridData(768);
        gdText.verticalAlignment = 1;
        this.m_annotationArea.setLayoutData((Object)gdText);
        GridLayout gridLayout2 = new GridLayout(6, false);
        gridLayout2.marginHeight = 10;
        gridLayout2.marginWidth = 10;
        gridLayout2.horizontalSpacing = 5;
        this.m_annotationArea.setLayout((Layout)gridLayout2);
        section.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanged(ExpansionEvent e) {
                if (e.getState()) {
                    MessageDetailsDialog.this.showAnnotations();
                }
                MessageDetailsDialog.this.scrolledComponent.layout(true);
                MessageDetailsDialog.this.scrolledComponent.setMinSize(MessageDetailsDialog.this.dialogArea.computeSize(-1, -1));
                MessageDetailsDialog.this.m_shell.layout(true, true);
            }

            public void expansionStateChanging(ExpansionEvent e) {
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    private void showAnnotations() {
        arr = this.m_annotationArea.getChildren();
        i = 0;
        while (i < arr.length) {
            arr[i].dispose();
            ++i;
        }
        this.m_annotationArea.layout(true);
        sc = new ServerClient("GET_ANNOT", this.m_se.getID(), new String[0]);
        sc.runInUIThread(null);
        if (sc.isSuccess()) {
            this.m_se.setAnnotations((ArrayList)sc.getResultObject());
        }
        totalSize = 80;
        tooltip = null;
        duplicates = new StringBuffer();
        duplicateText = null;
        annotations = this.m_se.getAnnotations();
        Collections.sort(annotations, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                try {
                    if (o1.indexOf(124) != -1 && o2.indexOf(124) != -1) {
                        String time1 = o1.substring(o1.indexOf(124) + 1, o1.indexOf(10));
                        String time2 = o2.substring(o2.indexOf(124) + 1, o2.indexOf(10));
                        return time1.compareTo(time2);
                    }
                }
                catch (Throwable throwable) {}
                return 0;
            }
        });
        i = 0;
        while (i < annotations.size()) {
            block44: {
                block45: {
                    ann = annotations.get(i);
                    if (ann == null) break block44;
                    isAutoClosed = false;
                    noteLabel = "Note " + i;
                    if (!ann.startsWith("AAT")) break block45;
                    noteLabel = "AutoAction\nSuccess\n";
                    firstNL = ann.indexOf(10);
                    time = ann.substring(ann.indexOf(124) + 1, firstNL);
                    try {
                        time = BMUI.m_sdf.format(new Date(Long.parseLong(time)));
                    }
                    catch (Throwable v0) {}
                    noteLabel = String.valueOf(noteLabel) + time;
                    ann = ann.substring(firstNL + 1);
                    ** GOTO lbl136
                }
                if (ann.startsWith("DD")) {
                    firstNL = ann.indexOf(124);
                    line = ann.substring(firstNL + 1);
                    if (duplicates.length() == 0) {
                        duplicates.append(line.replace('\n', ' '));
                    } else {
                        duplicates.append('\n').append(line.replace('\n', ' '));
                    }
                    if (duplicateText == null) {
                        h2 = 80;
                        duplicateLabel = "Custom Attributes\nin duplicates";
                        duplicateText = this.m_guiElements.addInputFieldMultiLine(this.m_annotationArea, "Annotation" + i, duplicateLabel, duplicates.toString(), 5, 1, h2, 120, 0, 0, null);
                        duplicateText.setEditable(false);
                    }
                } else {
                    if (ann.startsWith("AAF")) {
                        noteLabel = "AutoAction\nFailed\n";
                        firstNL = ann.indexOf(10);
                        time = ann.substring(ann.indexOf(124) + 1, firstNL);
                        try {
                            time = BMUI.m_sdf.format(new Date(Long.parseLong(time)));
                        }
                        catch (Throwable v1) {}
                        noteLabel = String.valueOf(noteLabel) + time;
                        ann = ann.substring(firstNL + 1);
                    } else if (ann.startsWith("SAM")) {
                        isAutoClosed = true;
                        noteLabel = "Auto closed\n";
                        firstNL = ann.indexOf(10);
                        time = ann.substring(ann.indexOf(124) + 1, firstNL);
                        try {
                            time = BMUI.m_sdf.format(new Date(Long.parseLong(time)));
                        }
                        catch (Throwable v2) {}
                        noteLabel = String.valueOf(noteLabel) + time;
                        ann = ann.substring(firstNL + 1);
                        se = this.m_eventStorage.getEventProvider().getEvent(ann);
                        if (se != null) {
                            tooltip = se.getText();
                        }
                        if (ann != null && ann.length() > 0) {
                            this.m_autoClosed_ID = ann;
                        }
                    } else if (ann.startsWith("OAM")) {
                        noteLabel = "Operator closed\n";
                        firstNL = ann.indexOf(10);
                        time = ann.substring(ann.indexOf(124) + 1, firstNL);
                        try {
                            time = BMUI.m_sdf.format(new Date(Long.parseLong(time)));
                        }
                        catch (Throwable v3) {}
                        noteLabel = String.valueOf(noteLabel) + time;
                        ann = ann.substring(firstNL + 1);
                    } else if (ann.startsWith("OMN")) {
                        noteLabel = "OP: ";
                        firstNL = ann.indexOf(10);
                        time = ann.substring(ann.indexOf(124) + 1, firstNL);
                        try {
                            time = BMUI.m_sdf.format(new Date(Long.parseLong(time)));
                        }
                        catch (Throwable v4) {}
                        ann = ann.substring(firstNL + 1);
                        lnl = ann.indexOf(10);
                        if (lnl != -1) {
                            user = ann.substring(0, lnl);
                            noteLabel = String.valueOf(noteLabel) + user + "\n";
                        }
                        noteLabel = String.valueOf(noteLabel) + time;
                    } else if (ann.startsWith("REO")) {
                        noteLabel = "Re-opened by: ";
                        firstNL = ann.indexOf(10);
                        time = ann.substring(ann.indexOf(124) + 1, firstNL);
                        try {
                            time = BMUI.m_sdf.format(new Date(Long.parseLong(time)));
                        }
                        catch (Throwable v5) {}
                        ann = ann.substring(firstNL + 1);
                        lnl = ann.indexOf(10);
                        if (lnl != -1) {
                            user = ann.substring(0, lnl);
                            noteLabel = String.valueOf(noteLabel) + user + "\n";
                        }
                        noteLabel = String.valueOf(noteLabel) + time;
                    } else if (ann.startsWith("ACF")) {
                        noteLabel = "Auto-closed Finished Alert\n";
                        firstNL = ann.indexOf(10);
                        time = ann.substring(ann.indexOf(124) + 1, firstNL);
                        try {
                            time = BMUI.m_sdf.format(new Date(Long.parseLong(time)));
                        }
                        catch (Throwable v6) {}
                        ann = ann.substring(firstNL + 1);
                        lnl = ann.indexOf(10);
                        if (lnl != -1) {
                            user = ann.substring(0, lnl);
                            noteLabel = String.valueOf(noteLabel) + user + "\n";
                        }
                        noteLabel = String.valueOf(noteLabel) + time;
                    }
lbl136:
                    // 9 sources

                    farr = ann.split("\n");
                    h2 = farr.length * 10 + 15;
                    h2 = Math.min(80, h2);
                    totalSize += h2;
                    if (isAutoClosed) {
                        if (this.m_autoClosed_ID != null && this.m_autoClosed_ID.length() != 0) {
                            l = new Label(this.m_annotationArea, 0);
                            l.setText(noteLabel);
                            link = new Link(this.m_annotationArea, 2048);
                            gd = new GridData(4, 4, true, false, 5, 1);
                            gd.horizontalIndent = 5;
                            link.setLayoutData((Object)gd);
                            message = " <a>" + ann + "</a>";
                            link.setText(message);
                            if (tooltip != null) {
                                link.setToolTipText(tooltip);
                            }
                            link.addListener(13, new Listener(){

                                public void handleEvent(Event event) {
                                    boolean isMsgActive = MessageDetailsDialog.this.m_eventStorage.getEventProvider().getActive(MessageDetailsDialog.this.m_autoClosed_ID) != null;
                                    ShowMessageForIDAction showMsgForID = new ShowMessageForIDAction(MessageDetailsDialog.this.m_autoClosed_ID, isMsgActive);
                                    showMsgForID.run();
                                }
                            });
                        }
                    } else {
                        t = this.m_guiElements.addInputFieldMultiLine(this.m_annotationArea, "Annotation" + i, noteLabel, ann, 5, 1, h2, 120, 0, 0, null);
                        t.setEditable(false);
                        if (tooltip != null) {
                            t.setToolTipText(tooltip);
                        }
                        ((GridData)t.getLayoutData()).horizontalIndent = 5;
                    }
                }
            }
            ++i;
        }
        if (duplicateText != null) {
            duplicateText.setText(duplicates.toString());
        }
        this.m_annotationArea.layout(true);
        this.scrolledComponent.layout(true);
        this.scrolledComponent.setMinSize(this.dialogArea.computeSize(-1, -1));
        this.m_shell.layout(true, true);
    }

    public void open() {
        this.m_shell.pack();
        this.m_shell.open();
        ManageDialogAction.addIndicationDialog(this);
    }

    public void close() {
        try {
            this.m_shell.close();
        }
        catch (Throwable throwable) {}
    }

    protected Point getInitialSize() {
        return new Point(800, 750);
    }

    public void shellActivated(ShellEvent e) {
        this.m_shell.moveAbove(null);
    }

    public void shellClosed(ShellEvent e) {
        ManageDialogAction.removeIndicationDialog(this);
    }

    public void shellDeactivated(ShellEvent e) {
    }

    public void shellDeiconified(ShellEvent e) {
    }

    public void shellIconified(ShellEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        String name = null;
        if (e.getSource() instanceof Button) {
            Button b = (Button)e.getSource();
            name = (String)b.getData();
            if (name.equalsIgnoreCase(EXECUTE_ACTION)) {
                String actionID = String.valueOf(this.m_se.getAgentNode()) + "_" + this.m_se.getOpAction();
                Shell s = ManageDialogAction.isActionDialogOpen(actionID);
                if (s != null) {
                    s.setActive();
                } else {
                    AgentRemoteAction execute = new AgentRemoteAction("Operator Action", this.m_se.getAgentNode(), this.m_se.getOpAction());
                    execute.runAndExecute();
                }
            } else if (name.equalsIgnoreCase(LOAD_ANNOTATIONS_ACTION)) {
                if (this.origDialogSize == 0) {
                    this.origDialogSize = this.dialogArea.getSize().y;
                }
                this.showAnnotations();
            } else if (name.equals(ADD_ANNOTATION_ACTION)) {
                String newAnnotString;
                if (this.origDialogSize == 0) {
                    this.origDialogSize = this.dialogArea.getSize().y;
                }
                if (this.m_newAnnot != null && (newAnnotString = this.m_newAnnot.getText()) != null && newAnnotString.trim().length() > 0) {
                    ServerClient sc = ServerClient.putAnnotation(this.m_se.getID(), newAnnotString);
                    sc.runInUIThread(null);
                    if (sc.isSuccess()) {
                        this.m_newAnnot.setText("");
                        this.showAnnotations();
                        this.loadButton.setVisible(true);
                    }
                }
            } else if (name.equals(RELOAD_ADVICE_ACTION)) {
                String advice = Repository.getInstance().fetchHelp(this.m_se.getInstructionID());
                if (advice == null) {
                    this.m_advice_field.setText("");
                } else if (!this.m_advice_field.getText().equals(advice)) {
                    this.m_advice_field.setText(advice);
                    this.lookupURLs(advice);
                }
            } else if (name.equals(BTN_CLOSE_INDI)) {
                this.m_action_closeIndi = new AcknowledgeAction(this.m_se, this.isOutage());
                this.m_action_closeIndi.run();
                this.m_guiElements.enableField(this.m_closeIndi_btn, false);
            } else if (name.equals(BTN_REOPEN)) {
                this.m_action_reopenIndi = new ReopenMessagesAction(this.m_se, this.isOutage());
                this.m_action_reopenIndi.run();
                this.m_guiElements.enableField(this.m_reopenIndi_btn, false);
            } else if (name.equals(BTN_ADD_COND)) {
                this.m_action_addIndiCond.run();
            } else if (name.equals(BTN_PUSH_INDI2NOTIFICATIOM)) {
                this.m_action_pusIndi2Notification.run();
            } else if (name.equals(BTN_RUN_ON_SELECTED)) {
                this.m_action_runOnSelected.run();
            } else if (name.equals(BTN_ARCHIVE_INDI)) {
                this.m_action_archiveMsg.run();
                this.m_guiElements.enableField(this.m_archiveIndi_btn, false);
                this.m_guiElements.enableField(this.m_closeIndi_btn, false);
            }
        }
    }

    public void modifyText(ModifyEvent e) {
    }

    public Link createLink(String url) {
        Link link = new Link((Composite)this.m_advice_field, 0);
        link.setText("<a href=\"" + url + "\">" + url + "</a>");
        link.setBackground(BMUI.color_grey);
        link.addListener(13, (Listener)this);
        link.pack();
        return link;
    }

    void addControl(StyledText styledText, Control control, int offset, String url) {
        StyleRange style = new StyleRange();
        style.start = offset;
        style.length = 1;
        control.pack();
        Rectangle rect = control.getBounds();
        int ascent = 11 * rect.height / 12;
        int descent = rect.height - ascent;
        Text text = new Text(new Composite((Composite)new Shell(), 0), 0);
        text.setText(url);
        GC gc = new GC((Drawable)text);
        FontMetrics fm = gc.getFontMetrics();
        int width = fm.getAverageCharWidth();
        gc.dispose();
        text.dispose();
        style.metrics = new GlyphMetrics(ascent + this.MARGIN, descent + this.MARGIN, width + this.MARGIN);
        styledText.setStyleRange(style);
    }

    public void handleEvent(Event event) {
        OpenBrowserAction openBrowser = new OpenBrowserAction(event.text);
        openBrowser.run();
    }

    @Override
    public void update(SEvent se) {
        if (this.m_shell.isDisposed()) {
            Repository.getEventProvider().unregisterSEventUpdateLitener(this);
            return;
        }
        if (se.getID().equals(this.m_se.getID())) {
            try {
                try {
                    if (this.m_refreshRunning.compareAndSet(false, true)) {
                        this.m_se = se;
                        UIJob uij = new UIJob("RMDD" + se.getID()){

                            @Override
                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                try {
                                    Control[] controlArray = MessageDetailsDialog.this.scrolledComponent.getChildren();
                                    int n = controlArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        Control ctrl = controlArray[n2];
                                        ctrl.dispose();
                                        ++n2;
                                    }
                                    MessageDetailsDialog.this.dialogArea = MessageDetailsDialog.this.createDialogArea((Composite)MessageDetailsDialog.this.scrolledComponent);
                                    MessageDetailsDialog.this.checkButtonSection();
                                    MessageDetailsDialog.this.scrolledComponent.setContent(MessageDetailsDialog.this.dialogArea);
                                    MessageDetailsDialog.this.scrolledComponent.setMinSize(MessageDetailsDialog.this.dialogArea.computeSize(-1, -1, true));
                                }
                                catch (Throwable throwable) {}
                                return Status.OK_STATUS;
                            }
                        };
                        UIJobManager.getInstance().schedule(uij);
                    }
                }
                catch (Throwable throwable) {
                    this.m_refreshRunning.set(false);
                }
            }
            finally {
                this.m_refreshRunning.set(false);
            }
        }
    }

    public boolean isDisposed() {
        return this.m_shell.isDisposed();
    }

    @Override
    public void update(Set<SEvent> se) {
        if (se.contains(this.m_se)) {
            this.cleanAll();
        }
    }

    @Override
    public void cleanAll() {
        UIJob uij = new UIJob(this.m_shell.toString()){

            @Override
            public IStatus runInUIThread(IProgressMonitor monitor) {
                MessageDetailsDialog.this.m_shell.dispose();
                return Status.OK_STATUS;
            }
        };
        UIJobManager.getInstance().schedule(uij);
    }

    private class ShowMessageForIDAction
    extends Action {
        private String m_ID;
        private boolean m_isMsgActive;

        public ShowMessageForIDAction(String indicationID, boolean isMsgActive) {
            super("ShowIndication");
            this.m_ID = null;
            this.m_isMsgActive = false;
            this.setText("Show Indication");
            this.setId("showindication");
            this.setImageDescriptor(BMUI.IMAGE_DESC_INDICATIONS);
            this.m_ID = indicationID;
            this.m_isMsgActive = isMsgActive;
            if (this.m_ID == null || this.m_ID.length() == 0 || Repository.getInstance().getRights(1000) <= 1) {
                this.setEnabled(false);
                return;
            }
        }

        public void run() {
            MessageDetailsDialog msd = new MessageDetailsDialog(MessageDetailsDialog.this.m_shell, Repository.getEventProvider().getEvent(this.m_ID), MessageDetailsDialog.this.m_eventStorage);
            msd.open();
        }
    }
}

