/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.dialogs;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.EventFilter;
import com.blixx.boom.engine.EventSorter;
import com.blixx.boom.engine.ITableBrowserProvider;
import com.blixx.boom.engine.MonitorHistoryTableProvider;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClient;
import com.blixx.boom.gui.dialogs.IDateRangeChangeListener;
import com.blixx.boom.gui.dialogs.MessageDetailsDialog;
import com.blixx.boom.gui.policies.PolicyManager;
import com.blixx.boom.gui.utils.Chart;
import com.blixx.boom.gui.views.PrintJob;
import com.blixx.log.RTLogger;
import com.blixx.shared.BM;
import com.blixx.shared.Condition;
import com.blixx.shared.Policy;
import com.blixx.shared.SEvent;
import com.blixx.shared.SEventFwd;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class MonitorHistoryDialog
implements ShellListener,
SelectionListener,
ModifyListener,
IDateRangeChangeListener,
IDoubleClickListener,
KeyListener {
    private static final String COLUMN_SEVERITY = "Severity";
    private static final String COLUMN_DUPLICATES = "Duplicates";
    private static final String COLUMN_FIRSTTIME = "FirstTime";
    private static final String COLUMN_TIME = "Time";
    private static final String COLUMN_TEXT = "Text";
    private static final String COLUMN_VALUE = "Value";
    private static final String COLUMN_FVALUE = "Fin Value";
    private static final String COLUMN_FTIME = "Fin Time";
    private static final String COLUMN_STATUS = "Status";
    private static final String COLUMN_HOST = "Host";
    private static final String COLUMN_SRV_TIME = "SrvTime";
    public static final Color COLOR_LIGHT_GREY = new Color(239, 239, 239);
    public static final Color COLOR_UNKNOWN = new Color(150, 150, 150, 60);
    public static final Color COLOR_NORMAL = new Color(20, 255, 20, 60);
    public static final Color COLOR_WARNING = new Color(37, 68, 131, 60);
    public static final Color COLOR_MINOR = new Color(255, 255, 10, 60);
    public static final Color COLOR_MAJOR = new Color(222, 142, 35, 60);
    public static final Color COLOR_RED = new Color(255, 0, 0, 60);
    public static final Color COLOR_LINE = new Color(10, 3, 10);
    public List<SEvent> m_arr;
    private Shell m_shell;
    private boolean maxthreshold;
    private Map<Double, Integer> m_intervals;
    private String monName;
    private String agentName;
    private String legend;
    private String title;
    private Image m_image;
    private SEvent m_firstEvent;
    private TableViewer m_eventsViewer;
    private MonitorHistoryTableProvider m_eventsProvider;
    private SashForm m_main;
    private Composite m_top;
    private EventSorter m_eventSorter;
    private int m_typeOfGraph;
    private ITableBrowserProvider m_eventStorage;
    private Listener sortListener;
    private Policy m_policy;

    public MonitorHistoryDialog(Shell parentShell, ArrayList<SEvent> arr, ITableBrowserProvider eventStorage) {
        this(parentShell, arr, -1, null, eventStorage);
    }

    public MonitorHistoryDialog(Shell parentShell, List<SEvent> arr, int type, Image image, ITableBrowserProvider eventStorage) {
        block12: {
            this.m_arr = null;
            this.maxthreshold = true;
            this.m_intervals = new LinkedHashMap<Double, Integer>();
            this.m_image = null;
            this.m_eventsViewer = null;
            this.m_eventsProvider = null;
            this.m_main = null;
            this.m_top = null;
            this.m_typeOfGraph = -1;
            this.m_eventStorage = null;
            this.sortListener = new Listener(){

                public void handleEvent(Event e) {
                    if (e.type == 13) {
                        TableColumn sortColumn = MonitorHistoryDialog.this.m_eventsViewer.getTable().getSortColumn();
                        TableColumn currentColumn = (TableColumn)e.widget;
                        int dir = MonitorHistoryDialog.this.m_eventsViewer.getTable().getSortDirection();
                        if (sortColumn == currentColumn) {
                            dir = dir == 128 ? 1024 : 128;
                        } else {
                            MonitorHistoryDialog.this.m_eventsViewer.getTable().setSortColumn(currentColumn);
                            dir = 128;
                        }
                        String sortIdentifier = currentColumn.getText();
                        MonitorHistoryDialog.this.m_eventSorter.setConfig(sortIdentifier, dir);
                        MonitorHistoryDialog.this.m_eventsViewer.getTable().setSortDirection(dir);
                        ISelection sel = MonitorHistoryDialog.this.m_eventsViewer.getSelection();
                        MonitorHistoryDialog.this.m_eventsViewer.refresh(true, false);
                        MonitorHistoryDialog.this.m_eventsViewer.setSelection(sel, false);
                    } else if (e.type != 40 && e.type != 36) {
                        int cfr_ignored_0 = e.type;
                    }
                }
            };
            this.m_eventStorage = eventStorage;
            this.m_typeOfGraph = type;
            this.m_shell = new Shell(Display.getCurrent().getActiveShell(), 1265);
            this.m_arr = arr;
            this.m_firstEvent = arr.get(0);
            this.monName = this.m_firstEvent.getMonitor();
            this.agentName = this.m_firstEvent.getAgentNode();
            try {
                PolicyManager pm;
                block13: {
                    if (this.monName.equals("Availability")) {
                        this.maxthreshold = false;
                        this.m_intervals.put(new Double(0.5), 5);
                        this.m_intervals.put((Double)Double.MAX_VALUE, 1);
                        break block12;
                    }
                    if (this.monName.length() == 0) {
                        this.maxthreshold = true;
                        this.m_intervals.put(new Double(4.5), 5);
                        this.m_intervals.put(new Double(3.5), 4);
                        this.m_intervals.put(new Double(2.5), 3);
                        this.m_intervals.put(new Double(1.5), 2);
                        this.m_intervals.put(new Double(0.5), 1);
                        this.m_intervals.put(new Double(-0.5), 0);
                        break block12;
                    }
                    pm = PolicyManager.getInstance();
                    this.m_policy = null;
                    try {
                        if (!(this.m_firstEvent instanceof SEventFwd)) break block13;
                        SEventFwd sef = (SEventFwd)this.m_firstEvent;
                        String slaveServer = null;
                        if (sef.getSrv() != null && !sef.getSrv().equals("")) {
                            slaveServer = !sef.getSrvtype().equals(BM.PRODUCT_lowercase) ? sef.getSrvtype() : sef.getSrv();
                        }
                        if (slaveServer == null) break block13;
                        ServerClient sc = ServerClient.getFileSlave(new String[]{this.monName, BMUI.type_mon, slaveServer, String.valueOf(Repository.getUserPoliciesDirectory()) + "slaves" + File.separator + slaveServer + File.separator});
                        sc.runInUIThread(null);
                        if (sc.isSuccess()) {
                            File f = (File)sc.getResultObject();
                            this.m_policy = pm.getMonitorPolicy(f);
                            break block13;
                        }
                        this.m_policy = Policy.createNewPolicy();
                        throw new RuntimeException("Slave server is too deep.");
                    }
                    catch (Throwable e) {
                        RTLogger.print(5, "", e);
                    }
                }
                if (this.m_policy == null) {
                    File fileP = Repository.getInstance().getFetched(this.monName, BMUI.type_mon);
                    if (fileP == null) {
                        fileP = Repository.getInstance().fetchFile(this.monName, BMUI.type_mon);
                    }
                    this.m_policy = pm.getMonitorPolicy(fileP);
                }
                if (this.m_policy != null) {
                    this.maxthreshold = this.m_policy.getType().startsWith("MAX");
                    String obj = this.m_firstEvent.getObject();
                    List<Object> conds = null;
                    conds = obj != null && !obj.equals("") ? this.m_policy.getConditionsForObject(obj, null) : this.m_policy.getConditions().getConditionList();
                    for (Condition c : conds) {
                        if (c == null) continue;
                        this.m_intervals.put(new Double(c.getThreshold()), c.getSetSeverity());
                    }
                }
            }
            catch (Throwable e) {
                RTLogger.print(5, "", e);
            }
        }
        this.legend = MonitorHistoryDialog.getEventLegend(this.m_firstEvent);
        this.title = "History of Monitor=\"" + this.monName + "\" Object=\"" + this.m_firstEvent.getObject() + "\" Agent: " + this.agentName;
        this.m_image = image == null ? (this.m_typeOfGraph > 0 ? BMUI.IMAGE_GR2 : BMUI.IMAGE_GR1) : image;
        this.setTitles();
        this.m_shell.addShellListener((ShellListener)this);
        this.m_shell.setData((Object)this.createContents((Composite)this.m_shell));
    }

    public static String getEventLegend(SEvent se) {
        StringBuffer sb = new StringBuffer();
        sb.append(se.getNode()).append(":");
        sb.append(se.getApplication()).append(":");
        sb.append(se.getGroup()).append(":");
        sb.append(se.getObject()).append(" (Agent: ").append(se.getAgentNode()).append(")");
        return sb.toString();
    }

    protected Control createContents(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.m_main = new SashForm(parent, 512);
        GridData gd = new GridData(4, 4, true, true);
        this.m_top = new Composite((Composite)this.m_main, 0);
        Composite comp = new Composite((Composite)this.m_main, 0);
        comp.setLayoutData((Object)gd);
        comp.setLayout((Layout)new FillLayout());
        Chart chart = new Chart(comp, 2048, this.m_arr, this.m_intervals, this.maxthreshold, this.m_typeOfGraph);
        chart.addDateRangeChangeListener(this);
        this.createEventsTable((Composite)this.m_main);
        int size = 1;
        List<String> keys = chart.getKeys();
        if (keys == null) {
            this.m_top.setLayout((Layout)new GridLayout(1, false));
            Label title = new Label(this.m_top, 0x1000000);
            title.setText(this.title);
            title.setFont(BMUI.font_arial8_bold);
            title.setLayoutData((Object)gd);
            this.m_main.setWeights(new int[]{5, 75, 20});
        } else {
            size = keys.size();
            this.m_top.setLayout((Layout)new GridLayout(6, false));
            int i = 0;
            while (i < size) {
                String key = keys.get(i);
                String[] arr = key.split("\\Q\u25ba\\E");
                org.eclipse.swt.graphics.Color c = chart.getColor(i);
                this.createSerieLabel(c, "Agent: " + arr[0]);
                this.createSerieLabel(c, "Host: " + arr[1]);
                this.createSerieLabel(c, "App: " + arr[2]);
                this.createSerieLabel(c, "Grp: " + arr[3]);
                this.createSerieLabel(c, "Obj: " + arr[4]);
                this.createSerieLabel(c, "Mon: " + arr[5]);
                ++i;
            }
            this.m_main.setWeights(new int[]{3 * size, 75, 20});
            this.m_shell.setText("Monitors History...");
        }
        this.m_main.addKeyListener((KeyListener)this);
        return this.m_main;
    }

    private void createSerieLabel(org.eclipse.swt.graphics.Color c, String text) {
        Label label = new Label(this.m_top, 16384);
        label.setText(text);
        label.setToolTipText(text);
        label.setFont(BMUI.font_arial7_bold);
        GridData gd = new GridData(4, 1, true, false);
        label.setLayoutData((Object)gd);
        label.setForeground(c);
    }

    public void createEventsTable(Composite parent) {
        ScrolledComposite xscrolledComponent = new ScrolledComposite(parent, 768);
        xscrolledComponent.setAlwaysShowScrollBars(false);
        xscrolledComponent.setExpandHorizontal(true);
        xscrolledComponent.setExpandVertical(true);
        GridData gd0 = new GridData(4, 3, true, false);
        xscrolledComponent.setLayoutData((Object)gd0);
        Table tbl = new Table((Composite)xscrolledComponent, 268503810);
        tbl.setHeaderVisible(true);
        tbl.setLinesVisible(true);
        TableColumn col1 = new TableColumn(tbl, 16384);
        col1.setText(COLUMN_SEVERITY);
        col1.setWidth(20);
        col1.setMoveable(true);
        TableColumn col1a = new TableColumn(tbl, 16384);
        col1a.setText(COLUMN_DUPLICATES);
        col1a.setWidth(30);
        col1a.setMoveable(true);
        TableColumn col1b = new TableColumn(tbl, 16384);
        col1b.setText(COLUMN_FIRSTTIME);
        col1b.setWidth(85);
        col1b.setMoveable(true);
        TableColumn col2 = new TableColumn(tbl, 16384);
        col2.setText(COLUMN_TIME);
        col2.setWidth(130);
        col2.setMoveable(true);
        TableColumn col3 = new TableColumn(tbl, 16384);
        col3.setText(COLUMN_TEXT);
        col3.setWidth(300);
        col3.setMoveable(true);
        TableColumn col4 = new TableColumn(tbl, 16384);
        col4.setText(COLUMN_VALUE);
        col4.setWidth(80);
        col4.setMoveable(true);
        TableColumn col4a = new TableColumn(tbl, 16384);
        col4a.setText(COLUMN_FVALUE);
        col4a.setWidth(80);
        col4a.setMoveable(true);
        TableColumn col4b = new TableColumn(tbl, 16384);
        col4b.setText(COLUMN_FTIME);
        col4b.setWidth(130);
        col4b.setMoveable(true);
        TableColumn col5 = new TableColumn(tbl, 16384);
        col5.setText(COLUMN_SRV_TIME);
        col5.setWidth(130);
        col5.addListener(13, this.sortListener);
        col5.setMoveable(true);
        TableColumn col6 = new TableColumn(tbl, 16384);
        col6.setText(COLUMN_STATUS);
        col6.setWidth(150);
        col6.setMoveable(true);
        TableColumn col7 = new TableColumn(tbl, 16384);
        col7.setText(COLUMN_HOST);
        col7.setWidth(250);
        col7.setMoveable(true);
        tbl.setSortColumn(col5);
        tbl.setSortDirection(1024);
        this.m_eventSorter = new EventSorter("ALLT", 1024);
        this.m_eventsViewer = new TableViewer(tbl);
        this.m_eventsProvider = new MonitorHistoryTableProvider(new String[]{COLUMN_SEVERITY, COLUMN_DUPLICATES, COLUMN_FIRSTTIME, COLUMN_TIME, COLUMN_VALUE, COLUMN_FVALUE, COLUMN_FTIME, COLUMN_SRV_TIME}, this.m_arr);
        this.m_eventsViewer.setSorter((ViewerSorter)this.m_eventSorter);
        this.m_eventsViewer.setContentProvider((IContentProvider)this.m_eventsProvider);
        this.m_eventsViewer.setComparer((IElementComparer)this.m_eventSorter);
        this.m_eventsViewer.setLabelProvider((IBaseLabelProvider)this.m_eventsProvider);
        this.m_eventsViewer.setUseHashlookup(true);
        this.m_eventsViewer.setInput((Object)this.m_eventsProvider.getElements(null));
        this.m_eventsViewer.addDoubleClickListener((IDoubleClickListener)this);
        GridData gd = new GridData();
        gd.verticalAlignment = 1024;
        gd.horizontalAlignment = 4;
        tbl.setLayoutData((Object)gd);
        tbl.setBackground(BMUI.color_lightYellow);
        tbl.setForeground(BMUI.color_black);
        xscrolledComponent.setMinSize(700, 100);
        xscrolledComponent.setContent((Control)this.m_eventsViewer.getTable());
    }

    public void setTitles() {
        this.m_shell.setImage(this.m_image);
        this.m_shell.setText(this.legend);
    }

    public void open() {
        this.m_shell.open();
    }

    protected Point getInitialSize() {
        return new Point(800, 750);
    }

    public void shellActivated(ShellEvent e) {
        this.m_shell.moveAbove(null);
    }

    public void shellClosed(ShellEvent e) {
    }

    public void shellDeactivated(ShellEvent e) {
        this.m_shell.moveAbove(null);
    }

    public void shellDeiconified(ShellEvent e) {
    }

    public void shellIconified(ShellEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
    }

    public void modifyText(ModifyEvent e) {
    }

    @Override
    public void changed(long start, long end) {
        try {
            String startSTR = BMUI.m_sdf_milliSec.format(new Date(start - 1L));
            String endSTR = BMUI.m_sdf_milliSec.format(new Date(end + 1L));
            if (this.m_eventsViewer != null) {
                EventFilter st = new EventFilter(null, "TimePlusDuplicates", startSTR, false, 5, this.m_eventsViewer, true, 0, 0);
                EventFilter fi = new EventFilter(null, "TimePlusDuplicates", endSTR, false, 6, this.m_eventsViewer, true, 0, 0);
                this.m_eventsViewer.setFilters(new ViewerFilter[]{st, fi});
                this.m_eventsViewer.refresh(true, false);
            }
        }
        catch (Throwable throwable) {}
    }

    public void drawLine() {
    }

    public void doubleClick(DoubleClickEvent event) {
        StructuredSelection ssel = (StructuredSelection)event.getSelection();
        if (!ssel.isEmpty()) {
            for (SEvent se : ssel) {
                MessageDetailsDialog mdd = new MessageDetailsDialog(this.m_shell, se, this.m_eventStorage);
                mdd.open();
                mdd.setTitles();
            }
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        Control o;
        PrintJob job;
        if (e.keyCode == 112 && e.stateMask == 262144 && (job = new PrintJob("name", o = (Control)e.getSource())).showDialog()) {
            job.schedule();
        }
    }
}

