/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.dialogs;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.views.AbstractPolicyTab;
import com.blixx.boom.gui.views.MonprogTableProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class MonprogDialog
extends StatusDialog
implements ModifyListener,
SelectionListener {
    public static final String TRANSACTION_TIMEOUT_TOOLTIP = "Maximum time in seconds to wait end of transaction (Successfull or Failed)";
    public static final String FINISH_PATTERN_TOOLTIP = "A record matches with this pattern must indicate successfully finished transaction.\nCapturing group from Start Pattern can be used here.\nuse: <$svarN> where N - number of capturing group defined in the Start Pattern\nNumeration of the variables is started from 1.";
    public static final String FAILED_PATTERN_TOOLTIP = "A record matches with this pattern must indicate failed transaction.\nCapturing group from Start Pattern can be used here.\nuse: <$svarN> where N - number of capturing group defined in the Start Pattern\nNumeration of the variables is started from 1.";
    public static final String START_TRANSACTION_TOOLTIP = "Pattern to match start of transaction.\nValue of defined capturing groups can be re-used in Finish or Fail Patterns";
    public static final String EXEC_TOOLTIP = "Will be triggered before checking logfile.\nCan be used to generate a new logfile.";
    public static final String FROM_START_TOOLTIP = "FROM_START tells the monitor to scan file from the start each polling interval\nFROM_LAST - indicates to analyze logfile from last position.";
    public static final String GENERAL_PATTERN_TOOLTIP = "Only records matched with this pattern will be checked against Policy conditions";
    public static final String SPLIT_RECORDS_TOOLTIP = "Allows to split multi-line log records based on the specified pattern.\nA line of the logfile matched with this pattern will indicate a start of a record";
    private MonprogDialog m_dialog = null;
    private String m_callType = null;
    private String m_currentOperator = null;
    private String[] m_monprog = null;
    private int m_itemIndex = -1;
    private int m_startIndex = -1;
    private boolean m_isNew = false;
    private GUIDisplayElements m_gui = null;
    private boolean m_isReadOnly = false;
    public Composite m_parentComp = null;
    public Composite m_dialogArea = null;
    private Composite m_topComp = null;
    public StyledText m_p1_field_styled = null;
    public StyledText m_p2_field_styled = null;
    public StyledText m_p3_field_styled = null;
    public Text m_object_field = null;
    public Text m_calculation_field = null;
    public StyledText m_variable_field_styled = null;
    public Text m_exec_field = null;
    public Text m_timeOut_field = null;
    public CCombo m_fromStartLast_combo = null;
    public CCombo m_operator_combo = null;
    private boolean m_isP1Valid = false;
    private boolean m_isP2Valid = false;
    private boolean m_isP3Valid = false;
    private boolean m_isSVarNValid = false;
    private boolean m_isTimeoutValid = false;
    public static String PATTERN1_FIELD = "PATTERN1_FIELD";
    public static String PATTERN2_FIELD = "PATTERN2_FIELD";
    public static String PATTERN3_FIELD = "PATTERN3_FIELD";
    public static String EXEC_FIELD = "EXEC_FIELD";
    public static String TIMEOUT_FIELD = "TIMEOUT_FIELD";
    public static String OBJECT_FIELD = "OBJECT_FIELD";
    public static String CALCULATION_FIELD = "CALCULATCION_FIELD";
    public static String VARIABLE_FIELD = "VARIABLE_FIELD";
    public static String FROM_START_LAST_COMBO = "FROM_START_LAST_COMBO";
    public static String OPERATOR_COMBO = "OPERATOR_COMBO";
    public static String FROM_START = "FROM_START";
    public static String FROM_LAST = "FROM_LAST";
    public static String[] list = new String[]{FROM_START, String.valueOf(FROM_LAST) + " (default)"};
    public static String[] OP_LIST_LBL = new String[]{"", "=", "DELTA"};
    public static String COUNT = "COUNT";
    public static String[] OP_LIST_TS = new String[]{"", "SUM", "MIN", "MAX", "AVG", "COUNT"};
    public Text m_punchCard_regex_field = null;
    public Text m_punchCard_variables_field = null;
    public static String PUNCHCARD_REGEX = "PUNCHCARD_REGEX";
    public static String PUNCHCARD_VARIABLES = "PUNCHCARD_VARIABLES";
    public boolean m_snmpWalk = false;

    public MonprogDialog(Shell parentShell, String callType, String[] monprog, int itemIndex, boolean isNew, boolean isReadOnly) {
        super(parentShell);
        String monitorClassName;
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x80 | 0x400);
        this.setTitle("  " + callType + " Details");
        this.m_dialog = this;
        this.m_callType = callType;
        this.m_monprog = monprog;
        if (MonprogTableProvider.LINE_BY_LINE.equals(this.m_callType) && MonprogTableProvider.SNMP_MONITOR_NAME.equals(monitorClassName = this.m_monprog[0])) {
            this.m_snmpWalk = true;
        }
        this.m_itemIndex = itemIndex;
        this.m_isNew = isNew;
        this.m_isReadOnly = isReadOnly;
        this.m_gui = new GUIDisplayElements();
    }

    protected Control createDialogArea(Composite parent) {
        this.m_parentComp = parent;
        this.m_gui = new GUIDisplayElements();
        this.m_gui.centerShell(this.m_parentComp.getShell(), Display.getCurrent());
        this.m_dialogArea = new Composite(this.m_parentComp, 0);
        GridLayout gdLayout = new GridLayout(4, false);
        gdLayout.marginTop = 5;
        gdLayout.marginRight = 10;
        gdLayout.marginLeft = 10;
        gdLayout.verticalSpacing = 1;
        this.m_dialogArea.setLayout((Layout)gdLayout);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 600;
        this.m_dialogArea.setLayoutData((Object)gd);
        if (this.m_callType.endsWith(MonprogTableProvider.LOGFILE_MONITOR)) {
            String startPattern = "";
            String generalPattern = "";
            String fromStart_fromLast = "";
            String execCall = "";
            try {
                startPattern = this.m_monprog[2];
                startPattern = MonprogTableProvider.removeLineBreak(startPattern);
            }
            catch (Exception exception) {}
            try {
                generalPattern = this.m_monprog[3];
                generalPattern = MonprogTableProvider.removeLineBreak(generalPattern);
            }
            catch (Exception exception) {}
            try {
                fromStart_fromLast = this.m_monprog[4];
                fromStart_fromLast = MonprogTableProvider.removeLineBreak(fromStart_fromLast);
                if (!fromStart_fromLast.equalsIgnoreCase(FROM_START)) {
                    fromStart_fromLast = fromStart_fromLast.equalsIgnoreCase(FROM_LAST) ? String.valueOf(FROM_LAST) + " (default)" : String.valueOf(FROM_LAST) + " (default)";
                }
            }
            catch (Exception exception) {
                fromStart_fromLast = String.valueOf(FROM_LAST) + " (default)";
            }
            try {
                execCall = this.m_monprog[5];
                execCall = MonprogTableProvider.removeLineBreak(execCall);
            }
            catch (Exception exception) {}
            this.m_gui.addTextField(this.m_dialogArea, null, "Split Records: ", 4, 1, 0, 0, null);
            this.m_p1_field_styled = this.m_gui.addStyledText(this.m_dialogArea, null, PATTERN1_FIELD, startPattern, 4, 1, 0, 3, this);
            this.m_p1_field_styled.setToolTipText(SPLIT_RECORDS_TOOLTIP);
            AbstractPolicyTab.addContentMenu4PatternField((Widget)this.m_p1_field_styled, false, this.m_dialog.getShell());
            this.m_isP1Valid = AbstractPolicyTab.validatePattern(this.m_p1_field_styled);
            this.m_gui.addTextField(this.m_dialogArea, null, "General Pattern: ", 4, 1, 0, 0, null);
            this.m_p2_field_styled = this.m_gui.addStyledText(this.m_dialogArea, null, PATTERN2_FIELD, generalPattern, 4, 1, 0, 3, this);
            this.m_p2_field_styled.setToolTipText(GENERAL_PATTERN_TOOLTIP);
            AbstractPolicyTab.addContentMenu4PatternField((Widget)this.m_p2_field_styled, false, this.m_dialog.getShell());
            this.m_isP2Valid = AbstractPolicyTab.validatePattern(this.m_p2_field_styled);
            this.m_fromStartLast_combo = this.m_gui.addDropDown(this.m_dialogArea, FROM_START_LAST_COMBO, "FROM_START Or FROM_LAST: ", list, fromStart_fromLast, "Default value is 'From_Last'", 4, 1, 0, 3, this);
            this.m_fromStartLast_combo.setToolTipText(FROM_START_TOOLTIP);
            this.m_exec_field = this.m_gui.addInputFieldSingle(this.m_dialogArea, EXEC_FIELD, "Executable Call (optional): ", execCall, 4, 1, 0, 3, 60, this);
            this.m_exec_field.setToolTipText(EXEC_TOOLTIP);
            ((GridData)this.m_exec_field.getLayoutData()).horizontalAlignment = 4;
        } else if (this.m_callType.endsWith(MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR) || this.m_callType.endsWith(MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR_MULITLINE)) {
            String startPattern = "";
            String finishPattern = "";
            String failPattern = "";
            String timeout = "";
            if (this.m_isNew) {
                startPattern = ".*";
                finishPattern = ".*";
                failPattern = ".*";
                timeout = "60";
            } else {
                if (this.m_callType.endsWith(MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR)) {
                    this.m_startIndex = 2;
                    if (this.m_itemIndex > 0) {
                        this.m_startIndex = this.m_itemIndex * 4 + 2;
                    }
                } else if (this.m_callType.endsWith(MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR_MULITLINE)) {
                    this.m_startIndex = 3;
                    if (this.m_itemIndex > 0) {
                        this.m_startIndex = this.m_itemIndex * 4 + 3;
                    }
                }
                if (this.m_startIndex > -1) {
                    try {
                        startPattern = this.m_monprog[this.m_startIndex];
                        startPattern = MonprogTableProvider.removeLineBreak(startPattern);
                        finishPattern = this.m_monprog[this.m_startIndex + 1];
                        finishPattern = MonprogTableProvider.removeLineBreak(finishPattern);
                        failPattern = this.m_monprog[this.m_startIndex + 2];
                        failPattern = MonprogTableProvider.removeLineBreak(failPattern);
                        timeout = this.m_monprog[this.m_startIndex + 3];
                        timeout = MonprogTableProvider.removeLineBreak(timeout);
                    }
                    catch (Exception exception) {}
                }
            }
            this.m_gui.addTextField(this.m_dialogArea, null, "Start Pattern: ", 4, 1, 0, 0, null);
            this.m_p1_field_styled = this.m_gui.addStyledText(this.m_dialogArea, null, PATTERN1_FIELD, startPattern, 4, 1, 0, 3, this);
            this.m_p1_field_styled.setToolTipText(START_TRANSACTION_TOOLTIP);
            AbstractPolicyTab.addContentMenu4PatternField((Widget)this.m_p1_field_styled, false, this.m_dialog.getShell());
            this.m_isP1Valid = AbstractPolicyTab.validatePattern(this.m_p1_field_styled);
            this.m_gui.addTextField(this.m_dialogArea, null, "Finish Pattern: ", 4, 1, 0, 0, null);
            this.m_p2_field_styled = this.m_gui.addStyledText(this.m_dialogArea, null, PATTERN2_FIELD, finishPattern, 4, 1, 0, 3, this);
            this.m_p2_field_styled.setToolTipText(FINISH_PATTERN_TOOLTIP);
            AbstractPolicyTab.addContentMenu4PatternField((Widget)this.m_p2_field_styled, false, this.m_dialog.getShell());
            this.m_isP2Valid = AbstractPolicyTab.validatePattern(this.m_p2_field_styled);
            this.m_gui.addTextField(this.m_dialogArea, null, "Fail Pattern: ", 4, 1, 0, 0, null);
            this.m_p3_field_styled = this.m_gui.addStyledText(this.m_dialogArea, null, PATTERN3_FIELD, failPattern, 4, 1, 0, 3, this);
            this.m_p3_field_styled.setToolTipText(FAILED_PATTERN_TOOLTIP);
            AbstractPolicyTab.addContentMenu4PatternField((Widget)this.m_p3_field_styled, false, this.m_dialog.getShell());
            this.m_isP3Valid = AbstractPolicyTab.validatePattern(this.m_p3_field_styled);
            this.m_timeOut_field = this.m_gui.addInputFieldSingle(this.m_dialogArea, TIMEOUT_FIELD, "Timeout (Sec): ", timeout, 4, 1, 0, 3, 60, this);
            this.m_timeOut_field.setToolTipText(TRANSACTION_TIMEOUT_TOOLTIP);
            ((GridData)this.m_timeOut_field.getLayoutData()).horizontalAlignment = 4;
            this.m_isTimeoutValid = this.validateTimeout(timeout, this.m_timeOut_field);
        } else if (this.m_callType.equals(MonprogTableProvider.LINE_BY_LINE)) {
            if (!this.m_snmpWalk) {
                String operator;
                String calculation;
                String object;
                String pattern;
                block73: {
                    pattern = "";
                    object = "";
                    calculation = "";
                    operator = "";
                    this.m_startIndex = this.m_itemIndex * 2 + 3;
                    if (!this.m_isNew && this.m_startIndex != -1) {
                        int i;
                        int size = this.m_startIndex + 2;
                        if (this.m_monprog.length < size) {
                            String[] newParams = new String[size];
                            i = 0;
                            while (i < this.m_monprog.length) {
                                if (this.m_monprog[i] == null) {
                                    this.m_monprog[i] = "";
                                }
                                newParams[i] = this.m_monprog[i];
                                ++i;
                            }
                            i = 0;
                            while (i < newParams.length) {
                                if (newParams[i] == null) {
                                    newParams[i] = "";
                                }
                                ++i;
                            }
                            this.m_monprog = newParams;
                        }
                        try {
                            pattern = this.m_monprog[this.m_startIndex];
                            pattern = MonprogTableProvider.removeLineBreak(pattern);
                        }
                        catch (Exception exception) {}
                        try {
                            String obj = this.m_monprog[this.m_startIndex + 1];
                            obj = MonprogTableProvider.removeLineBreak(obj);
                            operator = OP_LIST_LBL[0];
                            i = 1;
                            while (i < OP_LIST_LBL.length) {
                                if (obj.indexOf(OP_LIST_LBL[i]) != -1) {
                                    operator = OP_LIST_LBL[i];
                                    break;
                                }
                                ++i;
                            }
                            if (operator != "") {
                                String[] sub = obj.split(operator);
                                try {
                                    object = sub[0];
                                }
                                catch (Exception exception) {
                                    object = "";
                                }
                                try {
                                    calculation = sub[1];
                                }
                                catch (Exception exception) {
                                    calculation = "";
                                }
                                break block73;
                            }
                            object = obj.trim();
                        }
                        catch (Exception exception) {}
                    }
                }
                this.m_gui.addTextField(this.m_dialogArea, null, "Pattern: ", 4, 1, 0, 0, null);
                this.m_p1_field_styled = this.m_gui.addStyledText(this.m_dialogArea, null, PATTERN1_FIELD, pattern, 4, 1, 0, 3, this);
                AbstractPolicyTab.addContentMenu4PatternField((Widget)this.m_p1_field_styled, false, this.m_dialog.getShell());
                this.m_isP1Valid = AbstractPolicyTab.validatePattern(this.m_p1_field_styled);
                this.m_gui.addTextField(this.m_dialogArea, null, "Object: ", 3, 1, 10, 0, null);
                this.m_gui.addTextField(this.m_dialogArea, null, "Calculation: ", 1, 1, 10, 0, null);
                this.m_object_field = this.m_gui.addInputFieldSingle(this.m_dialogArea, OBJECT_FIELD, null, object, 2, 1, 0, 5, 150, this);
                ((GridData)this.m_object_field.getLayoutData()).horizontalAlignment = 1;
                ((GridData)this.m_object_field.getLayoutData()).grabExcessHorizontalSpace = false;
                if (object.trim().equals("")) {
                    this.m_object_field.setBackground(BMUI.color_light_red);
                }
                this.m_operator_combo = this.m_gui.addDropDown(this.m_dialogArea, OPERATOR_COMBO, OP_LIST_LBL, operator, 1, 1, 3, null);
                this.m_operator_combo.addSelectionListener((SelectionListener)this);
                if (operator.trim().equals("")) {
                    this.m_operator_combo.setBackground(BMUI.color_light_red);
                }
                this.m_calculation_field = this.m_gui.addInputFieldSingle(this.m_dialogArea, CALCULATION_FIELD, null, calculation, 1, 1, 0, 3, 60, this);
                ((GridData)this.m_calculation_field.getLayoutData()).horizontalAlignment = 4;
                ((GridData)this.m_calculation_field.getLayoutData()).grabExcessHorizontalSpace = true;
                if (calculation.trim().equals("")) {
                    this.m_calculation_field.setBackground(BMUI.color_light_red);
                }
            } else {
                String operator;
                String calculation;
                String object;
                block74: {
                    int firstOFCline = -1;
                    int i = 1;
                    while (i < this.m_monprog.length) {
                        if (!this.m_monprog[i].startsWith("-")) {
                            firstOFCline = i;
                            break;
                        }
                        ++i;
                    }
                    object = "";
                    calculation = "";
                    operator = "";
                    this.m_startIndex = this.m_itemIndex + firstOFCline;
                    if (!this.m_isNew && this.m_startIndex != -1) {
                        try {
                            String obj = this.m_monprog[this.m_startIndex];
                            obj = MonprogTableProvider.removeLineBreak(obj);
                            operator = OP_LIST_LBL[0];
                            int i2 = 1;
                            while (i2 < OP_LIST_LBL.length) {
                                if (obj.indexOf(OP_LIST_LBL[i2]) != -1) {
                                    operator = OP_LIST_LBL[i2];
                                    break;
                                }
                                ++i2;
                            }
                            if (operator != "") {
                                String[] sub = obj.split(operator);
                                try {
                                    object = sub[0];
                                }
                                catch (Exception exception) {
                                    object = "";
                                }
                                try {
                                    calculation = sub[1];
                                }
                                catch (Exception exception) {
                                    calculation = "";
                                }
                                break block74;
                            }
                            object = obj.trim();
                        }
                        catch (Exception exception) {}
                    }
                }
                this.m_gui.addTextField(this.m_dialogArea, null, "Object: ", 3, 1, 10, 0, null);
                this.m_gui.addTextField(this.m_dialogArea, null, "Calculation: ", 1, 1, 10, 0, null);
                this.m_object_field = this.m_gui.addInputFieldSingle(this.m_dialogArea, OBJECT_FIELD, null, object, 2, 1, 0, 5, 150, this);
                ((GridData)this.m_object_field.getLayoutData()).horizontalAlignment = 1;
                ((GridData)this.m_object_field.getLayoutData()).grabExcessHorizontalSpace = false;
                if (object.trim().equals("")) {
                    this.m_object_field.setBackground(BMUI.color_light_red);
                }
                this.m_operator_combo = this.m_gui.addDropDown(this.m_dialogArea, OPERATOR_COMBO, OP_LIST_LBL, operator, 1, 1, 3, null);
                this.m_operator_combo.addSelectionListener((SelectionListener)this);
                if (operator.trim().equals("")) {
                    this.m_operator_combo.setBackground(BMUI.color_light_red);
                }
                this.m_calculation_field = this.m_gui.addInputFieldSingle(this.m_dialogArea, CALCULATION_FIELD, null, calculation, 1, 1, 0, 3, 60, this);
                ((GridData)this.m_calculation_field.getLayoutData()).horizontalAlignment = 4;
                ((GridData)this.m_calculation_field.getLayoutData()).grabExcessHorizontalSpace = true;
                if (calculation.trim().equals("")) {
                    this.m_calculation_field.setBackground(BMUI.color_light_red);
                }
            }
        } else if (this.m_callType.equals(MonprogTableProvider.TABLE_SUMMARY)) {
            this.m_startIndex = this.m_itemIndex + 4;
            if (this.m_isNew) {
                this.m_currentOperator = "";
                this.createTableSummeryDialog(null, null, null, null, null);
            } else if (this.m_startIndex != -1) {
                List<String> params = this.getTableSummaryParams();
                String object = params.get(0);
                String operator = params.get(1);
                String calculation = params.get(2);
                String variable = params.get(3);
                String pattern = params.get(4);
                this.m_currentOperator = operator;
                this.createTableSummeryDialog(object, operator, calculation, variable, pattern);
            }
        } else if (this.m_callType.equals(MonprogTableProvider.PUNCHCARD)) {
            this.m_startIndex = 6;
            String regex = "";
            String vars = "";
            if (this.m_itemIndex != -1) {
                this.m_startIndex = this.m_itemIndex * 2 + 6;
                try {
                    regex = this.m_monprog[this.m_startIndex];
                }
                catch (Exception exception) {}
                try {
                    vars = this.m_monprog[this.m_startIndex + 1];
                }
                catch (Exception exception) {}
            }
            this.createPunchCardDialog(regex, vars);
        }
        return this.m_dialogArea;
    }

    public List<String> getTableSummaryParams() {
        String object = "";
        String operator = "";
        String calculation = "";
        String variable = "";
        String pattern = "";
        try {
            String obj = "";
            if (this.m_monprog.length >= this.m_startIndex + 1) {
                obj = this.m_monprog[this.m_startIndex];
                obj = MonprogTableProvider.removeLineBreak(obj);
            }
            operator = OP_LIST_TS[0];
            int i = 1;
            while (i < OP_LIST_TS.length) {
                if (obj.indexOf(OP_LIST_TS[i]) != -1) {
                    operator = OP_LIST_TS[i];
                    break;
                }
                ++i;
            }
            if (operator != "") {
                String[] sub = obj.split(operator);
                if (sub.length == 1) {
                    object = sub[0].trim();
                } else if (sub.length > 1) {
                    object = sub[0].trim();
                    String subStr = sub[1].trim();
                    if (operator.equals(COUNT)) {
                        String[] arr = subStr.split("\\s+", 2);
                        if (arr.length > 0) {
                            variable = arr[0].trim();
                        }
                        if (arr.length > 1) {
                            pattern = arr[1].trim();
                        }
                    } else {
                        calculation = subStr;
                    }
                }
            } else {
                object = obj.trim();
            }
        }
        catch (Exception exception) {}
        ArrayList<String> params = new ArrayList<String>();
        params.add(object);
        params.add(operator);
        params.add(calculation);
        params.add(variable);
        params.add(pattern);
        return params;
    }

    public void createTableSummeryDialog(String object, String operator, String calculation, String variable, String pattern) {
        GridLayout gdLayout;
        if (this.m_dialog == null || this.m_dialogArea.isDisposed()) {
            this.m_dialogArea = new Composite(this.m_parentComp, 0);
            this.m_dialogArea.setLayout((Layout)new GridLayout(3, false));
            GridData gd = new GridData(4, 4, true, true, 1, 1);
            gd.widthHint = 600;
            this.m_dialogArea.setLayoutData((Object)gd);
        } else {
            Control[] controls = this.m_dialogArea.getChildren();
            int i = 0;
            while (i < controls.length) {
                try {
                    controls[i].dispose();
                }
                catch (Exception exception) {}
                ++i;
            }
        }
        if (operator != null && operator.equals(COUNT)) {
            gdLayout = new GridLayout(4, false);
            gdLayout.marginTop = 5;
            gdLayout.marginRight = 10;
            gdLayout.marginLeft = 10;
            gdLayout.verticalSpacing = 1;
            this.m_dialogArea.setLayout((Layout)gdLayout);
            this.m_gui.addTextField(this.m_dialogArea, null, "Object: ", 2, 1, 10, 10, null);
            this.m_gui.addTextField(this.m_dialogArea, null, "Variable (svarN):", 1, 1, 10, 10, null);
            this.m_gui.addTextField(this.m_dialogArea, null, "svarN Pattern (optional): ", 1, 1, 10, 10, null);
            this.m_object_field = this.m_gui.addInputFieldSingle(this.m_dialogArea, OBJECT_FIELD, null, object, 1, 1, 0, 3, 100, this);
            if (object.trim().equals("")) {
                this.m_object_field.setBackground(BMUI.color_light_red);
            }
            this.m_operator_combo = this.m_gui.addDropDown(this.m_dialogArea, OPERATOR_COMBO, OP_LIST_TS, operator, 1, 1, 3, null);
            this.m_operator_combo.addSelectionListener((SelectionListener)this);
            this.m_variable_field_styled = this.m_gui.addStyledText(this.m_dialogArea, null, VARIABLE_FIELD, variable, 1, 1, 0, 3, this);
            AbstractPolicyTab.addContentMenu4PatternField((Widget)this.m_variable_field_styled, false, this.m_dialog.getShell());
            this.m_isSVarNValid = this.validateSVarN(this.m_variable_field_styled);
            this.m_p1_field_styled = this.m_gui.addStyledText(this.m_dialogArea, null, PATTERN1_FIELD, pattern, 1, 1, 0, 3, this);
            ((GridData)this.m_p1_field_styled.getLayoutData()).horizontalAlignment = 4;
            ((GridData)this.m_p1_field_styled.getLayoutData()).grabExcessHorizontalSpace = true;
            ((GridData)this.m_p1_field_styled.getLayoutData()).widthHint = 200;
            AbstractPolicyTab.addContentMenu4PatternField((Widget)this.m_p1_field_styled, false, this.m_dialog.getShell());
            if (this.m_p1_field_styled.getText().trim().length() == 0) {
                this.m_p1_field_styled.setBackground(BMUI.color_light_green);
                this.m_isP1Valid = true;
            } else {
                this.m_isP1Valid = AbstractPolicyTab.validatePattern(this.m_p1_field_styled);
            }
        } else {
            if (operator == null) {
                object = "";
                operator = "";
                calculation = "";
            }
            gdLayout = new GridLayout(3, false);
            gdLayout.marginTop = 5;
            gdLayout.marginRight = 10;
            gdLayout.marginLeft = 10;
            gdLayout.verticalSpacing = 1;
            this.m_dialogArea.setLayout((Layout)gdLayout);
            this.m_gui.addTextField(this.m_dialogArea, null, "Object: ", 2, 1, 10, 10, null);
            this.m_gui.addTextField(this.m_dialogArea, null, "Calculation", 1, 1, 10, 10, null);
            this.m_object_field = this.m_gui.addInputFieldSingle(this.m_dialogArea, OBJECT_FIELD, null, object, 1, 1, 0, 3, 100, this);
            if (object.trim().equals("")) {
                this.m_object_field.setBackground(BMUI.color_light_red);
            }
            this.m_operator_combo = this.m_gui.addDropDown(this.m_dialogArea, OPERATOR_COMBO, OP_LIST_TS, operator, 1, 1, 3, null);
            this.m_operator_combo.addSelectionListener((SelectionListener)this);
            if (operator.trim().equals("")) {
                this.m_operator_combo.setBackground(BMUI.color_light_red);
            }
            this.m_calculation_field = this.m_gui.addInputFieldSingle(this.m_dialogArea, CALCULATION_FIELD, null, calculation, 1, 1, 0, 3, 100, this);
            if (calculation.trim().equals("")) {
                this.m_calculation_field.setBackground(BMUI.color_light_red);
            }
        }
        this.m_dialogArea.layout(true);
    }

    public void createPunchCardDialog(String regex, String vars) {
        if (this.m_dialog == null || this.m_dialogArea.isDisposed()) {
            this.m_dialogArea = new Composite(this.m_parentComp, 0);
        } else {
            Control[] controls = this.m_dialogArea.getChildren();
            int i = 0;
            while (i < controls.length) {
                try {
                    controls[i].dispose();
                }
                catch (Exception exception) {}
                ++i;
            }
        }
        GridLayout gl = new GridLayout(2, false);
        this.m_dialogArea.setLayout((Layout)gl);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 600;
        this.m_dialogArea.setLayoutData((Object)gd);
        this.m_topComp = new Composite(this.m_dialogArea, 0);
        gl = new GridLayout(2, false);
        gl.marginRight = 5;
        gl.marginLeft = 5;
        this.m_topComp.setLayout((Layout)gl);
        this.m_topComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_punchCard_regex_field = this.m_gui.addInputFieldSingle(this.m_topComp, PUNCHCARD_REGEX, "Regex: ", regex, 1, 1, 0, 0, 60, this);
        if (regex == null || regex.equals("")) {
            this.m_punchCard_regex_field.setBackground(BMUI.color_light_red);
        }
        this.m_punchCard_variables_field = this.m_gui.addInputFieldSingle(this.m_topComp, PUNCHCARD_VARIABLES, "Variables: ", vars, 1, 1, 0, 0, 60, this);
        if (vars == null || vars.equals("")) {
            this.m_punchCard_variables_field.setBackground(BMUI.color_light_red);
        }
    }

    public void setDirty(boolean b) {
        if (!this.m_isReadOnly) {
            try {
                this.getButton(0).setEnabled(b);
            }
            catch (Exception exception) {}
        }
    }

    public void modifyText(ModifyEvent e) {
        block36: {
            Object obj = e.getSource();
            if (obj instanceof StyledText) {
                StyledText styledText = (StyledText)obj;
                String fieldName = (String)styledText.getData();
                if (fieldName.equals(PATTERN1_FIELD)) {
                    try {
                        styledText.setBackground(BMUI.defaultBackground);
                        if (this.m_callType.equals(MonprogTableProvider.TABLE_SUMMARY) && this.m_currentOperator.equals(COUNT) && styledText.getText().trim().length() == 0) {
                            this.m_isP1Valid = true;
                            styledText.setBackground(BMUI.color_light_green);
                            break block36;
                        }
                        this.m_isP1Valid = AbstractPolicyTab.validatePattern(styledText);
                    }
                    catch (Throwable throwable) {
                        this.m_isP1Valid = false;
                        styledText.setBackground(BMUI.color_light_red);
                    }
                } else if (fieldName.equals(PATTERN2_FIELD)) {
                    try {
                        styledText.setBackground(BMUI.defaultBackground);
                        this.m_isP2Valid = AbstractPolicyTab.validatePattern(styledText);
                    }
                    catch (Throwable throwable) {
                        this.m_isP2Valid = false;
                        styledText.setBackground(BMUI.color_light_red);
                    }
                } else if (fieldName.equals(PATTERN3_FIELD)) {
                    try {
                        styledText.setBackground(BMUI.defaultBackground);
                        this.m_isP3Valid = AbstractPolicyTab.validatePattern(styledText);
                    }
                    catch (Throwable throwable) {
                        this.m_isP3Valid = false;
                        styledText.setBackground(BMUI.color_light_red);
                    }
                } else if (fieldName.equals(VARIABLE_FIELD)) {
                    try {
                        styledText.setBackground(BMUI.defaultBackground);
                        this.m_isSVarNValid = this.validateSVarN(styledText);
                    }
                    catch (Throwable throwable) {
                        this.m_isSVarNValid = false;
                        styledText.setBackground(BMUI.color_light_red);
                    }
                }
            } else if (obj instanceof Text) {
                Text text = (Text)obj;
                String fieldName = (String)text.getData();
                String value = text.getText().trim();
                if (fieldName.equals(OBJECT_FIELD)) {
                    if (value.equals("")) {
                        text.setBackground(BMUI.color_light_red);
                    } else {
                        text.setBackground(BMUI.color_white);
                    }
                } else if (fieldName.equals(CALCULATION_FIELD)) {
                    if (value.equals("")) {
                        text.setBackground(BMUI.color_light_red);
                    } else {
                        text.setBackground(BMUI.color_white);
                    }
                } else if (fieldName.equals(PUNCHCARD_REGEX)) {
                    if (value.equals("")) {
                        text.setBackground(BMUI.color_light_red);
                    } else {
                        text.setBackground(BMUI.defaultBackground);
                    }
                } else if (fieldName.equals(PUNCHCARD_VARIABLES)) {
                    if (value.equals("")) {
                        text.setBackground(BMUI.color_light_red);
                    } else {
                        text.setBackground(BMUI.defaultBackground);
                    }
                } else if (fieldName.equals(TIMEOUT_FIELD)) {
                    this.m_isTimeoutValid = this.validateTimeout(value, this.m_timeOut_field);
                }
            }
        }
        this.checkDirtyStatus();
    }

    private void checkDirtyStatus() {
        if (this.m_callType.endsWith(MonprogTableProvider.LOGFILE_MONITOR)) {
            this.setDirty(this.m_isP1Valid && this.m_isP2Valid);
        } else if (this.m_callType.endsWith(MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR) || this.m_callType.endsWith(MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR_MULITLINE)) {
            this.setDirty(this.m_isP1Valid && this.m_isP2Valid && this.m_isP3Valid && this.m_isTimeoutValid);
        } else if (this.m_callType.equals(MonprogTableProvider.LINE_BY_LINE)) {
            if ((this.m_snmpWalk || this.m_isP1Valid) && this.m_object_field.getText().trim().length() > 0 && this.m_operator_combo.getText().trim().length() > 0 && this.m_calculation_field.getText().trim().length() > 0) {
                this.setDirty(true);
            } else {
                this.setDirty(false);
            }
        } else if (this.m_callType.equals(MonprogTableProvider.TABLE_SUMMARY)) {
            if (this.m_currentOperator.equals(COUNT)) {
                if (this.m_isSVarNValid && this.m_isP1Valid && this.m_object_field.getText().trim().length() > 0 && this.m_variable_field_styled.getText().trim().length() > 0) {
                    this.setDirty(true);
                } else {
                    this.setDirty(false);
                }
            } else if (this.m_currentOperator.length() > 0 && this.m_object_field.getText().trim().length() > 0 && this.m_calculation_field.getText().trim().length() > 0) {
                this.setDirty(true);
            } else {
                this.setDirty(false);
            }
        } else if (this.m_callType.equals(MonprogTableProvider.PUNCHCARD)) {
            String regex = this.m_punchCard_regex_field.getText().trim();
            String vars = this.m_punchCard_variables_field.getText().trim();
            if (regex.length() > 0 && vars.length() > 0) {
                this.setDirty(true);
            } else {
                this.setDirty(false);
            }
        } else {
            this.setDirty(false);
        }
    }

    private boolean validateSVarN(StyledText styledText) {
        Pattern p;
        Matcher m;
        boolean isValid = false;
        String svarN = styledText.getText().trim();
        if (svarN != null && (m = (p = Pattern.compile("^svar[0-9]+$")).matcher(svarN)).find()) {
            isValid = true;
        }
        if (isValid) {
            styledText.setBackground(BMUI.color_light_green);
        } else {
            styledText.setBackground(BMUI.color_light_red);
        }
        return isValid;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button btn = this.createButton(parent, 0, "Save", false);
        if (this.m_isReadOnly) {
            btn.setEnabled(false);
        }
        this.createButton(parent, 1, "Cancel", false);
        this.checkDirtyStatus();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1) {
            super.cancelPressed();
        } else if (buttonId == 0) {
            this.save();
            super.okPressed();
        }
    }

    public void save() {
        if (this.m_callType.endsWith(MonprogTableProvider.LOGFILE_MONITOR)) {
            String[] newMonprog = new String[6];
            if (this.m_callType.equals(MonprogTableProvider.LOGFILE_MONITOR)) {
                newMonprog[0] = MonprogTableProvider.LOGFILE_MONITOR_NAME;
            } else if (this.m_callType.equals(MonprogTableProvider.LOGFILE_MONITOR_MPATH)) {
                newMonprog[0] = MonprogTableProvider.LOGFILE_MONITOR_NAME_MPATH;
            }
            try {
                newMonprog[1] = this.m_monprog[1];
            }
            catch (Exception exception) {
                newMonprog[1] = "";
            }
            String startPattern = this.m_p1_field_styled.getText().trim();
            if (startPattern.length() == 0) {
                startPattern = ".*";
            }
            newMonprog[2] = startPattern;
            String generalPattern = this.m_p2_field_styled.getText().trim();
            if (generalPattern.length() == 0) {
                generalPattern = ".*";
            }
            newMonprog[3] = generalPattern;
            String value = this.m_fromStartLast_combo.getText();
            if (value.startsWith(FROM_LAST)) {
                value = FROM_LAST;
            }
            newMonprog[4] = value;
            newMonprog[5] = this.m_exec_field.getText().trim();
            this.m_monprog = newMonprog;
        } else if (this.m_callType.endsWith(MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR)) {
            int startIndex = this.m_startIndex;
            int monprogLength = this.m_monprog.length;
            if (this.m_isNew) {
                String[] newMonprog = null;
                if (monprogLength < 6) {
                    newMonprog = new String[6];
                    if (this.m_callType.equals(MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR)) {
                        newMonprog[0] = MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR_NAME;
                    } else if (this.m_callType.equals(MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR_MPATH)) {
                        newMonprog[0] = MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR_NAME_MPATH;
                    }
                    try {
                        newMonprog[1] = this.m_monprog[1];
                    }
                    catch (Exception exception) {
                        newMonprog[1] = "";
                    }
                    startIndex = 2;
                    this.m_monprog = newMonprog;
                } else {
                    int fix = 2;
                    int mod = (monprogLength - fix) % 4;
                    if (mod == 0) {
                        this.m_monprog = this.expandMonprog(monprogLength + 4);
                        startIndex = monprogLength;
                    } else {
                        int count = (monprogLength - fix) / 4;
                        int correctSize = (count + 1) * 4 + fix;
                        this.m_monprog = this.expandMonprog(correctSize + 4);
                        startIndex = this.m_monprog.length - 4;
                    }
                }
            } else {
                int minSize = startIndex + 4;
                if (monprogLength < minSize) {
                    this.m_monprog = this.expandMonprog(minSize);
                }
            }
            String defaultPattern = ".*";
            String defaultTimeout = "60";
            this.m_monprog[startIndex] = this.m_p1_field_styled.getText().trim().length() == 0 ? defaultPattern : this.m_p1_field_styled.getText().trim();
            this.m_monprog[startIndex + 1] = this.m_p2_field_styled.getText().trim().length() == 0 ? defaultPattern : this.m_p2_field_styled.getText().trim();
            this.m_monprog[startIndex + 2] = this.m_p3_field_styled.getText().trim().length() == 0 ? defaultPattern : this.m_p3_field_styled.getText().trim();
            this.m_monprog[startIndex + 3] = this.m_timeOut_field.getText().trim().length() == 0 ? defaultTimeout : this.m_timeOut_field.getText().trim();
        } else if (this.m_callType.endsWith(MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR_MULITLINE)) {
            int startIndex = this.m_startIndex;
            int monprogLength = this.m_monprog.length;
            if (this.m_isNew) {
                String[] newMonprog = null;
                if (monprogLength < 7) {
                    newMonprog = new String[7];
                    if (this.m_callType.equals(MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR_MULITLINE)) {
                        newMonprog[0] = MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR_MULTILINE_NAME;
                    } else if (this.m_callType.equals(MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR_MULITLINE_MPATH)) {
                        newMonprog[0] = MonprogTableProvider.LOGFILE_TRANSACTION_MONITOR_MULTILINE_NAME_MPATH;
                    }
                    try {
                        newMonprog[1] = this.m_monprog[1];
                    }
                    catch (Exception exception) {
                        newMonprog[1] = "";
                    }
                    try {
                        newMonprog[1] = this.m_monprog[2];
                    }
                    catch (Exception exception) {
                        newMonprog[1] = "";
                    }
                    startIndex = 3;
                    this.m_monprog = newMonprog;
                } else {
                    int fix = 3;
                    int mod = (monprogLength - fix) % 4;
                    if (mod == 0) {
                        newMonprog = new String[monprogLength + 4];
                        int i = 0;
                        while (i < monprogLength) {
                            newMonprog[i] = this.m_monprog[i];
                            ++i;
                        }
                        startIndex = newMonprog.length - 4;
                        this.m_monprog = newMonprog;
                    } else {
                        int count = (monprogLength - fix) / 4;
                        int correctSize = (count + 1) * 4 + fix;
                        newMonprog = new String[correctSize += 4];
                        int i = 0;
                        while (i < correctSize) {
                            try {
                                newMonprog[i] = this.m_monprog[i];
                            }
                            catch (Exception exception) {
                                newMonprog[i] = "";
                            }
                            ++i;
                        }
                        startIndex = newMonprog.length - 4;
                        this.m_monprog = newMonprog;
                    }
                }
            } else {
                int minSize = startIndex + 4;
                if (monprogLength < minSize) {
                    this.m_monprog = this.expandMonprog(minSize);
                }
            }
            String defaultPattern = ".*";
            String defaultTimeout = "60";
            this.m_monprog[startIndex] = this.m_p1_field_styled.getText().trim().length() == 0 ? defaultPattern : this.m_p1_field_styled.getText().trim();
            this.m_monprog[startIndex + 1] = this.m_p2_field_styled.getText().trim().length() == 0 ? defaultPattern : this.m_p2_field_styled.getText().trim();
            this.m_monprog[startIndex + 2] = this.m_p3_field_styled.getText().trim().length() == 0 ? defaultPattern : this.m_p3_field_styled.getText().trim();
            this.m_monprog[startIndex + 3] = this.m_timeOut_field.getText().trim().length() == 0 ? defaultTimeout : this.m_timeOut_field.getText().trim();
        } else if (this.m_callType.equals(MonprogTableProvider.LINE_BY_LINE)) {
            if (this.m_snmpWalk) {
                String object = this.m_object_field.getText().trim();
                String operator = this.m_operator_combo.getText();
                if (operator == "") {
                    operator = OP_LIST_LBL[1];
                }
                String calculation = MonprogTableProvider.checkCalculation(this.m_calculation_field.getText().trim());
                if (this.m_isNew) {
                    String[] newMonprog = null;
                    newMonprog = new String[this.m_monprog.length + 1];
                    int i = 0;
                    while (i < this.m_monprog.length) {
                        newMonprog[i] = this.m_monprog[i];
                        ++i;
                    }
                    newMonprog[i] = String.valueOf(object) + " " + operator + " " + calculation;
                    this.m_monprog = newMonprog;
                } else {
                    this.m_monprog[this.m_startIndex] = String.valueOf(object) + " " + operator + " " + calculation;
                }
            } else {
                String[] newMonprog = null;
                int startIndex = this.m_startIndex;
                if (this.m_isNew) {
                    newMonprog = new String[this.m_monprog.length + 2];
                    int i = 0;
                    while (i < this.m_monprog.length) {
                        newMonprog[i] = this.m_monprog[i];
                        ++i;
                    }
                    this.m_monprog = newMonprog;
                    startIndex = this.m_monprog.length - 2;
                } else {
                    int newSize = startIndex + 2;
                    if (this.m_monprog.length < newSize) {
                        newMonprog = new String[newSize];
                        int i = 0;
                        while (i < this.m_monprog.length) {
                            newMonprog[i] = this.m_monprog[i];
                            ++i;
                        }
                        this.m_monprog = newMonprog;
                        startIndex = this.m_startIndex;
                    }
                }
                this.m_monprog[startIndex] = this.m_p1_field_styled.getText().trim();
                String object = this.m_object_field.getText().trim();
                String operator = this.m_operator_combo.getText();
                if (operator == "") {
                    operator = OP_LIST_LBL[1];
                }
                String calculation = MonprogTableProvider.checkCalculation(this.m_calculation_field.getText().trim());
                this.m_monprog[startIndex + 1] = object == "" && calculation == "" ? "" : (object == "" && calculation != "" ? calculation : (object != "" && calculation == "" ? object : String.valueOf(object) + " " + operator + " " + calculation));
            }
        } else if (this.m_callType.equals(MonprogTableProvider.TABLE_SUMMARY)) {
            int startIndex = this.m_startIndex;
            if (this.m_isNew) {
                int count = this.m_monprog.length + 1;
                if (count < 5) {
                    count = 5;
                }
                String[] newMonprog = new String[count];
                int i = 0;
                while (i < this.m_monprog.length) {
                    newMonprog[i] = this.m_monprog[i];
                    ++i;
                }
                this.m_monprog = newMonprog;
                startIndex = this.m_monprog.length - 1;
            }
            if (this.m_currentOperator.equals(COUNT)) {
                String object = this.m_object_field.getText().trim();
                String variable = this.m_variable_field_styled.getText().trim();
                variable = variable.replace(" ", "");
                String pattern = this.m_p1_field_styled.getText().trim();
                this.m_monprog[startIndex] = String.valueOf(object) + " " + this.m_currentOperator + " " + variable + " " + pattern;
            } else {
                String object = this.m_object_field.getText().trim();
                if (this.m_currentOperator == "") {
                    this.m_currentOperator = OP_LIST_TS[1];
                }
                String calculation = this.m_calculation_field.getText().trim();
                this.m_monprog[startIndex] = String.valueOf(object) + " " + this.m_currentOperator + " " + calculation;
            }
        } else if (this.m_callType.equals(MonprogTableProvider.PUNCHCARD)) {
            if (this.m_itemIndex == -1) {
                int total = this.m_monprog.length + 2;
                if (total < 8) {
                    total = 8;
                }
                String[] newMonprog = new String[total];
                int i = 0;
                while (i < this.m_monprog.length) {
                    newMonprog[i] = this.m_monprog[i];
                    ++i;
                }
                this.m_monprog = newMonprog;
                String regex = this.m_punchCard_regex_field.getText().trim();
                String vars = this.m_punchCard_variables_field.getText().trim();
                this.m_monprog[this.m_monprog.length - 2] = regex;
                this.m_monprog[this.m_monprog.length - 1] = vars;
            } else {
                int total = 6 + (this.m_itemIndex + 1) * 2;
                int startIndex = this.m_startIndex = 6 + (this.m_itemIndex + 1) * 2 - 2;
                if (this.m_monprog.length < total) {
                    String[] newMonprog = new String[total];
                    int i = 0;
                    while (i < this.m_monprog.length) {
                        newMonprog[i] = this.m_monprog[i];
                        ++i;
                    }
                    this.m_monprog = newMonprog;
                }
                String regex = this.m_punchCard_regex_field.getText().trim();
                String vars = this.m_punchCard_variables_field.getText().trim();
                this.m_monprog[startIndex] = regex;
                this.m_monprog[++startIndex] = vars;
            }
        }
        this.setDirty(false);
    }

    public String[] getMonProg() {
        return this.m_monprog;
    }

    public String[] expandMonprog(int totalSize) {
        String[] monprog_tmp = new String[totalSize];
        int i = 0;
        while (i < totalSize) {
            try {
                monprog_tmp[i] = this.m_monprog[i];
            }
            catch (Exception exception) {
                monprog_tmp[i] = "";
            }
            ++i;
        }
        return monprog_tmp;
    }

    public boolean validateTimeout(String timeout, Text field) {
        boolean isValid = false;
        if (timeout == null || timeout.equals("")) {
            isValid = true;
        } else {
            try {
                int i = Integer.parseInt(timeout);
                if (i > 0) {
                    isValid = true;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (isValid) {
            field.setBackground(BMUI.defaultBackground);
        } else {
            field.setBackground(BMUI.color_light_red);
        }
        return isValid;
    }

    public void widgetSelected(SelectionEvent e) {
        Object obj = e.getSource();
        if (obj instanceof CCombo) {
            CCombo combo = (CCombo)obj;
            String data = (String)combo.getData();
            String newSelectedOperator = combo.getText().trim();
            if (data.equals(OPERATOR_COMBO)) {
                if (this.m_callType.equals(MonprogTableProvider.TABLE_SUMMARY)) {
                    String object = this.m_object_field.getText().trim();
                    String calculation = "";
                    String variable = "";
                    String pattern = "";
                    if (this.m_currentOperator.equals(COUNT) && !newSelectedOperator.equals(COUNT)) {
                        if (this.m_variable_field_styled != null) {
                            calculation = this.m_variable_field_styled.getText().trim();
                        }
                        this.createTableSummeryDialog(object, newSelectedOperator, calculation, variable, pattern);
                    } else if (!this.m_currentOperator.equals(COUNT) && newSelectedOperator.equals(COUNT)) {
                        if (this.m_calculation_field != null) {
                            variable = this.m_calculation_field.getText().trim();
                        }
                        this.createTableSummeryDialog(object, newSelectedOperator, calculation, variable, pattern);
                    } else if (!this.m_currentOperator.equals(newSelectedOperator)) {
                        calculation = this.m_calculation_field.getText().trim();
                        this.createTableSummeryDialog(object, newSelectedOperator, calculation, variable, pattern);
                    }
                    this.m_currentOperator = newSelectedOperator;
                } else if (this.m_callType.equals(MonprogTableProvider.LINE_BY_LINE)) {
                    String operator = combo.getText().trim();
                    if (operator != null && operator.trim().equals("")) {
                        this.m_operator_combo.setBackground(BMUI.color_light_red);
                    } else {
                        this.m_operator_combo.setBackground(BMUI.color_white);
                    }
                }
            }
            this.checkDirtyStatus();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public boolean close() {
        Control[] controls = this.m_dialogArea.getChildren();
        int i = 0;
        while (i < controls.length) {
            controls[i].dispose();
            ++i;
        }
        return super.close();
    }
}

