/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.dialogs;

import com.blixx.boom.gui.utils.GUIDisplayElements;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MultilineInputDialog
extends InputDialog {
    protected String m_okButtonText = "OK";
    protected boolean m_isOkButtonEnabled = true;

    public MultilineInputDialog(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue, IInputValidator validator) {
        super(parentShell, dialogTitle, dialogMessage, initialValue, validator);
    }

    protected int getInputTextStyle() {
        return 2818;
    }

    protected Control createDialogArea(Composite parent) {
        Control ctrl = super.createDialogArea(parent);
        GridData gdText = (GridData)this.getText().getLayoutData();
        gdText.verticalAlignment = 1;
        gdText.heightHint = 100;
        gdText.verticalIndent = 1;
        Text text = this.getText();
        text.setLayoutData((Object)gdText);
        GUIDisplayElements gui = new GUIDisplayElements();
        gui.addDefaultTextContentMenu(text, true);
        return ctrl;
    }

    public void setOKButtonText(String label) {
        this.m_okButtonText = label;
    }

    public void setOKButtonEnabled(boolean enable) {
        this.m_isOkButtonEnabled = enable;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button b = super.createButton(parent, id, label, defaultButton);
        if (id == 0) {
            b.setText(this.m_okButtonText);
            b.setEnabled(this.m_isOkButtonEnabled);
        }
        return b;
    }
}

