/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.dialogs;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.dialogs.NameValidatorFile;
import com.blixx.boom.gui.policies.PolicyManager;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.GroupTreeObjectUnsubmitted;
import java.util.LinkedList;
import java.util.List;

public class NameValidatorPolicyName
extends NameValidatorFile {
    @Override
    public String isValid(String name) {
        if (name == null || name.length() == 0) {
            return "Empty policy name is not allowed";
        }
        String error = super.isValid(name);
        if (error == null) {
            GroupTreeObjectLast gto_mon = PolicyManager.getInstance().getPolicyTree().findElement(name, BMUI.type_mon);
            GroupTreeObjectLast gto_msg = PolicyManager.getInstance().getPolicyTree().findElement(name, BMUI.type_msg);
            if (gto_mon != null) {
                return "Policy name conflicts with Monitor Policy: " + gto_mon.getPath();
            }
            if (gto_msg != null) {
                return "Policy name conflicts with Indication Policy: " + gto_msg.getPath();
            }
        } else {
            return error;
        }
        return null;
    }

    private List<GroupTreeObject> findUnsubmittedItemByName(GroupTreeObject gto, String name) {
        LinkedList<GroupTreeObject> list = new LinkedList<GroupTreeObject>();
        for (GroupTreeObject obj : gto.getAllElements()) {
            if (obj instanceof GroupTreeObjectUnsubmitted) {
                try {
                    String currentName = obj.getAttributes().get(PolicyManager.CURRENT_NAME);
                    if (currentName == null || !currentName.equals(name)) continue;
                    list.add(obj);
                }
                catch (Exception exception) {}
                continue;
            }
            obj.hasElements().booleanValue();
        }
        return list;
    }
}

