/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.dialogs;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.policies.ViewContentProvider;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.utils.STreeViewer;
import com.blixx.boom.gui.views.StyledTreeLabelProvider;
import com.blixx.boom.gui.views.actions.ExpandCollapseAction;
import com.blixx.boom.gui.views.outages.StyledTreeLabelProvider_S;
import com.blixx.log.RTLogger;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.ITreeObject;
import com.blixx.shared.utils.TreeObject;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;

public class NodeGroupTreeDialog
extends Dialog
implements SelectionListener {
    public static final String SELECTED = "SELECTED";
    private NodeGroupTreeDialog m_instance = null;
    private TreeViewer m_tv_left;
    private TreeViewer m_tv_right;
    private GroupTreeObject m_root_NG_left = null;
    private GroupTreeObject m_root_NG_right = null;
    private GUIDisplayElements m_gui = null;
    private Button m_add_btn = null;
    private Button m_remove_btn = null;
    private static String ADD_BTN = "SELECT_BUTTON";
    private static String REMOVE_BTN = "DESELECT_BUTTON";
    private StringBuffer m_nodeGroupsByPipe = null;
    private StringBuffer m_nodeGroupsByComma = null;
    private boolean m_selectAgents = false;

    public NodeGroupTreeDialog(Shell parentShell, String currentSelection, boolean selectAgents) {
        super(parentShell);
        super.setShellStyle(66704);
        this.m_selectAgents = selectAgents;
        NodeGroupTreeDialog.setDefaultImage((Image)BMUI.IMAGE_PRODUCT);
        this.m_instance = this;
        this.m_nodeGroupsByPipe = new StringBuffer(currentSelection);
    }

    protected Control createDialogArea(Composite parent) {
        this.m_gui = new GUIDisplayElements();
        Composite mainComp = (Composite)super.createDialogArea(parent);
        GridLayout gl = new GridLayout(3, false);
        gl.marginTop = 7;
        gl.marginRight = 7;
        gl.marginLeft = 7;
        mainComp.setLayout((Layout)gl);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 600;
        gd.heightHint = 350;
        mainComp.setLayoutData((Object)gd);
        this.m_gui.addTextField(mainComp, null, "Node Groups: ", 2, 1, 1, 1, null);
        if (this.m_selectAgents) {
            this.m_gui.addTextField(mainComp, null, "Selected Agents: ", 1, 1, 1, 1, null);
        } else {
            this.m_gui.addTextField(mainComp, null, "Selected Node Groups: ", 1, 1, 1, 1, null);
        }
        this.createTreeLeft(mainComp);
        Composite btnComp = new Composite(mainComp, 0);
        btnComp.setLayout((Layout)new GridLayout(1, false));
        btnComp.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        this.m_add_btn = this.m_gui.addButton(btnComp, ADD_BTN, " >> ", false, 120, 10, 1, 0, this);
        this.m_remove_btn = this.m_gui.addButton(btnComp, REMOVE_BTN, " << ", false, 120, 10, 1, 0, this);
        this.createTreeRight(mainComp);
        if (this.m_nodeGroupsByPipe != null) {
            if (this.m_selectAgents) {
                this.initSelectionAgents();
            } else {
                this.initSelectionNG();
            }
            this.m_tv_right.expandAll();
            this.m_tv_right.refresh();
        }
        return mainComp;
    }

    private void initSelectionNG() {
        String[] pathes;
        String[] stringArray = pathes = this.m_nodeGroupsByPipe.toString().split("\\|");
        int n = pathes.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            GroupTreeObject gto = this.m_root_NG_left.getRoot().searchPath(path, BMUI.type_folder);
            if (gto != null) {
                String gtoPath = gto.getPath();
                gtoPath = gtoPath.replace("/root/_Groups", "/root");
                GroupTreeObject leftObject = GroupTreeObject.createPath(gtoPath, this.m_root_NG_right);
                leftObject.getTreeObject().setObject(SELECTED);
                for (GroupTreeObject gtoChild : gto.getElements()) {
                    if (!(gtoChild instanceof GroupTreeObject)) continue;
                    try {
                        GroupTreeObject leftGtoChild = gtoChild.clone();
                        leftObject.addElement(leftGtoChild);
                    }
                    catch (Throwable throwable) {}
                }
            }
            ++n2;
        }
    }

    private void initSelectionAgents() {
        String[] agentIds;
        String[] stringArray = agentIds = this.m_nodeGroupsByPipe.toString().split("\\|");
        int n = agentIds.length;
        int n2 = 0;
        while (n2 < n) {
            String agentID = stringArray[n2];
            List<GroupTreeObject> elements = this.m_root_NG_left.findElements(agentID, BMUI.type_agt);
            if (elements != null) {
                for (GroupTreeObject gtol : elements) {
                    String gtoPath = gtol.getParentPath();
                    if (gtoPath.startsWith("/root/Agents/")) continue;
                    gtoPath = gtoPath.replace("/root/_Groups", "/root");
                    GroupTreeObject leftObject = GroupTreeObject.createPath(gtoPath, this.m_root_NG_right);
                    try {
                        GroupTreeObject clone = gtol.clone();
                        leftObject.addElement(clone);
                    }
                    catch (CloneNotSupportedException e) {
                        e.printStackTrace();
                    }
                }
            }
            ++n2;
        }
    }

    public void createTreeLeft(Composite parent) {
        this.m_tv_left = new STreeViewer(parent, 268438274);
        this.m_tv_left.setUseHashlookup(true);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 250;
        gd.heightHint = 250;
        this.m_tv_left.getTree().setLayoutData((Object)gd);
        this.m_tv_left.setContentProvider((IContentProvider)new ViewContentProvider());
        this.m_tv_left.setLabelProvider((IBaseLabelProvider)new StyledTreeLabelProvider());
        this.m_root_NG_left = this.m_selectAgents ? Repository.getInstance().getAgentTree() : Repository.getInstance().getNodeGroupTree();
        this.m_tv_left.setInput((Object)this.m_root_NG_left);
        this.m_tv_left.expandAll();
        this.m_tv_left.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (NodeGroupTreeDialog.this.getTreeSelection(NodeGroupTreeDialog.this.m_tv_left).size() > 0) {
                    NodeGroupTreeDialog.this.m_gui.enableField(NodeGroupTreeDialog.this.m_add_btn, true);
                    NodeGroupTreeDialog.this.m_gui.enableField(NodeGroupTreeDialog.this.m_remove_btn, false);
                } else {
                    NodeGroupTreeDialog.this.m_gui.enableField(NodeGroupTreeDialog.this.m_add_btn, false);
                }
            }
        });
        this.m_tv_left.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object obj;
                ISelection iSelect = event.getViewer().getSelection();
                int size = ((IStructuredSelection)iSelect).size();
                if (size == 1 && !((obj = ((IStructuredSelection)iSelect).getFirstElement()) instanceof GroupTreeObjectLast) && obj instanceof GroupTreeObject) {
                    NodeGroupTreeDialog.this.addSelection();
                }
            }
        });
        this.createTreeLeft_contentMenu();
    }

    public void createTreeLeft_contentMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        Menu menu = menuMgr.createContextMenu(this.m_tv_left.getControl());
        this.m_tv_left.getControl().setMenu(menu);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    manager.add((IAction)new ExpandCollapseAction(NodeGroupTreeDialog.this.m_tv_left, "ExpandAll"));
                    manager.add((IAction)new ExpandCollapseAction(NodeGroupTreeDialog.this.m_tv_left, "CollapseAll"));
                }
                catch (RuntimeException runtimeException) {}
            }
        });
    }

    public void createTreeRight(Composite parent) {
        this.m_tv_right = new STreeViewer(parent, 268438274);
        this.m_tv_right.setUseHashlookup(true);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 250;
        gd.heightHint = 250;
        this.m_tv_right.getTree().setLayoutData((Object)gd);
        this.m_tv_right.setContentProvider((IContentProvider)new ViewContentProvider());
        this.m_tv_right.setLabelProvider((IBaseLabelProvider)new StyledTreeLabelProvider_S());
        this.m_root_NG_right = new GroupTreeObject(new TreeObject("root", BMUI.type_folder, null));
        this.m_tv_right.setInput((Object)this.m_root_NG_right);
        this.m_tv_right.expandAll();
        this.m_tv_right.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (NodeGroupTreeDialog.this.getTreeSelection(NodeGroupTreeDialog.this.m_tv_right).size() > 0) {
                    NodeGroupTreeDialog.this.m_gui.enableField(NodeGroupTreeDialog.this.m_add_btn, false);
                    NodeGroupTreeDialog.this.m_gui.enableField(NodeGroupTreeDialog.this.m_remove_btn, true);
                } else {
                    NodeGroupTreeDialog.this.m_gui.enableField(NodeGroupTreeDialog.this.m_add_btn, true);
                }
            }
        });
        this.m_tv_right.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object obj;
                ISelection iSelect = event.getViewer().getSelection();
                int size = ((IStructuredSelection)iSelect).size();
                if (size == 1 && !((obj = ((IStructuredSelection)iSelect).getFirstElement()) instanceof GroupTreeObjectLast) && obj instanceof GroupTreeObject) {
                    NodeGroupTreeDialog.this.addSelection();
                }
            }
        });
        this.createTreeRight_contentMenu();
    }

    public void createTreeRight_contentMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        Menu menu = menuMgr.createContextMenu(this.m_tv_right.getControl());
        this.m_tv_right.getControl().setMenu(menu);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    manager.add((IAction)new ExpandCollapseAction(NodeGroupTreeDialog.this.m_tv_right, "ExpandAll"));
                    manager.add((IAction)new ExpandCollapseAction(NodeGroupTreeDialog.this.m_tv_right, "CollapseAll"));
                }
                catch (RuntimeException runtimeException) {}
            }
        });
    }

    public void addSelection() {
        Collection<GroupTreeObject> list = this.getTreeSelection(this.m_tv_left);
        for (GroupTreeObject gto : list) {
            if (gto == null) continue;
            this.addElement(gto);
        }
        this.m_tv_right.refresh();
        this.m_tv_right.expandAll();
    }

    private void setExpanded(List<GroupTreeObject> elememts) {
        if (elememts != null && elememts.size() > 0) {
            Iterator<GroupTreeObject> it = elememts.iterator();
            while (it.hasNext()) {
                GroupTreeObject groupTreeObject = it.next();
                if (!(groupTreeObject instanceof GroupTreeObjectLast)) continue;
                it.remove();
            }
            this.m_tv_right.setExpandedElements(elememts.toArray());
        }
    }

    public List<GroupTreeObject> addElement(GroupTreeObject gto) {
        LinkedList<GroupTreeObject> elements = new LinkedList<GroupTreeObject>();
        if (this.m_tv_right == null || this.m_root_NG_right == null || gto == null) {
            return elements;
        }
        GroupTreeObject parentGTO = null;
        GroupTreeObject existingGTO = null;
        String path = gto.getPath();
        existingGTO = this.m_root_NG_right.searchPath(path = path.replace("/root/_Groups", "/root"), gto.getType());
        if (existingGTO != null) {
            parentGTO = existingGTO.getParent();
            parentGTO.removeElement(existingGTO);
        } else {
            String parentPath = gto.getParentPath();
            parentPath = parentPath.replace("/root/_Groups", "/root");
            parentGTO = GroupTreeObject.createPath(parentPath, this.m_root_NG_right);
            parentGTO.setType(gto.getParent().getType());
        }
        elements.add(parentGTO);
        try {
            GroupTreeObject clone = gto.clone();
            if (clone != null) {
                if (!(clone instanceof GroupTreeObjectLast)) {
                    clone.getTreeObject().setObject(SELECTED);
                }
                clone.getAllElements().iterator();
                parentGTO.addElement(clone);
                elements.add(clone);
                elements.addAll(clone.getAllElements());
            }
        }
        catch (CloneNotSupportedException e) {
            RTLogger.print(5, "Error cloning element " + gto.getName(), e);
        }
        return elements;
    }

    public void removeSelection() {
        Collection<GroupTreeObject> list = this.getTreeSelection(this.m_tv_right);
        for (GroupTreeObject gto : list) {
            gto.getParent().removeElement(gto);
            if (!this.m_selectAgents) continue;
            GroupTreeObject.cleanEmptyGroups(gto.getParent(), gto.getRoot());
        }
        this.m_tv_right.refresh();
    }

    public Collection<GroupTreeObject> getTreeSelection(TreeViewer tv) {
        HashSet<GroupTreeObject> selection;
        block6: {
            selection = new HashSet<GroupTreeObject>();
            StructuredSelection sel = (StructuredSelection)tv.getSelection();
            try {
                if (sel.isEmpty()) break block6;
                for (Object o : sel) {
                    GroupTreeObject gto;
                    if (this.m_selectAgents) {
                        if (o instanceof GroupTreeObjectLast) {
                            gto = (GroupTreeObject)o;
                            selection.add(gto);
                            continue;
                        }
                        gto = (GroupTreeObject)o;
                        List<GroupTreeObject> elements = gto.getAllElements();
                        for (GroupTreeObject gtos : elements) {
                            if (!(gtos instanceof GroupTreeObjectLast)) continue;
                            selection.add(gtos);
                        }
                        continue;
                    }
                    if (!(o instanceof GroupTreeObject) || o instanceof GroupTreeObjectLast) continue;
                    gto = (GroupTreeObject)o;
                    selection.add(gto);
                }
            }
            catch (RuntimeException runtimeException) {}
        }
        return selection;
    }

    public void setTreeSelection(TreeViewer tv, GroupTreeObject root, GroupTreeObject gto) {
        if (tv == null || root == null || gto == null) {
            return;
        }
        String path = gto.getPath();
        GroupTreeObject gtoFound = root.searchPath(path = path.replace("/root/_Groups", "/root"), gto.getType());
        if (gtoFound != null) {
            tv.setSelection((ISelection)new StructuredSelection((Object)gtoFound), true);
            tv.refresh();
        }
    }

    public void createNodeGroupsSeparatedByPipe() {
        this.m_nodeGroupsByPipe = new StringBuffer();
        if (this.m_root_NG_right != null) {
            List<GroupTreeObject> list = this.m_root_NG_right.getAllElements();
            for (GroupTreeObject gto : list) {
                String path;
                if (gto instanceof GroupTreeObjectLast || gto.getName().equals("_Groups") || !(path = gto.getPath()).startsWith("/root/") || path.startsWith("/root/_Groups/")) continue;
                path = path.replace("/root", "/root/_Groups");
                if (SELECTED != gto.getTreeObject().getObject()) continue;
                this.m_nodeGroupsByPipe.append(path);
                this.m_nodeGroupsByPipe.append('|');
            }
            if (this.m_nodeGroupsByPipe.length() > 0 && this.m_nodeGroupsByPipe.charAt(this.m_nodeGroupsByPipe.length() - 1) == '|') {
                this.m_nodeGroupsByPipe.deleteCharAt(this.m_nodeGroupsByPipe.length() - 1);
            }
        }
    }

    public void createAgentIDsSeparatedByPipe() {
        this.m_nodeGroupsByPipe = new StringBuffer();
        if (this.m_root_NG_right != null) {
            List<GroupTreeObject> list = this.m_root_NG_right.getAllElements();
            for (GroupTreeObject gto : list) {
                if (!(gto instanceof GroupTreeObjectLast)) continue;
                this.m_nodeGroupsByPipe.append(gto.getName());
                this.m_nodeGroupsByPipe.append('|');
            }
            if (this.m_nodeGroupsByPipe.length() > 0 && this.m_nodeGroupsByPipe.charAt(this.m_nodeGroupsByPipe.length() - 1) == '|') {
                this.m_nodeGroupsByPipe.deleteCharAt(this.m_nodeGroupsByPipe.length() - 1);
            }
        }
    }

    public String getSelectionSeparatedByPipe() {
        return this.m_nodeGroupsByPipe.toString();
    }

    public void createOIDsSeparatedByComma() {
        this.m_nodeGroupsByComma = new StringBuffer();
        List<GroupTreeObject> list = this.m_root_NG_right.getAllElements();
        Iterator<GroupTreeObject> it = list.iterator();
        while (it.hasNext()) {
            ITreeObject ito;
            GroupTreeObject origGTO;
            GroupTreeObject gto = it.next();
            if (gto instanceof GroupTreeObjectLast || gto.getName().equals("_Groups")) continue;
            String path = gto.getPath();
            if (!path.startsWith("/root/_Groups")) {
                path = path.replace("/root", "/root/_Groups");
            }
            if ((origGTO = this.m_root_NG_left.searchPath(path, gto.getType())) == null || (ito = origGTO.getTreeObject()) == null || ito.getOID().length() != 32 || SELECTED != gto.getTreeObject().getObject()) continue;
            this.m_nodeGroupsByComma.append(origGTO.getTreeObject().getOID());
            if (!it.hasNext()) continue;
            this.m_nodeGroupsByComma.append(',');
        }
    }

    public String getSelectionOIDsSeparatedByComma() {
        return this.m_nodeGroupsByComma.toString();
    }

    protected void okPressed() {
        if (this.m_selectAgents) {
            this.createAgentIDsSeparatedByPipe();
        } else {
            this.createNodeGroupsSeparatedByPipe();
            this.createOIDsSeparatedByComma();
        }
        super.okPressed();
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    public boolean close() {
        try {
            this.m_add_btn.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_remove_btn.dispose();
        }
        catch (Throwable throwable) {}
        return super.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(" Select Node Groups");
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() instanceof Button) {
            Button b = (Button)e.getSource();
            String name = (String)b.getData();
            if (name.equals(ADD_BTN)) {
                AddNodeGroupAction add = new AddNodeGroupAction(this.m_instance, this.m_tv_left);
                add.run();
            } else if (name.equals(REMOVE_BTN)) {
                RemoveNodeGroupAction remove = new RemoveNodeGroupAction(this.m_instance, this.m_tv_right);
                remove.run();
            }
        }
    }

    private class AddNodeGroupAction
    extends Action {
        private NodeGroupTreeDialog m_NGTreeDialog;

        public AddNodeGroupAction(NodeGroupTreeDialog NGTreeDialog, TreeViewer tv) {
            super("SelectNodeGroups");
            this.m_NGTreeDialog = null;
            this.setId("SelectNodeGroups");
            this.m_NGTreeDialog = NGTreeDialog;
            if (Repository.getInstance().getRights(1009) < 3) {
                this.setEnabled(false);
            } else {
                StructuredSelection sel = (StructuredSelection)tv.getSelection();
                if (sel.size() == 1) {
                    GroupTreeObject gto = (GroupTreeObject)sel.getFirstElement();
                    if (gto instanceof GroupTreeObjectLast) {
                        this.setEnabled(false);
                    } else {
                        this.setText("Select Node Group");
                    }
                } else if (sel.size() > 1) {
                    this.setText("Select Node Groups");
                } else {
                    this.setEnabled(false);
                }
            }
        }

        public void run() {
            this.m_NGTreeDialog.addSelection();
        }
    }

    private class RemoveNodeGroupAction
    extends Action {
        private NodeGroupTreeDialog m_NGTreeDialog;

        public RemoveNodeGroupAction(NodeGroupTreeDialog NGTreeDialog, TreeViewer tv) {
            super("RemoveNodeGroup");
            this.m_NGTreeDialog = null;
            this.setId("RemoveNodeGroup");
            this.m_NGTreeDialog = NGTreeDialog;
            if (Repository.getInstance().getRights(1009) < 3) {
                this.setEnabled(false);
            } else {
                StructuredSelection sel = (StructuredSelection)tv.getSelection();
                if (sel.size() == 1) {
                    GroupTreeObject gto = (GroupTreeObject)sel.getFirstElement();
                    if (gto instanceof GroupTreeObjectLast) {
                        this.setEnabled(false);
                    } else {
                        this.setText("Remove Node Group");
                    }
                } else if (sel.size() > 1) {
                    this.setText("Remove Node Groups");
                } else {
                    this.setEnabled(false);
                }
            }
        }

        public void run() {
            this.m_NGTreeDialog.removeSelection();
        }
    }
}

