/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.dialogs;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.dialogs.CondVFilterDialog;
import com.blixx.boom.gui.dialogs.HelperJob;
import com.blixx.boom.gui.dialogs.IPatternValidation;
import com.blixx.boom.gui.dialogs.PatternValidationDialog;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.dialogs.SinglelineInputDialog;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.utils.PatternComposite;
import com.blixx.boom.gui.utils.PatternMatching;
import com.blixx.boom.gui.utils.PatternValidator;
import com.blixx.boom.gui.views.actions.ManageDialogAction;
import com.blixx.shared.PatternB;
import com.blixx.shared.PatternMatchResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class PVDialog
implements ModifyListener,
SelectionListener,
MouseListener,
ShellListener,
IPatternValidation {
    public static final String PVDIALOG = "PVDialog";
    private static final String PATTERN_EXAMPLE = "PATTERN_EXAMPLE";
    private Shell m_parentShell = null;
    private Shell m_shell;
    private String m_type = null;
    public String m_pattern = "";
    public PatternB m_patternObj = null;
    public TableItem[] m_selection = null;
    private CondVFilterDialog m_condVFilterDialog = null;
    public GUIDisplayElements m_guiElements;
    public TableViewer m_tableViewer = null;
    private SashForm m_main = null;
    private Composite m_top = null;
    private Composite m_bottom = null;
    private ScrolledComposite m_pattern_sComp = null;
    private Composite bottom_comp = null;
    private Composite m_lineCountComp = null;
    private Label m_validateIcon_JAVA = null;
    public Text m_result_field = null;
    public Text m_patternExample = null;
    private Text m_lineCount_field = null;
    private Button m_add_Button = null;
    private Button m_paste_Button = null;
    private Button m_edit_Button = null;
    private Button m_remove_Button = null;
    private Button m_load_Button = null;
    private Button m_append_Button = null;
    private Button m_saveToFile_Button = null;
    private Button m_testLines_Button = null;
    private Button m_stoptestLines_Button = null;
    private Button m_clearLines_Button = null;
    private Button m_close_Button = null;
    public Button m_save_Button = null;
    private Button m_lineLimit_check = null;
    private Button m_resplit_Button;
    public static String PATTERN_INPUT_FIELD_JAVA = "pattern_input_field_java";
    public static String BUTTON_ADD_PATTERN = "button_add_pattern";
    public static String BUTTON_ADD = "button_add";
    public static String BUTTON_EDIT = "button_edit";
    public static String BUTTON_PASTE = "button_paste";
    public static String BUTTON_REMOVE = "button_remove";
    public static String BUTTON_LOAD = "button_load";
    public static String BUTTON_APPEND = "button_append";
    public static String BUTTON_SAVE_TO_FILE = "button_saveToFile";
    public static String BUTTON_VALIDATAE_LINES = "button_test";
    public static String BUTTON_STOPTEST = "button_stoptest";
    public static String BUTTON_CLEAR = "button_clear";
    public static String BUTTON_CLOSE = "button_close";
    public static String BUTTON_SAVE = "button_save";
    private static String BUTTON_LIMIT = "button_limit";
    public static String BUTTON_RESPLIT = "button_resplit";
    public static String PATTERN_ELEMENTS = "pattern_elements";
    public static String JAVA = "JAVA";
    public static String DESCRIPTION_FIELD = "description_field";
    private static int LINE_LIMIT = 20000;
    public PatternMatching m_patternMatching = null;
    public boolean m_isCanceled = false;
    public boolean m_isRunning = false;
    private boolean m_hasLineLimitActive = true;
    private boolean m_savePattern = false;
    private Composite m_pattern_comp = null;
    public PatternComposite m_activePatternComp = null;
    public List<PatternComposite> m_patternFields = new ArrayList<PatternComposite>();
    private PatternValidator m_patternValidator = null;
    private org.eclipse.swt.widgets.List m_patternList_List = null;
    private Text m_description_Field = null;
    Pattern digits = Pattern.compile("\\d+");
    Pattern digitsWp = Pattern.compile("[0-9\\.]+([%a-zA-Z,]+)");
    Pattern digitsWp2 = Pattern.compile("[0-9\\.,:]+");
    Pattern words = Pattern.compile("\\w+");
    Pattern bracket1 = Pattern.compile("([\\Q[{(<\\E])(.*)");
    Pattern bracket2 = Pattern.compile("(.*)([\\Q]})>\\E])");
    Pattern punkt = Pattern.compile("\\p{Punct}+");
    Pattern doubleP = Pattern.compile("\\d+\\.\\d+");
    Pattern digitBr = Pattern.compile("(\\p{Punct})(\\d+)(\\p{Punct})");
    private ProgressBar m_progressBar;
    public Composite m_mRightComp;

    public PVDialog(String pattern, String type) {
        this.m_pattern = pattern;
        this.m_type = type;
        this.createDialog();
    }

    public PVDialog(String pattern, Shell parentShell, String type) {
        this.m_pattern = pattern;
        this.m_type = type;
        this.m_parentShell = parentShell;
        this.createDialog();
    }

    public PVDialog(String pattern, Shell parentShell, String type, boolean savePattern, CondVFilterDialog condVFilterDialog) {
        this.m_pattern = pattern;
        this.m_type = type;
        this.m_parentShell = parentShell;
        this.m_savePattern = savePattern;
        this.m_condVFilterDialog = condVFilterDialog;
        this.createDialog();
    }

    public PVDialog(String type) {
        this.m_type = type;
        this.createDialog();
    }

    public void createDialog() {
        this.m_guiElements = new GUIDisplayElements();
        int style = 1265;
        if (this.m_parentShell != null) {
            this.m_shell = new Shell(this.m_parentShell, style);
        } else {
            this.m_shell = new Shell(Display.getCurrent(), style);
            this.m_guiElements.openShellInActiveMonitor(this.m_shell);
        }
        this.m_shell.addShellListener((ShellListener)this);
        this.m_shell.setLayout((Layout)new GridLayout(1, false));
        this.createContents((Composite)this.m_shell);
        this.m_shell.setSize(700, 650);
        this.m_shell.setText(" Pattern Validation (" + this.m_type + " Pattern)");
        if (this.m_type.equals(PatternValidator.JAVA)) {
            this.m_shell.setImage(BMUI.IMAGE_PATTERN_VALIDATION);
        } else {
            this.m_shell.setImage(BMUI.IMAGE_PATTERN_VALIDATION_SP);
        }
    }

    @Override
    public String getPattern() {
        return this.m_pattern;
    }

    protected void createContents(Composite parent) {
        this.m_patternValidator = new PatternValidator();
        if (this.m_pattern == null || this.m_pattern.equals("")) {
            this.m_pattern = ".*";
            if (this.m_type.equals(PatternValidator.SIMPLIFIED)) {
                this.m_pattern = "<*>";
            }
        }
        GridLayout gdLayout = null;
        gdLayout = new GridLayout(2, false);
        gdLayout.marginBottom = 0;
        gdLayout.marginRight = 0;
        gdLayout.marginLeft = 0;
        parent.setLayout((Layout)gdLayout);
        parent.setBackground(BMUI.color_grey);
        this.m_main = new SashForm(parent, 512);
        GridData gdData = null;
        gdData = new GridData();
        gdData.horizontalSpan = 1;
        gdData.horizontalAlignment = 16384;
        gdData.grabExcessHorizontalSpace = true;
        gdData.grabExcessVerticalSpace = true;
        this.m_main.setLayoutData((Object)gdData);
        this.m_top = new Composite((Composite)this.m_main, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginTop = 5;
        gl.marginWidth = 10;
        this.m_top.setLayout((Layout)gl);
        this.m_bottom = new Composite((Composite)this.m_main, 0);
        gl = new GridLayout(1, false);
        gl.marginWidth = 10;
        this.m_bottom.setLayout((Layout)gl);
        this.m_validateIcon_JAVA = new Label(this.m_top, 0);
        this.m_validateIcon_JAVA.setText(String.valueOf(this.m_type) + " Pattern:   ");
        this.m_pattern_sComp = new ScrolledComposite(this.m_top, 2816);
        this.m_pattern_sComp.setAlwaysShowScrollBars(false);
        this.m_pattern_sComp.setExpandHorizontal(true);
        this.m_pattern_sComp.setExpandVertical(true);
        this.m_pattern_sComp.setLayout((Layout)new GridLayout(1, false));
        this.m_pattern_sComp.setLayoutData((Object)new GridData(4, 4, true, false, 1, 2));
        this.m_pattern_comp = new Composite((Composite)this.m_pattern_sComp, 0);
        gl = new GridLayout(1, false);
        gl.verticalSpacing = 0;
        this.m_pattern_comp.setLayout((Layout)gl);
        this.m_pattern_comp.setLayoutData((Object)new GridData(4, 4, true, false));
        String incomingPatternInitial = this.m_pattern;
        this.m_activePatternComp = new PatternComposite(this.m_pattern_comp, this, this.m_patternValidator);
        this.m_patternFields.add(this.m_activePatternComp);
        PatternComposite pattern1 = new PatternComposite(this.m_pattern_comp, this, this.m_patternValidator);
        pattern1.setPattern(null, this.m_type);
        this.m_patternFields.add(pattern1);
        PatternComposite pattern2 = new PatternComposite(this.m_pattern_comp, this, this.m_patternValidator);
        pattern2.setPattern(null, this.m_type);
        this.m_patternFields.add(pattern2);
        this.m_pattern_sComp.setContent((Control)this.m_pattern_comp);
        this.m_pattern_sComp.setMinSize(this.m_pattern_comp.computeSize(-1, -1, true));
        Button add_btn = this.m_guiElements.addButton(this.m_top, BUTTON_ADD_PATTERN, "Add Pattern", true, 90, 20, 0, this);
        ((GridData)add_btn.getLayoutData()).verticalAlignment = 1024;
        if (this.m_type.equals(PatternValidator.JAVA)) {
            Label l = new Label(this.m_top, 0);
            l.setText(" Pattern Example (ALT+MouseClick):");
            GridData gd = new GridData(4, 4, true, false, 2, 1);
            gd.verticalIndent = 10;
            l.setLayoutData((Object)gd);
            this.m_patternExample = this.m_guiElements.addInputFieldSingle(this.m_top, PATTERN_EXAMPLE, null, null, 2, 1, 0, 5, 365, this);
            ((GridData)this.m_patternExample.getLayoutData()).verticalIndent = 0;
        }
        this.createTableSection(this.m_top);
        this.createResultsArea(this.m_bottom);
        this.m_activePatternComp.setPattern(incomingPatternInitial, this.m_type);
        this.m_activePatternComp.setActive(true, true);
        this.m_main.setWeights(new int[]{72, 25});
        this.m_mRightComp = new Composite(parent, 0);
        gdLayout = new GridLayout(1, false);
        gdLayout.marginRight = 2;
        gdLayout.marginLeft = 2;
        gdLayout.marginHeight = 0;
        this.m_mRightComp.setLayout((Layout)gdLayout);
        this.m_mRightComp.setLayoutData((Object)new GridData(1, 4, false, false));
        this.m_mRightComp.setBackground(BMUI.color_grey);
        this.createPatternTypeSection(this.m_mRightComp);
        this.createButtons(this.m_mRightComp);
    }

    public void createPatternTypeSection(Composite parent) {
        GridData gd;
        this.m_guiElements.addTextField(parent, null, "Pattern Elements:", 7, 1, 10, 0, null);
        String[] patterns = null;
        patterns = this.m_type.equals(PatternValidator.JAVA) ? PatternValidationDialog.m_javaPattern.keySet().toArray(new String[0]) : PatternValidationDialog.m_ovoPattern.keySet().toArray(new String[0]);
        this.m_patternList_List = this.m_guiElements.addList(parent, PATTERN_ELEMENTS, null, patterns, 1, 1, 355, 135, 1, this);
        try {
            gd = (GridData)this.m_patternList_List.getLayoutData();
            gd.grabExcessVerticalSpace = true;
            gd.verticalAlignment = 4;
        }
        catch (Throwable throwable) {}
        this.m_guiElements.addTextField(parent, null, "Description:", 7, 1, 10, 0, null);
        this.m_description_Field = this.m_guiElements.addMultiLineFieldReadOnlyWrap(parent, DESCRIPTION_FIELD, null, null, 1, 1, 100, 127, 0, 1);
        try {
            gd = (GridData)this.m_description_Field.getLayoutData();
            gd.grabExcessVerticalSpace = true;
            gd.verticalAlignment = 4;
        }
        catch (Throwable throwable) {}
    }

    public void addPatternField() {
        PatternComposite patternField = new PatternComposite(this.m_pattern_comp, this, this.m_patternValidator);
        patternField.setPattern(null, this.m_type);
        this.m_patternFields.add(patternField);
        this.m_pattern_sComp.setContent((Control)this.m_pattern_comp);
        this.m_pattern_sComp.setMinSize(this.m_pattern_comp.computeSize(-1, -1, true));
        patternField.setActive(true, false);
        this.setActivePattern(patternField);
    }

    public void deletePatternField(PatternComposite patternField) {
        if (patternField == null) {
            return;
        }
        boolean wasActive = patternField.isActive();
        Control[] controls = this.m_pattern_comp.getChildren();
        int i = 0;
        while (i < controls.length) {
            Control child = controls[i];
            if (child instanceof PatternComposite && child.equals((Object)patternField)) {
                for (PatternComposite pComp : this.m_patternFields) {
                    if (!((Object)((Object)patternField)).equals((Object)pComp)) continue;
                    this.m_patternFields.remove((Object)patternField);
                    break;
                }
                child.dispose();
                this.m_pattern_sComp.setContent((Control)this.m_pattern_comp);
                this.m_pattern_sComp.setMinSize(this.m_pattern_comp.computeSize(-1, -1, true));
                if (wasActive && this.m_pattern_comp.getChildren().length > 0) {
                    Control next = null;
                    try {
                        next = controls[i + 1];
                    }
                    catch (Exception exception) {}
                    if (next == null) {
                        try {
                            next = controls[i - 1];
                        }
                        catch (Exception exception) {}
                    }
                    if (next == null) {
                        try {
                            next = controls[0];
                        }
                        catch (Exception exception) {}
                    }
                    if (next != null) {
                        ((PatternComposite)next).setActive(true, false);
                    }
                }
                return;
            }
            ++i;
        }
    }

    public void setActivePattern(PatternComposite newActivePattern) {
        for (PatternComposite pComp : this.m_patternFields) {
            if (((Object)((Object)newActivePattern)).equals((Object)pComp)) {
                this.m_activePatternComp = newActivePattern;
                this.m_pattern = this.m_activePatternComp.getPattern();
                continue;
            }
            pComp.setActive(false, false);
        }
    }

    public void createResultsArea(Composite comp) {
        String text = "                               \n\n\n\n\n\n\n\n\n\n\n\n";
        this.m_result_field = this.m_guiElements.addInputFieldMultiLine(comp, "RESULTAREA", " Results:", text, 1, 1, 250, 500, 1, 1, this);
        ((GridData)this.m_result_field.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.m_result_field.getLayoutData()).verticalAlignment = 4;
        ((GridData)this.m_result_field.getLayoutData()).grabExcessHorizontalSpace = true;
        ((GridData)this.m_result_field.getLayoutData()).grabExcessVerticalSpace = true;
    }

    private void createButtons(Composite comp) {
        if (this.m_savePattern) {
            Composite btnComp = new Composite(comp, 0);
            GridLayout gl = new GridLayout(2, false);
            gl.verticalSpacing = 0;
            gl.marginWidth = 0;
            gl.marginHeight = 0;
            btnComp.setLayout((Layout)gl);
            btnComp.setLayoutData((Object)new GridData(131072, 128, false, false));
            this.m_save_Button = this.m_guiElements.addButton(btnComp, BUTTON_SAVE, " Save Pattern ", true, 90, 20, 0, this);
            this.m_close_Button = this.m_guiElements.addButton(btnComp, BUTTON_CLOSE, "  Cancel  ", true, 90, 20, 0, this);
        } else {
            this.m_close_Button = this.m_guiElements.addButton(comp, BUTTON_CLOSE, "  Close  ", true, 90, 20, 5, this);
            ((GridData)this.m_close_Button.getLayoutData()).grabExcessHorizontalSpace = true;
            ((GridData)this.m_close_Button.getLayoutData()).grabExcessVerticalSpace = true;
            ((GridData)this.m_close_Button.getLayoutData()).horizontalAlignment = 131072;
            ((GridData)this.m_close_Button.getLayoutData()).verticalAlignment = 0x1000008;
        }
    }

    public Table createTableSection(Composite parentComp) {
        Composite btn1Comp = new Composite(parentComp, 0);
        GridLayout gl = new GridLayout(7, false);
        gl.marginWidth = 0;
        gl.marginTop = 5;
        gl.horizontalSpacing = 3;
        btn1Comp.setLayout((Layout)gl);
        btn1Comp.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        btn1Comp.setBackground(BMUI.color_grey);
        this.m_edit_Button = this.m_guiElements.addButton(btn1Comp, BUTTON_EDIT, "Edit Line", false, 90, 20, 10, this);
        this.m_edit_Button.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.m_add_Button = this.m_guiElements.addButton(btn1Comp, BUTTON_ADD, "Append Line", true, 90, 20, 10, this);
        this.m_add_Button.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.m_paste_Button = this.m_guiElements.addButton(btn1Comp, BUTTON_PASTE, "Paste", true, 90, 20, 10, this);
        this.m_paste_Button.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.m_load_Button = this.m_guiElements.addButton(btn1Comp, BUTTON_LOAD, "Load from File", true, 90, 20, 10, this);
        this.m_load_Button.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.m_append_Button = this.m_guiElements.addButton(btn1Comp, BUTTON_APPEND, "Append from File", true, 90, 20, 10, this);
        this.m_append_Button.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.m_saveToFile_Button = this.m_guiElements.addButton(btn1Comp, BUTTON_SAVE_TO_FILE, "Save to File", false, 90, 20, 10, this);
        this.m_saveToFile_Button.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.m_resplit_Button = this.m_guiElements.addButton(btn1Comp, BUTTON_RESPLIT, " Re-split ", false, 90, 20, 20, this);
        this.m_resplit_Button.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        Table table = new Table(parentComp, 268503810);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gridData = new GridData(4, 4, true, true, 2, 1);
        gridData.heightHint = 700;
        table.setLayoutData((Object)gridData);
        table.addSelectionListener((SelectionListener)this);
        this.m_tableViewer = new TableViewer(table);
        this.m_patternMatching = new PatternMatching(this.m_tableViewer, this);
        TableColumn col1 = new TableColumn(table, 0);
        col1.setWidth(25);
        col1.setText("Status");
        col1.setToolTipText("Validation Status (true|false)");
        TableColumn col2 = new TableColumn(table, 131072);
        col2.setWidth(30);
        col2.setText("Time(nanoSec)");
        col2.setToolTipText("Processing Time in nano seconds");
        TableColumn col3 = new TableColumn(table, 0);
        col3.setWidth(1646);
        col3.setText("Text");
        col3.setToolTipText("Text to validate");
        table.addMouseListener((MouseListener)this);
        table.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127 && (e.stateMask & 0x40000) == 0) {
                    PVDialog.this.removeLines();
                }
            }
        });
        this.bottom_comp = new Composite(parentComp, 0);
        gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        this.bottom_comp.setLayout((Layout)gl);
        this.bottom_comp.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        this.m_progressBar = new ProgressBar(this.bottom_comp, 256);
        this.m_progressBar.setEnabled(false);
        GridData ldp = new GridData(4, 128, true, false);
        ldp.verticalIndent = 2;
        ldp.heightHint = 10;
        this.m_progressBar.setLayoutData((Object)ldp);
        this.m_lineCountComp = new Composite(this.bottom_comp, 0);
        gl = new GridLayout(4, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.marginLeft = 5;
        gl.horizontalSpacing = 0;
        this.m_lineCountComp.setLayout((Layout)gl);
        this.m_lineCountComp.setLayoutData((Object)new GridData(4, 128, false, false));
        this.m_guiElements.addTextReadOnlyNoBorder(this.m_lineCountComp, null, "Current Lines:", 1, 1, 0, 0, null);
        this.m_lineCount_field = this.m_guiElements.addTextReadOnlyNoBorder(this.m_lineCountComp, null, "0", 1, 1, 0, 0, null);
        ((GridData)this.m_lineCount_field.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.m_lineCount_field.getLayoutData()).grabExcessHorizontalSpace = true;
        ((GridData)this.m_lineCount_field.getLayoutData()).widthHint = 50;
        this.m_lineLimit_check = this.m_guiElements.addCheckbox(this.m_lineCountComp, BUTTON_LIMIT, "Set Limit to " + LINE_LIMIT, this.m_hasLineLimitActive, 1, 1, 0, this);
        Composite btn2Comp = new Composite(this.bottom_comp, 0);
        gl = new GridLayout(4, true);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        btn2Comp.setLayout((Layout)gl);
        btn2Comp.setLayoutData((Object)new GridData(4, 128, false, false, 4, 1));
        this.m_testLines_Button = this.m_guiElements.addButton(btn2Comp, BUTTON_VALIDATAE_LINES, " Validate all Lines ", false, 90, 20, 0, this);
        this.m_testLines_Button.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.m_stoptestLines_Button = this.m_guiElements.addButton(btn2Comp, BUTTON_STOPTEST, " Stop Validation ", false, 90, 20, 0, this);
        this.m_stoptestLines_Button.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.m_remove_Button = this.m_guiElements.addButton(btn2Comp, BUTTON_REMOVE, " Remove Lines ", false, 90, 20, 10, this);
        this.m_remove_Button.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.m_clearLines_Button = this.m_guiElements.addButton(btn2Comp, BUTTON_CLEAR, " Clear All Lines ", false, 90, 20, 0, this);
        this.m_clearLines_Button.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        return table;
    }

    private void removeLines() {
        this.m_patternMatching.removeLines();
        this.updateLineCount();
        this.checkButtonStatus();
    }

    public void cleanImages() {
        if (this.m_patternMatching != null) {
            this.m_patternMatching.clearStatus();
        }
        if (this.m_progressBar != null) {
            this.m_progressBar.setSelection(0);
        }
    }

    public void modifyText(ModifyEvent e) {
    }

    public boolean hasLineLimitActive() {
        return this.m_hasLineLimitActive;
    }

    public int getLineLimit() {
        return LINE_LIMIT;
    }

    public void updateLineCount() {
        this.m_lineCount_field.setText("" + this.m_tableViewer.getTable().getItemCount());
    }

    public void disableAllButtons() {
        this.m_guiElements.enableField(this.m_edit_Button, false);
        this.m_guiElements.enableField(this.m_add_Button, false);
        this.m_guiElements.enableField(this.m_remove_Button, false);
        this.m_guiElements.enableField(this.m_load_Button, false);
        this.m_guiElements.enableField(this.m_append_Button, false);
        this.m_guiElements.enableField(this.m_stoptestLines_Button, false);
        this.m_guiElements.enableField(this.m_paste_Button, false);
        this.m_guiElements.enableField(this.m_saveToFile_Button, false);
        this.m_guiElements.enableField(this.m_testLines_Button, false);
        this.m_guiElements.enableField(this.m_clearLines_Button, false);
        this.m_guiElements.enableField(this.m_resplit_Button, false);
    }

    public void checkButtonStatus() {
        try {
            Table table;
            this.m_guiElements.enableField(this.m_stoptestLines_Button, this.m_isRunning);
            this.m_guiElements.enableField(this.m_paste_Button, !this.m_isRunning);
            if (this.m_tableViewer != null && (table = this.m_tableViewer.getTable()) != null && !table.isDisposed()) {
                int numOfItems = table.getItemCount();
                int selIndex = table.getSelectionIndex();
                if (numOfItems == 0) {
                    this.m_guiElements.enableField(this.m_edit_Button, false);
                    this.m_guiElements.enableField(this.m_add_Button, true);
                    this.m_guiElements.enableField(this.m_remove_Button, false);
                    this.m_guiElements.enableField(this.m_load_Button, true);
                    this.m_guiElements.enableField(this.m_append_Button, true);
                    this.m_guiElements.enableField(this.m_saveToFile_Button, false);
                    this.m_guiElements.enableField(this.m_testLines_Button, false);
                    this.m_guiElements.enableField(this.m_clearLines_Button, false);
                    this.m_guiElements.enableField(this.m_resplit_Button, false);
                } else if (numOfItems == 1) {
                    this.m_guiElements.enableField(this.m_add_Button, true);
                    this.m_guiElements.enableField(this.m_load_Button, true);
                    this.m_guiElements.enableField(this.m_append_Button, true);
                    this.m_guiElements.enableField(this.m_saveToFile_Button, true);
                    this.m_guiElements.enableField(this.m_testLines_Button, this.m_activePatternComp.isValid());
                    this.m_guiElements.enableField(this.m_clearLines_Button, true);
                    this.m_guiElements.enableField(this.m_resplit_Button, false);
                    if (selIndex != -1) {
                        this.m_guiElements.enableField(this.m_edit_Button, true);
                        this.m_guiElements.enableField(this.m_remove_Button, true);
                    } else {
                        this.m_guiElements.enableField(this.m_edit_Button, false);
                        this.m_guiElements.enableField(this.m_remove_Button, false);
                    }
                } else if (numOfItems > 1) {
                    this.m_guiElements.enableField(this.m_add_Button, true);
                    this.m_guiElements.enableField(this.m_load_Button, true);
                    this.m_guiElements.enableField(this.m_append_Button, true);
                    this.m_guiElements.enableField(this.m_saveToFile_Button, true);
                    this.m_guiElements.enableField(this.m_testLines_Button, this.m_activePatternComp.isValid());
                    this.m_guiElements.enableField(this.m_clearLines_Button, true);
                    this.m_guiElements.enableField(this.m_resplit_Button, true);
                    if (selIndex != -1) {
                        this.m_guiElements.enableField(this.m_edit_Button, true);
                        this.m_guiElements.enableField(this.m_remove_Button, true);
                    } else {
                        this.m_guiElements.enableField(this.m_edit_Button, false);
                        this.m_guiElements.enableField(this.m_remove_Button, false);
                    }
                }
                if (this.m_remove_Button != null) {
                    int selCount = table.getSelectionCount();
                    if (selCount > 1) {
                        this.m_remove_Button.setText(" Remove Lines ");
                    } else {
                        this.m_remove_Button.setText(" Remove Line ");
                    }
                }
            }
        }
        catch (Exception exception) {}
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        if (e.getSource() instanceof Table) {
            TableItem tableItem = this.m_patternMatching.editLine();
            this.validateLines(tableItem, null);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        org.eclipse.swt.widgets.List list;
        String name;
        if (e.getSource() instanceof Button) {
            Button b = (Button)e.getSource();
            String buttonName = (String)b.getData();
            if (buttonName.equals(BUTTON_ADD)) {
                TableItem tableItem = this.m_patternMatching.addNewLine();
                if (tableItem != null) {
                    this.validateLines(tableItem, null);
                    this.updateLineCount();
                    this.checkButtonStatus();
                }
            } else if (buttonName.equals(BUTTON_LOAD)) {
                this.disableAllButtons();
                this.m_patternMatching.loadFromFile(false);
            } else if (buttonName.equals(BUTTON_SAVE_TO_FILE)) {
                this.m_patternMatching.saveToFile();
                this.checkButtonStatus();
            } else if (buttonName.equals(BUTTON_VALIDATAE_LINES)) {
                this.disableAllButtons();
                try {
                    this.validateLines(null, null);
                }
                catch (Throwable throwable) {}
            } else if (buttonName.equals(BUTTON_STOPTEST)) {
                this.m_isCanceled = true;
            } else if (buttonName.equals(BUTTON_REMOVE)) {
                this.removeLines();
            } else if (buttonName.equals(BUTTON_EDIT)) {
                TableItem tableItem = this.m_patternMatching.editLine();
                if (tableItem != null && !tableItem.isDisposed()) {
                    this.validateLines(tableItem, null);
                }
                this.checkButtonStatus();
            } else if (buttonName.equals(BUTTON_APPEND)) {
                this.disableAllButtons();
                this.m_patternMatching.loadFromFile(true);
            } else if (buttonName.equals(BUTTON_PASTE)) {
                this.m_patternMatching.paste();
            } else if (buttonName == BUTTON_CLEAR) {
                this.m_tableViewer.getTable().removeAll();
                this.checkButtonStatus();
                this.updateLineCount();
            } else if (buttonName.equals(BUTTON_CLOSE)) {
                this.m_shell.dispose();
            } else if (buttonName.equals(BUTTON_SAVE)) {
                if (this.m_condVFilterDialog != null) {
                    this.m_condVFilterDialog.setPattern(this.m_activePatternComp.getPattern());
                }
                this.m_shell.dispose();
            } else if (buttonName.equals(BUTTON_LIMIT)) {
                this.m_hasLineLimitActive = this.m_lineLimit_check.getSelection();
            } else if (buttonName.equals(BUTTON_RESPLIT)) {
                try {
                    this.resplitRecords();
                }
                catch (Throwable throwable) {
                    new ShowMessageBox("Error", "Unexpected error occured", 8);
                }
                this.updateLineCount();
                this.checkButtonStatus();
            } else if (buttonName.equals(BUTTON_ADD_PATTERN)) {
                this.addPatternField();
            }
        } else if (e.getSource() instanceof Table) {
            if (this.m_isRunning) {
                return;
            }
            String result = "";
            Table table = (Table)e.getSource();
            int row = table.getSelectionIndex();
            if (this.m_activePatternComp.isValid()) {
                TableItem item = table.getItem(row);
                HelperJob hj = new HelperJob("PatternValidation", item, this.m_patternObj);
                hj.runInUIThread(null);
                PatternMatchResult pMatchResult = (PatternMatchResult)item.getData(PatternMatchResult.class.getName());
                if (pMatchResult != null) {
                    if (pMatchResult.getVariableMap().size() == 0) {
                        result = "No capturing group(s) defined";
                    } else {
                        Map<String, String> resultVars = pMatchResult.getVariableMap();
                        if (resultVars != null) {
                            ArrayList<String> varNames = new ArrayList<String>(resultVars.keySet());
                            StringBuffer sb = new StringBuffer();
                            for (String var : varNames) {
                                String value = resultVars.get(var);
                                if (var == null) {
                                    var = "";
                                }
                                sb.append(var).append(" = ").append((Object)value).append('\n');
                            }
                            result = sb.toString();
                        }
                    }
                }
                this.m_result_field.setText(result.replace("\r", ""));
            }
            this.checkButtonStatus();
        } else if (e.getSource() instanceof org.eclipse.swt.widgets.List && (name = (String)(list = (org.eclipse.swt.widgets.List)e.getSource()).getData()).equals(PATTERN_ELEMENTS)) {
            this.refreshDescriptionField();
            this.checkButtonStatus();
        }
        Display.getCurrent().readAndDispatch();
    }

    public void refreshDescriptionField() {
        this.m_description_Field.setText("");
        int index = this.m_patternList_List.getSelectionIndex();
        if (this.m_type.equals(PatternValidator.JAVA)) {
            this.m_description_Field.setText(PatternValidationDialog.m_javaPattern.get(this.m_patternList_List.getItem(index)));
        } else {
            this.m_description_Field.setText(PatternValidationDialog.m_ovoPattern.get(this.m_patternList_List.getItem(index)));
        }
    }

    protected void resplitRecords() {
        IInputValidator iid = new IInputValidator(){

            public String isValid(String newText) {
                if (PVDialog.this.m_patternMatching.validatePattern(newText, JAVA)) {
                    return null;
                }
                return "invalid java pattern";
            }
        };
        SinglelineInputDialog sld = new SinglelineInputDialog(this.m_shell, "  Split Records (Java Pattern)", "Pattern matching the start line of a Multiline Record:", ".*", iid);
        sld.setBlockOnOpen(true);
        int res = sld.open();
        if (res == 0) {
            String pattern = sld.getValue();
            Pattern p = Pattern.compile(pattern, 32);
            if (!".*".equals(pattern)) {
                TableItem[] ti = this.m_tableViewer.getTable().getItems();
                String[] arr = new String[ti.length];
                boolean matchedOne = false;
                int i = 0;
                while (i < ti.length) {
                    arr[i] = ti[i].getText(PatternMatching.COLUMN_TEXT);
                    if (matchedOne || p.matcher(arr[i]).matches()) {
                        matchedOne = true;
                    }
                    ++i;
                }
                if (!matchedOne) {
                    MessageBox mb = new MessageBox(this.m_shell, 8);
                    mb.setMessage("Pattern does not match with any String\nSplit operation discarded");
                    mb.setText("Warning");
                    mb.open();
                    return;
                }
                this.m_tableViewer.getTable().removeAll();
                this.updateLineCount();
                StringBuffer sb = null;
                int i2 = 0;
                while (i2 < arr.length) {
                    String text = arr[i2];
                    Matcher m = p.matcher(text);
                    if (m.matches()) {
                        if (sb != null && sb.length() > 0) {
                            this.m_patternMatching.addNewLine(sb.toString());
                            sb = new StringBuffer();
                        }
                        if (sb == null) {
                            sb = new StringBuffer();
                        }
                        sb.append(text);
                    } else if (sb != null) {
                        sb.append("\n").append(text);
                    }
                    ++i2;
                }
                if (sb != null && sb.length() > 0) {
                    this.m_patternMatching.addNewLine(sb.toString());
                }
            }
        }
    }

    private void validateLines(TableItem tableItem, List<TableItem> list) {
        try {
            if (tableItem != null) {
                this.checkTableItem(tableItem);
            } else if (list != null) {
                int i = 0;
                while (i < list.size()) {
                    TableItem item = list.get(i);
                    this.checkTableItem(item);
                    ++i;
                }
            } else {
                Table table = this.m_tableViewer.getTable();
                if (table != null && table.getItemCount() > 0) {
                    this.m_isRunning = true;
                    this.cleanImages();
                    this.m_progressBar.setEnabled(true);
                    this.m_progressBar.setMaximum(table.getItemCount());
                    this.m_testLines_Button.setEnabled(false);
                    this.m_stoptestLines_Button.setEnabled(true);
                    this.m_isCanceled = false;
                    HelperJob hj = new HelperJob("PatternValidation", 0, table, this.m_patternObj, this, PVDIALOG);
                    Repository.getUIJobManager().schedule(hj);
                }
            }
            this.m_patternMatching.setStatus(false);
        }
        catch (RuntimeException e) {
            new ShowMessageBox("Warning", e.getMessage(), 8);
        }
    }

    private void checkTableItem(TableItem item) {
        HelperJob hj = new HelperJob("PatternValidation", item, this.m_patternObj);
        Repository.getUIJobManager().schedule(hj);
    }

    public void mouseUp(MouseEvent e) {
        String text;
        Table t;
        TableItem[] ti;
        if (!(e.getSource() instanceof Text) && e.getSource() instanceof Table && (e.stateMask & 0x10000) > 0 && (ti = (t = (Table)e.getSource()).getSelection()) != null && ti.length == 1 && (text = ti[0].getText(PatternMatching.COLUMN_TEXT)) != null && text.length() > 0 && this.m_patternExample != null) {
            this.m_patternExample.setText(this.getSuggestion(text));
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public String getType() {
        return this.m_type;
    }

    public void activate() {
        if (this.m_shell != null) {
            this.m_shell.setActive();
            if (this.m_shell.getMinimized()) {
                this.m_shell.setMinimized(false);
            }
        }
    }

    public void close() {
        try {
            this.m_shell.close();
        }
        catch (Throwable throwable) {}
    }

    public void open() {
        this.m_shell.open();
        ManageDialogAction.addPVDialog(this);
    }

    public String getSuggestion(String text) {
        Pattern pEnd;
        Matcher mEnd;
        StringBuffer pattern = new StringBuffer();
        try {
            String[] parts = text.split("\\s+");
            int i = 0;
            while (i < parts.length) {
                if (i > 10) {
                    pattern.append(".*");
                    break;
                }
                Matcher m1 = this.digits.matcher(parts[i]);
                Matcher m2 = this.punkt.matcher(parts[i]);
                Matcher m4 = this.digitsWp.matcher(parts[i]);
                Matcher m5 = this.digitsWp2.matcher(parts[i]);
                Matcher doublePm = this.doubleP.matcher(parts[i]);
                Matcher w1 = this.words.matcher(parts[i]);
                Matcher dBr = this.digitBr.matcher(parts[i]);
                Matcher br1 = this.bracket1.matcher(parts[i]);
                Matcher br2 = this.bracket2.matcher(parts[i]);
                if (m1.matches()) {
                    pattern.append("(\\d+)");
                } else if (m5.matches()) {
                    if (doublePm.matches()) {
                        pattern.append("(\\d+\\.\\d+)");
                    } else if (Pattern.matches("\\d+.", parts[i])) {
                        pattern.append("(\\d+).");
                    } else {
                        pattern.append("([0-9\\.,:]*)");
                    }
                } else if (m4.matches()) {
                    pattern.append("([0-9\\.]+)").append(m4.group(1));
                } else if (m2.matches()) {
                    if (parts[i].length() == 1) {
                        pattern.append("\\" + parts[i]);
                    } else {
                        pattern.append("\\Q" + parts[i] + "\\E");
                    }
                } else if (dBr.matches()) {
                    pattern.append("\\" + dBr.group(1)).append("(\\d+)").append("\\" + dBr.group(3));
                } else if (br1.matches()) {
                    String group2 = br1.group(2);
                    if (br2.matches()) {
                        group2 = group2.substring(0, group2.length() - 1);
                    }
                    if (Pattern.matches("\\w+", group2)) {
                        pattern.append("\\" + br1.group(1)).append("(\\w+)");
                    } else if (Pattern.matches("\\d+", group2)) {
                        pattern.append("\\" + br1.group(1)).append("(\\d+)");
                    } else {
                        pattern.append("\\" + br1.group(1)).append("(.*)");
                    }
                    if (br2.matches()) {
                        pattern.append("\\" + br2.group(2));
                    }
                } else if (br2.matches()) {
                    String group1 = br2.group(1);
                    if (Pattern.matches("\\w+", group1)) {
                        pattern.append("(\\w+)").append("\\" + br2.group(2));
                    } else if (Pattern.matches("\\d+", group1)) {
                        pattern.append("(\\d+)").append("\\" + br2.group(2));
                    } else {
                        pattern.append("(.*)").append("\\" + br2.group(2));
                    }
                } else if (w1.matches()) {
                    pattern.append("(\\w+)");
                } else {
                    pattern.append("(.*)");
                }
                if (i != parts.length - 1) {
                    pattern.append("\\s+");
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            pattern = new StringBuffer();
        }
        String patternString = pattern.toString();
        Pattern pStart = Pattern.compile("\\s+.*");
        Matcher mStart = pStart.matcher(text);
        if (mStart.matches()) {
            patternString = "\\s*" + patternString;
        }
        if ((mEnd = (pEnd = Pattern.compile(".*\\s+")).matcher(text)).matches()) {
            patternString = String.valueOf(patternString) + "\\s*";
        }
        return patternString;
    }

    public void shellClosed(ShellEvent e) {
        ManageDialogAction.removePVDialog(this);
        try {
            this.m_validateIcon_JAVA.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_result_field.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_patternExample.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_lineCount_field.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_add_Button.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_paste_Button.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_edit_Button.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_remove_Button.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_load_Button.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_append_Button.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_close_Button.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_save_Button.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_saveToFile_Button.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_testLines_Button.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_stoptestLines_Button.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_progressBar.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_clearLines_Button.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_shell.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_patternMatching.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_lineLimit_check.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_lineCountComp.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.bottom_comp.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_top.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_bottom.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_description_Field.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_patternList_List.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_mRightComp.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_main.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_shell.dispose();
        }
        catch (Throwable throwable) {}
        this.m_shell = null;
    }

    public void shellActivated(ShellEvent e) {
    }

    public void shellDeactivated(ShellEvent e) {
    }

    public void shellDeiconified(ShellEvent e) {
    }

    public void shellIconified(ShellEvent e) {
    }

    @Override
    public ProgressBar getProgressBar() {
        return this.m_progressBar;
    }

    @Override
    public boolean isCanceled() {
        return this.m_isCanceled;
    }

    @Override
    public void setStopped() {
        this.m_isCanceled = false;
        this.m_isRunning = false;
        this.checkButtonStatus();
    }

    public boolean isDisposed() {
        return this.m_shell.isDisposed();
    }
}

