/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.dialogs;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.dialogs.HelperJob;
import com.blixx.boom.gui.dialogs.IPatternValidation;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.dialogs.SinglelineInputDialog;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.utils.PatternMatching;
import com.blixx.boom.gui.views.FilterCondDetails;
import com.blixx.log.RTLogger;
import com.blixx.shared.PatternB;
import com.blixx.shared.PatternMatchResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class PatternValidationDialog
extends StatusDialog
implements ModifyListener,
SelectionListener,
IPatternValidation,
DisposeListener {
    public static final String PATTERNVDIALOG = "PatternVDialog";
    public FilterCondDetails m_filterCondDetails = null;
    public String m_patternJAVA = "";
    public String m_patternOVO = "";
    public String m_patternType = null;
    public TableItem[] m_selection = null;
    public GUIDisplayElements m_guiElements;
    public TableViewer m_tableViewer = null;
    public PatternMatching m_patternMatching = null;
    public boolean m_isValidated_OVO = true;
    public boolean m_isValidated_JAVA = true;
    public boolean m_isCanceled = false;
    public boolean m_isRunning = false;
    private ProgressBar m_progressBar;
    private ScrolledComposite m_scrolledComp = null;
    private Composite m_parent = null;
    private Composite m_parentComp = null;
    private Composite m_leftComp = null;
    private Composite m_rightComp = null;
    private Composite patternInputComp = null;
    private Composite m_lineCountComp = null;
    private Composite m_compBtn1 = null;
    private Composite m_compBtn2 = null;
    private Composite m_bottomComp = null;
    private Label m_validateIcon_OVO = null;
    private Label m_validateIcon_JAVA = null;
    private Text m_pattern_inputField_OVO = null;
    private Text m_pattern_inputField_JAVA = null;
    private Text m_result_field = null;
    private Text m_lineCount_field = null;
    private Button m_save_OVOPattern_Button = null;
    private Button m_save_JAVAPattern_Button = null;
    private Button m_convert_Button = null;
    private Button m_add_Button = null;
    private Button m_paste_Button = null;
    private Button m_edit_Button = null;
    private Button m_remove_Button = null;
    private Button m_load_Button = null;
    private Button m_append_Button = null;
    private Button m_saveToFile_Button = null;
    private Button m_testLines_Button = null;
    private Button m_close_Button = null;
    private CCombo m_patternTypes_Combo = null;
    private List m_patternList_List = null;
    private Text m_description_Field = null;
    private Button m_stoptestLines_Button = null;
    private Button m_clearLines_Button = null;
    private Button m_lineLimit_check = null;
    private Button m_resplit_Button;
    public static String PATTERN_INPUT_FIELD_OVO = "pattern_input_field_ovo";
    public static String PATTERN_INPUT_FIELD_JAVA = "pattern_input_field_java";
    public static String BUTTON_SAVE_OVO_PATTERN = "button_save_ovo";
    public static String BUTTON_SAVE_JAVA_PATTERN = "button_save_java";
    public static String BUTTON_CONVERT = "button_convert";
    public static String BUTTON_ADD = "button_add";
    public static String BUTTON_PASTE = "button_paste";
    public static String BUTTON_EDIT = "button_edit";
    public static String BUTTON_REMOVE = "button_remove";
    public static String BUTTON_LOAD = "button_load";
    public static String BUTTON_APPEND = "button_append";
    public static String BUTTON_SAVE_TO_FILE = "button_saveToFile";
    public static String BUTTON_VALIDATE = "button_test";
    public static String BUTTON_CLOSE = "button_close";
    public static String BUTTON_RESPLIT = "button_resplit";
    public static String CHECK_SELECT_ALL = "SELECT_ALL";
    public static String PATTERN_TYPE = "pattern_type";
    public static String PATTERN_ELEMENTS = "pattern_elements";
    public static String DESCRIPTION_FIELD = "description_field";
    public static String JAVA = "JAVA";
    public static String OVO = "SIMPLIFIED";
    public static String BUTTON_STOPTEST = "button_stoptest";
    public static String BUTTON_CLEAR = "button_clear";
    private static String BUTTON_LIMIT = "button_limit";
    private static int LINE_LIMIT = 20000;
    private boolean m_hasLineLimitActive = true;
    public static String[] m_pList = new String[]{"JAVA", "SIMPLIFIED"};
    public String[] m_ovoList = null;
    public String[] m_ovoDesc = null;
    public String[] m_javaList = null;
    public String[] m_javaDesc = null;
    public static Map<String, String> m_javaPattern = new LinkedHashMap<String, String>();
    public static Map<String, String> m_ovoPattern;

    static {
        m_javaPattern.put(".", "Any character (may or may not match line terminators)");
        m_javaPattern.put("\\d", "Any digit: [0-9]");
        m_javaPattern.put("\\D", "Any non-digit: [^0-9]");
        m_javaPattern.put("\\s", "Any whitespace character: [ \\t\\n\\x0B\\f\\r]");
        m_javaPattern.put("\\S", "Any non-whitespace character: [^\\s]");
        m_javaPattern.put("\\w", "Any word character (letter, digit, underscore): [a-zA-Z_0-9]");
        m_javaPattern.put("\\W", "Any none-word character: [^\\w]");
        m_javaPattern.put("[abc]", "a, b, or c (simple class)");
        m_javaPattern.put("[^abc]", "Any character except a, b, or c (negation)");
        m_javaPattern.put("[a-zA-Z]", "a through z  or A through Z, inclusive (range)");
        m_javaPattern.put("[a-d[m-p]]", "a through d, or m through p: [a-dm-p] (union)");
        m_javaPattern.put("[a-z&&[def]]", "d, e, or f (intersection)");
        m_javaPattern.put("[a-z&&[^bc]]", "a through z, except for b and c: [ad-z] (subtraction)");
        m_javaPattern.put("[a-z&&[^m-p]]", "a through z, and not m through p: [a-lq-z](subtraction)");
        m_javaPattern.put("^", "The beginning of a line");
        m_javaPattern.put("$", "The end of a line");
        m_javaPattern.put("\\b", "A word boundary");
        m_javaPattern.put("\\B", "A non-word boundary");
        m_javaPattern.put("\\A", "The beginning of the input");
        m_javaPattern.put("\\G", "The end of the previous match");
        m_javaPattern.put("\\Z", "The end of the input but for the final terminator, if any");
        m_javaPattern.put("\\z", "The end of the input");
        m_javaPattern.put("\\Q", "Nothing, but quotes all characters until \\E");
        m_javaPattern.put("\\E", "Nothing, but ends quoting started by \\Q");
        m_javaPattern.put("[a-z]", "Any lower case letter");
        m_javaPattern.put("[0-9a-fA-F]", "any hexadecimal character");
        m_javaPattern.put("[^a-z]", "Any character except a lower case letter");
        m_javaPattern.put("[^%0-9]", "Any character except a digit or a % character");
        m_javaPattern.put("+", "One or more. i.e. \"\\s+\" matches one or more whitespace characters");
        m_javaPattern.put("*", "zero or more. i.e. \"\\s*\" matches zero or more whitespace characters");
        m_javaPattern.put("?", "zero or one. i.e. \"\\s?\" matches zero or one whitespace characters");
        m_ovoPattern = new LinkedHashMap<String, String>();
        m_ovoPattern.put("<*>", "Matches any string of zero or more arbitrary characters (including separators).");
        m_ovoPattern.put("<n*>", "Matches a string of n arbitrary characters (including separators).");
        m_ovoPattern.put("<#>", "Matches a sequence of one or more digits.");
        m_ovoPattern.put("<n#>", "Matches a number composed of n digit.");
        m_ovoPattern.put("<_>", "Matches a sequence of one or more field separators.");
        m_ovoPattern.put("<n_>", "Matches a string of n separators.");
        m_ovoPattern.put("<@>", "Matches any string that contains no separator characters, in other words, a sequence of one or more non-separators; this can be used for matching words.");
        m_ovoPattern.put("<*.var>", "Writes the result of <*> into the variable 'var'. ");
        m_ovoPattern.put("<#.var>", "Writes the result of <#> into the variable 'var'. ");
        m_ovoPattern.put("<@.var>", "Writes the result of <@> into the variable 'var'. ");
        m_ovoPattern.put("<<#> -lt N>", "A number less than N");
        m_ovoPattern.put("<<#> -le N>", "A number less than or equal to N");
        m_ovoPattern.put("<<#> -gt N>", "A number greater than N");
        m_ovoPattern.put("<<#> -ge N>", "A number greater than or equal to N");
        m_ovoPattern.put("<<#> -eq N>", "A number equal to N");
        m_ovoPattern.put("<<#> -ne N>", "A number not equal to N");
        m_ovoPattern.put("<N -lt [<#>] -lt M>", "A number between N and M");
        m_ovoPattern.put("<^javaPattern^>", "Inject native java pattern");
    }

    public PatternValidationDialog(Shell parent, String pattern, FilterCondDetails fcd) {
        super(parent);
        this.m_filterCondDetails = fcd;
        this.setShellStyle(1264);
        this.setTitle("  Pattern Validation (Simplified & Java)");
        this.initPatternLists();
        this.setPattern(pattern);
    }

    protected Control createContents(Composite parent) {
        this.m_parent = parent;
        this.m_parent.setLayout((Layout)new FillLayout(256));
        this.m_scrolledComp = new ScrolledComposite(this.m_parent, 0);
        this.m_scrolledComp.setAlwaysShowScrollBars(false);
        this.m_scrolledComp.setExpandHorizontal(true);
        this.m_scrolledComp.setExpandVertical(true);
        this.m_scrolledComp.setLayout((Layout)new FillLayout(257));
        this.m_scrolledComp.addDisposeListener((DisposeListener)this);
        PatternValidationDialog.applyDialogFont((Control)this.m_scrolledComp);
        this.initializeDialogUnits((Control)this.m_scrolledComp);
        this.dialogArea = this.createDialogArea((Composite)this.m_scrolledComp);
        this.m_scrolledComp.setContent(this.dialogArea);
        this.m_scrolledComp.setMinSize(this.dialogArea.computeSize(-1, -1));
        return this.m_parent;
    }

    protected Control createDialogArea(Composite scrolledComposite) {
        GridData gdData = null;
        GridLayout gdLayout = null;
        this.m_guiElements = new GUIDisplayElements();
        this.m_parentComp = new Composite(scrolledComposite, 0);
        gdLayout = new GridLayout(2, false);
        gdLayout.marginBottom = 10;
        gdLayout.marginRight = 10;
        gdLayout.marginLeft = 10;
        this.m_parentComp.setLayout((Layout)gdLayout);
        this.m_parentComp.setBackground(BMUI.color_grey);
        this.m_leftComp = new Composite(this.m_parentComp, 0);
        this.m_leftComp.setLayout((Layout)new GridLayout(1, false));
        this.m_leftComp.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.m_leftComp.setBackground(BMUI.color_grey);
        this.m_rightComp = new Composite(this.m_parentComp, 0);
        gdLayout = new GridLayout(1, false);
        gdLayout.marginRight = 10;
        gdLayout.marginLeft = 10;
        gdLayout.marginHeight = 15;
        this.m_rightComp.setLayout((Layout)gdLayout);
        this.m_rightComp.setLayoutData((Object)new GridData(1, 128, false, false));
        this.m_rightComp.setBackground(BMUI.color_grey);
        this.createPatternInputSection(this.m_leftComp);
        this.createTableSection(this.m_leftComp);
        this.createPatternTypeSection(this.m_rightComp);
        this.createResultsArea(this.m_parentComp);
        this.m_close_Button = this.m_guiElements.addButton(this.m_parentComp, BUTTON_CLOSE, " Close ", true, 90, 20, 20, this);
        gdData = (GridData)this.m_close_Button.getLayoutData();
        gdData.horizontalSpan = 2;
        gdData.horizontalAlignment = 131072;
        gdData.grabExcessHorizontalSpace = true;
        if (this.m_patternType.equalsIgnoreCase(OVO)) {
            this.validatePattern(this.m_patternOVO, OVO);
        } else {
            this.validatePattern(this.m_patternJAVA, JAVA);
        }
        this.refreshPatternList();
        this.refreshDescriptionField();
        this.checkButtonStatus();
        if (this.m_patternType.equals(OVO)) {
            this.m_pattern_inputField_OVO.setFocus();
        } else if (this.m_patternType.equals(JAVA)) {
            this.m_pattern_inputField_JAVA.setFocus();
        }
        return this.m_parentComp;
    }

    public void createPatternInputSection(Composite parent) {
        GridData gdData = null;
        this.patternInputComp = new Composite(parent, 0);
        GridLayout gl = new GridLayout(4, false);
        gl.marginWidth = 0;
        this.patternInputComp.setLayout((Layout)gl);
        this.patternInputComp.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.patternInputComp.setBackground(BMUI.color_grey);
        this.m_guiElements.addTextField(this.patternInputComp, null, "Simplified Pattern:", 1, 1, 5, 0, BMUI.font_arial8_bold);
        this.m_validateIcon_OVO = new Label(this.patternInputComp, 1);
        this.m_validateIcon_OVO.setImage(BMUI.IMAGE_ICON_GREY);
        this.m_pattern_inputField_OVO = this.m_guiElements.addInputFieldSingle(this.patternInputComp, PATTERN_INPUT_FIELD_OVO, null, this.m_patternOVO, 1, 1, 0, 5, 100, this);
        ((GridData)this.m_pattern_inputField_OVO.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.m_pattern_inputField_OVO.getLayoutData()).grabExcessHorizontalSpace = true;
        this.m_save_OVOPattern_Button = this.m_guiElements.addButton(this.patternInputComp, BUTTON_SAVE_OVO_PATTERN, " Save Simplified Pattern ", true, 100, 20, 5, this);
        if (this.m_filterCondDetails == null) {
            this.m_save_OVOPattern_Button.setVisible(false);
        }
        this.m_convert_Button = this.m_guiElements.addButton(this.patternInputComp, BUTTON_CONVERT, " Convert Simplified -> JAVA ", true, 160, 20, 1, this);
        gdData = (GridData)this.m_convert_Button.getLayoutData();
        gdData.horizontalSpan = 4;
        gdData.horizontalAlignment = 0x1000000;
        this.m_guiElements.addTextField(this.patternInputComp, null, "JAVA Pattern:    ", 1, 1, 5, 0, BMUI.font_arial8_bold);
        this.m_validateIcon_JAVA = new Label(this.patternInputComp, 1);
        this.m_validateIcon_JAVA.setImage(BMUI.IMAGE_ICON_GREY);
        this.m_pattern_inputField_JAVA = this.m_guiElements.addInputFieldSingle(this.patternInputComp, PATTERN_INPUT_FIELD_JAVA, null, this.m_patternJAVA, 1, 1, 0, 5, 100, this);
        ((GridData)this.m_pattern_inputField_JAVA.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.m_pattern_inputField_JAVA.getLayoutData()).grabExcessHorizontalSpace = true;
        this.m_save_JAVAPattern_Button = this.m_guiElements.addButton(this.patternInputComp, BUTTON_SAVE_JAVA_PATTERN, " Save JAVA Pattern ", true, 100, 20, 5, this);
        ((GridData)this.m_save_JAVAPattern_Button.getLayoutData()).horizontalAlignment = 4;
        if (this.m_filterCondDetails == null) {
            this.m_save_JAVAPattern_Button.setVisible(false);
        }
        if (this.m_patternType.equals(OVO)) {
            this.m_pattern_inputField_OVO.setFocus();
        } else {
            this.m_pattern_inputField_JAVA.setFocus();
        }
    }

    public Table createTableSection(Composite parent) {
        this.m_compBtn1 = new Composite(parent, 0);
        GridLayout gl = new GridLayout(7, false);
        gl.marginWidth = 0;
        gl.marginTop = 10;
        gl.horizontalSpacing = 3;
        this.m_compBtn1.setLayout((Layout)gl);
        this.m_compBtn1.setLayoutData((Object)new GridData(1, 128, false, false, 1, 1));
        this.m_edit_Button = this.m_guiElements.addButton(this.m_compBtn1, BUTTON_EDIT, " Edit Line ", false, 90, 20, 20, this);
        this.m_edit_Button.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.m_add_Button = this.m_guiElements.addButton(this.m_compBtn1, BUTTON_ADD, " Append Line ", true, 90, 20, 20, this);
        this.m_add_Button.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.m_paste_Button = this.m_guiElements.addButton(this.m_compBtn1, BUTTON_PASTE, " Paste ", true, 90, 20, 20, this);
        this.m_paste_Button.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.m_load_Button = this.m_guiElements.addButton(this.m_compBtn1, BUTTON_LOAD, " Load From File ", true, 90, 20, 20, this);
        this.m_load_Button.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.m_append_Button = this.m_guiElements.addButton(this.m_compBtn1, BUTTON_APPEND, " Append From File ", true, 90, 20, 20, this);
        this.m_append_Button.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.m_saveToFile_Button = this.m_guiElements.addButton(this.m_compBtn1, BUTTON_SAVE_TO_FILE, " Save To File ", false, 90, 20, 20, this);
        this.m_saveToFile_Button.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.m_resplit_Button = this.m_guiElements.addButton(this.m_compBtn1, BUTTON_RESPLIT, " Re-split ", false, 90, 20, 20, this);
        this.m_resplit_Button.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        GridData gdList = new GridData(4, 4, true, true, 1, 1);
        gdList.heightHint = 250;
        Table table = new Table(parent, 268503810);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)gdList);
        table.addSelectionListener((SelectionListener)this);
        table.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127 && (e.stateMask & 0x40000) == 0) {
                    PatternValidationDialog.this.removeLines();
                }
            }
        });
        this.m_tableViewer = new TableViewer(table);
        this.m_patternMatching = new PatternMatching(this.m_tableViewer, this);
        TableColumn col1 = new TableColumn(table, 0);
        col1.setWidth(25);
        col1.setText("Status");
        col1.setToolTipText("Validation Status (true|false)");
        TableColumn col2 = new TableColumn(table, 131072);
        col2.setWidth(30);
        col2.setText("Time(nanoSec)");
        col2.setToolTipText("Processing Time in nano seconds");
        TableColumn col3 = new TableColumn(table, 0);
        col3.setWidth(550);
        col3.setText("Text");
        col3.setToolTipText("Text to validate");
        this.m_bottomComp = new Composite(parent, 0);
        gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        this.m_bottomComp.setLayout((Layout)gl);
        this.m_bottomComp.setLayoutData((Object)new GridData(4, 128, true, false));
        this.m_progressBar = new ProgressBar(this.m_bottomComp, 256);
        this.m_progressBar.setEnabled(false);
        GridData ldp = new GridData(4, 128, true, false);
        ldp.heightHint = 10;
        this.m_progressBar.setLayoutData((Object)ldp);
        this.m_lineCountComp = new Composite(this.m_bottomComp, 0);
        gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.marginLeft = 10;
        gl.horizontalSpacing = 0;
        this.m_lineCountComp.setLayout((Layout)gl);
        this.m_lineCountComp.setLayoutData((Object)new GridData(1, 128, false, false, 1, 2));
        this.m_guiElements.addTextReadOnlyNoBorder(this.m_lineCountComp, null, "Current Lines:", 1, 1, 0, 0, null);
        this.m_lineCount_field = this.m_guiElements.addTextReadOnlyNoBorder(this.m_lineCountComp, null, "0", 1, 1, 0, 0, null);
        ((GridData)this.m_lineCount_field.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.m_lineCount_field.getLayoutData()).grabExcessHorizontalSpace = true;
        ((GridData)this.m_lineCount_field.getLayoutData()).widthHint = 42;
        this.m_lineLimit_check = this.m_guiElements.addCheckbox(this.m_lineCountComp, BUTTON_LIMIT, "Set Limit to " + LINE_LIMIT, this.m_hasLineLimitActive, 2, 1, 0, this);
        this.m_compBtn2 = new Composite(this.m_bottomComp, 0);
        gl = new GridLayout(4, true);
        gl.marginWidth = 0;
        gl.horizontalSpacing = 3;
        gl.marginTop = 10;
        this.m_compBtn2.setLayout((Layout)gl);
        this.m_compBtn2.setLayoutData((Object)new GridData(1, 128, false, false, 1, 1));
        this.m_testLines_Button = this.m_guiElements.addButton(this.m_compBtn2, BUTTON_VALIDATE, " Validate All Lines ", false, 90, 20, 0, this);
        this.m_testLines_Button.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.m_stoptestLines_Button = this.m_guiElements.addButton(this.m_compBtn2, BUTTON_STOPTEST, " Stop Validation ", false, 90, 20, 0, this);
        this.m_stoptestLines_Button.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.m_remove_Button = this.m_guiElements.addButton(this.m_compBtn2, BUTTON_REMOVE, " Remove Line ", false, 90, 20, 0, this);
        this.m_remove_Button.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.m_clearLines_Button = this.m_guiElements.addButton(this.m_compBtn2, BUTTON_CLEAR, " Clear All Lines ", false, 90, 20, 0, this);
        this.m_clearLines_Button.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        return table;
    }

    public void createPatternTypeSection(Composite parent) {
        this.m_guiElements.addTextField(parent, null, "Select Pattern Type:", 1, 1, 0, 0, BMUI.font_arial8_bold);
        this.m_patternTypes_Combo = this.m_guiElements.addDropDown(parent, PATTERN_TYPE, null, m_pList, this.m_patternType, null, 1, 1, 0, 5, this);
        this.m_patternTypes_Combo.setBackground(BMUI.color_normal);
        this.m_patternTypes_Combo.setFont(BMUI.font_arial8_bold);
        GridData gdData = (GridData)this.m_patternTypes_Combo.getLayoutData();
        gdData.verticalAlignment = 128;
        gdData.widthHint = 130;
        this.m_guiElements.addTextField(parent, null, "Pattern Elements:", 7, 1, 10, 0, BMUI.font_arial8_bold);
        this.m_patternList_List = this.m_guiElements.addList(parent, PATTERN_ELEMENTS, null, null, 1, 1, 215, 135, 1, this);
        this.m_guiElements.addTextField(parent, null, "Description:", 7, 1, 10, 0, BMUI.font_arial8_bold);
        this.m_description_Field = this.m_guiElements.addMultiLineFieldReadOnlyWrap(parent, DESCRIPTION_FIELD, null, null, 1, 1, 100, 127, 0, 1);
    }

    public void createResultsArea(Composite comp) {
        this.m_guiElements.addTextField(comp, null, "Results", 7, 1, 3, 0, BMUI.font_arial8_bold);
        this.m_result_field = this.m_guiElements.addInputFieldMultiLine(comp, "RESULTSAREA", null, "", 7, 2, 80, 100, 0, 3, this);
        ((GridData)this.m_result_field.getLayoutData()).verticalAlignment = 4;
        ((GridData)this.m_result_field.getLayoutData()).grabExcessVerticalSpace = true;
    }

    public void initPatternLists() {
        Set<Map.Entry<String, String>> set;
        int index = 0;
        int size = 0;
        size = m_javaPattern.size();
        if (size > 0) {
            this.m_javaList = new String[size];
            this.m_javaDesc = new String[size];
            set = m_javaPattern.entrySet();
            for (Map.Entry<String, String> me : set) {
                this.m_javaList[index] = me.getKey();
                this.m_javaDesc[index] = me.getValue();
                ++index;
            }
        }
        if ((size = m_ovoPattern.size()) > 0) {
            this.m_ovoList = new String[size];
            this.m_ovoDesc = new String[size];
            index = 0;
            set = m_ovoPattern.entrySet();
            for (Map.Entry<String, String> me : set) {
                this.m_ovoList[index] = me.getKey();
                this.m_ovoDesc[index] = me.getValue();
                ++index;
            }
        }
    }

    public void setPattern(String pattern) {
        if (this.m_patternType == null) {
            if (pattern.toLowerCase().startsWith("java=")) {
                this.m_patternType = JAVA;
                pattern = pattern.substring("java=".length());
            } else {
                this.m_patternType = OVO;
            }
        }
        if (this.m_patternType.equals(JAVA)) {
            this.m_patternJAVA = pattern;
        } else if (this.m_patternType.equals(OVO)) {
            this.m_patternOVO = pattern;
        }
    }

    public void validatePattern(String patternNew, String patternType) {
        if (patternNew == null) {
            patternNew = "";
        }
        int length = patternNew.length();
        boolean isValidated = false;
        isValidated = this.m_patternMatching.validatePattern(patternNew, patternType);
        this.m_patternType = patternType;
        if (patternType.equals(OVO)) {
            this.m_guiElements.enableField(this.m_save_OVOPattern_Button, true);
            if (length > 0 && isValidated) {
                this.m_patternOVO = patternNew;
                this.m_isValidated_OVO = true;
                this.m_validateIcon_OVO.setImage(BMUI.IMAGE_ACCEPT_GREEN);
                this.m_pattern_inputField_OVO.setBackground(BMUI.defaultBackground);
            } else {
                this.m_patternOVO = "";
                this.m_isValidated_OVO = false;
                this.m_validateIcon_OVO.setImage(BMUI.IMAGE_CANCEL_ROUND);
                this.m_pattern_inputField_OVO.setBackground(BMUI.color_critical);
                this.m_guiElements.enableField(this.m_save_OVOPattern_Button, false);
            }
        } else if (patternType.equals(JAVA)) {
            this.m_guiElements.enableField(this.m_save_JAVAPattern_Button, true);
            if (length > 0 && isValidated) {
                this.m_patternJAVA = patternNew.toLowerCase().startsWith("java=") ? patternNew.substring("java=".length()) : patternNew;
                this.m_isValidated_JAVA = true;
                this.m_validateIcon_JAVA.setImage(BMUI.IMAGE_ACCEPT_GREEN);
                this.m_pattern_inputField_JAVA.setBackground(BMUI.defaultBackground);
            } else {
                this.m_patternJAVA = "";
                this.m_isValidated_JAVA = false;
                this.m_validateIcon_JAVA.setImage(BMUI.IMAGE_CANCEL_ROUND);
                this.m_pattern_inputField_JAVA.setBackground(BMUI.color_critical);
                this.m_guiElements.enableField(this.m_save_JAVAPattern_Button, false);
            }
        }
    }

    public void validateLines(String type) {
        PatternB pattern = null;
        try {
            if (this.m_patternType.equals(JAVA)) {
                pattern = new PatternB("java=" + this.m_patternJAVA);
            } else if (this.m_patternType.equals(OVO)) {
                pattern = new PatternB(this.m_patternOVO);
            }
            if (type.equals(PatternMatching.ALL_LINES)) {
                Table table = this.m_tableViewer.getTable();
                if (table != null && table.getItemCount() > 0) {
                    this.m_isRunning = true;
                    this.cleanImages();
                    this.m_progressBar.setEnabled(true);
                    this.m_progressBar.setMaximum(table.getItemCount());
                    HelperJob hj = new HelperJob("PatternValidation", 0, table, pattern, this, PATTERNVDIALOG);
                    Repository.getUIJobManager().schedule(hj);
                }
            } else if (type.equals(PatternMatching.SINGLE_LINE)) {
                TableItem[] tableItems = this.m_tableViewer.getTable().getSelection();
                String line = tableItems[0].getText(PatternMatching.COLUMN_TEXT);
                this.checkTableItem(tableItems[0], pattern);
                if (this.m_patternType.equals(OVO)) {
                    boolean match = true;
                    StringBuffer result = new StringBuffer();
                    PatternMatchResult matchesR = pattern.matchesR(line);
                    match = matchesR.isMatch();
                    if (match) {
                        Map<String, String> m = matchesR.getVariableMap();
                        if (m.size() > 0) {
                            for (Map.Entry<String, String> entry : m.entrySet()) {
                                String key = entry.getKey();
                                if (key.indexOf("$$") != -1) continue;
                                String value = entry.getValue();
                                result.append("<$").append(key).append(">=").append(value).append("\n");
                            }
                        } else {
                            result.append("No variables defined!");
                        }
                        this.m_result_field.setText(result.toString());
                    } else {
                        this.m_result_field.setText("");
                    }
                } else if (this.m_patternType.equals(JAVA)) {
                    String result = "";
                    PatternMatchResult matchesR = pattern.matchesR(line);
                    if (matchesR.isMatch()) {
                        if (matchesR.getVariableMap().size() == 0) {
                            result = "No capturing group(s) defined";
                        } else {
                            ArrayList<String> varNames = new ArrayList<String>(matchesR.getVariableMap().keySet());
                            Collections.sort(varNames);
                            StringBuffer sb = new StringBuffer();
                            for (String var : varNames) {
                                String value = matchesR.getVariableMap().get(var);
                                if (var == null) {
                                    var = "";
                                }
                                sb.append(var).append(" = ").append((Object)value).append('\n');
                            }
                            result = sb.toString();
                        }
                    }
                    this.m_result_field.setText(result.replace("\r", ""));
                }
            }
            this.m_patternMatching.setStatus(false);
        }
        catch (RuntimeException e) {
            new ShowMessageBox("Warning", e.getMessage(), 8);
        }
        catch (Throwable throwable) {
            RTLogger.print(5, "PatternValidationDialog: validation error");
        }
    }

    private void checkTableItem(TableItem item, PatternB patternObj) {
        HelperJob hj = new HelperJob("PatternValidation", item, patternObj);
        Repository.getUIJobManager().schedule(hj);
    }

    protected void convertToJava() {
        this.m_patternType = JAVA;
        PatternB pt = new PatternB(this.m_patternOVO);
        this.m_patternJAVA = pt.getJavaPattern();
        this.m_pattern_inputField_JAVA.setText(this.m_patternJAVA);
        this.refreshPatternCombo();
        this.refreshPatternList();
        this.refreshDescriptionField();
    }

    private void removeLines() {
        this.m_patternMatching.removeLines();
        this.updateLineCount();
        this.checkButtonStatus();
    }

    protected void savePattern(String patternType) {
        String patternStr = "";
        if (patternType.equals(JAVA)) {
            patternStr = "java=" + this.m_pattern_inputField_JAVA.getText().trim();
        } else if (patternType.equals(OVO)) {
            patternStr = this.m_pattern_inputField_OVO.getText().trim();
        }
        if (this.m_filterCondDetails != null) {
            this.m_filterCondDetails.setPattern(patternStr);
        }
        super.okPressed();
    }

    public void refreshPatternCombo() {
        if (this.m_patternType.equals(JAVA)) {
            this.m_patternTypes_Combo.select(0);
        } else if (this.m_patternType.equals(OVO)) {
            this.m_patternTypes_Combo.select(1);
        }
    }

    public void refreshPatternList() {
        if (this.m_patternType.equals(JAVA)) {
            this.m_patternList_List.removeAll();
            this.m_patternList_List.setItems(this.m_javaList);
            this.m_patternList_List.select(0);
        } else if (this.m_patternType.equals(OVO)) {
            this.m_patternList_List.removeAll();
            this.m_patternList_List.setItems(this.m_ovoList);
            this.m_patternList_List.select(0);
        }
    }

    public void refreshDescriptionField() {
        this.m_description_Field.setText("");
        int index = this.m_patternList_List.getSelectionIndex();
        if (index > -1 && this.m_patternTypes_Combo.getText().equals(JAVA)) {
            this.m_description_Field.setText(this.m_javaDesc[index]);
        } else if (index > -1 && this.m_patternTypes_Combo.getText().equals(OVO)) {
            this.m_description_Field.setText(this.m_ovoDesc[index]);
        }
    }

    public boolean hasLineLimitActive() {
        return this.m_hasLineLimitActive;
    }

    public int getLineLimit() {
        return LINE_LIMIT;
    }

    public void updateLineCount() {
        try {
            this.m_lineCount_field.setText("" + this.m_tableViewer.getTable().getItemCount());
        }
        catch (Exception e) {
            RTLogger.print(1, "", e);
        }
    }

    public void disableAllButtons() {
        this.m_guiElements.enableField(this.m_save_OVOPattern_Button, false);
        this.m_guiElements.enableField(this.m_save_JAVAPattern_Button, false);
        this.m_guiElements.enableField(this.m_convert_Button, false);
        this.m_guiElements.enableField(this.m_edit_Button, false);
        this.m_guiElements.enableField(this.m_add_Button, false);
        this.m_guiElements.enableField(this.m_remove_Button, false);
        this.m_guiElements.enableField(this.m_load_Button, false);
        this.m_guiElements.enableField(this.m_append_Button, false);
        this.m_guiElements.enableField(this.m_saveToFile_Button, false);
        this.m_guiElements.enableField(this.m_testLines_Button, false);
        this.m_guiElements.enableField(this.m_clearLines_Button, false);
        this.m_guiElements.enableField(this.m_paste_Button, false);
        this.m_guiElements.enableField(this.m_stoptestLines_Button, false);
        this.m_guiElements.enableField(this.m_resplit_Button, false);
    }

    public void checkButtonStatus() {
        try {
            Table table;
            this.m_guiElements.enableField(this.m_stoptestLines_Button, this.m_isRunning);
            this.m_guiElements.enableField(this.m_paste_Button, !this.m_isRunning);
            if (this.m_patternType.equals(OVO)) {
                int ovoPatternLength = this.m_pattern_inputField_OVO.getText().trim().length();
                this.m_guiElements.enableField(this.m_pattern_inputField_OVO, true);
                if (this.m_isValidated_OVO && ovoPatternLength > 0) {
                    this.m_guiElements.enableField(this.m_save_OVOPattern_Button, true);
                    this.m_guiElements.enableField(this.m_convert_Button, true);
                } else {
                    this.m_guiElements.enableField(this.m_save_OVOPattern_Button, false);
                    this.m_guiElements.enableField(this.m_convert_Button, false);
                }
                this.m_guiElements.enableField(this.m_pattern_inputField_JAVA, false);
                this.m_guiElements.enableField(this.m_save_JAVAPattern_Button, false);
            } else if (this.m_patternType.equals(JAVA)) {
                int javaPatternLength = this.m_pattern_inputField_JAVA.getText().trim().length();
                this.m_guiElements.enableField(this.m_pattern_inputField_JAVA, true);
                if (this.m_isValidated_JAVA && javaPatternLength > 0) {
                    this.m_guiElements.enableField(this.m_save_JAVAPattern_Button, true);
                } else {
                    this.m_guiElements.enableField(this.m_save_JAVAPattern_Button, false);
                }
                this.m_guiElements.enableField(this.m_pattern_inputField_OVO, false);
                this.m_guiElements.enableField(this.m_save_OVOPattern_Button, false);
                this.m_guiElements.enableField(this.m_convert_Button, false);
            }
            if (this.m_tableViewer != null && (table = this.m_tableViewer.getTable()) != null && !table.isDisposed()) {
                int numOfItems = table.getItemCount();
                int selIndex = table.getSelectionIndex();
                if (numOfItems == 0) {
                    this.m_guiElements.enableField(this.m_edit_Button, false);
                    this.m_guiElements.enableField(this.m_add_Button, true);
                    this.m_guiElements.enableField(this.m_remove_Button, false);
                    this.m_guiElements.enableField(this.m_load_Button, true);
                    this.m_guiElements.enableField(this.m_append_Button, true);
                    this.m_guiElements.enableField(this.m_saveToFile_Button, false);
                    this.m_guiElements.enableField(this.m_testLines_Button, false);
                    this.m_guiElements.enableField(this.m_clearLines_Button, false);
                    this.m_guiElements.enableField(this.m_resplit_Button, false);
                } else if (numOfItems == 1) {
                    this.m_guiElements.enableField(this.m_add_Button, true);
                    this.m_guiElements.enableField(this.m_load_Button, true);
                    this.m_guiElements.enableField(this.m_append_Button, true);
                    this.m_guiElements.enableField(this.m_saveToFile_Button, true);
                    this.m_guiElements.enableField(this.m_testLines_Button, true);
                    this.m_guiElements.enableField(this.m_clearLines_Button, true);
                    this.m_guiElements.enableField(this.m_resplit_Button, false);
                    if (selIndex != -1) {
                        this.m_guiElements.enableField(this.m_edit_Button, true);
                        this.m_guiElements.enableField(this.m_remove_Button, true);
                    } else {
                        this.m_guiElements.enableField(this.m_edit_Button, false);
                        this.m_guiElements.enableField(this.m_remove_Button, false);
                    }
                } else if (numOfItems > 1) {
                    this.m_guiElements.enableField(this.m_add_Button, true);
                    this.m_guiElements.enableField(this.m_load_Button, true);
                    this.m_guiElements.enableField(this.m_append_Button, true);
                    this.m_guiElements.enableField(this.m_saveToFile_Button, true);
                    this.m_guiElements.enableField(this.m_testLines_Button, true);
                    this.m_guiElements.enableField(this.m_clearLines_Button, true);
                    this.m_guiElements.enableField(this.m_resplit_Button, true);
                    if (selIndex != -1) {
                        this.m_guiElements.enableField(this.m_edit_Button, true);
                        this.m_guiElements.enableField(this.m_remove_Button, true);
                    } else {
                        this.m_guiElements.enableField(this.m_edit_Button, false);
                        this.m_guiElements.enableField(this.m_remove_Button, false);
                    }
                }
                if (this.m_remove_Button != null) {
                    int selCount = table.getSelectionCount();
                    if (selCount > 1) {
                        this.m_remove_Button.setText(" Remove Lines ");
                    } else {
                        this.m_remove_Button.setText(" Remove Line ");
                    }
                }
            }
        }
        catch (Exception exception) {}
    }

    private void cleanImages() {
        this.m_patternMatching.clearStatus();
        if (this.m_progressBar.getSelection() != 0) {
            this.m_progressBar.setSelection(0);
        }
    }

    public void modifyText(ModifyEvent e) {
        Object obj = e.getSource();
        if (obj instanceof Text) {
            Text field = (Text)obj;
            String fieldName = (String)field.getData();
            if (PATTERN_INPUT_FIELD_OVO.equals(fieldName)) {
                try {
                    if (this.m_isRunning) {
                        this.m_isCanceled = true;
                    }
                    this.m_patternType = OVO;
                    this.m_pattern_inputField_JAVA.setBackground(BMUI.defaultBackground);
                    this.m_tableViewer.getTable().deselectAll();
                    this.m_result_field.setText("");
                    this.validatePattern(this.m_pattern_inputField_OVO.getText().trim(), this.m_patternType);
                    this.checkButtonStatus();
                }
                catch (Throwable throwable) {}
            } else if (PATTERN_INPUT_FIELD_JAVA.equals(fieldName)) {
                if (this.m_isRunning) {
                    this.m_isCanceled = true;
                }
                this.m_patternType = JAVA;
                this.m_pattern_inputField_JAVA.setBackground(BMUI.defaultBackground);
                this.m_tableViewer.getTable().deselectAll();
                this.m_result_field.setText("");
                this.validatePattern(this.m_pattern_inputField_JAVA.getText().trim(), this.m_patternType);
                this.checkButtonStatus();
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        String[] selection;
        List list;
        String name;
        Object obj = e.getSource();
        if (obj instanceof Table) {
            TableItem tableItem = this.m_patternMatching.editLine();
            if (tableItem != null) {
                this.validateLines(PatternMatching.SINGLE_LINE);
            }
        } else if (obj instanceof List && PATTERN_ELEMENTS.equals(name = (String)(list = (List)obj).getData()) && (selection = list.getSelection())[0] != null && selection[0] != "") {
            if (this.m_patternType.equals(JAVA)) {
                if (this.m_pattern_inputField_JAVA.getText().toLowerCase().startsWith("java=")) {
                    this.m_pattern_inputField_JAVA.setText(this.m_pattern_inputField_JAVA.getText().substring("java=".length()));
                }
                this.m_pattern_inputField_JAVA.append(selection[0]);
            } else if (this.m_patternType.equals(OVO)) {
                this.m_pattern_inputField_OVO.append(selection[0]);
            }
            this.refreshDescriptionField();
        }
    }

    public void widgetSelected(SelectionEvent e) {
        CCombo combo;
        String fieldName;
        Object obj = e.getSource();
        if (obj instanceof Button) {
            Button b = (Button)obj;
            String buttonName = (String)b.getData();
            if (buttonName.equals(BUTTON_SAVE_OVO_PATTERN)) {
                this.savePattern(OVO);
            } else if (buttonName.equals(BUTTON_SAVE_JAVA_PATTERN)) {
                this.savePattern(JAVA);
            } else if (buttonName.equals(BUTTON_CONVERT)) {
                this.convertToJava();
                this.checkButtonStatus();
            } else if (buttonName.equals(BUTTON_ADD)) {
                TableItem tableItem = this.m_patternMatching.addNewLine();
                if (tableItem != null) {
                    this.validateLines(PatternMatching.SINGLE_LINE);
                    this.updateLineCount();
                    this.checkButtonStatus();
                }
            } else if (buttonName.equals(BUTTON_PASTE)) {
                this.m_patternMatching.paste();
            } else if (buttonName.equals(BUTTON_LOAD)) {
                this.disableAllButtons();
                this.m_patternMatching.loadFromFile(false);
            } else if (buttonName.equals(BUTTON_SAVE_TO_FILE)) {
                this.m_patternMatching.saveToFile();
                this.checkButtonStatus();
            } else if (buttonName.equals(BUTTON_VALIDATE)) {
                this.disableAllButtons();
                this.m_guiElements.enableField(this.m_stoptestLines_Button, true);
                this.validateLines(PatternMatching.ALL_LINES);
            } else if (buttonName.equals(BUTTON_REMOVE)) {
                this.removeLines();
            } else if (buttonName.equals(BUTTON_EDIT)) {
                TableItem tableItem = this.m_patternMatching.editLine();
                if (tableItem != null) {
                    this.validateLines(PatternMatching.SINGLE_LINE);
                    this.checkButtonStatus();
                }
            } else if (buttonName.equals(BUTTON_APPEND)) {
                this.disableAllButtons();
                this.m_patternMatching.loadFromFile(true);
            } else {
                if (buttonName.equals(BUTTON_CLOSE)) {
                    super.cancelPressed();
                    return;
                }
                if (buttonName.equals(BUTTON_STOPTEST)) {
                    this.m_isCanceled = true;
                    this.checkButtonStatus();
                } else if (buttonName.equals(BUTTON_CLEAR)) {
                    this.m_tableViewer.getTable().removeAll();
                    this.updateLineCount();
                    this.checkButtonStatus();
                } else if (buttonName.equals(BUTTON_LIMIT)) {
                    this.m_hasLineLimitActive = this.m_lineLimit_check.getSelection();
                } else if (buttonName.equals(BUTTON_RESPLIT)) {
                    try {
                        this.resplitRecords();
                    }
                    catch (Throwable throwable) {
                        new ShowMessageBox("Error", "Unexpected error occured", 8);
                    }
                    this.updateLineCount();
                    this.checkButtonStatus();
                }
            }
        } else if (obj instanceof Table) {
            if (this.m_isRunning) {
                return;
            }
            this.validateLines(PatternMatching.SINGLE_LINE);
            this.checkButtonStatus();
        } else if (obj instanceof List) {
            List list = (List)obj;
            String name = (String)list.getData();
            if (name.equals(PATTERN_ELEMENTS)) {
                this.refreshDescriptionField();
                this.checkButtonStatus();
            }
        } else if (obj instanceof CCombo && (fieldName = (String)(combo = (CCombo)obj).getData()).equals(PATTERN_TYPE)) {
            if (this.m_isRunning) {
                this.m_isCanceled = true;
            }
            this.m_patternType = combo.getText();
            this.m_patternMatching.clearStatus();
            this.m_result_field.setText("");
            this.refreshPatternList();
            this.refreshDescriptionField();
            this.checkButtonStatus();
        }
        Display.getCurrent().readAndDispatch();
    }

    protected void resplitRecords() {
        IInputValidator iid = new IInputValidator(){

            public String isValid(String newText) {
                if (PatternValidationDialog.this.m_patternMatching.validatePattern(newText, JAVA)) {
                    return null;
                }
                return "invalid java pattern";
            }
        };
        SinglelineInputDialog sld = new SinglelineInputDialog(this.getShell(), "Split records java pattern", "Pattern matching the start line of a multiline record:", ".*", iid);
        sld.setBlockOnOpen(true);
        int res = sld.open();
        if (res == 0) {
            String pattern = sld.getValue();
            Pattern p = Pattern.compile(pattern);
            if (!".*".equals(pattern)) {
                TableItem[] ti = this.m_tableViewer.getTable().getItems();
                String[] arr = new String[ti.length];
                boolean matchedOne = false;
                int i = 0;
                while (i < ti.length) {
                    arr[i] = ti[i].getText(PatternMatching.COLUMN_TEXT);
                    if (matchedOne || p.matcher(arr[i]).matches()) {
                        matchedOne = true;
                    }
                    ++i;
                }
                if (!matchedOne) {
                    MessageBox mb = new MessageBox(this.getShell(), 8);
                    mb.setMessage("Pattern does not match with any String\nSplit operation discarded");
                    mb.setText("Warning");
                    mb.open();
                    return;
                }
                this.m_tableViewer.getTable().removeAll();
                this.updateLineCount();
                StringBuffer sb = null;
                int i2 = 0;
                while (i2 < arr.length) {
                    String text = arr[i2];
                    Matcher m = p.matcher(text);
                    if (m.matches()) {
                        if (sb != null && sb.length() > 0) {
                            this.m_patternMatching.addNewLine(sb.toString());
                            sb = new StringBuffer();
                        }
                        if (sb == null) {
                            sb = new StringBuffer();
                        }
                        sb.append(text);
                    } else if (sb != null) {
                        sb.append("\n").append(text);
                    }
                    ++i2;
                }
                if (sb != null && sb.length() > 0) {
                    this.m_patternMatching.addNewLine(sb.toString());
                }
            }
        }
    }

    @Override
    public ProgressBar getProgressBar() {
        return this.m_progressBar;
    }

    @Override
    public boolean isCanceled() {
        return this.m_isCanceled;
    }

    @Override
    public void setStopped() {
        this.m_isCanceled = false;
        this.m_isRunning = false;
        this.checkButtonStatus();
    }

    @Override
    public String getPattern() {
        String pattern = null;
        if (this.m_patternType.equals(JAVA)) {
            pattern = this.m_patternJAVA;
            if (this.m_patternJAVA.toLowerCase().startsWith("java=")) {
                pattern = this.m_patternJAVA.substring("java=".length());
            }
        } else if (this.m_patternType.equals(OVO)) {
            pattern = this.m_patternOVO;
        }
        return pattern;
    }

    public void widgetDisposed(DisposeEvent e) {
        try {
            this.m_validateIcon_OVO.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_validateIcon_JAVA.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_pattern_inputField_OVO.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_pattern_inputField_JAVA.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_result_field.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_description_Field.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_lineCount_field.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_save_OVOPattern_Button.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_save_JAVAPattern_Button.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_convert_Button.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_add_Button.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_paste_Button.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_edit_Button.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_remove_Button.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_load_Button.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_append_Button.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_saveToFile_Button.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_testLines_Button.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_close_Button.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_stoptestLines_Button.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_clearLines_Button.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_patternTypes_Combo.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_patternList_List.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_lineLimit_check.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_progressBar.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.patternInputComp.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_compBtn1.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_compBtn2.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_lineCountComp.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_leftComp.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_rightComp.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_bottomComp.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_scrolledComp.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_parentComp.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_parent.dispose();
        }
        catch (Throwable throwable) {}
    }
}

