/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.dialogs;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.utils.IntervalHelpListener;
import com.blixx.boom.gui.views.MonPerfSubmitProvider;
import com.blixx.shared.CFI;
import com.blixx.shared.PatternB;
import com.blixx.shared.exceptions.PolicyException;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class PerfMappingRowDialog
extends StatusDialog
implements ModifyListener,
SelectionListener {
    public static final String PATTERN = "PATTERN";
    public static final String PERFCLASS = "PERFCLASS";
    public static final String PERFCOLUMN = "PERFCOLUMN";
    public static final String PERFINTERVAL = "PERFINTERVAL";
    private Composite parent;
    private Composite m_dialogArea;
    private MonPerfSubmitProvider.PerfMappingRow row;
    private StyledText patternText;
    private StyledText perfClass;
    private StyledText perfColumn;
    private StyledText perfInterval;

    public PerfMappingRowDialog(Shell parentShell, MonPerfSubmitProvider.PerfMappingRow row) {
        super(parentShell);
        this.row = row;
        if (this.row == null) {
            try {
                this.row = new MonPerfSubmitProvider.PerfMappingRow(PatternB.getPattern("<*>"), new CFI("PerfClassName.ColumnName.5m"));
            }
            catch (PolicyException policyException) {}
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.parent = parent;
        GUIDisplayElements m_gui = new GUIDisplayElements();
        m_gui.centerShell(parent.getShell(), Display.getCurrent());
        this.m_dialogArea = new Composite(parent, 0);
        GridLayout gdLayout = new GridLayout(4, false);
        gdLayout.marginTop = 5;
        gdLayout.marginRight = 10;
        gdLayout.marginLeft = 10;
        gdLayout.verticalSpacing = 1;
        this.m_dialogArea.setLayout((Layout)gdLayout);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 600;
        this.m_dialogArea.setLayoutData((Object)gd);
        m_gui.addTextField(this.m_dialogArea, null, "Object pattern ", 1, 1, 0, 0, null);
        this.patternText = m_gui.addStyledText(this.m_dialogArea, null, PATTERN, this.row.pattern.getOvPattern(), 3, 1, 0, 3, this);
        m_gui.addTextField(this.m_dialogArea, null, "Perf Class ", 1, 1, 0, 0, null);
        this.perfClass = m_gui.addStyledText(this.m_dialogArea, null, PERFCLASS, this.row.cfi.m_class, 1, 1, 0, 3, this);
        this.validateClassName(this.perfClass);
        m_gui.addTextField(this.m_dialogArea, null, "Perf Column ", 1, 1, 0, 0, null);
        this.perfColumn = m_gui.addStyledText(this.m_dialogArea, null, PERFCOLUMN, this.row.cfi.m_filed, 1, 1, 0, 3, this);
        this.validateColumnName(this.perfColumn);
        m_gui.addTextField(this.m_dialogArea, null, "Interval ", 1, 1, 0, 0, null);
        this.perfInterval = m_gui.addStyledText(this.m_dialogArea, null, PERFINTERVAL, this.row.cfi.m_intervalOrigStr, 1, 1, 0, 3, this);
        this.validateInterval(this.perfInterval);
        Label helpIcon = new Label(this.m_dialogArea, 0);
        helpIcon.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        helpIcon.setImage(BMUI.IMAGE_HELP);
        helpIcon.addListener(4, (Listener)new IntervalHelpListener());
        new Label(this.m_dialogArea, 0).setText(" i.e. 1m, 5m, 1h, 1d");
        String text = "Monitor values collected by the policy will also forwarded to the server as performance data.\n\"Perf Class\" will specify related database tablename. (will be autocreated by server)\n\"Perf Column\" will specify related database column name. (will be autocreated by server)\nPlease use database compatible table and column names!\n\n\"HOST\" column wil be added automatically (Agent hostname). External hosts can not be used.\nCentral performance data collector of the Agent will join performance data from multiple policies\nif the same \"Perf Class\" is specified.\nIn case of the \"Perf Class\" has different intervals configured - lowest value will be choosen.";
        m_gui.addTextReadOnlyMulitLineNoBorder(this.m_dialogArea, "", text, 4, 1, 0, 3, null);
        return this.m_dialogArea;
    }

    public void modifyText(ModifyEvent e) {
        Object obj = e.getSource();
        if (obj instanceof StyledText) {
            this.setDirty(true);
            StyledText styledText = (StyledText)obj;
            String fieldName = (String)styledText.getData();
            styledText.setBackground(null);
            if (PATTERN.equals(fieldName)) {
                try {
                    this.row = new MonPerfSubmitProvider.PerfMappingRow(PatternB.getPattern(styledText.getText()), this.row.cfi);
                    styledText.setBackground(BMUI.color_light_green);
                }
                catch (Exception exception) {
                    styledText.setBackground(BMUI.color_light_red);
                }
            } else if (PERFCLASS.equals(fieldName)) {
                this.row.cfi.m_class = styledText.getText();
                this.validateClassName(styledText);
            } else if (PERFCOLUMN.equals(fieldName)) {
                this.row.cfi.m_filed = styledText.getText();
                this.validateColumnName(styledText);
            } else if (PERFINTERVAL.equals(fieldName)) {
                this.row.cfi.m_intervalOrigStr = styledText.getText();
                this.validateInterval(styledText);
            }
        }
    }

    private void validateInterval(StyledText styledText) {
        if (!this.row.cfi.isValidInterval()) {
            styledText.setBackground(BMUI.color_light_red);
        } else {
            styledText.setBackground(BMUI.color_light_green);
        }
    }

    private void validateColumnName(StyledText styledText) {
        if (!this.row.cfi.isValidColumn()) {
            styledText.setBackground(BMUI.color_light_red);
        } else {
            styledText.setBackground(BMUI.color_light_green);
        }
    }

    private void validateClassName(StyledText styledText) {
        if (!this.row.cfi.isValidClassName()) {
            styledText.setBackground(BMUI.color_light_red);
        } else {
            styledText.setBackground(BMUI.color_light_green);
        }
    }

    public void setDirty(boolean b) {
        try {
            this.getButton(0).setEnabled(b);
        }
        catch (Exception exception) {}
    }

    public void widgetSelected(SelectionEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public boolean close() {
        Control[] controls = this.m_dialogArea.getChildren();
        int i = 0;
        while (i < controls.length) {
            controls[i].dispose();
            ++i;
        }
        return super.close();
    }

    public MonPerfSubmitProvider.PerfMappingRow getPerfMappingRow() {
        return this.row;
    }
}

