/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.dialogs;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.dialogs.CondVFilterDialog;
import com.blixx.boom.gui.dialogs.HelperJob;
import com.blixx.boom.gui.dialogs.IPatternValidation;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.policies.PolicyManager;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.utils.PatternMatching;
import com.blixx.boom.gui.utils.PatternValidator;
import com.blixx.shared.MsgCondition;
import com.blixx.shared.MsgPolicy;
import com.blixx.shared.PatternB;
import com.blixx.shared.PatternMatchResult;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class PolicyObjectTestingDialog
implements ModifyListener,
SelectionListener,
MouseListener,
IPatternValidation {
    private Shell m_parentShell = null;
    private Shell m_shell;
    private String m_polType = null;
    public String m_pattern = "";
    public PatternB m_patternObj = null;
    public TableItem[] m_selection = null;
    private CondVFilterDialog m_condVFilterDialog = null;
    public GUIDisplayElements m_guiElements;
    public TableViewer m_tv_patternTable = null;
    public TableViewer m_tv_searchTextTable = null;
    private SashForm m_main = null;
    private Composite m_top = null;
    private Composite m_bottom = null;
    private ScrolledComposite m_pattern_sComp = null;
    private ScrolledComposite composite = null;
    private Composite bottom_comp = null;
    private Composite m_lineCountComp = null;
    private Label m_validateIcon_JAVA = null;
    public Text m_result_field = null;
    public Text m_patternExample = null;
    private Text m_lineCount_field = null;
    private Button m_add_Button = null;
    private Button m_paste_Button = null;
    private Button m_edit_Button = null;
    private Button m_remove_Button = null;
    private Button m_load_Button = null;
    private Button m_append_Button = null;
    private Button m_saveToFile_Button = null;
    private Button m_testLines_Button = null;
    private Button m_stoptestLines_Button = null;
    private Button m_clearLines_Button = null;
    private Button m_close_Button = null;
    public Button m_save_Button = null;
    private Button m_lineLimit_check = null;
    private Button m_resplit_Button;
    public static String PATTERN_INPUT_FIELD_JAVA = "pattern_input_field_java";
    public static String BUTTON_ADD_PATTERN = "button_add_pattern";
    public static String BUTTON_ADD = "button_add";
    public static String BUTTON_EDIT = "button_edit";
    public static String BUTTON_PASTE = "button_paste";
    public static String BUTTON_REMOVE = "button_remove";
    public static String BUTTON_LOAD = "button_load";
    public static String BUTTON_APPEND = "button_append";
    public static String BUTTON_SAVE_TO_FILE = "button_saveToFile";
    public static String BUTTON_VALIDATAE_LINES = "button_test";
    public static String BUTTON_STOPTEST = "button_stoptest";
    public static String BUTTON_CLEAR = "button_clear";
    public static String BUTTON_CLOSE = "button_close";
    public static String BUTTON_SAVE = "button_save";
    private static String BUTTON_LIMIT = "button_limit";
    public static String BUTTON_RESPLIT = "button_resplit";
    public static String PATTERN_ELEMENTS = "pattern_elements";
    public static String JAVA = "JAVA";
    public static String DESCRIPTION_FIELD = "description_field";
    private static int LINE_LIMIT = 20000;
    public PatternMatching m_pm_patternTable = null;
    public PatternMatching m_pm_searchTextTable = null;
    public boolean m_isCanceled = false;
    public boolean m_isRunning = false;
    private boolean m_hasLineLimitActive = true;
    private boolean m_savePattern = false;
    private Composite m_pattern_comp = null;
    private PatternValidator m_patternValidator = null;
    private org.eclipse.swt.widgets.List m_patternList_List = null;
    private Text m_description_Field = null;
    private Composite m_parent = null;
    private Image m_image = null;
    private String m_polType4Display = null;
    private String m_name = "";
    private String m_version = "";
    private String m_group = "";
    private String m_application = "";
    private String m_callType = "";
    private String m_path = "";
    private Composite m_info = null;
    private String m_monProg = "";
    private String m_splitRec = "";
    public boolean m_isMultiline = false;
    public static String SEARCHTEXT_TABLE = "searchtext_table";
    public static String PATTERN_TABLE = "pattern_table";
    public static String BUTTON_STEDIT = "button_stedit";
    private Button m_stedit_Button = null;
    public static String BUTTON_STREMOVE = "button_stremove";
    public static String RESPLIT_ACT = "Due to MULTILINE Re-split activated";

    public PolicyObjectTestingDialog(StructuredSelection ssel) {
        File fileP;
        Object selection = ssel.getFirstElement();
        if (selection instanceof String[]) {
            String[] element = (String[])selection;
            try {
                this.m_polType = element[0];
                this.m_name = element[1];
            }
            catch (Exception exception) {}
        } else if (selection instanceof GroupTreeObjectLast) {
            GroupTreeObjectLast gtol = (GroupTreeObjectLast)selection;
            this.m_name = gtol.getName();
            this.m_polType = gtol.getTreeObject().getType();
            this.m_path = gtol.getPath();
        }
        if ((fileP = Repository.getInstance().fetchFile(this.m_name, this.m_polType)) != null) {
            PolicyManager pm = PolicyManager.getInstance();
            if (this.m_polType.equals(BMUI.type_msg)) {
                this.m_polType4Display = "Indication";
                this.m_image = BMUI.IMAGE_MSG;
                MsgPolicy mp = pm.getMessagePolicy(fileP);
                if (mp != null) {
                    String[] lines;
                    this.m_version = mp.getVersion();
                    this.m_group = "-";
                    this.m_application = "-";
                    this.m_callType = mp.getCallType();
                    this.m_monProg = mp.getMonprog();
                    if (this.m_monProg != "" && (lines = this.m_monProg.split("\\r?\\n|\\r")).length > 1) {
                        this.m_splitRec = lines[2];
                    }
                }
            }
        }
        this.createDialog();
    }

    public void createDialog() {
        this.m_guiElements = new GUIDisplayElements();
        int style = 1265;
        if (this.m_parentShell != null) {
            this.m_shell = new Shell(this.m_parentShell, style);
        } else {
            this.m_shell = new Shell(Display.getCurrent(), style);
            this.m_guiElements.openShellInActiveMonitor(this.m_shell);
        }
        this.m_shell.setLayout((Layout)new GridLayout(1, false));
        this.createContents((Composite)this.m_shell);
        this.m_shell.setSize(700, 650);
        this.m_shell.setText(" SNMP-Policy All Conditions Testing (Object)");
        this.m_shell.setImage(BMUI.IMAGE_PRODUCT);
    }

    public void open() {
        this.m_shell.open();
    }

    public void mouseUp(MouseEvent e) {
        String text;
        Table t;
        TableItem[] ti;
        if (e.getSource() instanceof Text || !(e.getSource() instanceof Table) || (e.stateMask & 0x10000) <= 0 || (ti = (t = (Table)e.getSource()).getSelection()) == null || ti.length != 1 || (text = ti[0].getText(PatternMatching.COLUMN_TEXT)) == null || text.length() > 0) {
            // empty if block
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    protected void createContents(Composite parent) {
        this.m_patternValidator = new PatternValidator();
        GridLayout gdLayout = null;
        gdLayout = new GridLayout(2, false);
        gdLayout.marginBottom = 0;
        gdLayout.marginRight = 0;
        gdLayout.marginLeft = 0;
        parent.setLayout((Layout)gdLayout);
        parent.setBackground(BMUI.color_grey);
        this.m_top = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginTop = 5;
        gl.marginWidth = 10;
        this.m_top.setLayout((Layout)gl);
        this.m_top.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createInfoSection(this.m_top);
        this.createConditionSection(this.m_top);
        this.createPatternSection(this.m_top);
        this.createResultsArea(this.m_top);
    }

    private void createInfoSection(Composite parentComp) {
        Composite comp = new Composite(parentComp, 0);
        GridLayout gl = new GridLayout(2, false);
        comp.setLayout((Layout)gl);
        comp.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        Label l = new Label(comp, 0);
        if (this.m_image != null) {
            l.setImage(this.m_image);
        }
        l = new Label(comp, 0);
        l.setText(this.m_name);
        l.setFont(BMUI.font_arial8_bold);
        Composite compInfo = new Composite(parentComp, 0);
        gl = new GridLayout(2, false);
        compInfo.setLayout((Layout)gl);
        compInfo.setLayoutData((Object)new GridData(4, 128, true, false));
        this.m_guiElements.addTextReadOnlyNoBorder(compInfo, "Version:", this.m_version, 1, 1, 1, 1, null);
        if (this.m_splitRec != "") {
            if (!".*".equals(this.m_splitRec)) {
                this.m_isMultiline = true;
                this.m_guiElements.addTextReadOnlyNoBorder(compInfo, "Split Records (MULTILINE):", this.m_splitRec, 1, 1, 1, 1, null);
            } else {
                this.m_isMultiline = false;
                this.m_guiElements.addTextReadOnlyNoBorder(compInfo, "Split Records (SINGLE LINE):", this.m_splitRec, 1, 1, 1, 1, null);
            }
        }
    }

    public Table createConditionSection(Composite parentComp) {
        ScrolledComposite composite = new ScrolledComposite(parentComp, 2816);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Table table = new Table((Composite)composite, 65552);
        table.setHeaderVisible(true);
        table.addSelectionListener((SelectionListener)this);
        table.setData((Object)SEARCHTEXT_TABLE);
        this.m_tv_searchTextTable = new TableViewer(table);
        this.m_pm_searchTextTable = new PatternMatching(this.m_tv_searchTextTable, this);
        composite.setContent((Control)table);
        composite.setExpandHorizontal(true);
        composite.setExpandVertical(true);
        composite.setAlwaysShowScrollBars(true);
        composite.setMinSize(table.computeSize(-1, -1));
        TableColumn col1 = new TableColumn(table, 0);
        col1.setWidth(50);
        col1.setText("Cond.");
        col1.setToolTipText("Condition Number");
        TableColumn col2 = new TableColumn(table, 0);
        col2.setWidth(1646);
        col2.setText("Object");
        col2.setToolTipText("Object to compare");
        table.addMouseListener((MouseListener)this);
        this.fillCondTable(table);
        composite.setMinSize(table.computeSize(-1, -1));
        return table;
    }

    public void fillCondTable(Table table) {
        MsgPolicy mp;
        PolicyManager pm = PolicyManager.getInstance();
        File fileP = null;
        fileP = Repository.getInstance().fetchFile(this.m_name, this.m_polType);
        if (fileP != null && (mp = pm.getMessagePolicy(fileP)) != null) {
            int seq = 0;
            Iterator it = mp.getConditions().getConditionList().iterator();
            while (it.hasNext()) {
                new StringBuffer();
                MsgCondition mc = (MsgCondition)it.next();
                String condObj = mc.getObjectFilter();
                TableItem item = new TableItem(table, 0);
                String seqnr = Integer.toString(++seq);
                item.setText(0, seqnr);
                item.setText(1, condObj);
            }
        }
    }

    public Table createPatternSection(Composite parentComp) {
        Composite btn1Comp = new Composite(parentComp, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        btn1Comp.setLayout((Layout)gl);
        btn1Comp.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        btn1Comp.setBackground(BMUI.color_grey);
        this.m_stedit_Button = this.m_guiElements.addButton(btn1Comp, BUTTON_STEDIT, " Edit ", true, 90, 20, 10, this);
        this.m_stedit_Button.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.m_stedit_Button = this.m_guiElements.addButton(btn1Comp, BUTTON_STREMOVE, " Remove ", true, 90, 20, 10, this);
        this.m_stedit_Button.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        Composite compTable = new Composite(parentComp, 0);
        GridLayout glt = new GridLayout(1, false);
        compTable.setLayout((Layout)glt);
        compTable.setLayoutData((Object)new GridData(4, 4, true, false));
        Table table = new Table(compTable, 268503810);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setData((Object)PATTERN_TABLE);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.heightHint = 75;
        table.setLayoutData((Object)gridData);
        table.addSelectionListener((SelectionListener)this);
        this.m_tv_patternTable = new TableViewer(table);
        this.m_pm_patternTable = new PatternMatching(this.m_tv_patternTable, this);
        TableColumn col1 = new TableColumn(table, 0);
        col1.setWidth(25);
        col1.setText("Status");
        col1.setToolTipText("Compare Status (true|false)");
        TableColumn col2 = new TableColumn(table, 16384);
        col2.setWidth(50);
        col2.setText("Cond.");
        col2.setToolTipText("Condtion Number");
        TableColumn col3 = new TableColumn(table, 0);
        col3.setWidth(1646);
        col3.setText("Text Pattern                                                                          ");
        col3.setToolTipText("Text to compare");
        table.addMouseListener((MouseListener)this);
        table.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127 && (e.stateMask & 0x40000) == 0) {
                    PolicyObjectTestingDialog.this.removeLines();
                }
            }
        });
        this.m_lineCountComp = new Composite(parentComp, 0);
        gl = new GridLayout(4, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.marginLeft = 5;
        gl.horizontalSpacing = 0;
        this.m_lineCountComp.setLayout((Layout)gl);
        this.m_lineCountComp.setLayoutData((Object)new GridData(4, 128, false, false));
        this.m_guiElements.addTextReadOnlyNoBorder(this.m_lineCountComp, null, "Current Lines:", 1, 1, 0, 0, null);
        this.m_lineCount_field = this.m_guiElements.addTextReadOnlyNoBorder(this.m_lineCountComp, null, "0", 1, 1, 0, 0, null);
        ((GridData)this.m_lineCount_field.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.m_lineCount_field.getLayoutData()).grabExcessHorizontalSpace = true;
        ((GridData)this.m_lineCount_field.getLayoutData()).widthHint = 50;
        this.m_lineLimit_check = this.m_guiElements.addCheckbox(this.m_lineCountComp, BUTTON_LIMIT, "Set Limit to " + LINE_LIMIT, this.m_hasLineLimitActive, 1, 1, 0, this);
        Composite btn2Comp = new Composite(parentComp, 0);
        gl = new GridLayout(8, false);
        gl.marginWidth = 0;
        btn2Comp.setLayout((Layout)gl);
        btn2Comp.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        btn2Comp.setBackground(BMUI.color_grey);
        this.m_testLines_Button = this.m_guiElements.addButton(btn2Comp, BUTTON_VALIDATAE_LINES, " Test All ", false, 90, 20, 0, this);
        this.m_testLines_Button.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.m_edit_Button = this.m_guiElements.addButton(btn2Comp, BUTTON_EDIT, "Edit Line", false, 90, 20, 10, this);
        this.m_edit_Button.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.m_add_Button = this.m_guiElements.addButton(btn2Comp, BUTTON_ADD, "Append Line", true, 90, 20, 10, this);
        this.m_add_Button.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.m_paste_Button = this.m_guiElements.addButton(btn2Comp, BUTTON_PASTE, "Paste", true, 90, 20, 10, this);
        this.m_paste_Button.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.m_load_Button = this.m_guiElements.addButton(btn2Comp, BUTTON_LOAD, "Load File", true, 90, 20, 10, this);
        this.m_load_Button.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.m_append_Button = this.m_guiElements.addButton(btn2Comp, BUTTON_APPEND, "Append File", true, 90, 20, 10, this);
        this.m_append_Button.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.m_remove_Button = this.m_guiElements.addButton(btn2Comp, BUTTON_REMOVE, " Remove Line ", false, 90, 20, 10, this);
        this.m_remove_Button.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.m_clearLines_Button = this.m_guiElements.addButton(btn2Comp, BUTTON_CLEAR, " Clear All ", false, 90, 20, 0, this);
        this.m_clearLines_Button.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        return table;
    }

    public void createResultsArea(Composite comp) {
        String text = "                               \n\n\n\n\n\n\n\n\n\n\n\n";
        Composite compRes = new Composite(comp, 0);
        GridLayout gl = new GridLayout(3, false);
        compRes.setLayout((Layout)gl);
        this.m_result_field = this.m_guiElements.addInputFieldMultiLine(compRes, "RESULTAREA", " Variables:", text, 1, 1, 20, 450, 1, 1, this);
        this.m_close_Button = this.m_guiElements.addButton(compRes, BUTTON_CLOSE, "    Close    ", true, 90, 20, 20, this);
    }

    private void createButtons(Composite comp) {
        Composite cmp = new Composite(comp, 2048);
        GridLayout gl = new GridLayout(1, false);
        cmp.setLayout((Layout)gl);
        cmp.setLayoutData((Object)new GridData(131072, 1024, false, false));
        this.m_close_Button = this.m_guiElements.addButton(cmp, BUTTON_CLOSE, "  Close  ", true, 90, 20, 0, this);
    }

    public boolean hasLineLimitActive() {
        return this.m_hasLineLimitActive;
    }

    public int getLineLimit() {
        return LINE_LIMIT;
    }

    public void updateLineCount() {
        this.m_lineCount_field.setText("" + this.m_tv_patternTable.getTable().getItemCount());
    }

    public void disableAllButtons() {
        this.m_guiElements.enableField(this.m_edit_Button, false);
        this.m_guiElements.enableField(this.m_add_Button, false);
        this.m_guiElements.enableField(this.m_remove_Button, false);
        this.m_guiElements.enableField(this.m_load_Button, false);
        this.m_guiElements.enableField(this.m_append_Button, false);
        this.m_guiElements.enableField(this.m_paste_Button, false);
        this.m_guiElements.enableField(this.m_testLines_Button, false);
        this.m_guiElements.enableField(this.m_clearLines_Button, false);
    }

    public void checkButtonStatus() {
        try {
            Table table;
            this.m_guiElements.enableField(this.m_paste_Button, true);
            if (this.m_tv_patternTable != null && (table = this.m_tv_patternTable.getTable()) != null && !table.isDisposed()) {
                int numOfItems = table.getItemCount();
                int selIndex = table.getSelectionIndex();
                if (numOfItems == 0) {
                    this.m_guiElements.enableField(this.m_edit_Button, false);
                    this.m_guiElements.enableField(this.m_add_Button, true);
                    this.m_guiElements.enableField(this.m_remove_Button, false);
                    this.m_guiElements.enableField(this.m_load_Button, true);
                    this.m_guiElements.enableField(this.m_append_Button, true);
                    this.m_guiElements.enableField(this.m_testLines_Button, false);
                    this.m_guiElements.enableField(this.m_clearLines_Button, false);
                } else if (numOfItems == 1) {
                    this.m_guiElements.enableField(this.m_add_Button, true);
                    this.m_guiElements.enableField(this.m_load_Button, true);
                    this.m_guiElements.enableField(this.m_append_Button, true);
                    this.m_guiElements.enableField(this.m_testLines_Button, true);
                    this.m_guiElements.enableField(this.m_clearLines_Button, true);
                    if (selIndex != -1) {
                        this.m_guiElements.enableField(this.m_edit_Button, true);
                        this.m_guiElements.enableField(this.m_remove_Button, true);
                    } else {
                        this.m_guiElements.enableField(this.m_edit_Button, false);
                        this.m_guiElements.enableField(this.m_remove_Button, false);
                    }
                } else if (numOfItems > 1) {
                    this.m_guiElements.enableField(this.m_add_Button, true);
                    this.m_guiElements.enableField(this.m_load_Button, true);
                    this.m_guiElements.enableField(this.m_append_Button, true);
                    this.m_guiElements.enableField(this.m_testLines_Button, true);
                    this.m_guiElements.enableField(this.m_clearLines_Button, true);
                    if (selIndex != -1) {
                        this.m_guiElements.enableField(this.m_edit_Button, true);
                        this.m_guiElements.enableField(this.m_remove_Button, true);
                    } else {
                        this.m_guiElements.enableField(this.m_edit_Button, false);
                        this.m_guiElements.enableField(this.m_remove_Button, false);
                    }
                }
                if (this.m_remove_Button != null) {
                    int selCount = table.getSelectionCount();
                    if (selCount > 1) {
                        this.m_remove_Button.setText(" Remove Lines ");
                    } else {
                        this.m_remove_Button.setText(" Remove Line ");
                    }
                }
            }
        }
        catch (Exception exception) {}
    }

    private void removeLines() {
        this.m_pm_patternTable.removeLines();
        this.updateLineCount();
        this.checkButtonStatus();
    }

    public void cleanImages() {
        if (this.m_pm_patternTable != null) {
            this.m_pm_patternTable.clearStatus();
        }
    }

    public void modifyText(ModifyEvent e) {
        Object obj = e.getSource();
        if (obj instanceof Text) {
            Text field = (Text)obj;
            String cfr_ignored_0 = (String)field.getData();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        if (e.getSource() instanceof Table) {
            Table t = (Table)e.getSource();
            String tableName = (String)t.getData();
            if (tableName.equals(PATTERN_TABLE)) {
                TableItem tableItem = this.m_pm_patternTable.editLine();
                this.validateLines(tableItem, null);
            } else if (tableName.equals(SEARCHTEXT_TABLE)) {
                this.m_pm_searchTextTable.editSTLine();
            }
        }
    }

    public void widgetSelected(SelectionEvent e) {
        org.eclipse.swt.widgets.List list;
        String name;
        if (e.getSource() instanceof Button) {
            Button b = (Button)e.getSource();
            String buttonName = (String)b.getData();
            if (buttonName.equals(BUTTON_ADD)) {
                TableItem tableItem = this.m_pm_patternTable.addNewLine();
                if (tableItem != null) {
                    if (this.m_isMultiline) {
                        TableItem[] t_i = this.m_tv_patternTable.getTable().getItems();
                        boolean matchedOne = false;
                        String[] arr = new String[t_i.length];
                        int i = 0;
                        while (i < t_i.length) {
                            arr[i] = t_i[i].getText(PatternMatching.COLUMN_TEXT);
                            if (matchedOne || arr[i].matches(this.m_splitRec)) {
                                matchedOne = true;
                            }
                            ++i;
                        }
                        if (matchedOne) {
                            this.m_result_field.setText(RESPLIT_ACT);
                            this.resplitRecords();
                            TableItem[] ti = this.m_tv_patternTable.getTable().getItems();
                            int i2 = 0;
                            while (i2 < ti.length) {
                                this.checkTableItem(ti[i2]);
                                ++i2;
                            }
                        }
                    } else {
                        this.validateLines(tableItem, null);
                    }
                    this.updateLineCount();
                    this.checkButtonStatus();
                }
            } else if (buttonName.equals(BUTTON_LOAD)) {
                this.disableAllButtons();
                this.m_pm_patternTable.loadFromFile(false);
            } else if (buttonName.equals(BUTTON_SAVE_TO_FILE)) {
                this.m_pm_patternTable.saveToFile();
                this.checkButtonStatus();
            } else if (buttonName.equals(BUTTON_VALIDATAE_LINES)) {
                if (this.m_isMultiline) {
                    this.m_result_field.setText(RESPLIT_ACT);
                    this.resplitRecords();
                }
                try {
                    this.validateLines(null, null);
                }
                catch (Throwable throwable) {}
            } else if (buttonName.equals(BUTTON_STOPTEST)) {
                this.m_isCanceled = true;
            } else if (buttonName.equals(BUTTON_REMOVE)) {
                this.removeLines();
                this.m_result_field.setText("");
            } else if (buttonName.equals(BUTTON_EDIT)) {
                TableItem tableItem = this.m_pm_patternTable.editLine();
                if (tableItem != null && !tableItem.isDisposed()) {
                    this.validateLines(tableItem, null);
                }
                this.checkButtonStatus();
            } else if (buttonName.equals(BUTTON_APPEND)) {
                this.disableAllButtons();
                this.m_pm_patternTable.loadFromFile(true);
            } else if (buttonName.equals(BUTTON_PASTE)) {
                this.m_pm_patternTable.paste();
            } else if (buttonName == BUTTON_CLEAR) {
                this.m_tv_patternTable.getTable().removeAll();
                this.checkButtonStatus();
                this.updateLineCount();
                this.m_result_field.setText("");
            } else if (buttonName.equals(BUTTON_STEDIT)) {
                this.m_pm_searchTextTable.editSTLine();
            } else if (buttonName.equals(BUTTON_STREMOVE)) {
                this.m_pm_searchTextTable.removeLines();
            } else if (buttonName.equals(BUTTON_CLOSE)) {
                this.m_shell.dispose();
            } else if (buttonName.equals(BUTTON_LIMIT)) {
                this.m_hasLineLimitActive = this.m_lineLimit_check.getSelection();
            }
        } else if (e.getSource() instanceof Table) {
            String result = "";
            Table table = (Table)e.getSource();
            String tableName = (String)table.getData();
            if (tableName.equals(SEARCHTEXT_TABLE)) {
                return;
            }
            int row = table.getSelectionIndex();
            TableItem[] ti = table.getItems();
            String condno = ti[row].getText(1);
            if (condno == "") {
                result = "Condition number not available";
                this.m_result_field.setText(result);
            } else {
                int condNo = Integer.valueOf(condno.replaceAll(".*,", ""));
                int index = condNo - 1;
                TableItem[] tiST = this.m_tv_searchTextTable.getTable().getItems();
                String condText = tiST[index].getText(PatternMatching.COLUMN_PROCESSING_TIME);
                boolean isValid = this.m_patternValidator.validatePattern(PatternValidator.SIMPLIFIED, condText);
                if (isValid) {
                    PatternB patternObj = this.m_patternValidator.getPatternObj();
                    TableItem item = table.getItem(row);
                    HelperJob hj = new HelperJob("PatternValidation", item, patternObj, condNo);
                    hj.runInUIThread(null);
                    PatternMatchResult pMatchResult = (PatternMatchResult)item.getData(PatternMatchResult.class.getName());
                    if (pMatchResult != null) {
                        if (pMatchResult.getVariableMap().size() == 0) {
                            result = "No capturing group(s) defined";
                        } else {
                            Map<String, String> resultVars = pMatchResult.getVariableMap();
                            if (resultVars != null) {
                                ArrayList<String> varNames = new ArrayList<String>(resultVars.keySet());
                                StringBuffer sb = new StringBuffer();
                                for (String var : varNames) {
                                    String value = resultVars.get(var);
                                    if (var == null) {
                                        var = "";
                                    }
                                    sb.append(var).append("=").append((Object)value).append("  ");
                                }
                                result = sb.toString();
                            }
                        }
                    }
                    this.m_result_field.setText(result.replace("\r", ""));
                }
                this.checkButtonStatus();
            }
        } else if (e.getSource() instanceof org.eclipse.swt.widgets.List && (name = (String)(list = (org.eclipse.swt.widgets.List)e.getSource()).getData()).equals(PATTERN_ELEMENTS)) {
            this.checkButtonStatus();
        }
        Display.getCurrent().readAndDispatch();
    }

    public void widgetDisposed(DisposeEvent e) {
        try {
            this.m_parent.dispose();
        }
        catch (Throwable throwable) {}
    }

    private void validateLines(TableItem tableItem, List<TableItem> list) {
        try {
            if (tableItem != null) {
                this.checkTableItem(tableItem);
            } else if (list != null) {
                int i = 0;
                while (i < list.size()) {
                    TableItem item = list.get(i);
                    this.checkTableItem(item);
                    ++i;
                }
            } else {
                Table table = this.m_tv_patternTable.getTable();
                if (table != null && table.getItemCount() > 0) {
                    this.m_isRunning = true;
                    this.cleanImages();
                    TableItem[] tableItems = table.getItems();
                    int i = 0;
                    while (i < tableItems.length) {
                        this.checkTableItem(tableItems[i]);
                        ++i;
                    }
                }
            }
            this.m_pm_patternTable.setStatus(false);
        }
        catch (RuntimeException e) {
            new ShowMessageBox("Warning", e.getMessage(), 8);
        }
    }

    private void checkTableItem(TableItem item) {
        TableItem[] ti = this.m_tv_searchTextTable.getTable().getItems();
        int i = 0;
        while (i < ti.length) {
            int condNo = Integer.valueOf(ti[i].getText(PatternMatching.COLUMN_STATUS));
            String condText = ti[i].getText(PatternMatching.COLUMN_PROCESSING_TIME);
            boolean isValid = this.m_patternValidator.validatePattern(PatternValidator.SIMPLIFIED, condText);
            if (isValid) {
                PatternB patternObj = this.m_patternValidator.getPatternObj();
                HelperJob hj = new HelperJob("PatternValidation", item, patternObj, condNo);
                hj.runInUIThread(null);
            }
            ++i;
        }
    }

    protected void resplitRecords() {
        boolean res = false;
        if (!res) {
            String pattern = this.m_splitRec;
            Pattern p = Pattern.compile(pattern, 32);
            if (!".*".equals(pattern)) {
                TableItem[] ti = this.m_tv_patternTable.getTable().getItems();
                String[] arr = new String[ti.length];
                boolean matchedOne = false;
                int i = 0;
                while (i < ti.length) {
                    arr[i] = ti[i].getText(PatternMatching.COLUMN_TEXT);
                    if (matchedOne || p.matcher(arr[i]).matches()) {
                        matchedOne = true;
                    }
                    ++i;
                }
                this.m_tv_patternTable.getTable().removeAll();
                StringBuffer sb = null;
                int i2 = 0;
                while (i2 < arr.length) {
                    String text = arr[i2];
                    Matcher m = p.matcher(text);
                    if (m.matches()) {
                        if (sb != null && sb.length() > 0) {
                            this.m_pm_patternTable.addNewLine(sb.toString());
                            sb = new StringBuffer();
                        }
                        if (sb == null) {
                            sb = new StringBuffer();
                        }
                        sb.append(text);
                    } else if (sb != null) {
                        sb.append("\n").append(text);
                    }
                    ++i2;
                }
                if (sb != null && sb.length() > 0) {
                    this.m_pm_patternTable.addNewLine(sb.toString());
                }
            }
        }
    }

    @Override
    public String getPattern() {
        return null;
    }

    @Override
    public ProgressBar getProgressBar() {
        return null;
    }

    @Override
    public boolean isCanceled() {
        return false;
    }

    @Override
    public void setStopped() {
    }
}

