/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.dialogs;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.dialogs.NameValidatorPolicyName;
import com.blixx.boom.gui.policies.PolicyManager;
import com.blixx.boom.gui.policies.ViewContentProvider;
import com.blixx.boom.gui.policies.ViewLabelProvider;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.utils.PolicyRenamingValidation;
import com.blixx.boom.gui.utils.STreeViewer;
import com.blixx.boom.gui.views.PolicyListView;
import com.blixx.boom.gui.views.actions.AddGroupTreeObjectAction;
import com.blixx.log.RTLogger;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.util.HashMap;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class PolicyRenamingDialog
extends StatusDialog
implements ModifyListener,
SelectionListener,
IDoubleClickListener,
DisposeListener {
    private static final String COPY = "Copy";
    private static final String IMPORT = "Apply";
    private static final String RENAME = "Apply";
    private static final String IMPORT_ONLY = "Import";
    private static final String BUTTON_FORCE_NEW_VERSIONS = "BUTTON_FORCE_NEW_VERSIONS";
    public TreeViewer m_treeViewer = null;
    public TableViewer m_tableViewer = null;
    public PolicyRenamingValidation m_renamingValidation = null;
    private HashMap<String, GroupTreeObjectLast> m_hashMap = null;
    private HashMap<String, GroupTreeObjectLast> m_conflicts = null;
    public String m_actionType = null;
    public String m_prefix = "";
    public String m_suffix = "";
    public String m_find = "";
    public String m_replace = "";
    public GroupTreeObject m_target = null;
    public boolean m_isValid = true;
    private boolean m_isImportForced = false;
    private int m_numOfConflicts = 0;
    public GUIDisplayElements m_guiElements;
    public Composite m_parentComp = null;
    public Composite m_leftComp = null;
    public Composite m_previewComp = null;
    public Composite m_btnComp = null;
    public Composite m_comp = null;
    public Composite m_comp1 = null;
    public Composite m_comp2 = null;
    private Group m_renaming_grp = null;
    public Group m_prefixSuffix_grp = null;
    public Group m_findReplace_grp = null;
    public Group m_copying_grp = null;
    public Group m_groupPrieview = null;
    public Text m_prefix_field = null;
    public Text m_suffix_field = null;
    public Text m_find_field = null;
    public Text m_replace_field = null;
    public Label m_totalItems_label = null;
    public Label m_conflicts_label = null;
    public Button m_copy_chk = null;
    public Button m_prefixSuffix_radio = null;
    public Button m_findReplace_radio = null;
    private Button m_removeLine_button = null;
    private Button m_removeConflicts_button = null;
    private Button m_forceNewVersions_button = null;
    public static String BUTTON_REMOVE_LINES = "button_remove";
    public static String BUTTON_REMOVE_CONFLICTS = "button_remove_conflicts";
    public static String PREFIX_SUFFIX = "PREFIX_SUFFIX";
    public static String FIND_REPLACE = "FIND_REPLACE";
    public static String PREFIX = "PREFIX";
    public static String SUFFIX = "SUFFIX";
    public static String FIND = "FIND";
    public static String REPLACE = "REPLACE";
    public static String CHECK_COPY = "CHECK_COPY";
    public static String RADIO_PREFIX_SUFFIX = "RADIO_PREFIX_SUFFIX";
    public static String RADIO_FIND_REPLACE = "RADIO_FIND_REPLACE";
    public static String IMPORT_POLICY = "import_policy";
    public static String RENAME_POLICY = "rename_policy";
    public static String IMPORT_POLICY_ONLY = "import_policy_only";

    public PolicyRenamingDialog(Shell parentShell, HashMap<String, GroupTreeObjectLast> hashMap, String type) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x80 | 0x400);
        this.m_hashMap = hashMap;
        this.m_actionType = type;
        this.setTitles();
        this.setImage(BMUI.IMAGE_PRODUCT);
    }

    protected Control createDialogArea(Composite parent) {
        GridLayout gdLayout = null;
        this.m_guiElements = new GUIDisplayElements();
        this.m_parentComp = new Composite(parent, 0);
        this.m_parentComp.addDisposeListener((DisposeListener)this);
        gdLayout = new GridLayout(2, false);
        gdLayout.marginRight = 10;
        gdLayout.marginLeft = 10;
        gdLayout.marginHeight = 10;
        this.m_parentComp.setLayout((Layout)gdLayout);
        GridData gdData = new GridData(4, 4, true, true, 1, 1);
        gdData.widthHint = 850;
        gdData.heightHint = 500;
        this.m_parentComp.setLayoutData((Object)gdData);
        this.createRenamingSection(this.m_parentComp);
        this.createPreviewTable(this.m_parentComp);
        this.preview();
        return this.m_parentComp;
    }

    public void createRenamingSection(Composite parentComp) {
        this.m_leftComp = new Composite(parentComp, 0);
        GridLayout gdLayout = new GridLayout(1, false);
        gdLayout.marginRight = 5;
        this.m_leftComp.setLayout((Layout)gdLayout);
        GridData gdData = new GridData(4, 4, false, true, 1, 1);
        gdData.widthHint = 300;
        this.m_leftComp.setLayoutData((Object)gdData);
        this.m_renaming_grp = new Group(this.m_leftComp, 32);
        this.m_renaming_grp.setText("Policy Renaming");
        this.m_renaming_grp.setLayout((Layout)new GridLayout(4, false));
        this.m_renaming_grp.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.m_prefixSuffix_grp = new Group((Composite)this.m_renaming_grp, 32);
        this.m_prefixSuffix_grp.setText("Prefix/Suffix");
        this.m_prefixSuffix_grp.setLayout((Layout)new GridLayout(2, false));
        this.m_prefixSuffix_grp.setLayoutData((Object)new GridData(4, 4, true, false, 4, 1));
        this.m_prefixSuffix_radio = this.m_guiElements.addRadioButton((Composite)this.m_prefixSuffix_grp, RADIO_PREFIX_SUFFIX, "Prefix/Suffix", true, 2, 1, 0, 0, this);
        this.m_prefix_field = this.m_guiElements.addInputFieldSingle((Composite)this.m_prefixSuffix_grp, PREFIX, "Add Prefix: ", "", 1, 1, 0, 0, 100, this);
        this.m_suffix_field = this.m_guiElements.addInputFieldSingle((Composite)this.m_prefixSuffix_grp, SUFFIX, "Add Suffix: ", "", 1, 1, 0, 0, 100, this);
        this.m_findReplace_grp = new Group((Composite)this.m_renaming_grp, 32);
        this.m_findReplace_grp.setText("Find/Replace");
        this.m_findReplace_grp.setLayout((Layout)new GridLayout(2, false));
        this.m_findReplace_grp.setLayoutData((Object)new GridData(4, 128, true, false, 4, 1));
        this.m_findReplace_radio = this.m_guiElements.addRadioButton((Composite)this.m_findReplace_grp, RADIO_FIND_REPLACE, "Find/Replace", false, 2, 1, 0, 0, this);
        this.m_find_field = this.m_guiElements.addInputFieldSingle((Composite)this.m_findReplace_grp, FIND, "Find: ", "", 1, 1, 0, 0, 100, this);
        this.m_guiElements.enableField(this.m_find_field, false);
        this.m_replace_field = this.m_guiElements.addInputFieldSingle((Composite)this.m_findReplace_grp, REPLACE, "Replace With: ", "", 1, 1, 0, 0, 100, this);
        this.m_guiElements.enableField(this.m_replace_field, false);
        boolean isImport = this.m_actionType.equalsIgnoreCase(IMPORT_POLICY) || this.m_actionType.equalsIgnoreCase(IMPORT_POLICY_ONLY);
        int vIndent = 10;
        if (isImport) {
            Text text = this.m_guiElements.addTextReadOnlyNoBorder((Composite)this.m_renaming_grp, null, "Not available for IMPORT!", 4, 1, 0, vIndent, BMUI.font_arial8);
            text.setForeground(BMUI.color_critical);
            vIndent = 0;
        }
        this.m_copy_chk = this.m_guiElements.addCheckbox((Composite)this.m_renaming_grp, CHECK_COPY, "Enable Copying to a different Group", false, 4, 1, vIndent, this);
        if (isImport) {
            this.m_guiElements.enableField(this.m_copy_chk, false);
        }
        this.m_copying_grp = new Group((Composite)this.m_renaming_grp, 32);
        this.m_copying_grp.setText("Copying");
        this.m_copying_grp.setLayout((Layout)new GridLayout(1, false));
        this.m_copying_grp.setEnabled(this.m_actionType.equalsIgnoreCase(IMPORT_POLICY) || this.m_actionType.equalsIgnoreCase(IMPORT_POLICY_ONLY));
        this.m_copying_grp.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        this.m_treeViewer = new STreeViewer((Composite)this.m_copying_grp, 2052);
        this.m_treeViewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.m_treeViewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider(null, null));
        this.m_treeViewer.setInput((Object)PolicyManager.getInstance().getPolicyTree());
        this.m_treeViewer.expandToLevel(2);
        this.m_treeViewer.getTree().setEnabled(false);
        this.m_treeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        this.m_treeViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.createContentMenu();
    }

    public Table createPreviewTable(Composite parentComp) {
        GridData gdData = null;
        this.m_previewComp = new Composite(parentComp, 0);
        this.m_previewComp.setLayout((Layout)new GridLayout(1, false));
        this.m_previewComp.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.m_groupPrieview = new Group(this.m_previewComp, 32);
        this.m_groupPrieview.setText("Preview");
        this.m_groupPrieview.setLayout((Layout)new GridLayout(3, false));
        this.m_groupPrieview.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Table table = new Table((Composite)this.m_groupPrieview, 68354);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        gdData = new GridData(4, 4, true, true, 1, 1);
        gdData.horizontalSpan = 3;
        gdData.horizontalIndent = 3;
        table.setLayoutData((Object)gdData);
        table.addSelectionListener((SelectionListener)this);
        this.m_tableViewer = new TableViewer(table);
        this.m_renamingValidation = new PolicyRenamingValidation(this.m_tableViewer, this.m_hashMap, this.m_hashMap);
        TableColumn col1 = new TableColumn(table, 0);
        col1.setWidth(40);
        col1.setText("valid");
        col1.setAlignment(0x1000000);
        TableColumn col2 = new TableColumn(table, 0);
        col2.setWidth(40);
        col2.setText("Type");
        TableColumn col3 = new TableColumn(table, 0);
        col3.setWidth(300);
        col3.setText("Name");
        TableColumn col4 = new TableColumn(table, 0);
        col4.setWidth(500);
        col4.setText("Path");
        this.m_comp = new Composite((Composite)this.m_groupPrieview, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        this.m_comp.setLayout((Layout)gl);
        this.m_comp.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        this.m_comp1 = new Composite(this.m_comp, 0);
        this.m_comp1.setLayout((Layout)gl);
        this.m_comp1.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.m_comp2 = new Composite(this.m_comp, 0);
        this.m_comp2.setLayout((Layout)gl);
        this.m_comp2.setLayoutData((Object)new GridData(131072, 4, false, false, 1, 1));
        this.m_totalItems_label = this.m_guiElements.addTextField(this.m_comp1, null, "", 1, 1, 5, 0, null);
        ((GridData)this.m_totalItems_label.getLayoutData()).verticalAlignment = 128;
        this.m_conflicts_label = this.m_guiElements.addTextField(this.m_comp2, null, "", 1, 1, 5, 0, BMUI.font_arial7_bold);
        this.m_conflicts_label.setForeground(BMUI.color_critical);
        ((GridData)this.m_conflicts_label.getLayoutData()).horizontalAlignment = 131072;
        ((GridData)this.m_conflicts_label.getLayoutData()).verticalAlignment = 128;
        this.m_conflicts_label.setVisible(false);
        int marginTop = 10;
        if (this.m_actionType.equalsIgnoreCase(IMPORT_POLICY) || this.m_actionType.equalsIgnoreCase(IMPORT_POLICY_ONLY)) {
            this.m_forceNewVersions_button = this.m_guiElements.addCheckbox((Composite)this.m_groupPrieview, BUTTON_FORCE_NEW_VERSIONS, "Force import all conflicts as next versions ", false, 3, 0, 5, this);
            gdData = (GridData)this.m_forceNewVersions_button.getLayoutData();
            gdData.horizontalAlignment = 131072;
            gdData.grabExcessHorizontalSpace = true;
            marginTop = 0;
        }
        this.m_btnComp = new Composite((Composite)this.m_groupPrieview, 0);
        gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.marginTop = marginTop;
        this.m_btnComp.setLayout((Layout)gl);
        this.m_btnComp.setLayoutData((Object)new GridData(16384, 128, false, false, 3, 1));
        this.m_removeConflicts_button = this.m_guiElements.addButton(this.m_btnComp, BUTTON_REMOVE_CONFLICTS, " Remove Conflicts ", false, 90, 20, 0, this);
        ((GridData)this.m_removeConflicts_button.getLayoutData()).verticalIndent = 5;
        this.m_removeLine_button = this.m_guiElements.addButton(this.m_btnComp, BUTTON_REMOVE_LINES, " Remove Line(s) ", false, 90, 20, 0, this);
        ((GridData)this.m_removeLine_button.getLayoutData()).verticalIndent = 5;
        this.m_renamingValidation.initTable();
        return table;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.m_actionType.equals(RENAME_POLICY)) {
            this.createButton(parent, 0, "Apply", true);
        } else if (this.m_actionType.equals(IMPORT_POLICY)) {
            this.createButton(parent, 0, "Apply", true);
        } else if (this.m_actionType.equals(IMPORT_POLICY_ONLY)) {
            this.createButton(parent, 0, IMPORT_ONLY, true);
        }
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.checkButtonStatus();
    }

    public void setTitles() {
        if (this.m_actionType.equalsIgnoreCase(RENAME_POLICY)) {
            this.setTitle(" Copy and Renaming Policies");
        } else if (this.m_actionType.equalsIgnoreCase(IMPORT_POLICY)) {
            this.setTitle(" Rename Policies");
        } else if (this.m_actionType.equalsIgnoreCase(IMPORT_POLICY_ONLY)) {
            this.setTitle(" Import Policies");
        }
    }

    public void createContentMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        Menu menu = menuMgr.createContextMenu(this.m_treeViewer.getControl());
        this.m_treeViewer.getControl().setMenu(menu);
        PolicyListView.getInstance().getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.m_treeViewer);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    Object o;
                    StructuredSelection ssel = (StructuredSelection)PolicyRenamingDialog.this.m_treeViewer.getSelection();
                    if (!ssel.isEmpty() && (o = ssel.getFirstElement()) instanceof GroupTreeObject && !(o instanceof GroupTreeObjectLast)) {
                        GroupTreeObject gto = (GroupTreeObject)o;
                        manager.add((IAction)new AddGroupTreeObjectAction(PolicyRenamingDialog.this.m_treeViewer, gto, BMUI.type_tree_policy_renaming_dialog, null));
                    }
                }
                catch (RuntimeException e) {
                    RTLogger.print(5, "PolicyRenamingDialog: Error creating conten menu " + e);
                }
            }
        });
    }

    public void activatePrefixSuffix(boolean b) {
        this.m_prefixSuffix_radio.setSelection(b);
        this.m_guiElements.enableField(this.m_prefix_field, b);
        this.m_guiElements.enableField(this.m_suffix_field, b);
        if (b) {
            this.m_renamingValidation.resetTable();
        } else {
            this.m_prefix_field.setText("");
            this.m_suffix_field.setText("");
            this.m_prefix = "";
            this.m_suffix = "";
        }
    }

    public void activateFindReplace(boolean b) {
        this.m_findReplace_radio.setSelection(b);
        this.m_guiElements.enableField(this.m_find_field, b);
        this.m_guiElements.enableField(this.m_replace_field, b);
        if (b) {
            this.m_renamingValidation.resetTable();
        } else {
            this.m_find_field.setText("");
            this.m_replace_field.setText("");
            this.m_find = "";
            this.m_replace = "";
        }
    }

    public void activateCopying(boolean b) {
        if (b) {
            this.getButton(0).setText(COPY);
        } else {
            this.getButton(0).setText("Apply");
        }
        this.m_copy_chk.setSelection(b);
        this.m_copying_grp.setEnabled(b);
        this.m_treeViewer.getTree().setEnabled(b);
        if (!b) {
            this.m_treeViewer.getTree().deselectAll();
            this.m_target = null;
        }
    }

    public void checkButtonStatus() {
        int numOfItems = this.m_tableViewer.getTable().getItemCount();
        int selIndex = this.m_tableViewer.getTable().getSelectionIndex();
        if (numOfItems > 0) {
            if (selIndex != -1) {
                this.m_guiElements.enableField(this.m_removeLine_button, true);
            } else {
                this.m_guiElements.enableField(this.m_removeLine_button, false);
            }
            this.m_guiElements.enableField(this.m_removeConflicts_button, this.m_numOfConflicts > 0);
            if (this.m_isImportForced) {
                this.m_guiElements.enableField(this.getButton(0), true);
            } else {
                this.m_guiElements.enableField(this.getButton(0), this.m_isValid && this.m_numOfConflicts == 0);
            }
        } else if (numOfItems == 0) {
            this.m_guiElements.enableField(this.m_removeLine_button, false);
            this.m_guiElements.enableField(this.m_removeConflicts_button, false);
            this.m_guiElements.enableField(this.getButton(0), false);
        }
    }

    protected void okPressed() {
        boolean isOk = false;
        if (this.m_treeViewer.getSelection() == null || this.m_treeViewer.getSelection().isEmpty()) {
            this.m_treeViewer.getTree().setSelection(this.m_treeViewer.getTree().getItem(0));
        }
        if (this.m_actionType.equalsIgnoreCase(IMPORT_POLICY) || this.m_actionType.equalsIgnoreCase(IMPORT_POLICY_ONLY)) {
            Object obj;
            ISelection iSelect = this.m_treeViewer.getSelection();
            if (!iSelect.isEmpty() && (obj = ((IStructuredSelection)iSelect).getFirstElement()) != null && obj instanceof GroupTreeObject && !(obj instanceof GroupTreeObjectLast)) {
                isOk = true;
                this.m_target = (GroupTreeObject)obj;
                super.okPressed();
            }
            if (!isOk) {
                this.m_target = null;
                MessageDialog.openInformation((Shell)this.m_treeViewer.getControl().getShell(), (String)"Import Policy", (String)"Please select a Target Folder!");
            }
        } else {
            if (this.m_copy_chk != null && this.m_copy_chk.getSelection()) {
                Object obj;
                ISelection iSelect = this.m_treeViewer.getSelection();
                if (!iSelect.isEmpty() && (obj = ((IStructuredSelection)iSelect).getFirstElement()) != null && obj instanceof GroupTreeObject && !(obj instanceof GroupTreeObjectLast)) {
                    isOk = true;
                    this.m_target = (GroupTreeObject)obj;
                    super.okPressed();
                }
            } else {
                isOk = true;
                super.okPressed();
            }
            if (!isOk) {
                this.m_target = null;
                MessageDialog.openInformation((Shell)this.m_treeViewer.getControl().getShell(), (String)"Copy and Rename Policies", (String)"Select a Target Folder or deactivate the Section 'Enable copying to a different Group'!");
            }
        }
    }

    public HashMap<String, GroupTreeObjectLast> getElements() {
        return this.m_hashMap;
    }

    public HashMap<String, GroupTreeObjectLast> getConflicts() {
        return this.m_conflicts;
    }

    public void preview() {
        if (this.m_prefixSuffix_radio.getSelection()) {
            this.m_numOfConflicts = this.m_renamingValidation.preview(this.m_prefix, this.m_suffix, PREFIX_SUFFIX);
        } else if (this.m_findReplace_radio.getSelection()) {
            this.m_numOfConflicts = this.m_renamingValidation.preview(this.m_find, this.m_replace, FIND_REPLACE);
        }
        this.m_totalItems_label.setText("total: " + this.m_tableViewer.getTable().getItemCount() + " / selected: " + this.m_tableViewer.getTable().getSelectionCount());
        this.m_comp1.pack();
        if (this.m_numOfConflicts == 0) {
            this.m_conflicts_label.setVisible(false);
            this.m_guiElements.enableField(this.m_forceNewVersions_button, false);
        } else if (this.m_numOfConflicts > 0) {
            this.m_conflicts = this.m_renamingValidation.getConflicts();
            this.m_conflicts_label.setVisible(true);
            this.m_conflicts_label.setText("You have " + this.m_numOfConflicts + " Conflicts! ");
            this.m_guiElements.enableField(this.m_forceNewVersions_button, true);
        }
    }

    public boolean validateString(String text) {
        if ("".equals(text)) {
            return true;
        }
        return new NameValidatorPolicyName().isValid(text) == null;
    }

    public void modifyText(ModifyEvent e) {
        String name = null;
        if (e.getSource() instanceof Text) {
            Text text = (Text)e.getSource();
            name = (String)text.getData();
            if (name.equals(PREFIX)) {
                this.m_isValid = this.validateString(this.m_prefix_field.getText().trim());
                if (this.m_isValid) {
                    this.m_prefix = this.m_prefix_field.getText().trim();
                } else {
                    this.m_prefix_field.removeModifyListener((ModifyListener)this);
                    this.m_prefix_field.setText(this.m_prefix);
                    this.m_prefix_field.addModifyListener((ModifyListener)this);
                    try {
                        this.m_prefix_field.setSelection(this.m_prefix.length());
                    }
                    catch (Throwable throwable) {}
                }
            } else if (name.equals(SUFFIX)) {
                this.m_isValid = this.validateString(this.m_suffix_field.getText());
                if (this.m_isValid) {
                    this.m_suffix = this.m_suffix_field.getText().trim();
                } else {
                    this.m_suffix_field.removeModifyListener((ModifyListener)this);
                    this.m_suffix_field.setText(this.m_suffix);
                    this.m_suffix_field.addModifyListener((ModifyListener)this);
                    try {
                        this.m_suffix_field.setSelection(this.m_suffix.length());
                    }
                    catch (Throwable throwable) {}
                }
            } else if (name.equals(FIND)) {
                this.m_find = this.m_find_field.getText().trim();
            } else if (name.equals(REPLACE)) {
                this.m_isValid = this.validateString(this.m_replace_field.getText());
                if (this.m_isValid) {
                    this.m_replace = this.m_replace_field.getText().trim();
                } else {
                    this.m_replace_field.removeModifyListener((ModifyListener)this);
                    this.m_replace_field.setText(this.m_replace);
                    this.m_replace_field.addModifyListener((ModifyListener)this);
                    try {
                        this.m_replace_field.setSelection(this.m_replace.length());
                    }
                    catch (Throwable throwable) {}
                }
            }
            this.preview();
            this.checkButtonStatus();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        boolean selected = false;
        if (e.getSource() instanceof Button) {
            Button b = (Button)e.getSource();
            String buttonName = (String)b.getData();
            if (buttonName.equals(CHECK_COPY)) {
                this.activateCopying(this.m_copy_chk.getSelection());
            } else if (buttonName.equals(RADIO_PREFIX_SUFFIX)) {
                selected = this.m_prefixSuffix_radio.getSelection();
                this.activatePrefixSuffix(selected);
                this.activateFindReplace(!selected);
            } else if (buttonName.equals(RADIO_FIND_REPLACE)) {
                selected = this.m_findReplace_radio.getSelection();
                this.activateFindReplace(selected);
                this.activatePrefixSuffix(!selected);
            } else if (buttonName.equals(BUTTON_REMOVE_CONFLICTS)) {
                this.m_renamingValidation.removeConflicts();
                this.preview();
                this.checkButtonStatus();
            } else if (buttonName.equals(BUTTON_REMOVE_LINES)) {
                this.m_renamingValidation.removeLines();
                this.preview();
                this.checkButtonStatus();
            } else if (buttonName.equals(BUTTON_FORCE_NEW_VERSIONS)) {
                this.m_isImportForced = b.getSelection();
                this.checkButtonStatus();
            }
        } else if (e.getSource() instanceof Table) {
            this.m_guiElements.enableField(this.m_removeLine_button, true);
            this.m_totalItems_label.setText("total: " + this.m_tableViewer.getTable().getItemCount() + " / selected: " + this.m_tableViewer.getTable().getSelectionCount());
            this.m_comp1.pack();
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        ISelection iSelect = event.getViewer().getSelection();
        Object obj = ((IStructuredSelection)iSelect).getFirstElement();
        if (obj instanceof GroupTreeObject && !(obj instanceof GroupTreeObjectLast)) {
            if (this.m_treeViewer.getExpandedState(obj)) {
                this.m_treeViewer.collapseToLevel(obj, -1);
            } else {
                this.m_treeViewer.expandToLevel(obj, 1);
            }
        }
    }

    public boolean isImportForced() {
        return this.m_isImportForced;
    }

    public void widgetDisposed(DisposeEvent e) {
        try {
            this.m_parentComp.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_leftComp.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_previewComp.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_btnComp.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_comp.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_prefixSuffix_grp.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_findReplace_grp.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_renaming_grp.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_copying_grp.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_totalItems_label.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_conflicts_label.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_prefix_field.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_suffix_field.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_find_field.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_replace_field.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_prefixSuffix_radio.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_findReplace_radio.dispose();
        }
        catch (Throwable throwable) {}
        try {
            if (this.m_copy_chk != null) {
                this.m_copy_chk.dispose();
            }
        }
        catch (Throwable throwable) {}
        try {
            this.m_removeLine_button.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_removeConflicts_button.dispose();
        }
        catch (Throwable throwable) {}
        try {
            if (this.m_forceNewVersions_button != null) {
                this.m_forceNewVersions_button.dispose();
            }
        }
        catch (Throwable throwable) {}
    }
}

