/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.dialogs;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.utils.ScheduleComposite;
import com.blixx.shared.MsgPolicy;
import com.blixx.shared.Policy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PolicySchedulerDialog
extends StatusDialog
implements SelectionListener {
    private GUIDisplayElements m_gui = null;
    private ScrolledComposite m_sc = null;
    private Composite m_topComp = null;
    private Button m_selAll_chk = null;
    private boolean m_isReadOnly = false;
    public String m_deactivation_str = null;
    private Object m_policy = null;
    private List<Composite> m_compositesToDelete = null;
    private Map<Composite, ScheduleComposite> m_map = null;
    public static String SEL_CHKBOX = "SEL_CHKBOX";
    public static String DELETE_LINE = "DELETE_LINE";
    public static String ADD_LINE = "ADD_LINE";
    public static String SELECT_ALL = "SELECT_ALL";

    public PolicySchedulerDialog(Shell parentShell, Object policy, boolean isReadOnly) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x80 | 0x400);
        this.setImage(BMUI.IMAGE_PRODUCT);
        this.setTitle("   Deactivation Schedule");
        this.m_policy = policy;
        if (policy instanceof MsgPolicy) {
            this.m_deactivation_str = ((MsgPolicy)this.m_policy).getDeactivationTimes();
        } else if (policy instanceof Policy) {
            this.m_deactivation_str = ((Policy)this.m_policy).getDeactivationTimes();
        }
        this.m_isReadOnly = isReadOnly;
    }

    protected Control createDialogArea(Composite parent) {
        this.m_gui = new GUIDisplayElements();
        this.m_map = new HashMap<Composite, ScheduleComposite>();
        this.m_compositesToDelete = new ArrayList<Composite>();
        Label title = this.m_gui.addTextField(parent, null, "Deactivation Schedule Configuration:", 1, 1, 10, 0, BMUI.font_arial8_bold);
        ((GridData)title.getLayoutData()).horizontalIndent = 8;
        this.m_sc = new ScrolledComposite(parent, 2816);
        this.m_sc.setAlwaysShowScrollBars(false);
        this.m_sc.setExpandHorizontal(true);
        this.m_sc.setExpandVertical(true);
        this.m_sc.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(4, 4, true, true);
        gd.verticalIndent = 10;
        this.m_sc.setLayoutData((Object)gd);
        this.m_topComp = new Composite((Composite)this.m_sc, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginRight = 5;
        gl.marginLeft = 5;
        this.m_topComp.setLayout((Layout)gl);
        this.m_topComp.setLayoutData((Object)new GridData(4, 4, true, true));
        if (this.m_deactivation_str == null) {
            ScheduleComposite scheduleComp = new ScheduleComposite(this.m_topComp, 0, "0", true);
            Composite checkBoxComp = this.createCheckBoxComposite(this.m_topComp);
            scheduleComp.setEnabled(!this.m_isReadOnly);
            checkBoxComp.setEnabled(!this.m_isReadOnly);
            this.m_map.put(checkBoxComp, scheduleComp);
        } else {
            String[] lines = this.m_deactivation_str.split("\\n");
            int i = 0;
            while (i < lines.length) {
                ScheduleComposite scheduleComp = new ScheduleComposite(this.m_topComp, 0, lines[i], true);
                Composite checkBoxComp = this.createCheckBoxComposite(this.m_topComp);
                scheduleComp.setEnabled(!this.m_isReadOnly);
                checkBoxComp.setEnabled(!this.m_isReadOnly);
                this.m_map.put(checkBoxComp, scheduleComp);
                ++i;
            }
        }
        Composite compBtn = new Composite(parent, 0);
        gl = new GridLayout(3, false);
        gl.marginHeight = 0;
        gl.marginTop = 5;
        gl.marginRight = 10;
        compBtn.setLayout((Layout)gl);
        compBtn.setLayoutData((Object)new GridData(4, 4, true, false));
        this.m_gui.addButton(compBtn, ADD_LINE, " Add Schedule ", !this.m_isReadOnly, 90, 20, 0, this);
        this.m_gui.addButton(compBtn, DELETE_LINE, " Delete Schedule ", !this.m_isReadOnly, 90, 20, 0, this);
        this.m_selAll_chk = this.m_gui.addCheckbox(compBtn, SELECT_ALL, "Select All", false, 1, 1, 0, this);
        this.m_selAll_chk.setEnabled(!this.m_isReadOnly);
        ((GridData)this.m_selAll_chk.getLayoutData()).horizontalAlignment = 131072;
        ((GridData)this.m_selAll_chk.getLayoutData()).grabExcessHorizontalSpace = true;
        this.m_sc.setContent((Control)this.m_topComp);
        this.m_sc.setMinSize(this.m_topComp.computeSize(-1, -1, true));
        return parent;
    }

    public Composite createCheckBoxComposite(Composite parent) {
        Composite checkBoxComp = new Composite(parent, 0);
        checkBoxComp.setLayout((Layout)new GridLayout(1, false));
        checkBoxComp.setLayoutData((Object)new GridData(4, 4, false, false));
        this.m_gui.addTextField(checkBoxComp, null, "Delete", 1, 1, 1, 1, null);
        Button chkBox = this.m_gui.addCheckbox(checkBoxComp, SEL_CHKBOX, "", false, 1, 1, 0, this);
        ((GridData)chkBox.getLayoutData()).horizontalAlignment = 0x1000000;
        return checkBoxComp;
    }

    public void addLine() {
        ScheduleComposite sComp = new ScheduleComposite(this.m_topComp, 0, "", true);
        Composite checkBoxComp = this.createCheckBoxComposite(this.m_topComp);
        this.m_map.put(checkBoxComp, sComp);
        this.m_sc.setContent((Control)this.m_topComp);
        this.m_sc.setMinSize(this.m_topComp.computeSize(-1, -1, true));
    }

    public void deleteLine() {
        int ii = 0;
        while (ii < this.m_compositesToDelete.size()) {
            Composite chkBoxCompToDelete = this.m_compositesToDelete.get(ii);
            ScheduleComposite sCompToDelete = this.m_map.get(chkBoxCompToDelete);
            try {
                chkBoxCompToDelete.dispose();
            }
            catch (Throwable throwable) {}
            try {
                sCompToDelete.dispose();
                this.m_map.remove(chkBoxCompToDelete);
            }
            catch (Throwable throwable) {}
            ++ii;
        }
        this.m_compositesToDelete.clear();
        this.m_selAll_chk.setSelection(false);
        this.m_sc.setContent((Control)this.m_topComp);
        this.m_sc.setMinSize(this.m_topComp.computeSize(-1, -1, true));
    }

    public void selectAll(boolean doSelectAll) {
        if (this.m_map.isEmpty()) {
            this.m_selAll_chk.setSelection(false);
            return;
        }
        for (Composite selComp : this.m_map.keySet()) {
            Control[] controls = selComp.getChildren();
            int i = 0;
            while (i < controls.length) {
                if (controls[i] instanceof Button) {
                    Button chkBox = (Button)controls[i];
                    chkBox.setSelection(doSelectAll);
                    if (doSelectAll) {
                        this.m_compositesToDelete.add(selComp);
                    } else {
                        this.m_compositesToDelete.remove(selComp);
                    }
                }
                ++i;
            }
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button saveBtn = this.createButton(parent, 0, "Save", false);
        if (this.m_isReadOnly) {
            GUIDisplayElements gui = new GUIDisplayElements();
            gui.enableField(saveBtn, false);
        }
        this.createButton(parent, 1, "Cancel", false);
    }

    public boolean close() {
        try {
            this.m_topComp.dispose();
        }
        catch (Throwable throwable) {}
        return super.close();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        String name = "";
        Object obj = e.getSource();
        if (obj instanceof Button) {
            Button b = (Button)obj;
            name = (String)b.getData();
            if (name.equals(ADD_LINE)) {
                this.addLine();
            } else if (name.equals(DELETE_LINE)) {
                this.deleteLine();
            } else if (name.equals(SEL_CHKBOX)) {
                Boolean selected = b.getSelection();
                Composite selComp = b.getParent();
                if (selected.booleanValue()) {
                    this.m_compositesToDelete.add(selComp);
                } else if (this.m_compositesToDelete.contains(selComp)) {
                    this.m_compositesToDelete.remove(selComp);
                }
                if (this.m_selAll_chk.getSelection()) {
                    this.m_selAll_chk.setSelection(false);
                }
            } else if (name.equals(SELECT_ALL)) {
                this.selectAll(b.getSelection());
            }
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1) {
            super.cancelPressed();
        } else if (buttonId == 0) {
            ArrayList<String> arr = new ArrayList<String>();
            Control[] controls = this.m_topComp.getChildren();
            int i = 0;
            while (i < controls.length) {
                ScheduleComposite comp;
                String line;
                if (controls[i] instanceof ScheduleComposite && (line = (comp = (ScheduleComposite)controls[i]).getConfigLine()) != null) {
                    arr.add(line);
                }
                ++i;
            }
            if (arr.size() > 0) {
                StringBuffer sb = new StringBuffer();
                Iterator it = arr.iterator();
                while (it.hasNext()) {
                    sb.append((String)it.next());
                    if (!it.hasNext()) continue;
                    sb.append("\n");
                }
                this.m_deactivation_str = sb.toString();
            } else {
                this.m_deactivation_str = null;
            }
            super.okPressed();
        }
    }

    protected Point getInitialSize() {
        return this.getShell().computeSize(-1, 350, true);
    }
}

