/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.dialogs;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.policies.PolicyManager;
import com.blixx.boom.gui.policies.PolicyTreeProvider;
import com.blixx.boom.gui.policies.ViewContentProvider;
import com.blixx.boom.gui.policies.ViewLabelProvider;
import com.blixx.boom.gui.utils.FilterComposite;
import com.blixx.boom.gui.utils.STreeViewer;
import com.blixx.boom.gui.utils.TreeElementComparer;
import com.blixx.boom.gui.views.actions.ExpandCollapseAction;
import com.blixx.log.RTLogger;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.GroupTreeObjectUnsubmitted;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;

public class PolicyTreeDialog
extends Dialog {
    protected STreeViewer treeViewer = null;
    public GroupTreeObject policyROOT = null;
    public static String TREE_VIEWER_TYPE = "TREE_VIEWER_TYPE";
    public static String POLICY_LIST = "POLICY_LIST";
    private ArrayList<Object> selectedPolicies = null;
    private String title = null;

    public PolicyTreeDialog(Shell parentShell, String title) {
        super(parentShell);
        this.title = title;
        this.setShellStyle(1040);
        PolicyTreeDialog.setDefaultImage((Image)BMUI.IMAGE_PRODUCT);
        this.selectedPolicies = new ArrayList();
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComp = (Composite)super.createDialogArea(parent);
        parentComp.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 500;
        gd.heightHint = 600;
        parentComp.setLayoutData((Object)gd);
        new FilterComposite(parentComp, (Object)this);
        Composite comp = new Composite(parentComp, 0);
        comp.setLayout((Layout)new GridLayout(1, false));
        comp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.treeViewer = new STreeViewer(comp, 268438274);
        this.treeViewer.setData(TREE_VIEWER_TYPE, POLICY_LIST);
        this.treeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.setComparer(new TreeElementComparer());
        this.treeViewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider(null, this.treeViewer));
        this.policyROOT = PolicyTreeProvider.getInstance().createPolicyTree();
        this.treeViewer.setInput(this.policyROOT);
        this.treeViewer.expandToLevel(2);
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TreeViewer tv = (TreeViewer)event.getViewer();
                StructuredSelection sel = (StructuredSelection)tv.getSelection();
                Object o = sel.getFirstElement();
                if (o instanceof GroupTreeObject && !(o instanceof GroupTreeObjectLast)) {
                    tv.setExpandedState(o, !tv.getExpandedState(o));
                }
            }
        });
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                Object obj = selection.getFirstElement();
                if (obj != null && obj instanceof GroupTreeObject) {
                    GroupTreeObject gto = (GroupTreeObject)obj;
                    boolean isValidSelection = true;
                    if (gto.getTreeObject().getType().equals(BMUI.type_toplevel)) {
                        isValidSelection = false;
                    }
                    PolicyTreeDialog.this.getButton(0).setEnabled(isValidSelection);
                }
            }
        });
        this.createTreeContentMenu();
        return parentComp;
    }

    public void createTreeContentMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(false);
        Menu menu = menuMgr.createContextMenu(this.treeViewer.getControl());
        this.treeViewer.getControl().setMenu(menu);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    manager.add((IAction)new ExpandCollapseAction(PolicyTreeDialog.this.treeViewer, "ExpandAll"));
                    manager.add((IAction)new ExpandCollapseAction(PolicyTreeDialog.this.treeViewer, "CollapseAll"));
                }
                catch (RuntimeException e) {
                    RTLogger.print(4, "", e);
                }
            }
        });
    }

    protected void okPressed() {
        block7: {
            StructuredSelection sel = (StructuredSelection)this.treeViewer.getSelection();
            try {
                if (sel.isEmpty()) break block7;
                for (Object obj : sel) {
                    if (obj instanceof GroupTreeObjectUnsubmitted) continue;
                    if (obj instanceof GroupTreeObjectLast) {
                        GroupTreeObjectLast gtol = (GroupTreeObjectLast)obj;
                        if (!PolicyManager.getInstance().isPermittedPolicyModify(gtol)) {
                            return;
                        }
                        this.selectedPolicies.add(gtol);
                        continue;
                    }
                    if (!(obj instanceof GroupTreeObject)) continue;
                    GroupTreeObject gto = (GroupTreeObject)obj;
                    if (!gto.getTreeObject().getType().equals(BMUI.type_toplevel)) {
                        if (!PolicyManager.getInstance().isPermittedPolicyModifyRecursive(gto)) {
                            return;
                        }
                        this.selectedPolicies.add(gto);
                        continue;
                    }
                    break;
                }
            }
            catch (RuntimeException e) {
                RTLogger.print(4, "", e);
            }
        }
        super.okPressed();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button okBtn = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        okBtn.setEnabled(false);
        Button cancelBtn = this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        cancelBtn.setEnabled(true);
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public List<Object> getSelectedPolicies() {
        return this.selectedPolicies;
    }
}

