/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.dialogs;

import com.blixx.boom.engine.UIJob;
import com.blixx.boom.engine.UIJobManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.ui.PlatformUI;

public class ProgressDialog
extends Dialog {
    private String m_title = "";
    private String m_message = "Processing...";
    private ProgressBar m_pb = null;
    private int m_min = 0;
    private int m_max = 10;
    private int m_current = 0;
    private Label m_msgLabel;
    private Label m_countLabel;

    public ProgressDialog(String title, String text, int min, int max) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.setShellStyle(16481);
        this.m_title = title;
        this.m_message = text;
        this.m_min = min;
        this.m_max = max + 1;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.m_title);
        Composite comp = new Composite(parent, 0);
        GridLayout gdLayout = new GridLayout(1, false);
        gdLayout.marginTop = 10;
        gdLayout.marginLeft = 15;
        gdLayout.marginBottom = 10;
        gdLayout.marginRight = 15;
        comp.setLayout((Layout)gdLayout);
        GridData gdLabel = new GridData();
        gdLabel.horizontalSpan = 1;
        gdLabel.verticalSpan = 1;
        gdLabel.verticalAlignment = 1;
        gdLabel.verticalIndent = 0;
        gdLabel.horizontalIndent = 0;
        gdLabel.widthHint = 500;
        this.m_msgLabel = new Label(comp, 0);
        this.m_msgLabel.setText(this.m_message);
        this.m_msgLabel.setLayoutData((Object)gdLabel);
        this.m_pb = new ProgressBar(comp, 256);
        this.m_pb.setMaximum(this.m_max);
        this.m_pb.setMinimum(this.m_min);
        this.m_pb.setLayoutData((Object)gdLabel);
        this.m_countLabel = new Label(comp, 0);
        this.m_countLabel.setText(String.valueOf(this.m_current) + " of " + (this.m_max - 1) + "    ");
        this.m_countLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        return comp;
    }

    protected Control createButtonBar(Composite parent) {
        return null;
    }

    public void setMaximum(int max) {
        this.m_max = max;
        UIJob job = new UIJob("progress-" + (Object)((Object)this)){

            @Override
            public IStatus runInUIThread(IProgressMonitor monitor) {
                ProgressDialog.this.m_pb.setMaximum(ProgressDialog.this.m_max);
                return null;
            }
        };
        UIJobManager.getInstance().schedule(job);
    }

    public int getMaximum() {
        return this.m_max;
    }

    public int getCurrent() {
        return this.m_current;
    }

    public void setProgress(final String text, final int progress) {
        UIJob job = new UIJob("progress-" + (Object)((Object)this)){

            @Override
            public IStatus runInUIThread(IProgressMonitor monitor) {
                int n = progress;
                if (n < ProgressDialog.this.m_min) {
                    n = ProgressDialog.this.m_min;
                }
                if (n > ProgressDialog.this.m_max) {
                    n = ProgressDialog.this.m_max;
                }
                ProgressDialog.this.m_msgLabel.setText(text);
                ProgressDialog.this.m_current = n;
                ProgressDialog.this.m_pb.setSelection(n);
                ProgressDialog.this.m_countLabel.setText(String.valueOf(ProgressDialog.this.m_current) + " of " + (ProgressDialog.this.m_max - 1) + "   ");
                ProgressDialog.this.m_countLabel.pack();
                return null;
            }
        };
        UIJobManager.getInstance().schedule(job);
    }
}

