/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.dialogs;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.policies.PolicyOverviewTableProvider;
import com.blixx.boom.gui.policies.ViewContentProvider;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.utils.STreeViewer;
import com.blixx.boom.gui.views.AssignmentListView;
import com.blixx.boom.gui.views.StyledTreeLabelProvider;
import com.blixx.boom.gui.views.actions.SelectAgentInTreeAction;
import com.blixx.boom.gui.views.actions.SelectAssignmentInTreeAction;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.TreeObject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class RelatedBinaryInfoDialog
extends Dialog
implements IDoubleClickListener {
    private GroupTreeObject m_pkgGTO = null;
    private Composite m_topComp = null;
    private Table m_asnTable = null;
    private Table m_agentTable = null;
    private TableViewer m_asn_tv = null;
    private TableViewer m_agent_tv = null;
    private List<AgentCard> m_agents = new ArrayList<AgentCard>();
    private List<String> m_assignments = new ArrayList<String>();
    private GUIDisplayElements m_gui = null;
    private static String VIEWER_TYPE = "VIEWER_TYPE";
    public static String AGENT_TABLE = "AGENT_TABLE";
    public static String ASN_TABLE = "ASN_TABLE";
    private boolean m_hasAsnRights = true;
    private boolean m_hasAgentRights = true;

    public RelatedBinaryInfoDialog(Shell parentShell, StructuredSelection ssel) {
        super(parentShell);
        GroupTreeObject gto;
        super.setShellStyle(66704);
        if (Repository.getInstance().getRights(1008) < 2) {
            this.m_hasAsnRights = false;
        }
        if (Repository.getInstance().getRights(1002) < 2) {
            this.m_hasAgentRights = false;
        }
        if (ssel.getFirstElement() instanceof GroupTreeObject && (gto = (GroupTreeObject)ssel.getFirstElement()) != null && gto.getType().equals(BMUI.type_assignment_bin)) {
            this.m_pkgGTO = gto;
        }
        if (this.m_pkgGTO != null) {
            this.m_agents = PolicyOverviewTableProvider.getRelatedAgentCards(this.m_pkgGTO.getName(), BMUI.type_assignment_bin);
            this.m_assignments = RelatedBinaryInfoDialog.getRelatedAssignments(this.m_pkgGTO.getName());
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.m_gui = new GUIDisplayElements();
        this.m_topComp = (Composite)super.createDialogArea(parent);
        GridLayout gl = new GridLayout(4, false);
        gl.verticalSpacing = 0;
        this.m_topComp.setLayout((Layout)gl);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 600;
        gd.heightHint = !this.m_hasAgentRights && !this.m_hasAsnRights ? 150 : 400;
        this.m_topComp.setLayoutData((Object)gd);
        this.createInfoSection();
        if (this.m_hasAgentRights) {
            this.createAgentTable();
        }
        if (this.m_hasAsnRights) {
            this.createPkgTable();
        }
        this.m_gui.addTextReadOnlyNoBorder(this.m_topComp, null, "Number of Agents:", 1, 1, 0, 5, null);
        Text m_AgentCount = this.m_gui.addTextReadOnlyNoBorder(this.m_topComp, null, "" + this.m_agents.size(), 1, 1, 0, 5, null);
        ((GridData)m_AgentCount.getLayoutData()).widthHint = 40;
        this.m_gui.addTextReadOnlyNoBorder(this.m_topComp, null, "Number of Assignments:", 1, 1, 0, 5, null);
        Text m_AsnCount = this.m_gui.addTextReadOnlyNoBorder(this.m_topComp, null, "" + this.m_assignments.size(), 1, 1, 0, 5, null);
        ((GridData)m_AsnCount.getLayoutData()).widthHint = 40;
        return this.m_topComp;
    }

    private void createInfoSection() {
        Composite imageComp = new Composite(this.m_topComp, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginBottom = 20;
        imageComp.setLayout((Layout)gl);
        imageComp.setLayoutData((Object)new GridData(1, 128, false, false, 4, 1));
        Label l = new Label(imageComp, 0);
        l.setImage(BMUI.IMAGE_PKG);
        l = new Label(imageComp, 0);
        l.setText(this.m_pkgGTO.getName());
        l.setFont(BMUI.font_arial8_bold);
    }

    private void createAgentTable() {
        this.m_agentTable = new Table(this.m_topComp, 68354);
        this.m_agentTable.setData((Object)AGENT_TABLE);
        this.m_agentTable.setHeaderVisible(true);
        this.m_agentTable.setLinesVisible(false);
        this.m_agentTable.setLayout((Layout)new GridLayout());
        this.m_agentTable.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        TableColumn col = new TableColumn(this.m_agentTable, 16384);
        col.setText("Single deployed on ...");
        col.setWidth(280);
        int i = 0;
        while (i < this.m_agents.size()) {
            AgentCard ac = this.m_agents.get(i);
            TableItem item = new TableItem(this.m_agentTable, 0);
            item.setData((Object)ac.getAgentID());
            item.setText(String.valueOf(ac.getComparableName()) + " (" + ac.getAgentIP() + ")");
            item.setImage(AgentCard.getOSIcon(ac.getOSName()));
            ++i;
        }
        this.m_agent_tv = new TableViewer(this.m_agentTable);
        this.m_agent_tv.setData(VIEWER_TYPE, (Object)AGENT_TABLE);
        this.m_agent_tv.addDoubleClickListener((IDoubleClickListener)this);
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(false);
        Menu menu = menuMgr.createContextMenu(this.m_agent_tv.getControl());
        this.m_agent_tv.getControl().setMenu(menu);
    }

    private void createPkgTable() {
        GridData gd = new GridData(4, 4, true, true, 2, 1);
        int width = 280;
        if (!this.m_hasAgentRights) {
            gd = new GridData(4, 4, true, true, 3, 1);
            width = 550;
        }
        GroupTreeObject asnRoot = new GroupTreeObject(new TreeObject("root", BMUI.type_toplevel, null));
        GroupTreeObject allAssigments = Repository.getInstance().getAllAssignments().getAllAssignmentRoot();
        int i = 0;
        while (i < this.m_assignments.size()) {
            String asn_name = this.m_assignments.get(i);
            List<GroupTreeObject> asn = allAssigments.findElements(asn_name, BMUI.type_assignment_pol);
            if (asn.size() > 0) {
                asnRoot.addElements(asn);
            } else {
                asnRoot.addElement(new GroupTreeObject(new TreeObject(asn_name, BMUI.type_assignment_pol, null)));
            }
            ++i;
        }
        STreeViewer asn_tv = new STreeViewer(this.m_topComp, 268503810);
        asn_tv.setData(VIEWER_TYPE, ASN_TABLE);
        asn_tv.setUseHashlookup(true);
        asn_tv.setContentProvider((IContentProvider)new ViewContentProvider());
        asn_tv.setLabelProvider((IBaseLabelProvider)new StyledTreeLabelProvider());
        asn_tv.setInput(asnRoot);
        asn_tv.collapseAll();
        asn_tv.addDoubleClickListener(this);
        Tree asn_tree = asn_tv.getTree();
        asn_tree.setLayout((Layout)new GridLayout());
        asn_tree.setLayoutData((Object)gd);
        asn_tree.setHeaderVisible(true);
        TreeColumn column1 = new TreeColumn(asn_tree, 16384);
        column1.setText("Related Assignments");
        column1.setWidth(width);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "OK", false);
    }

    public boolean close() {
        try {
            this.m_topComp.dispose();
        }
        catch (Throwable throwable) {}
        return super.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("  Related Package Information");
        newShell.setImage(BMUI.IMAGE_PRODUCT);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void doubleClick(DoubleClickEvent event) {
        TreeViewer treeViewer;
        TreeItem[] sel;
        Viewer viewer = event.getViewer();
        if (viewer instanceof TableViewer) {
            TableViewer tableViewer = (TableViewer)viewer;
            TableItem[] sel2 = tableViewer.getTable().getSelection();
            if (sel2 != null && sel2.length > 0) {
                TableItem ti = sel2[0];
                String agentID = (String)ti.getData();
                SelectAgentInTreeAction action = new SelectAgentInTreeAction(agentID);
                action.run();
            }
        } else if (viewer instanceof TreeViewer && (sel = (treeViewer = (TreeViewer)viewer).getTree().getSelection()) != null && sel.length > 0) {
            TreeItem ti = sel[0];
            String asnName = ti.getText();
            SelectAssignmentInTreeAction selectAction = new SelectAssignmentInTreeAction(asnName);
            selectAction.run();
        }
    }

    public static ArrayList<String> getRelatedAssignments(String pkgName) {
        ArrayList<String> relatedAsn = new ArrayList<String>();
        if (AssignmentListView.getInstance() == null) {
            return relatedAsn;
        }
        List<GroupTreeObject> elem = AssignmentListView.getInstance().m_assignmentROOT.getElements();
        if (elem != null && elem.size() > 0) {
            GroupTreeObject root = elem.get(0);
            List<GroupTreeObject> assignments = root.getElements();
            int i = 0;
            while (i < assignments.size()) {
                GroupTreeObject asnGTO;
                GroupTreeObject o = assignments.get(i);
                if (o instanceof GroupTreeObject && !(o instanceof GroupTreeObjectLast) && (asnGTO = o).getTreeObject().getType().equals(BMUI.type_assignment_pol)) {
                    List<GroupTreeObject> elements = asnGTO.getAllElements();
                    int ii = 0;
                    while (ii < elements.size()) {
                        String last;
                        GroupTreeObjectLast gtol;
                        String[] split;
                        GroupTreeObject obj = elements.get(ii);
                        if (obj instanceof GroupTreeObjectLast && (split = (gtol = (GroupTreeObjectLast)obj).getLinkedPath().split("/")).length != 0 && pkgName.equals(last = split[split.length - 1])) {
                            String asnName = asnGTO.getTreeObject().getName();
                            if (relatedAsn.contains(asnName)) break;
                            relatedAsn.add(asnName);
                            break;
                        }
                        ++ii;
                    }
                }
                ++i;
            }
        }
        return relatedAsn;
    }
}

