/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.dialogs;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.views.AgentOverviewTableProvider;
import com.blixx.boom.gui.views.NodeListView;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class RelatedHostInfoDialog
extends Dialog
implements IDoubleClickListener {
    private AgentCard m_ac = null;
    private TableViewer m_tableViewer = null;
    private Composite m_topComp = null;
    private Table m_table = null;
    private Image m_statusImage = null;
    private Image m_osImage = null;
    private GUIDisplayElements m_gui = null;
    private static String VIEWER_TYPE = "VIEWER_TYPE";
    public static String REL_HOST_GROUPS_TABLE = "REL_HOST_GROUPS_TABLE";

    public RelatedHostInfoDialog(Shell parentShell, AgentCard ac) {
        super(parentShell);
        super.setShellStyle(66704);
        RelatedHostInfoDialog.setDefaultImage((Image)BMUI.IMAGE_PRODUCT);
        this.m_ac = ac;
        this.m_statusImage = AgentOverviewTableProvider.getImage(0, ac);
        this.m_osImage = AgentOverviewTableProvider.getImage(1, ac);
    }

    protected Control createDialogArea(Composite parent) {
        this.m_gui = new GUIDisplayElements();
        this.m_topComp = (Composite)super.createDialogArea(parent);
        this.m_topComp.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 500;
        gd.heightHint = 400;
        this.m_topComp.setLayoutData((Object)gd);
        this.createTable();
        return this.m_topComp;
    }

    private void createTable() {
        Composite comp = new Composite(this.m_topComp, 0);
        GridLayout gl = new GridLayout(3, false);
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 7;
        comp.setLayout((Layout)gl);
        comp.setLayoutData((Object)new GridData(1, 128, false, false, 3, 1));
        Label l = new Label(comp, 0);
        if (this.m_statusImage != null) {
            l.setImage(this.m_statusImage);
        }
        l = new Label(comp, 0);
        l.setText(AgentOverviewTableProvider.getText(1, this.m_ac));
        l.setFont(BMUI.font_arial8_bold);
        Composite detailsComp = new Composite(this.m_topComp, 0);
        gl = new GridLayout(3, false);
        gl.verticalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginBottom = 5;
        detailsComp.setLayout((Layout)gl);
        detailsComp.setLayoutData((Object)new GridData(1, 128, false, false, 3, 1));
        l = new Label(detailsComp, 0);
        l.setText("OS:");
        l = new Label(detailsComp, 0);
        if (this.m_osImage != null) {
            l.setImage(this.m_osImage);
        }
        l = new Label(detailsComp, 0);
        l.setText(AgentOverviewTableProvider.getText(0, this.m_ac));
        this.m_gui.addTextReadOnlyNoBorder(detailsComp, "Agent ID:", AgentOverviewTableProvider.getText(13, this.m_ac), 2, 1, 1, 1, null);
        this.m_gui.addTextReadOnlyNoBorder(detailsComp, "IP:", AgentOverviewTableProvider.getText(7, this.m_ac), 2, 1, 1, 1, null);
        this.m_gui.addTextReadOnlyNoBorder(detailsComp, "Disabled:", "" + this.m_ac.isDisabled(), 2, 1, 1, 1, null);
        this.m_gui.addTextReadOnlyNoBorder(detailsComp, "Version:", AgentOverviewTableProvider.getText(6, this.m_ac), 2, 1, 1, 1, null);
        this.m_gui.addTextReadOnlyNoBorder(detailsComp, "Port:", AgentOverviewTableProvider.getText(8, this.m_ac), 2, 1, 1, 1, null);
        this.m_gui.addTextReadOnlyNoBorder(detailsComp, "Host:", AgentOverviewTableProvider.getText(10, this.m_ac), 2, 1, 1, 1, null);
        String days = "";
        String lastM = AgentOverviewTableProvider.getText(11, this.m_ac);
        days = lastM.trim().equals("") ? "-" : (lastM.trim().equals("0") ? "today" : (lastM.trim().equals("1") ? "1 day ago" : String.valueOf(lastM.trim()) + " days ago"));
        this.m_gui.addTextReadOnlyNoBorder(detailsComp, "Last Indication:  ", days, 2, 1, 1, 1, null);
        this.m_gui.addTextReadOnlyNoBorder(detailsComp, "BOOM Server:", AgentOverviewTableProvider.getText(12, this.m_ac), 2, 1, 1, 1, null);
        this.m_table = new Table(this.m_topComp, 68354);
        this.m_table.setData((Object)REL_HOST_GROUPS_TABLE);
        this.m_table.setHeaderVisible(true);
        this.m_table.setLinesVisible(false);
        gl = new GridLayout();
        gl.marginHeight = 0;
        gl.verticalSpacing = 0;
        this.m_table.setLayout((Layout)gl);
        this.m_table.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        TableColumn col1 = new TableColumn(this.m_table, 16384);
        col1.setText("Related Host Groups:  _Groups/...");
        col1.setWidth(280);
        String grpStr = this.m_ac.getRelatedNodeGroups();
        String sep = null;
        if (grpStr.contains("|")) {
            sep = "\\|";
        } else if (grpStr.contains("\n")) {
            sep = "\n";
        }
        if (sep != null) {
            String[] relGroups = grpStr.split(sep);
            int i = 0;
            while (i < relGroups.length) {
                String grp = relGroups[i].trim();
                if (grp.length() > 0) {
                    TableItem item = new TableItem(this.m_table, 0);
                    item.setText(grp);
                }
                ++i;
            }
        } else if (grpStr.length() > 0) {
            TableItem item = new TableItem(this.m_table, 0);
            item.setText(grpStr);
        }
        this.m_tableViewer = new TableViewer(this.m_table);
        this.m_tableViewer.setData(VIEWER_TYPE, (Object)REL_HOST_GROUPS_TABLE);
        this.m_tableViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.m_gui.addTextReadOnlyNoBorder(this.m_topComp, null, "Number of Related Groups: ", 1, 1, 0, 0, null);
        this.m_gui.addTextReadOnlyNoBorder(this.m_topComp, null, "" + this.m_table.getItemCount(), 1, 1, 0, 0, null);
    }

    protected void okPressed() {
        super.okPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "OK", false);
    }

    public boolean close() {
        try {
            this.m_table.dispose();
        }
        catch (Throwable throwable) {}
        return super.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("  Related Host Information");
        newShell.setImage(BMUI.IMAGE_PRODUCT);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void doubleClick(DoubleClickEvent event) {
        TableViewer tableViewer = (TableViewer)event.getViewer();
        TableItem[] sel = tableViewer.getTable().getSelection();
        if (sel.length > 0) {
            String prefix;
            String group = sel[0].getText();
            if (!group.startsWith(prefix = "/root/_Groups/")) {
                group = String.valueOf(prefix) + group;
            }
            NodeListView.setTreeSelectionAgentLink(group, this.m_ac);
        }
    }
}

