/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.dialogs;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.policies.PolicyManager;
import com.blixx.boom.gui.policies.PolicyOverviewTableProvider;
import com.blixx.boom.gui.policies.ViewContentProvider;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.utils.STreeViewer;
import com.blixx.boom.gui.views.StyledTreeLabelProvider;
import com.blixx.boom.gui.views.actions.SelectAgentInTreeAction;
import com.blixx.boom.gui.views.actions.SelectAssignmentInTreeAction;
import com.blixx.shared.MsgPolicy;
import com.blixx.shared.Policy;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.TreeObject;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class RelatedPolicyInfoDialog
extends Dialog
implements IDoubleClickListener {
    private Image m_image = null;
    private String m_polType4Display = null;
    private String m_polType = "";
    private String m_name = "";
    private String m_version = "";
    private String m_group = "";
    private String m_application = "";
    private String m_callType = "";
    private String m_path = "";
    private Composite m_topComp = null;
    private Composite m_middleComp = null;
    private List<AgentCard> m_relAgents = new ArrayList<AgentCard>();
    private List<String> m_rel_asn_names = new ArrayList<String>();
    private GUIDisplayElements m_gui = null;
    private static String VIEWER_TYPE = "VIEWER_TYPE";
    public static String AGENT_TABLE = "AGENT_TABLE";
    public static String ASN_TABLE = "ASN_TABLE";
    private boolean m_hasAsnRights = true;
    private boolean m_hasAgentRights = true;

    public RelatedPolicyInfoDialog(Shell parentShell, StructuredSelection ssel) {
        super(parentShell);
        Object selection;
        super.setShellStyle(66704);
        RelatedPolicyInfoDialog.setDefaultImage((Image)BMUI.IMAGE_PRODUCT);
        if (Repository.getInstance().getRights(1008) < 2) {
            this.m_hasAsnRights = false;
        }
        if (Repository.getInstance().getRights(1002) < 2) {
            this.m_hasAgentRights = false;
        }
        if ((selection = ssel.getFirstElement()) instanceof String[]) {
            String[] element = (String[])selection;
            try {
                this.m_polType = element[0];
                this.m_name = element[1];
                this.m_version = element[2];
                this.m_group = element[3];
                this.m_application = element[4];
                this.m_callType = element[5];
                this.m_path = element[6];
                if (this.m_polType.equals(BMUI.type_msg)) {
                    this.m_polType4Display = "Indication";
                    this.m_image = BMUI.IMAGE_MSG;
                } else if (this.m_polType.equals(BMUI.type_mon)) {
                    this.m_polType4Display = "Monitor";
                    this.m_image = BMUI.IMAGE_MON;
                }
            }
            catch (Exception exception) {}
        } else if (selection instanceof GroupTreeObjectLast) {
            GroupTreeObjectLast gtol = (GroupTreeObjectLast)selection;
            this.m_name = gtol.getName();
            this.m_polType = gtol.getTreeObject().getType();
            this.m_path = gtol.getPath();
            File fileP = Repository.getInstance().fetchFile(this.m_name, this.m_polType);
            if (fileP != null) {
                PolicyManager pm = PolicyManager.getInstance();
                if (this.m_polType.equals(BMUI.type_msg)) {
                    this.m_polType4Display = "Indication";
                    this.m_image = BMUI.IMAGE_MSG;
                    MsgPolicy mp = pm.getMessagePolicy(fileP);
                    if (mp != null) {
                        this.m_version = mp.getVersion();
                        this.m_group = "-";
                        this.m_application = "-";
                        this.m_callType = mp.getCallType();
                    }
                } else if (this.m_polType.equals(BMUI.type_mon)) {
                    this.m_polType4Display = "Monitor";
                    this.m_image = BMUI.IMAGE_MON;
                    Policy p = pm.getMonitorPolicy(fileP);
                    if (p != null) {
                        this.m_version = p.getVersion();
                        this.m_group = p.getSetGroup();
                        this.m_application = p.getSetApplication();
                        this.m_callType = p.getCallType();
                    }
                }
            }
        }
        if (this.m_hasAgentRights && this.m_name != null && !this.m_name.equals("") && this.m_polType != null) {
            this.m_relAgents = PolicyOverviewTableProvider.getRelatedAgentCards(this.m_name, this.m_polType);
        }
        if (this.m_hasAsnRights && this.m_name != null && !this.m_name.equals("")) {
            this.m_rel_asn_names = PolicyOverviewTableProvider.getRelatedAssignments(this.m_name);
        }
        if (this.m_path != null && this.m_path.startsWith("/root/")) {
            this.m_path = this.m_path.replace("/root/", "");
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.m_gui = new GUIDisplayElements();
        this.m_topComp = (Composite)super.createDialogArea(parent);
        GridLayout gl = new GridLayout(4, false);
        gl.verticalSpacing = 0;
        this.m_topComp.setLayout((Layout)gl);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 600;
        gd.heightHint = !this.m_hasAgentRights && !this.m_hasAsnRights ? 150 : 400;
        this.m_topComp.setLayoutData((Object)gd);
        this.createInfoSection();
        this.m_middleComp = new Composite(this.m_topComp, 0);
        gl = new GridLayout(2, true);
        gl.verticalSpacing = 0;
        this.m_middleComp.setLayout((Layout)gl);
        this.m_middleComp.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        if (this.m_hasAgentRights) {
            this.createAgentTable();
        }
        if (this.m_hasAsnRights) {
            this.createAsnTree();
        }
        this.createLabels();
        return this.m_topComp;
    }

    private void createInfoSection() {
        Composite comp0 = new Composite(this.m_topComp, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.verticalSpacing = 0;
        comp0.setLayout((Layout)gl);
        comp0.setLayoutData((Object)new GridData(1, 128, false, false, 4, 1));
        Label l = new Label(comp0, 0);
        if (this.m_image != null) {
            l.setImage(this.m_image);
        }
        l = new Label(comp0, 0);
        l.setText(this.m_name);
        l.setFont(BMUI.font_arial8_bold);
        Composite comp = new Composite(this.m_topComp, 0);
        gl = new GridLayout(3, false);
        gl.verticalSpacing = 0;
        gl.marginBottom = 10;
        comp.setLayout((Layout)gl);
        comp.setLayoutData((Object)new GridData(4, 4, true, false, 4, 1));
        this.m_gui.addTextReadOnlyNoBorder(comp, "Type:", this.m_polType4Display, 2, 1, 1, 1, null);
        this.m_gui.addTextReadOnlyNoBorder(comp, "Version:", this.m_version, 2, 1, 1, 1, null);
        this.m_gui.addTextReadOnlyNoBorder(comp, "Group:", this.m_group, 2, 1, 1, 1, null);
        this.m_gui.addTextReadOnlyNoBorder(comp, "Application:  ", this.m_application, 2, 1, 1, 1, null);
        this.m_gui.addTextReadOnlyNoBorder(comp, "CallType:", this.m_callType, 2, 1, 1, 1, null);
        this.m_gui.addTextReadOnlyNoBorder(comp, "Tree Path:", this.m_path, 2, 1, 1, 1, null);
    }

    private void createAgentTable() {
        GridData gd = new GridData(4, 4, true, true);
        int width = 280;
        if (!this.m_hasAsnRights) {
            gd = new GridData(4, 4, true, true, 2, 1);
            width = 550;
        }
        Table agentTable = new Table(this.m_middleComp, 68354);
        agentTable.setData((Object)AGENT_TABLE);
        agentTable.setHeaderVisible(true);
        agentTable.setLinesVisible(false);
        agentTable.setLayout((Layout)new GridLayout());
        agentTable.setLayoutData((Object)gd);
        TableColumn col = new TableColumn(agentTable, 16384);
        col.setText("Deployed on ...");
        col.setWidth(width);
        int i = 0;
        while (i < this.m_relAgents.size()) {
            AgentCard ac = this.m_relAgents.get(i);
            if (ac != null) {
                TableItem item = new TableItem(agentTable, 0);
                item.setData((Object)ac.getAgentID());
                item.setText(String.valueOf(ac.getComparableName()) + " (" + ac.getAgentIP() + ")");
                item.setImage(AgentCard.getOSIcon(ac.getOSName()));
            }
            ++i;
        }
        TableViewer agent_tv = new TableViewer(agentTable);
        agent_tv.setData(VIEWER_TYPE, (Object)AGENT_TABLE);
        agent_tv.addDoubleClickListener((IDoubleClickListener)this);
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(false);
        Menu menu = menuMgr.createContextMenu(agent_tv.getControl());
        agent_tv.getControl().setMenu(menu);
    }

    public void createAsnTree() {
        GridData gd = new GridData(4, 4, true, true);
        int width = 280;
        if (!this.m_hasAgentRights) {
            gd = new GridData(4, 4, true, true, 2, 1);
            width = 550;
        }
        GroupTreeObject asnRoot = new GroupTreeObject(new TreeObject("root", BMUI.type_toplevel, null));
        GroupTreeObject allAssigments = Repository.getInstance().getAllAssignments().getAllAssignmentRoot();
        int i = 0;
        while (i < this.m_rel_asn_names.size()) {
            String asn_name = this.m_rel_asn_names.get(i);
            List<GroupTreeObject> asn = allAssigments.findElements(asn_name, BMUI.type_assignment_pol);
            if (asn.size() > 0) {
                asnRoot.addElements(asn);
            } else {
                asnRoot.addElement(new GroupTreeObject(new TreeObject(asn_name, BMUI.type_assignment_pol, null)));
            }
            ++i;
        }
        STreeViewer asn_tv = new STreeViewer(this.m_middleComp, 268503810);
        asn_tv.setData(VIEWER_TYPE, ASN_TABLE);
        asn_tv.setUseHashlookup(true);
        asn_tv.setContentProvider((IContentProvider)new ViewContentProvider());
        asn_tv.setLabelProvider((IBaseLabelProvider)new StyledTreeLabelProvider());
        asn_tv.setInput(asnRoot);
        asn_tv.collapseAll();
        asn_tv.addDoubleClickListener(this);
        Tree asn_tree = asn_tv.getTree();
        asn_tree.setLayout((Layout)new GridLayout());
        asn_tree.setLayoutData((Object)gd);
        asn_tree.setHeaderVisible(true);
        TreeColumn column1 = new TreeColumn(asn_tree, 16384);
        column1.setText("Related Assignments");
        column1.setWidth(width);
    }

    public void createLabels() {
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        GridData gd = new GridData(4, 4, true, false);
        if (this.m_hasAgentRights) {
            Composite compRight = new Composite(this.m_middleComp, 0);
            compRight.setLayout((Layout)gl);
            compRight.setLayoutData((Object)gd);
            this.m_gui.addTextReadOnlyNoBorder(compRight, null, "Number of Agents:", 1, 1, 0, 5, null);
            Text m_AgentCount = this.m_gui.addTextReadOnlyNoBorder(compRight, null, "" + this.m_relAgents.size(), 1, 1, 0, 5, null);
            ((GridData)m_AgentCount.getLayoutData()).widthHint = 40;
        }
        if (this.m_hasAsnRights) {
            Composite compLeft = new Composite(this.m_middleComp, 0);
            compLeft.setLayout((Layout)gl);
            compLeft.setLayoutData((Object)gd);
            this.m_gui.addTextReadOnlyNoBorder(compLeft, null, "Number of Assignments:", 1, 1, 0, 5, null);
            Text m_AsnCount = this.m_gui.addTextReadOnlyNoBorder(compLeft, null, "" + this.m_rel_asn_names.size(), 1, 1, 0, 5, null);
            ((GridData)m_AsnCount.getLayoutData()).widthHint = 40;
        }
    }

    protected void okPressed() {
        super.okPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "OK", false);
    }

    public boolean close() {
        try {
            this.m_topComp.dispose();
        }
        catch (Throwable throwable) {}
        return super.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("  Related Policy Information");
        newShell.setImage(BMUI.IMAGE_PRODUCT);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void doubleClick(DoubleClickEvent event) {
        TreeViewer treeViewer;
        TreeItem[] sel;
        Viewer viewer = event.getViewer();
        if (viewer instanceof TableViewer) {
            TableViewer tableViewer = (TableViewer)viewer;
            TableItem[] sel2 = tableViewer.getTable().getSelection();
            if (sel2 != null && sel2.length > 0) {
                TableItem ti = sel2[0];
                String agentID = (String)ti.getData();
                SelectAgentInTreeAction action = new SelectAgentInTreeAction(agentID);
                action.run();
            }
        } else if (viewer instanceof TreeViewer && (sel = (treeViewer = (TreeViewer)viewer).getTree().getSelection()) != null && sel.length > 0) {
            TreeItem ti = sel[0];
            String asnName = ti.getText();
            SelectAssignmentInTreeAction selectAction = new SelectAssignmentInTreeAction(asnName);
            selectAction.run();
        }
    }
}

