/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.dialogs;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.dialogs.ServerFilterDialogTableProvider;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.views.FancyToolTipSupport;
import com.blixx.shared.ext.ForwardPolicy;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class RelatedServerFilterInfoDialog
extends Dialog {
    private ForwardPolicy m_fp = null;
    private Table m_fwdCondition_tbl = null;
    private Table m_attributeFilter_tbl = null;
    private TableViewer m_fwdCondition_tv = null;
    private TableViewer m_attrFilter_tv = null;
    private GUIDisplayElements m_gui = null;
    private static String VIEWER_TYPE = "VIEWER_TYPE";
    public static String ATTRIBUTE_FILTER_TABLE = "ATTRIBUTE_FILTER_TABLE";
    public static String FWD_CONDITION_TABLE = "FWD_CONDITION_INFO_TABLE";

    public RelatedServerFilterInfoDialog(Shell parentShell, ForwardPolicy fp) {
        super(parentShell);
        super.setShellStyle(66704);
        RelatedServerFilterInfoDialog.setDefaultImage((Image)BMUI.IMAGE_PRODUCT);
        this.m_fp = fp;
    }

    protected Control createDialogArea(Composite parent) {
        this.m_gui = new GUIDisplayElements();
        Composite m_topComp = new Composite(parent, 0);
        m_topComp.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 600;
        gd.heightHint = 400;
        m_topComp.setLayoutData((Object)gd);
        this.createInfoSection(m_topComp);
        this.createAttrFilterTable(m_topComp);
        this.createFwdConditionTable(m_topComp);
        return m_topComp;
    }

    private void createInfoSection(Composite parent) {
        Composite titleComp = new Composite(parent, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.verticalSpacing = 0;
        titleComp.setLayout((Layout)gl);
        titleComp.setLayoutData((Object)new GridData(1, 128, false, false, 2, 1));
        Label l = new Label(titleComp, 0);
        l.setImage(BMUI.IMAGE_FWD);
        l = new Label(titleComp, 0);
        l.setText(this.m_fp.policyName);
        l.setFont(BMUI.font_arial8_bold);
        Composite detailsComp = new Composite(parent, 0);
        gl = new GridLayout(3, false);
        gl.marginBottom = 5;
        detailsComp.setLayout((Layout)gl);
        detailsComp.setLayoutData((Object)new GridData(1, 128, false, false, 2, 1));
        this.m_gui.addTextReadOnlyNoBorder(detailsComp, "Type: ", this.m_fp.isUserPolicy() ? "User Filter" : "Notification Filter", 2, 1, 0, 0, null);
        this.m_gui.addTextReadOnlyNoBorder(detailsComp, "Description:  ", this.m_fp.description, 2, 1, 1, 1, null);
        l = new Label(detailsComp, 0);
        l.setText("Status: ");
        Label image = new Label(detailsComp, 0);
        Label text = new Label(detailsComp, 0);
        if (this.m_fp.isActive()) {
            image.setImage(BMUI.IMAGE_ACCEPT_GREEN);
            text.setText("ACTIVE");
        } else {
            image.setImage(BMUI.IMAGE_CANCEL_ROUND);
            text.setText("NOT ACTIVE");
        }
    }

    private void createAttrFilterTable(Composite parent) {
        this.m_attributeFilter_tbl = new Table(parent, 68354);
        this.m_attributeFilter_tbl.setData((Object)ATTRIBUTE_FILTER_TABLE);
        this.m_attributeFilter_tbl.setHeaderVisible(true);
        this.m_attributeFilter_tbl.setLinesVisible(false);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.verticalSpacing = 0;
        this.m_attributeFilter_tbl.setLayout((Layout)gl);
        this.m_attributeFilter_tbl.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.m_attrFilter_tv = new TableViewer(this.m_attributeFilter_tbl);
        this.m_attrFilter_tv.setData(VIEWER_TYPE, (Object)ATTRIBUTE_FILTER_TABLE);
        ServerFilterDialogTableProvider m_attrFilter_tblProvider = new ServerFilterDialogTableProvider(this.m_attrFilter_tv, this.m_fp);
        TableViewerColumn col1 = new TableViewerColumn(this.m_attrFilter_tv, 16384);
        col1.getColumn().setText("Assigned Filters");
        col1.getColumn().setWidth(150);
        col1.setLabelProvider(m_attrFilter_tblProvider.labelProvider);
        TableViewerColumn col2 = new TableViewerColumn(this.m_attrFilter_tv, 16384);
        col2.getColumn().setText("Attribute");
        col2.getColumn().setWidth(100);
        col2.setLabelProvider(m_attrFilter_tblProvider.labelProvider);
        TableViewerColumn col3 = new TableViewerColumn(this.m_attrFilter_tv, 16384);
        col3.getColumn().setText("Pattern");
        col3.getColumn().setWidth(150);
        col3.setLabelProvider(m_attrFilter_tblProvider.labelProvider);
        TableViewerColumn col4 = new TableViewerColumn(this.m_attrFilter_tv, 16384);
        col4.getColumn().setText("Description");
        col4.getColumn().setWidth(150);
        col4.setLabelProvider(m_attrFilter_tblProvider.labelProvider);
        TableViewerColumn col5 = new TableViewerColumn(this.m_attrFilter_tv, 16384);
        col5.getColumn().setText("Number");
        col5.getColumn().setWidth(30);
        col5.setLabelProvider(m_attrFilter_tblProvider.labelProvider);
        this.m_attrFilter_tv.setContentProvider((IContentProvider)m_attrFilter_tblProvider);
        this.m_attrFilter_tv.setInput((Object)m_attrFilter_tblProvider.getElements(null));
        FancyToolTipSupport.enableFor((ColumnViewer)this.m_attrFilter_tv, 2);
        this.m_attributeFilter_tbl.setToolTipText("");
        Composite filterComp = new Composite(parent, 0);
        gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.verticalSpacing = 0;
        gl.marginBottom = 10;
        filterComp.setLayout((Layout)gl);
        filterComp.setLayoutData((Object)new GridData(4, 4, false, false));
        this.m_gui.addTextReadOnlyNoBorder(filterComp, null, "Total Attribute Filters: ", 1, 1, 0, 0, null);
        this.m_gui.addTextReadOnlyNoBorder(filterComp, null, "" + this.m_attributeFilter_tbl.getItemCount(), 1, 1, 0, 0, null);
    }

    private void createFwdConditionTable(Composite parent) {
        this.m_fwdCondition_tbl = new Table(parent, 68354);
        this.m_fwdCondition_tbl.setData((Object)FWD_CONDITION_TABLE);
        this.m_fwdCondition_tbl.setHeaderVisible(true);
        this.m_fwdCondition_tbl.setLinesVisible(false);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.verticalSpacing = 0;
        this.m_fwdCondition_tbl.setLayout((Layout)gl);
        this.m_fwdCondition_tbl.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.m_fwdCondition_tv = new TableViewer(this.m_fwdCondition_tbl);
        this.m_fwdCondition_tv.setData(VIEWER_TYPE, (Object)FWD_CONDITION_TABLE);
        ServerFilterDialogTableProvider m_fCond_tableProvider = new ServerFilterDialogTableProvider(this.m_fwdCondition_tv, this.m_fp);
        TableViewerColumn col0 = new TableViewerColumn(this.m_fwdCondition_tv, 16384);
        col0.getColumn().setText("Condition Name");
        col0.getColumn().setWidth(150);
        col0.setLabelProvider(m_fCond_tableProvider.labelProvider);
        TableViewerColumn col1 = new TableViewerColumn(this.m_fwdCondition_tv, 16384);
        col1.getColumn().setText("ActivationTime");
        col1.getColumn().setWidth(50);
        col1.setLabelProvider(m_fCond_tableProvider.labelProvider);
        TableViewerColumn col2 = new TableViewerColumn(this.m_fwdCondition_tv, 16384);
        col2.getColumn().setText("DeactivatingTime");
        col2.getColumn().setWidth(50);
        col2.setLabelProvider(m_fCond_tableProvider.labelProvider);
        TableViewerColumn col3 = new TableViewerColumn(this.m_fwdCondition_tv, 16384);
        col3.getColumn().setText("AV");
        col3.getColumn().setWidth(30);
        col3.setLabelProvider(m_fCond_tableProvider.labelProvider);
        TableViewerColumn col4 = new TableViewerColumn(this.m_fwdCondition_tv, 16384);
        col4.getColumn().setText("KPI");
        col4.getColumn().setWidth(30);
        col4.setLabelProvider(m_fCond_tableProvider.labelProvider);
        TableViewerColumn col5 = new TableViewerColumn(this.m_fwdCondition_tv, 16384);
        col5.getColumn().setText("Type");
        col5.getColumn().setWidth(60);
        col5.setLabelProvider(m_fCond_tableProvider.labelProvider);
        TableViewerColumn col6 = new TableViewerColumn(this.m_fwdCondition_tv, 16384);
        col6.getColumn().setText("Target");
        col6.getColumn().setWidth(100);
        col6.setLabelProvider(m_fCond_tableProvider.labelProvider);
        TableViewerColumn col7 = new TableViewerColumn(this.m_fwdCondition_tv, 16384);
        col7.getColumn().setText("Severities");
        col7.getColumn().setWidth(150);
        col7.setLabelProvider(m_fCond_tableProvider.labelProvider);
        TableViewerColumn col8 = new TableViewerColumn(this.m_fwdCondition_tv, 16384);
        col8.getColumn().setText("Description");
        col8.getColumn().setWidth(200);
        col8.setLabelProvider(m_fCond_tableProvider.labelProvider);
        TableViewerColumn col9 = new TableViewerColumn(this.m_fwdCondition_tv, 16384);
        col9.getColumn().setText("Send");
        col9.getColumn().setWidth(200);
        col9.setLabelProvider(m_fCond_tableProvider.labelProvider);
        this.m_fwdCondition_tv.setContentProvider((IContentProvider)m_fCond_tableProvider);
        this.m_fwdCondition_tv.setInput((Object)m_fCond_tableProvider.getElements(null));
        FancyToolTipSupport.enableFor((ColumnViewer)this.m_fwdCondition_tv, 2);
        this.m_fwdCondition_tbl.setToolTipText("");
        Composite fConditionComp = new Composite(parent, 0);
        gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.verticalSpacing = 0;
        fConditionComp.setLayout((Layout)gl);
        fConditionComp.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.m_gui.addTextReadOnlyNoBorder(fConditionComp, null, "Total Conditions: ", 1, 1, 0, 0, null);
        this.m_gui.addTextReadOnlyNoBorder(fConditionComp, null, "" + this.m_fwdCondition_tbl.getItemCount(), 1, 1, 0, 0, null);
    }

    protected void okPressed() {
        super.okPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "OK", false);
    }

    public boolean close() {
        return super.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        Image defaultImage = BMUI.IMAGE_PRODUCT;
        if (this.m_fp == null) {
            newShell.setText(" ");
            newShell.setImage(defaultImage);
        } else {
            String name = this.m_fp.policyName;
            if (name == null) {
                name = "";
            }
            if (this.m_fp.isUserPolicy()) {
                newShell.setText("Related User Filter Information");
            } else {
                newShell.setText("Related Notification Filter Information");
            }
            newShell.setImage(BMUI.IMAGE_FWD);
        }
    }
}

