/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.dialogs;

import com.blixx.boom.engine.ActionClient;
import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.dialogs.SelectActionDialog;
import com.blixx.boom.gui.policies.ViewContentProvider;
import com.blixx.boom.gui.utils.ActionTreeFilter;
import com.blixx.boom.gui.utils.AgentTreeFilter;
import com.blixx.boom.gui.utils.AgentTreeFilterExcludeExternal;
import com.blixx.boom.gui.utils.FilterComposite;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.utils.STreeViewer;
import com.blixx.boom.gui.views.NodeListView;
import com.blixx.boom.gui.views.Proposals;
import com.blixx.boom.gui.views.StyledTreeLabelProvider;
import com.blixx.boom.gui.views.actions.ExpandCollapseAction;
import com.blixx.boom.gui.views.actions.ManageDialogAction;
import com.blixx.shared.Action;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.Section;

public class RemoteActionDialog
implements ShellListener,
ISelectionChangedListener,
IExpansionListener,
KeyListener {
    private Action m_action = null;
    private String m_host = null;
    private String m_call = null;
    private boolean m_displayTree = true;
    private int m_timeoutSeconds = 120;
    private int m_executedCMDsPosition = 0;
    private int m_rights = 0;
    private boolean m_activateSupportedVars = false;
    private TreeViewer m_viewer = null;
    private Set<AgentCard> m_selectedAgents = new HashSet<AgentCard>();
    private GUIDisplayElements m_gui = new GUIDisplayElements();
    private Shell m_dialogShell = null;
    private Composite m_parent = null;
    private SashForm main = null;
    private Section m_description_section = null;
    private Section m_help_section = null;
    private Text m_commandField = null;
    private CCombo m_server_combo = null;
    private Text m_output = null;
    private Text m_optParamsField = null;
    private Text m_timeoutField = null;
    private Button m_execButton = null;
    private int[] m_expanded_none = new int[]{37, 63};
    private int[] m_expanded_one = new int[]{53, 47};
    private int[] m_expanded_all = new int[]{67, 33};
    private int[] m_topWeights = new int[]{40, 60};
    private static final String OPTIONAL_PARAMETERS = "OPTIONAL_PARAMETERS";
    private static final String COMMAND_FIELD = "COMMAND_FIELD";
    public static String ACTION_ID = "ACTION_ID";
    public static String ACTION_TYPE = "ACTION_TYPE";
    public static String ACTION = ActionTreeFilter.DISPLAY_AGENT_ACTIONS;
    public static String SERVER_ACTION = ActionTreeFilter.DISPLAY_SERVER_ACTIONS;
    public static String SERVER_COMBO = "SERVER_COMBO";
    public static String MASTER_SERVER = "Master Server";
    private ArrayList<String> m_executedCMDs = new ArrayList();
    private FilterComposite m_filterComp = null;
    private boolean m_hideExternal = true;

    public RemoteActionDialog(String title, String host, String call, boolean displayTree, int rights, boolean hideExternal) {
        this.m_hideExternal = hideExternal;
        new RemoteActionDialog(title, host, call, displayTree, rights);
    }

    public RemoteActionDialog(String title, String host, String call, boolean displayTree, int rights) {
        this.m_host = host;
        this.m_call = call;
        this.m_displayTree = displayTree;
        this.m_rights = rights;
        int style = 1264;
        this.m_dialogShell = new Shell(Display.getCurrent(), style);
        this.m_dialogShell.setLayout((Layout)new GridLayout(1, false));
        this.m_dialogShell.setText("  " + title);
        this.m_dialogShell.addShellListener((ShellListener)this);
        this.m_gui.openShellInActiveMonitor(this.m_dialogShell);
        this.m_dialogShell.setImage(BMUI.IMAGE_ACTION);
        this.m_dialogShell.setData(ACTION_ID, (Object)(String.valueOf(this.m_host) + "_" + this.m_call));
        this.createDialogArea((Composite)this.m_dialogShell);
    }

    public RemoteActionDialog(String title, Action action, boolean displayTree, int rights, boolean activateSupportedVars, boolean hideExternal) {
        this.m_hideExternal = hideExternal;
        new RemoteActionDialog(title, action, displayTree, rights, activateSupportedVars);
    }

    public RemoteActionDialog(String title, Action action, boolean displayTree, int rights, boolean activateSupportedVars) {
        this.m_action = action;
        this.m_displayTree = displayTree;
        this.m_rights = rights;
        this.m_activateSupportedVars = activateSupportedVars;
        int style = 1264;
        this.m_dialogShell = new Shell(Display.getCurrent(), style);
        this.m_dialogShell.setLayout((Layout)new GridLayout(1, false));
        this.m_dialogShell.setText("  " + title);
        this.m_dialogShell.addShellListener((ShellListener)this);
        this.m_gui.openShellInActiveMonitor(this.m_dialogShell);
        if (this.m_action.m_serverAction) {
            this.m_dialogShell.setImage(BMUI.IMAGE_ACTION_SERVER);
            this.m_dialogShell.setData(ACTION_TYPE, (Object)SERVER_ACTION);
        } else {
            this.m_dialogShell.setImage(BMUI.IMAGE_ACTION);
            this.m_dialogShell.setData(ACTION_TYPE, (Object)ACTION);
        }
        this.createDialogArea((Composite)this.m_dialogShell);
    }

    protected Control createDialogArea(Composite parent) {
        this.m_parent = parent;
        this.m_parent.setLayout((Layout)new FillLayout());
        this.m_parent.setSize(800, 650);
        this.main = new SashForm(this.m_parent, 2560);
        SashForm top = new SashForm((Composite)this.main, 256);
        SashForm bottom = new SashForm((Composite)this.main, 512);
        this.createAgentTree(top);
        this.createCommandSection(top);
        this.createResultSection(bottom);
        this.main.setWeights(this.m_expanded_none);
        if (this.m_description_section != null && this.m_description_section.isExpanded()) {
            this.main.setWeights(this.m_expanded_one);
        }
        top.setWeights(this.m_topWeights);
        return this.m_parent;
    }

    public void open() {
        this.m_dialogShell.open();
        ManageDialogAction.addActionDialog(this.m_dialogShell);
    }

    public void createAgentTree(SashForm sashForm) {
        GridData gridData = null;
        if (this.m_displayTree) {
            gridData = new GridData(4, 4, false, false, 1, 1);
            gridData.heightHint = 100;
            if (this.m_action == null || !this.m_action.m_serverAction) {
                Composite search = new Composite((Composite)sashForm, 0);
                GridLayout gl = new GridLayout(1, false);
                gl.marginTop = 5;
                search.setLayout((Layout)gl);
                search.setLayoutData((Object)new GridData(4, 4, true, false));
                this.m_filterComp = new FilterComposite(search, this);
                this.m_filterComp.setCompositeLayoutData(new GridData(4, 0x1000000, true, false));
                this.m_viewer = new STreeViewer(search, 268438274);
                this.m_viewer.setUseHashlookup(true);
                this.m_viewer.setContentProvider((IContentProvider)new ViewContentProvider());
                this.m_viewer.setLabelProvider((IBaseLabelProvider)new StyledTreeLabelProvider());
                this.m_viewer.setInput((Object)Repository.getInstance().getAgentTree());
                Repository.getInstance().addAgentTreeListener((StructuredViewer)this.m_viewer);
                Repository.getInstance().addNodeGroupTreeListener((Viewer)this.m_viewer);
                gridData = new GridData(4, 4, true, true);
                this.m_viewer.getTree().setLayoutData((Object)gridData);
                this.m_viewer.expandToLevel(2);
                this.m_viewer.addSelectionChangedListener((ISelectionChangedListener)this);
                try {
                    if (this.m_hideExternal) {
                        this.hideExternal();
                    }
                }
                catch (Throwable throwable) {}
                this.createContentMenu(this.m_viewer);
            } else {
                this.m_gui.addTextField((Composite)sashForm, null, "", 1, 1, 0, 0, null);
                this.m_topWeights = new int[]{1, 99};
            }
        } else {
            this.m_gui.addTextField((Composite)sashForm, null, "", 1, 1, 0, 0, null);
            this.m_topWeights = new int[]{1, 99};
        }
    }

    public void createContentMenu(final TreeViewer viewer) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        Menu menu = menuMgr.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        NodeListView.getInstance().getSite().registerContextMenu(menuMgr, (ISelectionProvider)viewer);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    manager.add((IAction)new ExpandCollapseAction(viewer, "ExpandAll"));
                    manager.add((IAction)new ExpandCollapseAction(viewer, "CollapseAll"));
                }
                catch (Throwable throwable) {}
            }
        });
    }

    public void createCommandSection(SashForm sashForm) {
        Composite comp = new Composite((Composite)sashForm, 0);
        GridLayout gdLayout = new GridLayout(2, false);
        gdLayout.verticalSpacing = 0;
        gdLayout.horizontalSpacing = 0;
        gdLayout.marginHeight = 0;
        gdLayout.marginWidth = 0;
        comp.setLayout((Layout)gdLayout);
        comp.setLayoutData((Object)new GridData(4, 4, true, false));
        if (!this.m_displayTree) {
            this.m_gui.addTextField(comp, null, "Host: ", 1, 1, 3, 0, null);
            this.m_gui.addTextField(comp, this.m_host, null, 2, 1, 3, 0, BMUI.font_arial8_bold);
        }
        Composite c = new Composite(comp, 0);
        GridData d = new GridData(4, 4, true, false, 2, 0);
        d.verticalIndent = 0;
        d.horizontalIndent = 0;
        c.setLayoutData((Object)d);
        GridLayout gd = new GridLayout(2, false);
        gd.verticalSpacing = 0;
        gd.horizontalSpacing = 0;
        gd.marginHeight = 0;
        gd.marginWidth = 0;
        c.setLayout((Layout)gd);
        Label l1 = this.m_gui.addTextField(c, null, "Command: ", 1, 1, 10, 0, null);
        l1.setLayoutData((Object)new GridData(4, 1024, true, false));
        Button selectAction = this.m_gui.addButton(c, "SELECT_ACTION", null, true, null);
        selectAction.setImage(this.m_dialogShell.getImage());
        selectAction.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SelectActionDialog sad = new SelectActionDialog(RemoteActionDialog.this.m_dialogShell, "select Action", (String)RemoteActionDialog.this.m_dialogShell.getData(ACTION_TYPE));
                sad.setBlockOnOpen(true);
                int open = sad.open();
                if (open == 0) {
                    RemoteActionDialog.this.m_action = sad.getAction();
                    RemoteActionDialog.this.m_dialogShell.setText("  " + ((RemoteActionDialog)RemoteActionDialog.this).m_action.m_label);
                    RemoteActionDialog.this.m_commandField.setText(((RemoteActionDialog)RemoteActionDialog.this).m_action.m_call);
                    RemoteActionDialog.this.m_timeoutField.setText("" + ((RemoteActionDialog)RemoteActionDialog.this).m_action.m_timeoutSeconds);
                    RemoteActionDialog.this.m_optParamsField.setText(((RemoteActionDialog)RemoteActionDialog.this).m_action.m_optional_parameters);
                    RemoteActionDialog.this.m_dialogShell.redraw();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.m_commandField = this.m_gui.addInputFieldSingle(comp, COMMAND_FIELD, null, null, 2, 1, 0, 3, 90, null);
        if (this.m_action != null) {
            this.m_commandField.setText(this.m_action.m_call);
        } else if (!this.m_displayTree) {
            this.m_commandField.setText(this.m_call);
        }
        if (this.m_rights < 3) {
            this.m_commandField.setEditable(false);
        }
        this.m_commandField.addKeyListener((KeyListener)this);
        Label timeoutLabel = this.m_gui.addTextField(comp, null, "Timeout (sec): ", 1, 1, 5, 0, null);
        ((GridData)timeoutLabel.getLayoutData()).horizontalAlignment = 1;
        ((GridData)timeoutLabel.getLayoutData()).grabExcessHorizontalSpace = false;
        if (this.m_displayTree) {
            Label l = this.m_gui.addTextField(comp, null, "Parameters: ", 1, 1, 5, 0, null);
            ((GridData)l.getLayoutData()).horizontalAlignment = 4;
            ((GridData)l.getLayoutData()).grabExcessHorizontalSpace = true;
            ((GridData)l.getLayoutData()).horizontalIndent = 10;
        } else {
            this.m_gui.addTextField(comp, null, "", 1, 1, 5, 0, null);
        }
        this.m_timeoutField = this.m_gui.addInputFieldSingle(comp, "", null, null, 1, 1, 0, 5, 55, null);
        ((GridData)this.m_timeoutField.getLayoutData()).horizontalAlignment = 1;
        ((GridData)this.m_timeoutField.getLayoutData()).grabExcessHorizontalSpace = false;
        if (this.m_action != null) {
            this.m_timeoutField.setText("" + this.m_action.m_timeoutSeconds);
        } else if (!this.m_displayTree) {
            this.m_timeoutField.setText("120");
        }
        if (this.m_displayTree) {
            if (this.m_rights == 3) {
                this.m_optParamsField = this.m_gui.addInputFieldSingle(comp, OPTIONAL_PARAMETERS, null, null, 1, 1, 0, 5, 90, null);
            } else {
                this.m_optParamsField = this.m_gui.addInputFieldSingleNoListeners(comp, OPTIONAL_PARAMETERS, null, null, 1, 1, 0, 5, 90, null);
                this.m_optParamsField.addKeyListener((KeyListener)this);
            }
            ((GridData)this.m_optParamsField.getLayoutData()).horizontalAlignment = 4;
            ((GridData)this.m_optParamsField.getLayoutData()).grabExcessHorizontalSpace = true;
            ((GridData)this.m_optParamsField.getLayoutData()).horizontalIndent = 10;
            if (this.m_activateSupportedVars) {
                this.createContentAssist((Control)this.m_optParamsField, Proposals.SERVER_INSTRUCTIONS_MONITOR);
            }
            if (this.m_action != null) {
                this.m_optParamsField.setText(this.m_action.m_optional_parameters);
            } else {
                this.m_optParamsField.setEnabled(false);
            }
            if (this.m_action != null && this.m_action.m_serverAction) {
                List<String> slaves = Repository.getInstance().getSlaves();
                int slaveCount = slaves.size();
                String[] list = new String[slaveCount + 1];
                list[0] = MASTER_SERVER;
                int i = 0;
                while (i < slaveCount) {
                    list[i + 1] = slaves.get(i);
                    ++i;
                }
                String tooltip = "Server where the action should be executed!";
                this.m_gui.addTextField(comp, null, "Server: ", 2, 1, 5, 0, null);
                this.m_server_combo = this.m_gui.addDropDown(comp, SERVER_COMBO, null, list, MASTER_SERVER, tooltip, 2, 1, 0, 3, null);
                ((GridData)this.m_server_combo.getLayoutData()).horizontalAlignment = 4;
                ((GridData)this.m_server_combo.getLayoutData()).widthHint = 40;
            }
            if (this.m_action != null) {
                this.m_description_section = this.addTextSection(comp, "Description", this.m_action.m_description);
                this.m_help_section = this.addTextSection(comp, "Help", this.m_action.m_help);
                this.m_description_section.setExpanded(true);
            }
        }
        if (this.m_rights < 3) {
            this.m_gui.enableField(this.m_commandField, false);
        }
    }

    public Section addTextSection(Composite comp, String title, String value) {
        Section section = BMUI.getFormToolkit(Display.getCurrent()).createSection(comp, 514);
        section.setText(title);
        GridData gdText = new GridData(4, 4, false, false, 2, 1);
        gdText.verticalIndent = 8;
        section.setLayoutData((Object)gdText);
        Composite sectionClient = BMUI.getFormToolkit(Display.getCurrent()).createComposite((Composite)section, 64);
        sectionClient.setLayout((Layout)new GridLayout(1, false));
        Text description = this.m_gui.addInputFieldMultiLineNoWrap(sectionClient, "", null, value, 1, 1, 70, 90, 0, 0, null);
        description.setEditable(false);
        description.setBackground(BMUI.color_lightYellow);
        section.setClient((Control)sectionClient);
        section.addExpansionListener((IExpansionListener)this);
        return section;
    }

    public void createResultSection(SashForm sashForm) {
        Composite comp = new Composite((Composite)sashForm, 2048);
        GridLayout gdLayout = new GridLayout(1, false);
        gdLayout.marginRight = 3;
        gdLayout.marginLeft = 3;
        gdLayout.verticalSpacing = 0;
        gdLayout.horizontalSpacing = 0;
        gdLayout.marginHeight = 0;
        gdLayout.marginBottom = 5;
        comp.setLayout((Layout)gdLayout);
        GridData gridData_btn = new GridData(131072, 128, false, false, 2, 1);
        gridData_btn.verticalIndent = 5;
        gridData_btn.widthHint = 80;
        this.m_execButton = new Button(comp, 8);
        this.m_execButton.setText("Execute");
        boolean enabled = this.m_call != null || this.m_action != null && this.m_action.m_serverAction;
        this.m_execButton.setEnabled(enabled);
        this.m_execButton.setLayoutData((Object)gridData_btn);
        this.m_execButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemoteActionDialog.this.execute();
            }
        });
        this.m_gui.addTextField(comp, null, "Result: ", 1, 1, 0, 0, null);
        String msg = "                               \n\n\n\n\n\n\n\n\n\n\n\n";
        this.m_output = this.m_gui.addInputFieldMultiLineNoWrap(comp, "", null, msg, 1, 5, 100, 90, 1, 1, null);
        ((GridData)this.m_output.getLayoutData()).verticalAlignment = 4;
        ((GridData)this.m_output.getLayoutData()).grabExcessVerticalSpace = true;
        ((GridData)this.m_output.getLayoutData()).verticalIndent = 5;
        Button close = new Button(comp, 8);
        close.setText("Close");
        close.setLayoutData((Object)gridData_btn);
        close.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemoteActionDialog.this.m_dialogShell.close();
            }
        });
    }

    public SimpleContentProposalProvider createContentAssist(Control ct, String[] proposals) {
        char[] autoActivationCharacters = new char[]{};
        SimpleContentProposalProvider defaultProposalProvider = null;
        try {
            KeyStroke keyStroke = KeyStroke.getInstance((String)"Ctrl+Space");
            defaultProposalProvider = new SimpleContentProposalProvider(proposals);
            new ContentProposalAdapter(ct, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)defaultProposalProvider, keyStroke, autoActivationCharacters);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return defaultProposalProvider;
    }

    public void execute() {
        Object ac;
        String command = this.m_commandField.getText().trim();
        if (command.length() == 0) {
            this.m_output.setText("Please enter a command!");
            this.m_output.redraw();
            return;
        }
        if (this.m_displayTree && this.m_optParamsField != null) {
            command = String.valueOf(command) + " " + this.m_optParamsField.getText().trim();
        }
        String agents = "";
        if (this.m_displayTree) {
            this.collectAgentCardSelected();
            if (this.m_viewer == null) {
                String sel;
                agents = "BOOM_SERVER";
                if (this.m_server_combo != null && !this.m_server_combo.isDisposed() && !(sel = this.m_server_combo.getText()).equals(MASTER_SERVER)) {
                    command = String.valueOf(command) + "(BS:" + sel + ")";
                }
            } else {
                Iterator<AgentCard> it = this.m_selectedAgents.iterator();
                if (it.hasNext()) {
                    agents = "";
                }
                while (it.hasNext()) {
                    ac = it.next();
                    agents = String.valueOf(agents) + ac.getAgentID();
                    if (!it.hasNext()) continue;
                    agents = String.valueOf(agents) + " ";
                }
            }
        } else {
            Collection<AgentCard> acList = Repository.getInstance().getAgentCards();
            for (AgentCard ac2 : acList) {
                if (!this.m_host.equalsIgnoreCase(ac2.getAgentHost())) continue;
                agents = ac2.getAgentID();
            }
        }
        if (agents.length() == 0) {
            this.m_output.setText("Selection does not have runnable Agents ...\n\n\n\n\n\n\n\n\n\n\n\n");
            this.m_output.redraw();
            return;
        }
        if (this.m_selectedAgents.size() > 0) {
            this.m_output.setText("Processing " + this.m_selectedAgents.size() + " agents ...\n\n\n\n\n\n\n\n\n\n\n\n");
        } else {
            this.m_output.setText("Processing ...\n\n\n\n\n\n\n\n\n\n\n\n");
        }
        this.m_output.redraw();
        try {
            this.m_timeoutSeconds = Integer.parseInt(this.m_timeoutField.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {}
        String actionID = null;
        if (this.m_action != null) {
            actionID = this.m_action.m_ID;
        }
        if (!(Repository.getInstance().getRights(1005) <= 2 || this.m_executedCMDs.size() != 0 && command.equals(this.m_executedCMDs.get(this.m_executedCMDs.size() - 1)))) {
            this.m_executedCMDs.add(command);
            this.m_executedCMDsPosition = this.m_executedCMDs.size() - 1;
        }
        ac = new ActionClient("RemoteAction", command, agents, this.m_timeoutSeconds, this.m_output, actionID, (Control)this.m_execButton);
        ac.schedule();
    }

    public void collectAgentCardSelected() {
        if (this.m_viewer == null) {
            return;
        }
        this.m_selectedAgents.clear();
        StructuredSelection sel = (StructuredSelection)this.m_viewer.getSelection();
        ViewerFilter[] filters = this.m_viewer.getFilters();
        try {
            if (!sel.isEmpty()) {
                for (GroupTreeObject gto : sel) {
                    this.addIfAgentCard(gto, filters);
                }
            }
        }
        catch (RuntimeException runtimeException) {}
    }

    private void addIfAgentCard(GroupTreeObject gto, ViewerFilter[] filters) {
        if (gto instanceof GroupTreeObjectLast) {
            AgentCard ac;
            AgentCard ac2;
            String linkedID;
            int i = 0;
            while (filters != null && i < filters.length) {
                if (!filters[i].select(null, null, (Object)gto)) {
                    return;
                }
                ++i;
            }
            GroupTreeObjectLast gtol = (GroupTreeObjectLast)gto;
            Object o = gtol.getTreeObject().getObject();
            if ((o == null || o.equals("")) && (linkedID = gtol.getLinkedPath()) != null && this.isPermitted(ac2 = Repository.getInstance().getAgentCard(linkedID))) {
                this.m_selectedAgents.add(ac2);
            }
            if (o instanceof AgentCard && this.isPermitted(ac = (AgentCard)o)) {
                this.m_selectedAgents.add(ac);
            }
        } else {
            List<GroupTreeObject> al = gto.getElements();
            for (GroupTreeObject gto2 : al) {
                this.addIfAgentCard(gto2, filters);
            }
        }
    }

    private boolean isPermitted(AgentCard ac) {
        return ac != null && !ac.isExternal() && ac.isApproved() && Repository.getInstance().isPermittedAgentModify(ac.getAgentID());
    }

    public void hideExternal() {
        AgentTreeFilterExcludeExternal filter = new AgentTreeFilterExcludeExternal();
        this.m_viewer.addFilter((ViewerFilter)filter);
    }

    public void setFilter(String text) {
        this.removeFilter();
        AgentTreeFilter atf = new AgentTreeFilter(text);
        this.m_viewer.addFilter((ViewerFilter)atf);
        this.m_viewer.setExpandedElements(atf.getFilteredFolders().toArray());
    }

    public void setFilters(List<String> filterList, String searchText) {
        this.m_filterComp.setSearchText(searchText);
        AgentTreeFilter atf = new AgentTreeFilter(filterList);
        this.m_viewer.addFilter((ViewerFilter)atf);
        this.m_viewer.expandAll();
        ArrayList<GroupTreeObjectLast> allGTOLs = new ArrayList<GroupTreeObjectLast>();
        TreeItem[] treeItems = this.m_viewer.getTree().getItems();
        int i = 0;
        while (i < treeItems.length) {
            GroupTreeObject gto;
            TreeItem ti = treeItems[i];
            Object obj = ti.getData();
            if (!(obj == null || obj instanceof GroupTreeObjectLast || !(obj instanceof GroupTreeObject) || (gto = (GroupTreeObject)obj).getName().equals("_Groups") || gto.getName().equals("Connecting...") || gto.getName().contains("_External"))) {
                allGTOLs.addAll(gto.getAllGTOLs());
            }
            ++i;
        }
        this.m_viewer.setSelection((ISelection)new StructuredSelection(allGTOLs));
        this.m_viewer.refresh();
    }

    public List<GroupTreeObjectLast> getTreeItemsGTOL(TreeItem ti, List<GroupTreeObjectLast> list) {
        if (ti != null) {
            Object obj = ti.getData();
            if (obj != null && obj instanceof GroupTreeObjectLast) {
                list.add((GroupTreeObjectLast)obj);
            } else if (obj instanceof GroupTreeObject) {
                TreeItem[] items = ti.getItems();
                int i = 0;
                while (i < items.length) {
                    TreeItem subItem = items[i];
                    this.getTreeItemsGTOL(subItem, list);
                    ++i;
                }
            }
        }
        return list;
    }

    public void removeFilter() {
        ViewerFilter[] viewerFilterArray = this.m_viewer.getFilters();
        int n = viewerFilterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerFilter vf = viewerFilterArray[n2];
            if (!(vf instanceof AgentTreeFilterExcludeExternal)) {
                this.m_viewer.removeFilter(vf);
            }
            ++n2;
        }
    }

    public void shellActivated(ShellEvent e) {
        this.m_dialogShell.moveAbove(null);
    }

    public void shellClosed(ShellEvent e) {
        ManageDialogAction.removeActionDialog(this.m_dialogShell);
    }

    public void shellDeactivated(ShellEvent e) {
    }

    public void shellDeiconified(ShellEvent e) {
    }

    public void shellIconified(ShellEvent e) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection iSelect = event.getSelection();
        int size = ((IStructuredSelection)iSelect).size();
        if (size > 0) {
            this.m_execButton.setEnabled(true);
        } else {
            this.m_execButton.setEnabled(false);
        }
    }

    public void expansionStateChanged(ExpansionEvent e) {
        if (e.getState()) {
            if (this.m_description_section.isExpanded() && this.m_help_section.isExpanded()) {
                this.main.setWeights(this.m_expanded_all);
            } else if (this.m_description_section.isExpanded() || this.m_help_section.isExpanded()) {
                this.main.setWeights(this.m_expanded_one);
            }
        } else if (this.m_description_section.isExpanded() || this.m_help_section.isExpanded()) {
            this.main.setWeights(this.m_expanded_one);
        } else {
            this.main.setWeights(this.m_expanded_none);
        }
        this.m_dialogShell.layout(true, true);
    }

    public void expansionStateChanging(ExpansionEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (e.widget instanceof Text && this.m_rights < 3 && OPTIONAL_PARAMETERS == e.widget.getData()) {
            String text;
            if (e.character == ';' || e.character == '|' || e.character == '&' || e.character == '`') {
                e.doit = false;
            }
            if ((e.stateMask & 0x40000) != 0 && (e.keyCode == 118 || e.keyCode == 86)) {
                e.doit = false;
            }
            if ((text = this.m_optParamsField.getText()).indexOf("$(") != -1) {
                this.m_optParamsField.setText(this.m_optParamsField.getText().replace("$(", ""));
            }
        }
    }

    public void keyReleased(KeyEvent e) {
        if (e.widget instanceof Text) {
            if (COMMAND_FIELD == e.widget.getData()) {
                if (e.keyCode == 13) {
                    this.execute();
                } else if (e.keyCode == 0x1000002) {
                    if (this.m_executedCMDsPosition < this.m_executedCMDs.size() - 1) {
                        ++this.m_executedCMDsPosition;
                    }
                    this.m_commandField.setText(this.m_executedCMDs.get(this.m_executedCMDsPosition));
                    int lp = this.m_commandField.getText().length() - 1;
                    if (lp < 0) {
                        lp = 0;
                    }
                    this.m_commandField.setSelection(lp);
                    e.doit = false;
                } else if (e.keyCode == 0x1000001) {
                    if (this.m_executedCMDsPosition > 0) {
                        --this.m_executedCMDsPosition;
                    }
                    this.m_commandField.setText(this.m_executedCMDs.get(this.m_executedCMDsPosition));
                    int lp = this.m_commandField.getText().length() - 1;
                    if (lp < 0) {
                        lp = 0;
                    }
                    this.m_commandField.setSelection(lp);
                    e.doit = false;
                }
            } else if (this.m_rights < 3 && OPTIONAL_PARAMETERS == e.widget.getData()) {
                String text;
                if (e.character == ';' || e.character == '|' || e.character == '&' || e.character == '`') {
                    e.doit = false;
                }
                if ((e.stateMask & 0x40000) != 0 && (e.keyCode == 118 || e.keyCode == 86)) {
                    e.doit = false;
                }
                if ((text = this.m_optParamsField.getText()).indexOf("$(") != -1) {
                    this.m_optParamsField.setText(this.m_optParamsField.getText().replace("$(", ""));
                }
            }
        }
    }
}

