/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.dialogs;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.views.AbstractPolicyTab;
import com.blixx.boom.gui.views.ActionTab;
import com.blixx.boom.gui.views.AgentOverviewTab;
import com.blixx.boom.gui.views.AgentTab;
import com.blixx.boom.gui.views.FilterPolicyTab;
import com.blixx.boom.gui.views.MonitorPolicyTab;
import com.blixx.boom.gui.views.PolicyOverviewTab;
import com.blixx.boom.gui.views.outages.ScheduledMaintenanceTab;
import com.blixx.boom.gui.views.outages.ServerPolicyTab;
import com.blixx.shared.Action;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class SaveDialog
extends StatusDialog
implements DisposeListener {
    private GUIDisplayElements m_gui = null;
    private Composite m_compMain = null;
    private Composite m_compBtn = null;
    private ArrayList<CTabItem> m_unsavedTabs = null;
    private ArrayList<CTabItem> m_readOnlyTabs = null;
    public ArrayList<CTabItem> m_tabs_doSave = null;
    public ArrayList<CTabItem> m_tabs_doNotSave = null;
    public ArrayList<CTabItem> m_unchangedTabs = null;
    private Table m_table = null;
    private String m_msg = null;
    public static String DIRTY_STATUS = "dirty_Status";
    public static final String CLOSE = "CLOSE";
    public static final String CLOSE_OTHERS = "CLOSE_OTHERS";
    public static String POLICY_RENAMING = "POLICY_RENAMING";
    public static String POLICY = "POLICY";
    public static String ACTION = "ACTION";
    public static String AGENT = "AGENT";
    public static int JUST_CLOSE_ID = 999999;

    public SaveDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x80 | 0x400);
        this.setImage(BMUI.IMAGE_PRODUCT);
    }

    public void init(CTabFolder folder, String action, List<CTabItem> cTabs, String type) {
        int i;
        CTabItem[] tabs;
        this.m_unsavedTabs = new ArrayList();
        this.m_readOnlyTabs = new ArrayList();
        this.m_unchangedTabs = new ArrayList();
        List<Object> tabList = new ArrayList();
        if (type.equals(POLICY_RENAMING)) {
            this.setTitle("  Save Policies");
            this.m_msg = "Select the Policies to save:";
            tabList = cTabs;
        } else if (type.equals(POLICY)) {
            this.setTitle("  Save Policies");
            this.m_msg = "Select the Policies to save:";
            if (action.equals(CLOSE)) {
                if (!(folder.getSelection() instanceof PolicyOverviewTab)) {
                    tabList.add(folder.getSelection());
                }
            } else {
                tabs = folder.getItems();
                i = 0;
                while (i < tabs.length) {
                    if (!(tabs[i] instanceof PolicyOverviewTab)) {
                        tabList.add(tabs[i]);
                    }
                    ++i;
                }
            }
        } else if (type.equals(ACTION)) {
            this.setTitle("  Save Actions");
            this.m_msg = "Select the Actions to save:";
            if (action.equals(CLOSE)) {
                tabList.add(folder.getSelection());
            } else {
                tabs = folder.getItems();
                i = 0;
                while (i < tabs.length) {
                    tabList.add(tabs[i]);
                    ++i;
                }
            }
        } else if (type.equals(AGENT)) {
            this.setTitle("  Save Agents");
            this.m_msg = "Select the Agents to save:";
            if (action.equals(CLOSE)) {
                if (!(folder.getSelection() instanceof AgentOverviewTab)) {
                    tabList.add(folder.getSelection());
                }
            } else {
                tabs = folder.getItems();
                i = 0;
                while (i < tabs.length) {
                    if (!(tabs[i] instanceof AgentOverviewTab)) {
                        tabList.add(tabs[i]);
                    }
                    ++i;
                }
            }
        }
        boolean isDirty = false;
        boolean isReadOnly = false;
        int i2 = 0;
        while (i2 < tabList.size()) {
            CTabItem tab;
            CTabItem cTab = (CTabItem)tabList.get(i2);
            if (cTab instanceof MonitorPolicyTab) {
                tab = (MonitorPolicyTab)cTab;
                isDirty = tab.isDirty();
                isReadOnly = tab.isReadOnly();
            } else if (cTab instanceof FilterPolicyTab) {
                tab = (FilterPolicyTab)cTab;
                isDirty = tab.isDirty();
                isReadOnly = tab.isReadOnly();
            } else if (cTab instanceof ActionTab) {
                tab = (ActionTab)cTab;
                isDirty = tab.isDirty();
            } else if (cTab instanceof AgentTab) {
                tab = (AgentTab)cTab;
                isDirty = tab.isDirty();
            } else if (cTab instanceof ScheduledMaintenanceTab) {
                tab = (ScheduledMaintenanceTab)cTab;
                isDirty = tab.isDirty();
            } else if (cTab instanceof ServerPolicyTab) {
                tab = (ServerPolicyTab)cTab;
                isDirty = tab.isDirty();
            }
            if (isDirty) {
                this.m_unsavedTabs.add(cTab);
                if (isReadOnly) {
                    this.m_readOnlyTabs.add(cTab);
                }
            } else {
                this.m_unchangedTabs.add(cTab);
            }
            ++i2;
        }
        if (action != null && action.equals(CLOSE_OTHERS)) {
            CTabItem selected = folder.getSelection();
            if (this.m_unsavedTabs.contains(selected)) {
                this.m_unsavedTabs.remove(selected);
            } else if (this.m_unchangedTabs.contains(selected)) {
                this.m_unchangedTabs.remove(selected);
            }
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.m_gui = new GUIDisplayElements();
        this.m_compMain = new Composite(parent, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginTop = 10;
        gl.marginWidth = 10;
        this.m_compMain.setLayout((Layout)gl);
        this.m_compMain.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.m_compMain.addDisposeListener((DisposeListener)this);
        this.m_gui.addTextField(this.m_compMain, null, this.m_msg, 2, 1, 0, 0, null);
        this.m_table = new Table(this.m_compMain, 268438304);
        this.m_table.setHeaderVisible(false);
        this.m_table.setLinesVisible(false);
        this.m_table.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        TableColumn col1 = new TableColumn(this.m_table, 0);
        col1.setWidth(400);
        this.m_table.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 32 && event.item instanceof TableItem) {
                    AbstractPolicyTab tab;
                    TableItem ti = (TableItem)event.item;
                    boolean isReadOnly = false;
                    if (ti.getData() instanceof MonitorPolicyTab) {
                        tab = (MonitorPolicyTab)ti.getData();
                        isReadOnly = tab.isReadOnly();
                    } else if (ti.getData() instanceof FilterPolicyTab) {
                        tab = (FilterPolicyTab)ti.getData();
                        isReadOnly = tab.isReadOnly();
                    }
                    if (isReadOnly) {
                        event.detail = 0;
                        event.type = 0;
                        event.doit = false;
                        try {
                            SaveDialog.this.m_table.setRedraw(false);
                            ti.setChecked(!ti.getChecked());
                        }
                        finally {
                            SaveDialog.this.m_table.setRedraw(true);
                        }
                    }
                }
            }
        });
        for (CTabItem cTab : this.m_unsavedTabs) {
            CTabItem tab;
            Image image = null;
            String name = "";
            if (cTab instanceof MonitorPolicyTab) {
                tab = (MonitorPolicyTab)cTab;
                image = BMUI.IMAGE_MON;
                name = " " + tab.m_policy.getName();
            } else if (cTab instanceof FilterPolicyTab) {
                tab = (FilterPolicyTab)cTab;
                image = BMUI.IMAGE_MSG;
                name = " " + tab.m_policy.getName();
            } else if (cTab instanceof ActionTab) {
                tab = (ActionTab)cTab;
                Action action = (Action)tab.getData(ACTION);
                image = tab.isNew() ? PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_NEW_WIZARD") : (action.m_serverAction ? BMUI.IMAGE_ACTION_SERVER : BMUI.IMAGE_ACTION);
                name = " " + action.m_label;
            } else if (cTab instanceof AgentTab) {
                tab = (AgentTab)cTab;
                image = tab.getImage();
                name = " " + (AgentCard)tab.getData();
            } else {
                image = cTab.getImage();
                name = cTab.getText();
            }
            TableItem item = new TableItem(this.m_table, 0);
            item.setImage(0, image);
            item.setData((Object)cTab);
            if (!this.m_readOnlyTabs.contains(cTab)) {
                item.setText(name);
                continue;
            }
            item.setText(String.valueOf(name) + " (ReadOnly!)");
            item.setForeground(BMUI.color_darkGrey2);
        }
        this.m_gui.addTextField(this.m_compMain, null, String.valueOf(this.m_table.getItemCount()) + " Elements", 1, 1, 0, 0, null);
        this.selectTableItems(true);
        this.m_compBtn = new Composite(this.m_compMain, 0);
        gl = new GridLayout(0, true);
        gl.marginWidth = 0;
        this.m_compBtn.setLayout((Layout)gl);
        this.m_compBtn.setLayoutData((Object)new GridData(131072, 128, true, false, 1, 1));
        this.createButton(this.m_compBtn, 18, "Select All", false);
        this.createButton(this.m_compBtn, 19, "Deselect All", false);
        return this.m_compMain;
    }

    protected Button getButton(int id) {
        return super.getButton(id);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == JUST_CLOSE_ID) {
            this.m_tabs_doSave = new ArrayList();
            this.m_tabs_doNotSave = new ArrayList();
            TableItem[] items = this.m_table.getItems();
            int i = 0;
            while (i < items.length) {
                TableItem ti = items[i];
                this.m_tabs_doNotSave.add((CTabItem)ti.getData());
                ++i;
            }
            this.setReturnCode(JUST_CLOSE_ID);
            this.close();
        } else if (buttonId == 1) {
            super.cancelPressed();
        } else if (buttonId == 0) {
            this.m_tabs_doSave = new ArrayList();
            this.m_tabs_doNotSave = new ArrayList();
            TableItem[] items = this.m_table.getItems();
            int i = 0;
            while (i < items.length) {
                AbstractPolicyTab tab;
                TableItem ti = items[i];
                boolean isReadOnly = false;
                CTabItem cTab = (CTabItem)ti.getData();
                if (cTab instanceof FilterPolicyTab) {
                    tab = (FilterPolicyTab)cTab;
                    isReadOnly = tab.isReadOnly();
                } else if (cTab instanceof MonitorPolicyTab) {
                    tab = (MonitorPolicyTab)cTab;
                    isReadOnly = tab.isReadOnly();
                }
                if (!isReadOnly && ti.getChecked()) {
                    this.m_tabs_doSave.add((CTabItem)ti.getData());
                } else {
                    this.m_tabs_doNotSave.add((CTabItem)ti.getData());
                }
                ++i;
            }
            super.okPressed();
        } else if (buttonId == 18) {
            this.selectTableItems(true);
        } else if (buttonId == 19) {
            this.selectTableItems(false);
        }
    }

    public void selectTableItems(boolean select) {
        TableItem[] items = this.m_table.getItems();
        int i = 0;
        while (i < items.length) {
            AbstractPolicyTab tab;
            TableItem ti = items[i];
            if (ti.getData() instanceof MonitorPolicyTab) {
                tab = (MonitorPolicyTab)ti.getData();
                if (tab.isReadOnly()) {
                    select = false;
                }
            } else if (ti.getData() instanceof FilterPolicyTab && (tab = (FilterPolicyTab)ti.getData()).isReadOnly()) {
                select = false;
            }
            ti.setChecked(select);
            ++i;
        }
    }

    protected Point getInitialSize() {
        return new Point(345, 420);
    }

    public void widgetDisposed(DisposeEvent e) {
        try {
            this.m_compMain.dispose();
        }
        catch (Throwable throwable) {}
    }

    protected void createButtonsForButtonBar(Composite parent) {
        GridLayout gl = (GridLayout)parent.getLayout();
        gl.marginHeight = 0;
        gl.marginBottom = 10;
        if (this.m_unsavedTabs.size() == this.m_readOnlyTabs.size()) {
            this.createButton(parent, JUST_CLOSE_ID, "Just Close", true);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        } else {
            this.createButton(parent, JUST_CLOSE_ID, "Just Close", false);
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }
    }

    public void create() {
        super.create();
        try {
            Point p2 = this.getShell().computeSize(-1, this.getShell().getSize().y);
            this.getShell().setSize(p2);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

