/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.dialogs;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class SaveDialog2
extends StatusDialog
implements DisposeListener {
    private GUIDisplayElements m_gui = null;
    private Composite m_compMain = null;
    private Composite m_compBtn = null;
    private Image m_image = null;
    private List<String> m_elements = null;
    private List<String> m_selected_elements = null;
    private List<String> m_not_selected_elements = null;
    private Table m_table = null;
    private String m_msg = null;
    private String m_okBtnText = null;
    private String m_cancelBtnText = null;

    public SaveDialog2(String title, String msg, Image image, List<String> elements) {
        super(Display.getCurrent().getActiveShell());
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x80 | 0x400);
        this.setImage(BMUI.IMAGE_PRODUCT);
        this.setTitle("  " + title);
        this.m_msg = msg;
        this.m_image = image;
        this.m_elements = elements;
    }

    public void setBtnText(String okBtnText, String cancelBtnText) {
        this.m_okBtnText = okBtnText;
        this.m_cancelBtnText = cancelBtnText;
    }

    protected Control createDialogArea(Composite parent) {
        this.m_gui = new GUIDisplayElements();
        this.m_compMain = new Composite(parent, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.verticalSpacing = 10;
        this.m_compMain.setLayout((Layout)gl);
        this.m_compMain.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_compMain.addDisposeListener((DisposeListener)this);
        this.m_gui.addTextField(this.m_compMain, null, this.m_msg, 2, 1, 5, 5, null);
        this.m_table = new Table(this.m_compMain, 268438304);
        this.m_table.setHeaderVisible(false);
        this.m_table.setLinesVisible(false);
        this.m_table.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        TableColumn col1 = new TableColumn(this.m_table, 0);
        col1.setWidth(400);
        for (String elem : this.m_elements) {
            TableItem item = new TableItem(this.m_table, 0);
            item.setText(elem);
            if (this.m_image == null) continue;
            item.setImage(0, this.m_image);
        }
        this.m_gui.addTextField(this.m_compMain, null, String.valueOf(this.m_table.getItemCount()) + " Element(s)", 1, 1, 0, 0, null);
        this.selectTableItems(true);
        this.m_compBtn = new Composite(this.m_compMain, 0);
        gl = new GridLayout(0, true);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        gl.verticalSpacing = 0;
        this.m_compBtn.setLayout((Layout)gl);
        this.m_compBtn.setLayoutData((Object)new GridData(131072, 128, false, false));
        this.createButton(this.m_compBtn, 18, "Select All", false);
        this.createButton(this.m_compBtn, 19, "Deselect All", false);
        return this.m_compMain;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1) {
            super.cancelPressed();
        } else if (buttonId == 0) {
            this.m_selected_elements = new ArrayList<String>();
            this.m_not_selected_elements = new ArrayList<String>();
            TableItem[] items = this.m_table.getItems();
            int i = 0;
            while (i < items.length) {
                TableItem ti = items[i];
                if (ti.getChecked()) {
                    this.m_selected_elements.add(ti.getText());
                } else {
                    this.m_not_selected_elements.add(ti.getText());
                }
                ++i;
            }
            super.okPressed();
        } else if (buttonId == 18) {
            this.selectTableItems(true);
        } else if (buttonId == 19) {
            this.selectTableItems(false);
        }
    }

    public void selectTableItems(boolean select) {
        TableItem[] items = this.m_table.getItems();
        int i = 0;
        while (i < items.length) {
            TableItem ti = items[i];
            ti.setChecked(select);
            ++i;
        }
    }

    protected Point getInitialSize() {
        return new Point(345, 420);
    }

    public void widgetDisposed(DisposeEvent e) {
        try {
            this.m_compMain.dispose();
        }
        catch (Throwable throwable) {}
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        if (this.m_okBtnText != null && this.m_okBtnText.length() > 0) {
            this.getButton(0).setText(this.m_okBtnText);
        }
        if (this.m_cancelBtnText != null && this.m_cancelBtnText.length() > 0) {
            this.getButton(1).setText(this.m_cancelBtnText);
        }
    }

    public List<String> getSelectedElements() {
        return this.m_selected_elements;
    }

    public List<String> getNotSelectedElements() {
        return this.m_not_selected_elements;
    }

    public void create() {
        super.create();
        try {
            Point p2 = this.getShell().computeSize(-1, this.getShell().getSize().y);
            this.getShell().setSize(p2);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

