/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.dialogs;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.views.ActionTab;
import com.blixx.boom.gui.views.FilterPolicyTab;
import com.blixx.boom.gui.views.MonitorPolicyTab;
import com.blixx.shared.Action;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class SaveDialogSingle
extends StatusDialog
implements DisposeListener {
    private GUIDisplayElements m_guiElements = new GUIDisplayElements();
    private Image m_image = null;
    private String m_name = null;
    public static String YES = "YES";
    public static String NO = "NO";
    public static String CANCEL = "CANCEL";
    private String m_actionType = CANCEL;

    public SaveDialogSingle(Shell parentShell, CTabItem cTab) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x80 | 0x400);
        this.setImage(BMUI.IMAGE_PRODUCT);
        if (cTab instanceof MonitorPolicyTab) {
            this.setTitle("  Save Policy");
            MonitorPolicyTab tab = (MonitorPolicyTab)cTab;
            this.m_image = BMUI.IMAGE_MON;
            this.m_name = tab.m_policy.getName();
        } else if (cTab instanceof FilterPolicyTab) {
            this.setTitle("  Save Policy");
            FilterPolicyTab tab = (FilterPolicyTab)cTab;
            this.m_image = BMUI.IMAGE_MSG;
            this.m_name = tab.m_policy.getName();
        } else if (cTab instanceof ActionTab) {
            this.setTitle("  Save Action");
            ActionTab tab = (ActionTab)cTab;
            Action action = (Action)tab.getData(ActionTab.ACTION);
            this.m_image = tab.isNew() ? PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_NEW_WIZARD") : (action.m_serverAction ? BMUI.IMAGE_ACTION_SERVER : BMUI.IMAGE_ACTION);
            this.m_name = action.m_label;
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite m_comp = new Composite(parent, 0);
        m_comp.addDisposeListener((DisposeListener)this);
        GridLayout gdLayout = new GridLayout(2, false);
        gdLayout.marginBottom = 0;
        gdLayout.marginWidth = 0;
        gdLayout.marginHeight = 0;
        gdLayout.marginLeft = 20;
        gdLayout.marginTop = 20;
        m_comp.setLayout((Layout)gdLayout);
        m_comp.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        int limit = 60;
        StringBuffer msg = new StringBuffer();
        String name = "'" + this.m_name + "' has been modified.";
        while (name.length() > limit) {
            msg.append(name.substring(0, limit)).append("\n");
            name = name.substring(limit);
        }
        msg = msg.append(name).append("\nSave changes?");
        Label l = new Label(m_comp, 1);
        l.setImage(this.m_image);
        l.setLayoutData((Object)new GridData(4, 128, false, false));
        this.m_guiElements.addTextReadOnlyMulitLineNoBorder(m_comp, null, msg.toString(), 1, 1, 0, 0, null);
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 2, "Save", false);
        this.getButton(2).setFocus();
        this.createButton(parent, 3, "Do Not Save", false);
        this.createButton(parent, 1, "Cancel", true);
    }

    public String getActionType() {
        return this.m_actionType;
    }

    protected Point getInitialSize() {
        return new Point(405, 170);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1) {
            this.m_actionType = CANCEL;
        } else if (buttonId == 3) {
            this.m_actionType = NO;
        } else if (buttonId == 2) {
            this.m_actionType = YES;
        }
        super.close();
    }

    public void widgetDisposed(DisposeEvent e) {
    }
}

