/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.dialogs;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.policies.ViewContentProvider;
import com.blixx.boom.gui.policies.ViewLabelProvider;
import com.blixx.boom.gui.utils.ActionTreeFilter;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.utils.STreeViewer;
import com.blixx.boom.gui.views.actions.ExpandCollapseAction;
import com.blixx.log.RTLogger;
import com.blixx.shared.Action;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.GroupTreeObjectUnsubmitted;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class SelectActionDialog
extends Dialog {
    private String m_title = null;
    private String m_type = null;
    private STreeViewer m_tv = null;
    private Action m_action = null;
    private String m_actionGrpName = null;

    public SelectActionDialog(Shell parentShell, String title, String type) {
        super(parentShell);
        super.setShellStyle(66704);
        this.m_title = title;
        this.m_type = type;
    }

    protected Control createDialogArea(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 300;
        gd.heightHint = 400;
        parent.setLayoutData((Object)gd);
        this.createActionTree(parent);
        return parent;
    }

    private void createActionTree(Composite parent) {
        this.m_tv = new STreeViewer(parent, 2816);
        this.m_tv.getTree().setLayout((Layout)new GridLayout(1, false));
        this.m_tv.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_tv.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider(null, null));
        this.m_tv.setContentProvider((IContentProvider)new ViewContentProvider());
        this.m_tv.setInput(Repository.getInstance().getActionTree((Viewer)this.m_tv));
        this.m_tv.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                STreeViewer tv = (STreeViewer)((Object)event.getSource());
                StructuredSelection ssel = (StructuredSelection)tv.getSelection();
                if (!ssel.isEmpty()) {
                    Object o = ssel.getFirstElement();
                    if (o instanceof GroupTreeObjectUnsubmitted) {
                        return;
                    }
                    if (o instanceof GroupTreeObjectLast) {
                        GroupTreeObjectLast gtol = (GroupTreeObjectLast)o;
                        String actionGroupName = gtol.getParent().getName();
                        if (Repository.getInstance().getRights(actionGroupName) < 2) {
                            new ShowMessageBox("Insufficient rights", " You are not allowed to run actions inside " + actionGroupName, 1);
                            return;
                        }
                        SelectActionDialog.this.okPressed();
                    } else if (o instanceof GroupTreeObject) {
                        GroupTreeObject gto;
                        tv.setExpandedState(gto, !tv.getExpandedState(gto = (GroupTreeObject)o));
                    }
                }
            }
        });
        this.m_tv.getTree().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] items;
                Tree tree = (Tree)e.getSource();
                Button okBtn = SelectActionDialog.this.getButton(0);
                if (tree.getSelectionCount() > 0 && (items = tree.getSelection()).length > 0) {
                    TreeItem ti = items[0];
                    Object obj = ti.getData();
                    if (obj == null) {
                        return;
                    }
                    GUIDisplayElements gui = new GUIDisplayElements();
                    if (obj instanceof GroupTreeObjectLast) {
                        gui.enableField(okBtn, true);
                    } else if (obj instanceof GroupTreeObject) {
                        gui.enableField(okBtn, false);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (this.m_type != null) {
            this.m_tv.addFilter(new ActionTreeFilter(this.m_type));
        }
        this.createContentMenu();
    }

    public void createContentMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        Menu menu = menuMgr.createContextMenu(this.m_tv.getControl());
        this.m_tv.getControl().setMenu(menu);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    manager.add((IAction)new ExpandCollapseAction(SelectActionDialog.this.m_tv, "ExpandAll"));
                    manager.add((IAction)new ExpandCollapseAction(SelectActionDialog.this.m_tv, "CollapseAll"));
                }
                catch (RuntimeException e) {
                    RTLogger.print(5, "", e);
                }
            }
        });
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    protected void okPressed() {
        Object o;
        StructuredSelection ssel = (StructuredSelection)this.m_tv.getSelection();
        if (!ssel.isEmpty() && (o = ssel.getFirstElement()) != null && o instanceof GroupTreeObjectLast) {
            GroupTreeObjectLast gtol = (GroupTreeObjectLast)o;
            this.m_actionGrpName = gtol.getParent().getName();
            Object obj = gtol.getTreeObject().getObject();
            if (obj != null && obj instanceof Action) {
                this.m_action = (Action)obj;
            }
        }
        super.okPressed();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.m_title);
        shell.setImage(BMUI.IMAGE_PRODUCT);
    }

    public Action getAction() {
        return this.m_action;
    }

    public String getActionGrpName() {
        return this.m_actionGrpName;
    }
}

