/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.dialogs;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.policies.ViewContentProvider;
import com.blixx.boom.gui.policies.ViewLabelProvider;
import com.blixx.boom.gui.utils.STreeViewer;
import com.blixx.boom.gui.views.StyledTreeLabelProvider;
import com.blixx.shared.utils.GroupTreeObject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class SelectInTreeDialog
extends Dialog
implements IDoubleClickListener {
    protected String m_title = null;
    protected STreeViewer m_tv = null;
    protected GroupTreeObject m_selection = null;
    protected GroupTreeObject m_tree = null;
    protected boolean m_useNodeGroupProvider = false;

    public SelectInTreeDialog(Shell parentShell, String title, GroupTreeObject tree, boolean useNodeGroupProvider) {
        super(parentShell);
        super.setShellStyle(66704);
        this.m_title = title;
        this.m_tree = tree;
        this.m_useNodeGroupProvider = useNodeGroupProvider;
    }

    protected Control createDialogArea(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 300;
        gd.heightHint = 400;
        parent.setLayoutData((Object)gd);
        this.m_tv = new STreeViewer(parent, 2820);
        this.m_tv.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        if (this.m_useNodeGroupProvider) {
            this.m_tv.setLabelProvider((IBaseLabelProvider)new StyledTreeLabelProvider());
        } else {
            this.m_tv.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider(null, null));
        }
        this.m_tv.setContentProvider((IContentProvider)new ViewContentProvider());
        this.m_tv.setInput(this.m_tree);
        this.m_tv.expandToLevel(2);
        this.m_tv.getTree().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] items;
                Tree tree = (Tree)e.getSource();
                if (tree.getSelectionCount() > 0 && (items = tree.getSelection()).length > 0) {
                    TreeItem ti = items[0];
                    Object obj = ti.getData();
                    if (obj instanceof GroupTreeObject) {
                        SelectInTreeDialog.this.m_selection = (GroupTreeObject)obj;
                    }
                    SelectInTreeDialog.this.checkSelectionData(obj);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.m_tv.addDoubleClickListener(this);
        this.m_tv.refresh(true);
        return parent;
    }

    public void checkSelectionData(Object obj) {
    }

    public GroupTreeObject getSelection() {
        return this.m_selection;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.m_title);
        shell.setImage(BMUI.IMAGE_PRODUCT);
    }

    public void doubleClick(DoubleClickEvent event) {
        this.okPressed();
    }
}

