/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.dialogs;

import com.blixx.boom.gui.dialogs.RelatedServerFilterInfoDialog;
import com.blixx.boom.gui.views.ServerFilterView;
import com.blixx.shared.Severity;
import com.blixx.shared.ext.ForwardCondition;
import com.blixx.shared.ext.ForwardConditions;
import com.blixx.shared.ext.ForwardFilter;
import com.blixx.shared.ext.ForwardPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class ServerFilterDialogTableProvider
implements IStructuredContentProvider {
    private TableViewer m_tv = null;
    private ForwardPolicy m_fp = null;
    private List m_elements = null;
    public CellLabelProvider labelProvider = new CellLabelProvider(){

        public String getToolTipText(Object element) {
            String htmlStr = null;
            if (element instanceof ForwardFilter) {
                ForwardFilter ff = (ForwardFilter)element;
                Properties props = ff.getProperties();
                String name = props.getProperty("NAME");
                String number = props.getProperty("FILTER_NUMBER");
                String desc = props.getProperty("DESCRIPTION");
                String attr = props.getProperty("ATTRIBUTE");
                String pattern = props.getProperty("PATTERN");
                htmlStr = "<html><body bgcolor='#FFFFE1'>";
                htmlStr = String.valueOf(htmlStr) + "<table border='0' cellspacing='0' cellpadding='0'>";
                htmlStr = String.valueOf(htmlStr) + "<tr valign='top'><td nowrap ><font face='Arial' size='1' color='#000000'>Forward Filter:&nbsp;&nbsp;</font></td>";
                htmlStr = String.valueOf(htmlStr) + "<td nowrap ><font face='Arial' size='1' color='#000000'><b>" + name + "</b></font></td></tr>";
                htmlStr = String.valueOf(htmlStr) + "<tr valign='top'><td nowrap ><font face='Arial' size='1' color='#000000'>Number:</font></td>";
                htmlStr = String.valueOf(htmlStr) + "<td nowrap ><font face='Arial' size='1' color='#000000'><b>" + number + "</b></font></td></tr>";
                htmlStr = String.valueOf(htmlStr) + "<tr valign='top'><td nowrap ><font face='Arial' size='1' color='#000000'>Description:</font></td>";
                htmlStr = String.valueOf(htmlStr) + "<td nowrap ><font face='Arial' size='1' color='#000000'><b>" + desc + "</b></font></td></tr>";
                htmlStr = String.valueOf(htmlStr) + "<tr valign='top'><td nowrap ><font face='Arial' size='1' color='#000000'>Type:</font></td>";
                htmlStr = String.valueOf(htmlStr) + "<td nowrap ><font face='Arial' size='1' color='#000000'><b>" + attr + "</b></font></td></tr>";
                htmlStr = attr.equals("NODEGROUP") ? String.valueOf(htmlStr) + "<tr valign='top'><td nowrap ><font face='Arial' size='1' color='#000000'>Group Paths:</font></td>" : (attr.equals("AGENTID") ? String.valueOf(htmlStr) + "<tr valign='top'><td nowrap ><font face='Arial' size='1' color='#000000'>Agent IDs:</font></td>" : String.valueOf(htmlStr) + "<tr valign='top'><td nowrap ><font face='Arial' size='1' color='#000000'>Java Pattern:</font></td>");
                htmlStr = String.valueOf(htmlStr) + "<td nowrap ><font face='Arial' size='1' color='#000000'><b>" + pattern + "</b></font></td></tr>";
                htmlStr = String.valueOf(htmlStr) + "</table>";
                htmlStr = String.valueOf(htmlStr) + "</body></html>";
            } else if (element instanceof ForwardCondition) {
                ForwardCondition fc = (ForwardCondition)element;
                Properties props = fc.getProperties();
                String name = props.getProperty("NAME");
                String desc = props.getProperty("C_DESCRIPTION");
                String severity = ServerFilterDialogTableProvider.this.getSeverityString(props.getProperty("SEVERITY"), true);
                String xsend = props.getProperty("XSEND");
                String type = fc.type;
                String typeA = props.getProperty("TYPE_A").equals("1") ? "+" : "-";
                String typeK = props.getProperty("TYPE_K").equals("1") ? "+" : "-";
                String to = props.getProperty(ForwardCondition.TO);
                String aTime = props.getProperty(ForwardCondition.ACTIVATION_TIME);
                String dTime = props.getProperty(ForwardCondition.DEACTIVATION_TIME);
                htmlStr = "<html><body bgcolor='#FFFFE1'>";
                htmlStr = String.valueOf(htmlStr) + "<table border='0' cellspacing='0' cellpadding='0'>";
                htmlStr = String.valueOf(htmlStr) + "<tr valign='top'><td nowrap ><font face='Arial' size='1' color='#000000'>Forward Condition:&nbsp;&nbsp;</font></td>";
                htmlStr = String.valueOf(htmlStr) + "<td nowrap ><font face='Arial' size='1' color='#000000'><b>" + name + "</b></font></td></tr>";
                htmlStr = String.valueOf(htmlStr) + "<tr valign='top'><td nowrap ><font face='Arial' size='1' color='#000000'>Description:</font></td>";
                htmlStr = String.valueOf(htmlStr) + "<td nowrap ><font face='Arial' size='1' color='#000000'><b>" + desc + "</b></font></td></tr>";
                htmlStr = String.valueOf(htmlStr) + "<tr valign='top'><td nowrap ><font face='Arial' size='1' color='#000000'>Activation Time:</font></td>";
                htmlStr = String.valueOf(htmlStr) + "<td nowrap ><font face='Arial' size='1' color='#000000'><b>" + aTime + "</b></font></td></tr>";
                htmlStr = String.valueOf(htmlStr) + "<tr valign='top'><td nowrap ><font face='Arial' size='1' color='#000000'>Deactivation Time:</font></td>";
                htmlStr = String.valueOf(htmlStr) + "<td nowrap ><font face='Arial' size='1' color='#000000'><b>" + dTime + "</b></font></td></tr>";
                htmlStr = String.valueOf(htmlStr) + "<tr valign='top'><td nowrap ><font face='Arial' size='1' color='#000000'>Availability:&nbsp;&nbsp;</font></td>";
                htmlStr = String.valueOf(htmlStr) + "<td nowrap ><font face='Arial' size='1' color='#000000'><b>" + typeA + "</b></font></td></tr>";
                htmlStr = String.valueOf(htmlStr) + "<tr valign='top'><td nowrap ><font face='Arial' size='1' color='#000000'>KPI:</font></td>";
                htmlStr = String.valueOf(htmlStr) + "<td nowrap ><font face='Arial' size='1' color='#000000'><b>" + typeK + "</b></font></td></tr>";
                htmlStr = String.valueOf(htmlStr) + "<tr valign='top'><td nowrap ><font face='Arial' size='1' color='#000000'>Type:</font></td>";
                htmlStr = String.valueOf(htmlStr) + "<td nowrap ><font face='Arial' size='1' color='#000000'><b>" + type + "</b></font></td></tr>";
                htmlStr = String.valueOf(htmlStr) + "<tr valign='top'><td nowrap ><font face='Arial' size='1' color='#000000'>Target:</font></td>";
                htmlStr = String.valueOf(htmlStr) + "<td nowrap ><font face='Arial' size='1' color='#000000'><b>" + to + "</b></font></td></tr>";
                htmlStr = String.valueOf(htmlStr) + "<tr valign='top'><td nowrap ><font face='Arial' size='1' color='#000000'>Severity:</font></td>";
                htmlStr = String.valueOf(htmlStr) + "<td nowrap ><font face='Arial' size='1' color='#000000'><b>" + severity + "</b></font></td></tr>";
                htmlStr = String.valueOf(htmlStr) + "<tr valign='top'><td nowrap ><font face='Arial' size='1' color='#000000'>Send:</font></td>";
                htmlStr = String.valueOf(htmlStr) + "<td nowrap ><font face='Arial' size='1' color='#000000'><b>" + xsend + "</b></font></td></tr>";
                htmlStr = String.valueOf(htmlStr) + "</table>";
                htmlStr = String.valueOf(htmlStr) + "</body></html>";
            }
            return htmlStr;
        }

        public Point getToolTipShift(Object object) {
            return new Point(3, 3);
        }

        public int getToolTipDisplayDelayTime(Object object) {
            return 50;
        }

        public int getToolTipTimeDisplayed(Object object) {
            return 9999999;
        }

        public void update(ViewerCell cell) {
            String result = "";
            Image image = null;
            int columnIndex = cell.getColumnIndex();
            Object element = cell.getElement();
            if (element instanceof ForwardFilter) {
                ForwardFilter fp = (ForwardFilter)element;
                switch (columnIndex) {
                    case 0: {
                        result = fp.getProperties().getProperty("NAME");
                        break;
                    }
                    case 1: {
                        result = fp.getProperties().getProperty("ATTRIBUTE");
                        break;
                    }
                    case 2: {
                        result = fp.getProperties().getProperty("PATTERN");
                        break;
                    }
                    case 3: {
                        result = fp.getProperties().getProperty("DESCRIPTION");
                        break;
                    }
                    case 4: {
                        result = "" + fp.getNumber();
                    }
                }
            } else if (element instanceof ForwardCondition) {
                ForwardCondition fc = (ForwardCondition)element;
                Properties props = fc.getProperties();
                switch (columnIndex) {
                    case 0: {
                        result = props.getProperty("NAME");
                        break;
                    }
                    case 1: {
                        result = props.getProperty(ForwardCondition.ACTIVATION_TIME);
                        break;
                    }
                    case 2: {
                        result = props.getProperty(ForwardCondition.DEACTIVATION_TIME);
                        break;
                    }
                    case 3: {
                        String typeA = props.getProperty("TYPE_A");
                        result = typeA.equals("1") ? "+" : "-";
                        break;
                    }
                    case 4: {
                        String typeK = props.getProperty("TYPE_K");
                        result = typeK.equals("1") ? "+" : "-";
                        break;
                    }
                    case 5: {
                        result = props.getProperty(ForwardCondition.TYPE);
                        break;
                    }
                    case 6: {
                        result = props.getProperty(ForwardCondition.TO);
                        break;
                    }
                    case 7: {
                        String sev = props.getProperty("SEVERITY");
                        result = ServerFilterDialogTableProvider.this.getSeverityString(sev, false);
                        break;
                    }
                    case 8: {
                        result = props.getProperty("C_DESCRIPTION");
                        break;
                    }
                    case 9: {
                        result = props.getProperty("XSEND");
                    }
                }
            }
            cell.setText(result);
            cell.setImage(image);
        }
    };

    public ServerFilterDialogTableProvider(TableViewer tableViewer, ForwardPolicy fp) {
        this.m_tv = tableViewer;
        this.m_fp = fp;
        if (this.m_tv == null) {
            return;
        }
        this.m_elements = new ArrayList();
        String tableType = (String)this.m_tv.getTable().getData();
        if (tableType.equals(RelatedServerFilterInfoDialog.ATTRIBUTE_FILTER_TABLE)) {
            ServerFilterView.getInstance();
            this.m_elements = ServerFilterView.getCurrentAttrFilters_SortedByNumber(this.m_fp);
        } else if (tableType.equals(RelatedServerFilterInfoDialog.FWD_CONDITION_TABLE)) {
            ForwardConditions fConditions = this.m_fp.conditions;
            this.m_elements = fConditions.getConditionList();
        }
    }

    public Object[] getElements(Object inputElement) {
        return this.m_elements.toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public String getSeverityString(String sevNumbers, boolean multiLine) {
        StringBuffer sevString = new StringBuffer();
        String[] items = sevNumbers.split(",");
        int i = 0;
        while (i < items.length) {
            try {
                int num = Integer.parseInt(items[i]);
                sevString.append(Severity.getSeverity(num)).append(this.getSeparator(i, items.length, multiLine));
            }
            catch (NumberFormatException numberFormatException) {}
            ++i;
        }
        return sevString.toString();
    }

    public String getSeparator(int num, int total, boolean multiLine) {
        String sep = "";
        if (num == total - 1) {
            return sep;
        }
        sep = multiLine ? (++num % 3 == 0 ? ",<br>" : ", ") : ", ";
        return sep;
    }
}

