/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.dialogs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.dialogs.SelectionDialog;

public class ShowHideColumnsDialog
extends SelectionDialog {
    private static List<TableColumn> defaultCol = null;
    private ILabelProvider labelProvider;
    private IStructuredContentProvider contentProvider;
    private Object inputElement;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 250;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 300;
    CheckboxTableViewer listViewer;

    public ShowHideColumnsDialog(Shell parentShell, TableViewer tv) {
        super(parentShell);
        this.setTitle("Show/Hide Columns");
        this.inputElement = tv.getTable().getColumns();
        this.setMessage("Columns:");
        this.contentProvider = ArrayContentProvider.getInstance();
        this.labelProvider = new ILabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getText(Object element) {
                TableColumn tc = (TableColumn)element;
                return tc.getToolTipText();
            }

            public Image getImage(Object element) {
                return null;
            }
        };
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)composite);
        this.createMessageArea(composite);
        this.listViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        GridData data = new GridData(1808);
        data.heightHint = 250;
        data.widthHint = 300;
        this.listViewer.getTable().setLayoutData((Object)data);
        this.listViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.listViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.addButtons(composite);
        this.initializeViewer();
        if (!this.getInitialElementSelections().isEmpty()) {
            this.checkInitialSelections();
        }
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void addButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)new GridData(0x1000008, 128, true, false));
        Button btnDefault = this.createButton(buttonComposite, 13, "Default", false);
        btnDefault.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ShowHideColumnsDialog.this.listViewer.setAllGrayed(false);
                ShowHideColumnsDialog.this.listViewer.setCheckedElements(defaultCol.toArray());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button btnSelect = this.createButton(buttonComposite, 18, "Select all", false);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShowHideColumnsDialog.this.listViewer.setAllChecked(true);
            }
        };
        btnSelect.addSelectionListener((SelectionListener)listener);
        Button btndeselect = this.createButton(buttonComposite, 19, "Deselect all", false);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShowHideColumnsDialog.this.listViewer.setAllChecked(false);
            }
        };
        btndeselect.addSelectionListener((SelectionListener)listener);
    }

    private void checkInitialSelections() {
        Iterator itemsToCheck = this.getInitialElementSelections().iterator();
        while (itemsToCheck.hasNext()) {
            this.listViewer.setChecked(itemsToCheck.next(), true);
        }
    }

    protected CheckboxTableViewer getViewer() {
        return this.listViewer;
    }

    private void initializeViewer() {
        this.listViewer.setInput(this.inputElement);
    }

    protected void okPressed() {
        Object[] children = this.contentProvider.getElements(this.inputElement);
        if (children != null) {
            ArrayList<Object> list = new ArrayList<Object>();
            int i = 0;
            while (i < children.length) {
                Object element = children[i];
                if (this.listViewer.getChecked(element)) {
                    list.add(element);
                }
                ++i;
            }
            this.setResult(list);
        }
        super.okPressed();
    }

    public void setDefaultColumns(List<TableColumn> list) {
        defaultCol = new ArrayList<TableColumn>();
        defaultCol.addAll(list);
    }
}

