/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.dialogs;

import com.blixx.boom.engine.UIJob;
import com.blixx.boom.engine.UIJobManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ShowMessageBox {
    protected String m_title = "";
    protected String m_message = "";
    protected int m_style = 0;

    public ShowMessageBox(String title, String message, int style) {
        if (title == null) {
            title = "";
        }
        if (message == null) {
            return;
        }
        this.m_title = title;
        this.m_message = message;
        this.m_style = style;
        if (Display.getCurrent() != null) {
            this.display();
        } else {
            UIJob uij = new UIJob("Dialog " + message){

                @Override
                public IStatus runInUIThread(IProgressMonitor monitor) {
                    ShowMessageBox.this.display();
                    return null;
                }
            };
            UIJobManager.getInstance().schedule(uij);
        }
    }

    private void display() {
        Shell parent = null;
        try {
            parent = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        }
        catch (Throwable throwable) {
            parent = Display.getCurrent().getActiveShell();
        }
        Shell dialog = new Shell(parent, 16861280);
        MessageBox messageBox = new MessageBox(dialog, this.m_style);
        messageBox.setText(this.m_title);
        messageBox.setMessage(this.m_message);
        messageBox.open();
        dialog.dispose();
    }
}

