/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.dialogs;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.views.BTableViewer;
import com.blixx.shared.Action;
import com.blixx.shared.User;
import com.blixx.shared.ext.ForwardPolicy;
import com.blixx.shared.ext.ModifyServerPolicy;
import com.blixx.shared.ext.OutagePolicy;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.GroupTreeObjectUnsubmitted;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class ShowMessageDialog
extends StatusDialog
implements DisposeListener,
SelectionListener {
    protected static final String VALUES_LIST = "VALUES_LIST";
    protected GUIDisplayElements m_gui = null;
    protected Composite m_compMain = null;
    protected Composite m_comp = null;
    protected Label m_icon = null;
    protected Label m_label = null;
    protected Text m_text = null;
    protected String m_okBtnText = "OK";
    protected String m_cancelBtnText = "Cancel";
    protected String m_header = null;
    protected String m_footer = null;
    protected String m_middletext = null;
    protected String m_noElementsText = null;
    protected List<Object> m_elements = null;
    protected boolean m_showCancelBtn = true;
    protected int m_hight = 70;
    protected List<Object> m_selection = new ArrayList<Object>();
    protected org.eclipse.swt.widgets.List m_UIList;
    public static int TYPE_TEXT = 0;
    public static int TYPE_LIST_WITHOUT_IMAGES = 1;
    public static int TYPE_LIST_WITH_IMAGES = 2;
    protected int m_type = TYPE_LIST_WITH_IMAGES;
    private Image headerImage = BMUI.IMAGE_QUESTION_MARK;
    private Image m_image_ok_btn = null;
    private Image m_image_cancel_btn = null;

    public ShowMessageDialog(Shell parentShell, String title, String header, String middleText, String footer, boolean showCancelBtn, String okBtnText) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x80 | 0x400);
        this.setTitle(title);
        this.setImage(BMUI.IMAGE_PRODUCT);
        this.m_type = TYPE_TEXT;
        this.m_header = header;
        this.m_middletext = middleText;
        this.m_footer = footer;
        this.m_hight = 450;
        this.m_showCancelBtn = showCancelBtn;
        if (okBtnText != null && okBtnText.length() > 1) {
            this.m_okBtnText = okBtnText;
        }
    }

    public ShowMessageDialog(Shell parentShell, String title, String header, String middleText, String footer, boolean showCancelBtn, String okBtnText, int height) {
        this(parentShell, title, header, middleText, footer, showCancelBtn, okBtnText);
        this.m_hight = height;
    }

    public ShowMessageDialog(Shell parentShell, String title, String header, String footer, boolean showCancelBtn, String okBtnText, List<?> elements, String noElementsText) {
        this(parentShell, title, header, null, footer, showCancelBtn, okBtnText);
        this.m_elements = new ArrayList<Object>(elements.size());
        for (Object o : elements) {
            this.m_elements.add(o);
        }
        this.m_type = TYPE_LIST_WITH_IMAGES;
        if (this.m_elements != null && this.m_elements.size() > 0) {
            try {
                Collections.sort(this.m_elements, new Comparator<Object>(){

                    @Override
                    public int compare(Object o1, Object o2) {
                        String str1 = "";
                        String str2 = "";
                        if (o1 != null) {
                            str1 = o1 instanceof AgentCard ? ((AgentCard)o1).getLabel() : o1.toString();
                        }
                        if (o2 != null) {
                            str2 = o2 instanceof AgentCard ? ((AgentCard)o2).getLabel() : o2.toString();
                        }
                        return str1.compareToIgnoreCase(str2);
                    }
                });
            }
            catch (Throwable throwable) {}
        }
        this.m_noElementsText = noElementsText;
    }

    public ShowMessageDialog(Shell parentShell, String title, String header, String footer, boolean showCancelBtn, String okBtnText, List elements, String noElementText, int type) {
        this(parentShell, title, header, footer, showCancelBtn, okBtnText, elements, noElementText);
        this.m_type = type;
    }

    protected Control createDialogArea(Composite parent) {
        GridLayout gl = null;
        GridData gd = null;
        this.m_gui = new GUIDisplayElements();
        this.m_compMain = new Composite(parent, 0);
        this.m_compMain.addDisposeListener((DisposeListener)this);
        gl = new GridLayout(2, false);
        gl.marginRight = 15;
        gl.marginLeft = 15;
        gl.marginTop = 10;
        this.m_compMain.setLayout((Layout)gl);
        gd = new GridData(4, 4, true, true);
        gd.widthHint = 500;
        gd.heightHint = this.m_hight;
        this.m_compMain.setLayoutData((Object)gd);
        this.m_icon = new Label(this.m_compMain, 128);
        this.m_icon.setImage(this.headerImage);
        this.m_icon.setLayoutData((Object)new GridData(16384, 128, false, false));
        if (this.m_type == TYPE_TEXT && this.m_middletext != null) {
            if (this.m_middletext.length() == 0) {
                this.displayHeader(this.m_noElementsText, this.m_compMain);
                this.m_showCancelBtn = false;
                this.m_okBtnText = "OK";
                return parent;
            }
            this.displayHeader(this.m_header, this.m_compMain);
            this.createNormalMiddleText();
        } else if (this.m_type == TYPE_LIST_WITHOUT_IMAGES && this.m_elements != null) {
            if (this.m_elements.size() == 0) {
                this.displayHeader(this.m_noElementsText, this.m_compMain);
                this.m_showCancelBtn = false;
                this.m_okBtnText = "OK";
                return parent;
            }
            this.displayHeader(this.m_header, this.m_compMain);
            ScrolledComposite sc = new ScrolledComposite(this.m_compMain, 2816);
            sc.setAlwaysShowScrollBars(false);
            sc.setExpandHorizontal(true);
            sc.setExpandVertical(true);
            sc.setLayout((Layout)new GridLayout(2, false));
            sc.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
            this.m_UIList = new org.eclipse.swt.widgets.List((Composite)sc, 2);
            String[] array = new String[this.m_elements.size()];
            int i = 0;
            while (i < this.m_elements.size()) {
                array[i] = "" + this.m_elements.get(i);
                ++i;
            }
            this.m_UIList.setItems(array);
            this.m_UIList.setData((Object)VALUES_LIST);
            this.m_UIList.addSelectionListener((SelectionListener)this);
            sc.setContent((Control)this.m_UIList);
            sc.setMinSize(this.m_UIList.computeSize(-1, -1));
        } else if (this.m_type == TYPE_LIST_WITH_IMAGES && this.m_elements != null) {
            if (this.m_elements.size() == 0) {
                this.displayHeader(this.m_noElementsText, this.m_compMain);
                this.m_showCancelBtn = false;
                this.m_okBtnText = "OK";
                return parent;
            }
            this.displayHeader(this.m_header, this.m_compMain);
            ScrolledComposite sc = new ScrolledComposite(this.m_compMain, 2816);
            sc.setAlwaysShowScrollBars(false);
            sc.setExpandHorizontal(true);
            sc.setExpandVertical(true);
            sc.setLayout((Layout)new GridLayout(2, false));
            sc.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
            Composite m_comp = new Composite((Composite)sc, 0);
            gl = new GridLayout(1, false);
            gl.verticalSpacing = 2;
            m_comp.setLayout((Layout)gl);
            m_comp.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            m_comp = this.createContent(m_comp, this.m_elements);
            sc.setContent((Control)m_comp);
            sc.setMinSize(m_comp.computeSize(-1, -1));
        }
        this.createFooter(this.m_footer, this.m_compMain);
        return parent;
    }

    protected void createNormalMiddleText() {
        this.m_comp = new Composite(this.m_compMain, 0);
        this.m_comp.setLayout((Layout)new GridLayout(2, false));
        this.m_comp.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.m_text = this.m_gui.addInputFieldMultiLineNoWrap(this.m_comp, "", null, this.m_middletext, 2, 1, 200, 100, 1, 1, null);
        this.m_text.setEditable(false);
        ((GridData)this.m_text.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.m_text.getLayoutData()).verticalAlignment = 4;
        ((GridData)this.m_text.getLayoutData()).grabExcessHorizontalSpace = true;
        ((GridData)this.m_text.getLayoutData()).grabExcessVerticalSpace = true;
    }

    protected void createFooter(String text, Composite compMain) {
        if (text != null && text.length() > 0) {
            this.m_label = this.m_gui.addTextField(compMain, null, text, 1, 1, 1, 1, null);
            ((GridData)this.m_label.getLayoutData()).horizontalSpan = 2;
            ((GridData)this.m_label.getLayoutData()).horizontalAlignment = 16384;
        }
    }

    protected void displayHeader(String msg1, Composite compMain) {
        if (msg1 != null && msg1.length() > 1) {
            this.m_label = this.m_gui.addTextField(compMain, null, msg1, 1, 1, 1, 1, null);
            ((GridData)this.m_label.getLayoutData()).horizontalIndent = 5;
        }
    }

    protected Composite createContent(Composite parent, List<Object> elements) {
        LinkedList<Object[]> list = new LinkedList<Object[]>();
        int i = 0;
        while (i < elements.size()) {
            StringBuilder sb;
            OutagePolicy sp;
            String type;
            Image image;
            Object o = elements.get(i);
            if (o instanceof GroupTreeObjectUnsubmitted) {
                GroupTreeObjectUnsubmitted gtolu = (GroupTreeObjectUnsubmitted)o;
                String imageKey = "IMG_TOOL_NEW_WIZARD";
                image = PlatformUI.getWorkbench().getSharedImages().getImage(imageKey);
                list.add(new Object[]{image, gtolu.getName()});
            } else if (o instanceof GroupTreeObjectLast) {
                Image image2;
                GroupTreeObjectLast gtol = (GroupTreeObjectLast)o;
                type = gtol.getTreeObject().getType();
                if (type.equals(BMUI.type_mon)) {
                    if (gtol.isItLink()) {
                        list.add(new Object[]{BMUI.IMAGE_MON_LNK, gtol.getName()});
                    } else {
                        list.add(new Object[]{BMUI.IMAGE_MON, gtol.getName()});
                    }
                } else if (type.equals(BMUI.type_msg)) {
                    if (gtol.isItLink()) {
                        list.add(new Object[]{BMUI.IMAGE_MSG_LNK, gtol.getName()});
                    } else {
                        list.add(new Object[]{BMUI.IMAGE_MSG, gtol.getName()});
                    }
                } else if (type.equals(BMUI.type_act)) {
                    Action action = (Action)gtol.getTreeObject().getObject();
                    if (action.m_serverAction) {
                        list.add(new Object[]{BMUI.IMAGE_ACTION_SERVER, gtol.getName()});
                    } else {
                        list.add(new Object[]{BMUI.IMAGE_ACTION, gtol.getName()});
                    }
                } else if (type.equals(BMUI.type_agt)) {
                    AgentCard ac = (AgentCard)gtol.getTreeObject().getObject();
                    image2 = BMUI.IMAGE_MAP.get(gtol.getIcon());
                    if (ac == null) {
                        list.add(new Object[]{image2, gtol.getTreeObject().getName()});
                    } else {
                        list.add(new Object[]{image2, String.valueOf(ac.getLabel()) + " (" + ac.getAgentIP() + ")"});
                    }
                } else if (type.equals(BMUI.type_assignment_bin)) {
                    if (gtol.isItLink()) {
                        list.add(new Object[]{BMUI.IMAGE_PKG_LNK, gtol.getName()});
                    } else {
                        list.add(new Object[]{BMUI.IMAGE_PKG, gtol.getName()});
                    }
                } else if (type.equals(BMUI.type_file)) {
                    String imageKey = "IMG_OBJ_FILE";
                    image2 = PlatformUI.getWorkbench().getSharedImages().getImage(imageKey);
                    list.add(new Object[]{image2, gtol.getName()});
                }
            } else if (o instanceof GroupTreeObject) {
                GroupTreeObject gto = (GroupTreeObject)o;
                type = gto.getTreeObject().getType();
                if (type.equals(BMUI.type_assignment_pol)) {
                    list.add(new Object[]{BMUI.IMAGE_ASN, gto.getName()});
                } else if (type.equals(BMUI.type_assignment_bin)) {
                    list.add(new Object[]{BMUI.IMAGE_PKG, gto.getName()});
                } else {
                    list.add(new Object[]{BMUI.IMAGE_FOLDER_DEFAULT, gto.getName()});
                }
            } else if (o instanceof ForwardPolicy) {
                ForwardPolicy fp = (ForwardPolicy)o;
                list.add(new Object[]{BMUI.IMAGE_FWD, fp.policyName});
            } else if (o instanceof String) {
                String element = (String)o;
                list.add(new Object[]{BMUI.IMAGE_TRANSPARENT_12x12, element});
            } else if (o instanceof AgentCard) {
                AgentCard ac = (AgentCard)o;
                String status = ac.getIconnameForAgent();
                image = BMUI.IMAGE_MAP.get(status);
                if (image == null) {
                    image = BMUI.IMAGE_PC;
                }
                list.add(new Object[]{image, String.valueOf(ac.getLabel()) + " (" + ac.getAgentIP() + ")"});
            } else if (o instanceof User) {
                User user = (User)o;
                String image3 = Repository.getInstance().getUserManager().getUserImageStr(user);
                StringBuffer sb2 = new StringBuffer();
                sb2.append(user.m_firstName).append(" ").append(user.m_lastName).append(" (").append(user.m_loginName).append(")");
                list.add(new Object[]{BMUI.IMAGE_MAP.get(image3), sb2.toString()});
            } else if (o instanceof ModifyServerPolicy) {
                sp = (ModifyServerPolicy)o;
                sb = new StringBuilder(sp.getName());
                sb.append(" (ID=").append(sp.getID()).append(")");
                list.add(new Object[]{BMUI.IMAGE_MODIFYPOL, sb.toString()});
            } else if (o instanceof OutagePolicy) {
                sp = (OutagePolicy)o;
                sb = new StringBuilder(sp.getName());
                sb.append(" (ID=").append(sp.getID()).append(")");
                list.add(new Object[]{BMUI.IMAGE_OUTAGE, sb.toString()});
            }
            ++i;
        }
        Composite tableComp = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        tableComp.setLayout((Layout)gl);
        tableComp.setLayoutData((Object)new GridData(4, 4, true, true));
        Table tbl = new Table(tableComp, 0x10000300);
        tbl.setHeaderVisible(false);
        tbl.setLinesVisible(false);
        tbl.setLayoutData((Object)new GridData(4, 4, true, true));
        TableColumn col1 = new TableColumn(tbl, 16384);
        col1.setWidth(25);
        col1.setMoveable(true);
        TableColumn col2 = new TableColumn(tbl, 16384);
        col2.setWidth(330);
        col2.setMoveable(true);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableComp.setLayout((Layout)tableLayout);
        tableLayout.setColumnData((Widget)col1, (ColumnLayoutData)new ColumnWeightData(0, col1.getWidth()));
        tableLayout.setColumnData((Widget)col2, (ColumnLayoutData)new ColumnWeightData(100, col2.getWidth()));
        BTableViewer tableViewer = new BTableViewer(tbl);
        tableViewer.setUseHashlookup(true);
        tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){
            Object[] data = new Object[0];

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                this.data = (Object[])newInput;
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return this.data;
            }
        });
        tableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return true;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element == null) {
                    return "";
                }
                if (element instanceof Object[]) {
                    Object el = ((Object[])element)[columnIndex];
                    if (el instanceof String) {
                        return el.toString();
                    }
                    return "";
                }
                return element.toString();
            }

            public Image getColumnImage(Object element, int columnIndex) {
                Object el;
                if (element instanceof Object[] && (el = ((Object[])element)[columnIndex]) instanceof Image) {
                    return (Image)el;
                }
                return null;
            }
        });
        tableViewer.setInput(list.toArray());
        return parent;
    }

    public void setCancelButtonText(String text) {
        this.m_cancelBtnText = text;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button ok = this.createButton(parent, 3, this.m_okBtnText, true);
        if (this.m_image_ok_btn != null) {
            ok.setImage(this.m_image_ok_btn);
        }
        if (this.m_showCancelBtn) {
            Button cancel = this.createButton(parent, 1, this.m_cancelBtnText, false);
            if (this.m_image_cancel_btn != null) {
                cancel.setImage(this.m_image_cancel_btn);
            }
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1) {
            super.cancelPressed();
        } else if (buttonId == 3) {
            super.okPressed();
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        try {
            this.m_compMain.dispose();
        }
        catch (Throwable throwable) {}
        try {
            if (this.m_comp != null) {
                this.m_comp.dispose();
            }
        }
        catch (Throwable throwable) {}
        try {
            this.m_icon.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_label.dispose();
        }
        catch (Throwable throwable) {}
        try {
            if (this.m_text != null) {
                this.m_text.dispose();
            }
        }
        catch (Throwable throwable) {}
        try {
            if (this.m_UIList != null) {
                this.m_UIList.dispose();
            }
        }
        catch (Throwable throwable) {}
    }

    public boolean close() {
        return super.close();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget.getData() == VALUES_LIST) {
            String[] arr = this.m_UIList.getSelection();
            this.m_selection.clear();
            int i = 0;
            while (i < arr.length) {
                this.m_selection.add(arr[i]);
                ++i;
            }
        }
    }

    public List<Object> getSelection() {
        return this.m_selection;
    }

    public void setIconInHeader(Image icon) {
        this.headerImage = icon;
        try {
            if (this.m_icon != null && !this.m_icon.isDisposed()) {
                this.m_icon.setImage(icon);
            }
        }
        catch (Throwable throwable) {}
    }

    public void setImageOkButton(Image image) {
        this.m_image_ok_btn = image;
    }

    public void setHight(int hight) {
        this.m_hight = hight;
    }

    public void setImageCancelButton(Image image) {
        this.m_image_cancel_btn = image;
    }
}

