/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.dialogs;

import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.log.RTLogger;
import com.blixx.shared.utils.StrUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class SnmpV3ImportUserDialog
extends StatusDialog
implements ModifyListener,
SelectionListener {
    public static final String FIELD_ = "Field ";
    public static final String CC_NONE = "-";
    public static final String CC_COMMENT = "COMMENT";
    public static final String CC_PRIV_PASS = "PRIV_PASS";
    public static final String CC_PRIV_TYPE = "PRIV_TYPE";
    public static final String CC_AUTH_PASS = "AUTH_PASS";
    public static final String CC_AUTH_TYPE = "AUTH_TYPE";
    public static final String CC_USER = "USER";
    public static final String CC_ENGINE_ID = "ENGINE_ID";
    public static final String FIELD_REFRESH = "FIELD_REFRESH";
    public static final String FIELD_QUOTES = "FIELD_QUOTES";
    public static final String FIELD_SEPARATORS = "SEPARATORS";
    public GUIDisplayElements m_gui = null;
    public Composite m_parentComp = null;
    public Composite m_dialogArea = null;
    public ScrolledComposite m_sc = null;
    public File m_importFile = null;
    public boolean m_useDoubleQuotes = true;
    public String m_separators = ",";
    public Table m_table = null;
    public TableViewer m_tableViewer = null;
    public TableProvider m_tableProvider = null;
    public List<String[]> m_data = null;
    public Map<String, String> m_mapping = new HashMap<String, String>();

    public SnmpV3ImportUserDialog(Shell parent, File importFile) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x80 | 0x400);
        this.setTitle(" Import  SNMP v3 Users");
        this.m_parentComp = parent;
        this.m_importFile = importFile;
        this.m_gui = new GUIDisplayElements();
    }

    protected Control createDialogArea(Composite parent) {
        try {
            this.m_dialogArea = new Composite(parent, 0);
            GridLayout gl = new GridLayout(1, false);
            gl.marginHeight = 0;
            gl.marginTop = 5;
            gl.marginRight = 10;
            gl.marginLeft = 10;
            this.m_dialogArea.setLayout((Layout)gl);
            this.m_dialogArea.setLayoutData((Object)new GridData(4, 4, true, true));
            Composite sepChar_comp = new Composite(this.m_dialogArea, 0);
            sepChar_comp.setLayout((Layout)new GridLayout(3, false));
            sepChar_comp.setLayoutData((Object)new GridData(4, 4, true, false));
            Text sepChar_input = this.m_gui.addInputFieldSingle(sepChar_comp, FIELD_SEPARATORS, "Separator Characters: ", ",", 1, 1, 0, 0, 80, this);
            ((GridData)sepChar_input.getLayoutData()).horizontalAlignment = 4;
            ((GridData)sepChar_input.getLayoutData()).grabExcessHorizontalSpace = true;
            this.m_gui.addButton(sepChar_comp, FIELD_REFRESH, "Refresh", true, this);
            this.createTable();
        }
        catch (Throwable e) {
            RTLogger.print(5, "", e);
        }
        return this.m_dialogArea;
    }

    public void createTable() {
        if (this.m_table == null) {
            this.m_table = new Table(this.m_dialogArea, 268503810);
            this.m_table.setHeaderVisible(true);
            this.m_table.setLinesVisible(true);
            GridData gridData = new GridData(4, 4, true, true);
            gridData.minimumHeight = 200;
            gridData.heightHint = 400;
            gridData.horizontalSpan = ((GridLayout)this.m_dialogArea.getLayout()).numColumns;
            this.m_table.setLayoutData((Object)gridData);
            this.m_tableViewer = new TableViewer(this.m_table);
            this.m_tableProvider = new TableProvider();
            this.m_tableViewer.setContentProvider((IContentProvider)this.m_tableProvider);
            this.m_tableViewer.setLabelProvider((IBaseLabelProvider)this.m_tableProvider);
        } else {
            TableColumn[] tableColumnArray = this.m_table.getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn tc = tableColumnArray[n2];
                tc.dispose();
                ++n2;
            }
        }
        this.m_data = this.readFile();
        int columns = this.getMaxColumns(this.m_data);
        String[] fields = new String[columns + 1];
        fields[0] = CC_NONE;
        int i = 1;
        while (i <= columns) {
            String fname;
            TableColumn tc = new TableColumn(this.m_table, 16384);
            fields[i] = fname = FIELD_ + i;
            tc.setText(fname);
            tc.setMoveable(true);
            tc.setWidth(280);
            ++i;
        }
        this.m_tableViewer.setInput((Object)this.m_data.toArray());
        Composite bottom_comp = new Composite(this.m_dialogArea, 0);
        GridLayout gl = new GridLayout(4, false);
        gl.marginHeight = 0;
        gl.marginTop = 5;
        bottom_comp.setLayout((Layout)gl);
        bottom_comp.setLayoutData((Object)new GridData(4, 4, true, false));
        CCombo cc1 = this.m_gui.addDropDown(bottom_comp, CC_ENGINE_ID, "Engine ID (Required):  ", fields, fields[0], "", 1, 1, 0, 0, this);
        ((GridData)cc1.getLayoutData()).grabExcessHorizontalSpace = true;
        CCombo cc2 = this.m_gui.addDropDown(bottom_comp, CC_USER, "User (Required):  ", fields, fields[0], "", 1, 1, 20, 0, this);
        ((GridData)cc2.getLayoutData()).grabExcessHorizontalSpace = true;
        this.m_gui.addDropDown(bottom_comp, CC_AUTH_TYPE, "Auth Type: ", fields, fields[0], "", 1, 1, 0, 0, this);
        this.m_gui.addDropDown(bottom_comp, CC_AUTH_PASS, "Auth Pass: ", fields, fields[0], "", 1, 1, 20, 0, this);
        this.m_gui.addDropDown(bottom_comp, CC_PRIV_TYPE, "Priv Type: ", fields, fields[0], "", 1, 1, 0, 0, this);
        this.m_gui.addDropDown(bottom_comp, CC_PRIV_PASS, "Priv Pass", fields, fields[0], "", 1, 1, 20, 0, this);
        this.m_gui.addDropDown(bottom_comp, CC_COMMENT, "Comment: ", fields, fields[0], "", 1, 1, 0, 0, this);
    }

    protected void updateButtonsEnableState(IStatus status) {
        super.updateButtonsEnableState(status);
        this.getButton(0).setEnabled(false);
    }

    public List<String[]> readFile() {
        ArrayList<String[]> data = new ArrayList<String[]>();
        FileReader fr = null;
        try {
            fr = new FileReader(this.m_importFile);
            BufferedReader br = new BufferedReader(fr);
            String line = null;
            while ((line = br.readLine()) != null) {
                ArrayList<String> tokens = new ArrayList<String>();
                StrUtils su = new StrUtils();
                String[] values = su.split(line, this.m_separators);
                int i = 0;
                while (i < values.length) {
                    tokens.add(su.removeQuotesStrict(values[i]));
                    ++i;
                }
                data.add(tokens.toArray(new String[0]));
            }
            if (data.size() < 5) {
                int i = data.size();
                while (i <= 5) {
                    data.add(new String[0]);
                    ++i;
                }
            }
        }
        catch (Throwable e) {
            new ShowMessageBox("Error reading file", "Error reading file: " + e.getMessage(), 1);
            try {
                fr.close();
            }
            catch (Throwable throwable) {}
        }
        return data;
    }

    public int getMaxColumns(List<String[]> data) {
        int max = 0;
        for (String[] arr : data) {
            max = Math.max(max, arr.length);
        }
        return max;
    }

    public void modifyText(ModifyEvent e) {
        Text text;
        if (e.widget instanceof Text && FIELD_SEPARATORS.equals((text = (Text)e.widget).getData())) {
            this.m_separators = text.getText().replace("\\n", "\n").replace("\\t", "\t");
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget instanceof Button) {
            Button button = (Button)e.widget;
            if (FIELD_QUOTES.equals(button.getData())) {
                this.m_useDoubleQuotes = button.getSelection();
            } else if (FIELD_REFRESH.equals(button.getData())) {
                this.createTable();
            }
        } else if (e.widget instanceof CCombo) {
            CCombo cc = (CCombo)e.widget;
            if (CC_ENGINE_ID.equals(cc.getData())) {
                if (cc.getText().equals(CC_NONE)) {
                    this.m_mapping.remove(CC_ENGINE_ID);
                } else {
                    this.m_mapping.put(CC_ENGINE_ID, cc.getText());
                }
            } else if (CC_USER.equals(cc.getData())) {
                if (cc.getText().equals(CC_NONE)) {
                    this.m_mapping.remove(CC_USER);
                } else {
                    this.m_mapping.put(CC_USER, cc.getText());
                }
            } else if (CC_AUTH_TYPE.equals(cc.getData())) {
                if (cc.getText().equals(CC_NONE)) {
                    this.m_mapping.remove(CC_AUTH_TYPE);
                } else {
                    this.m_mapping.put(CC_AUTH_TYPE, cc.getText());
                }
            } else if (CC_AUTH_PASS.equals(cc.getData())) {
                if (cc.getText().equals(CC_NONE)) {
                    this.m_mapping.remove(CC_AUTH_PASS);
                } else {
                    this.m_mapping.put(CC_AUTH_PASS, cc.getText());
                }
            } else if (CC_PRIV_TYPE.equals(cc.getData())) {
                if (cc.getText().equals(CC_NONE)) {
                    this.m_mapping.remove(CC_PRIV_TYPE);
                } else {
                    this.m_mapping.put(CC_PRIV_TYPE, cc.getText());
                }
            } else if (CC_PRIV_PASS.equals(cc.getData())) {
                if (cc.getText().equals(CC_NONE)) {
                    this.m_mapping.remove(CC_PRIV_PASS);
                } else {
                    this.m_mapping.put(CC_PRIV_PASS, cc.getText());
                }
            }
        }
        this.getButton(0).setEnabled(this.isValidMapping());
    }

    public boolean isValidMapping() {
        String engineFF = this.m_mapping.get(CC_ENGINE_ID);
        String userFF = this.m_mapping.get(CC_USER);
        return engineFF != null && userFF != null;
    }

    public class TableProvider
    implements IStructuredContentProvider,
    ITableLabelProvider {
        Object[] data = null;

        public void addListener(ILabelProviderListener arg0) {
        }

        public void dispose() {
        }

        public Image getColumnImage(Object arg0, int arg1) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String[] arr = (String[])element;
            return columnIndex < arr.length ? arr[columnIndex] : "";
        }

        public Object[] getElements(Object arg0) {
            return this.data;
        }

        public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
            this.data = (Object[])arg2;
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

