/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.dialogs;

import com.blixx.boom.authentication.UserTreeObject;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.dialogs.IRefreshable;
import com.blixx.boom.gui.policies.ViewContentProvider;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.utils.STreeViewer;
import com.blixx.boom.gui.views.StyledTreeLabelProvider;
import com.blixx.boom.gui.views.UserDialogTableProvider;
import com.blixx.boom.gui.views.actions.ExpandCollapseAction;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class UserTreeDialog
extends Dialog
implements SelectionListener,
IRefreshable {
    private TreeViewer m_treeViewer;
    private GroupTreeObject m_root = null;
    private String[] m_userRoles = null;
    private GUIDisplayElements m_gui = null;
    private Table m_userTable = null;
    private TableViewer m_tableViewer = null;
    private UserDialogTableProvider m_tableProvider = null;
    private Button m_select_button = null;
    private Button m_deselect_button = null;
    private static String SELECT_BUTTON = "SELECT_BUTTON";
    private static String DESELECT_BUTTON = "DESELECT_BUTTON";
    private Boolean m_isUserSelected = false;

    public UserTreeDialog(Shell parentShell, String[] userRoles) {
        super(parentShell);
        super.setShellStyle(66704);
        UserTreeDialog.setDefaultImage((Image)BMUI.IMAGE_USERS);
        this.m_userRoles = userRoles;
        this.m_isUserSelected = this.isUserSelected();
    }

    protected Control createDialogArea(Composite parent) {
        super.getShell().setText(this.m_isUserSelected != false ? "  Select Users/Roles" : "  Select User Roles");
        this.m_gui = new GUIDisplayElements();
        Composite comp = (Composite)super.createDialogArea(parent);
        GridLayout gl = new GridLayout(3, false);
        gl.marginTop = 7;
        gl.marginRight = 7;
        gl.marginLeft = 7;
        comp.setLayout((Layout)gl);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 600;
        gd.heightHint = 350;
        comp.setLayoutData((Object)gd);
        this.m_gui.addTextField(comp, null, this.m_isUserSelected != false ? "Users/Roles: " : "User Roles: ", 2, 1, 1, 1, null);
        this.m_gui.addTextField(comp, null, this.m_isUserSelected != false ? "Selected Users/Roles: " : "Selected User Roles: ", 1, 1, 1, 1, null);
        this.createTree(comp);
        Composite btnComp = new Composite(comp, 0);
        btnComp.setLayout((Layout)new GridLayout(1, false));
        btnComp.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        this.m_select_button = this.m_gui.addButton(btnComp, SELECT_BUTTON, " >> ", false, 120, 10, 1, 0, this);
        this.m_deselect_button = this.m_gui.addButton(btnComp, DESELECT_BUTTON, " << ", false, 120, 10, 1, 0, this);
        this.createUserTable(comp);
        return comp;
    }

    public void createTree(Composite parent) {
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 250;
        gd.heightHint = 250;
        this.m_treeViewer = new STreeViewer(parent, 2818);
        this.m_treeViewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.m_treeViewer.getTree().setLayoutData((Object)gd);
        this.m_treeViewer.setLabelProvider((IBaseLabelProvider)new StyledTreeLabelProvider(StyledTreeLabelProvider.UserTreeDialog));
        Repository.getInstance().getUserManager().addUserTreeListener(this);
        this.m_root = Repository.getInstance().getUserManager().getUserTree();
        this.m_treeViewer.setInput((Object)this.m_root);
        this.m_treeViewer.collapseAll();
        this.m_treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean isValidSelection = false;
                ArrayList<GroupTreeObject> treeSelection = UserTreeDialog.this.getTreeSelection();
                if (UserTreeDialog.this.m_isUserSelected.booleanValue()) {
                    if (treeSelection.size() > 0) {
                        isValidSelection = true;
                    }
                } else {
                    int i = 0;
                    while (i < treeSelection.size()) {
                        GroupTreeObject gto = (GroupTreeObject)treeSelection.get(i);
                        if (!(gto instanceof GroupTreeObjectLast)) {
                            isValidSelection = true;
                            break;
                        }
                        ++i;
                    }
                }
                if (isValidSelection) {
                    UserTreeDialog.this.m_gui.enableField(UserTreeDialog.this.m_select_button, true);
                } else {
                    UserTreeDialog.this.m_gui.enableField(UserTreeDialog.this.m_select_button, false);
                }
                UserTreeDialog.this.m_gui.enableField(UserTreeDialog.this.m_select_button, isValidSelection);
            }
        });
        this.m_treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                AddUserAction addAction = new AddUserAction(UserTreeDialog.this.m_isUserSelected);
                addAction.run();
            }
        });
        this.createTree_contentMenu();
    }

    public void createTree_contentMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        Menu menu = menuMgr.createContextMenu(this.m_treeViewer.getControl());
        this.m_treeViewer.getControl().setMenu(menu);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    manager.add((IAction)new AddUserAction(UserTreeDialog.this.m_isUserSelected));
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new ExpandCollapseAction(UserTreeDialog.this.m_treeViewer, "ExpandAll"));
                    manager.add((IAction)new ExpandCollapseAction(UserTreeDialog.this.m_treeViewer, "CollapseAll"));
                }
                catch (RuntimeException runtimeException) {}
            }
        });
    }

    public void createUserTable(Composite parent) {
        this.m_userTable = new Table(parent, 68354);
        this.m_userTable.setHeaderVisible(false);
        this.m_userTable.setLinesVisible(false);
        GridLayout gl = new GridLayout();
        gl.verticalSpacing = 0;
        this.m_userTable.setLayout((Layout)gl);
        GridData gd = new GridData(4, 4, true, true, 1, 1);
        gd.heightHint = 250;
        gd.widthHint = 250;
        this.m_userTable.setLayoutData((Object)gd);
        TableColumn col1 = new TableColumn(this.m_userTable, 16384);
        col1.setText("Number");
        col1.setWidth(160);
        this.m_tableViewer = new TableViewer(this.m_userTable);
        this.m_tableProvider = new UserDialogTableProvider(this.m_tableViewer);
        this.m_tableProvider.init(this.m_root, this.m_userRoles);
        this.m_tableViewer.setContentProvider((IContentProvider)this.m_tableProvider);
        this.m_tableViewer.setLabelProvider((IBaseLabelProvider)this.m_tableProvider);
        this.m_tableViewer.setInput((Object)this.m_tableProvider.getElements(null));
        this.m_tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ArrayList<GroupTreeObject> selection = UserTreeDialog.this.getTableSelection();
                if (selection.size() > 0) {
                    UserTreeDialog.this.m_gui.enableField(UserTreeDialog.this.m_deselect_button, true);
                } else {
                    UserTreeDialog.this.m_gui.enableField(UserTreeDialog.this.m_deselect_button, false);
                }
            }
        });
        this.m_tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                RemoveUserAction removeUser = new RemoveUserAction();
                removeUser.run();
            }
        });
        this.createTable_contentMenu();
    }

    public void createTable_contentMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        Menu menu = menuMgr.createContextMenu(this.m_tableViewer.getControl());
        this.m_tableViewer.getControl().setMenu(menu);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    manager.add((IAction)new RemoveUserAction());
                }
                catch (RuntimeException runtimeException) {}
            }
        });
    }

    private boolean isUserSelected() {
        GroupTreeObject root = Repository.getInstance().getUserManager().getUserTree();
        int i = 0;
        while (i < this.m_userRoles.length) {
            GroupTreeObjectLast gtol = UserDialogTableProvider.findUserByLoginName(root, this.m_userRoles[i]);
            if (gtol != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public ArrayList<GroupTreeObject> getTreeSelection() {
        ArrayList<GroupTreeObject> selection = new ArrayList<GroupTreeObject>();
        StructuredSelection sel = (StructuredSelection)this.m_treeViewer.getSelection();
        try {
            if (!sel.isEmpty()) {
                Iterator it = sel.iterator();
                while (it.hasNext()) {
                    selection.add((GroupTreeObject)it.next());
                }
            }
        }
        catch (RuntimeException runtimeException) {}
        return selection;
    }

    public ArrayList<GroupTreeObject> getTableSelection() {
        ArrayList<GroupTreeObject> selection = new ArrayList<GroupTreeObject>();
        StructuredSelection sel = (StructuredSelection)this.m_tableViewer.getSelection();
        try {
            if (!sel.isEmpty()) {
                for (Object o : sel) {
                    if (!(o instanceof GroupTreeObject)) continue;
                    selection.add((GroupTreeObject)o);
                }
            }
        }
        catch (RuntimeException runtimeException) {}
        return selection;
    }

    public String getSelectionSeparatedByComma() {
        StringBuffer selection_sb = new StringBuffer();
        ArrayList<GroupTreeObject> selection = this.m_tableProvider.getUsers();
        int i = 0;
        while (i < selection.size()) {
            GroupTreeObject gto = (GroupTreeObject)selection.get(i);
            if (gto instanceof GroupTreeObjectLast) {
                selection_sb.append(',').append(((UserTreeObject)gto.getTreeObject()).m_user.m_loginName);
            } else {
                selection_sb.append(",[").append(gto.getName()).append(']');
            }
            ++i;
        }
        if (selection_sb.toString().startsWith(",")) {
            selection_sb.delete(0, 1);
        }
        return selection_sb.toString();
    }

    protected void okPressed() {
        super.okPressed();
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    public boolean close() {
        try {
            this.m_userTable.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_select_button.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_deselect_button.dispose();
        }
        catch (Throwable throwable) {}
        try {
            this.m_tableProvider.dispose();
        }
        catch (Throwable throwable) {}
        return super.close();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() instanceof Button) {
            Button b = (Button)e.getSource();
            String name = (String)b.getData();
            if (name.equals(SELECT_BUTTON)) {
                AddUserAction addAction = new AddUserAction(this.m_isUserSelected);
                addAction.run();
            } else if (name.equals(DESELECT_BUTTON)) {
                RemoveUserAction removeUser = new RemoveUserAction();
                removeUser.run();
            }
        }
    }

    @Override
    public void refresh() {
        this.m_treeViewer.refresh();
    }

    private class AddUserAction
    extends Action {
        private boolean m_hasUser;
        private ArrayList<GroupTreeObject> m_treeSelection;

        public AddUserAction(boolean isUserSelected) {
            super("AddUsers");
            this.m_hasUser = false;
            this.m_treeSelection = null;
            this.setId("AddUsers");
            this.setText("Add User Role");
            this.m_hasUser = isUserSelected;
            this.m_treeSelection = UserTreeDialog.this.getTreeSelection();
            if (this.m_hasUser) {
                if (this.m_treeSelection.size() == 1) {
                    if (this.m_treeSelection.get(0) instanceof GroupTreeObjectLast) {
                        this.setText("Add User");
                    } else {
                        this.setText("Add User Role");
                    }
                } else if (this.m_treeSelection.size() > 1) {
                    this.setText(this.m_hasUser ? "Add Users/Roles" : "Add User Roles");
                } else {
                    this.setEnabled(false);
                }
            } else if (this.m_treeSelection.size() == 1) {
                if (this.m_treeSelection.get(0) instanceof GroupTreeObjectLast) {
                    this.setEnabled(false);
                } else {
                    this.setText("Add User Role");
                }
            } else if (this.m_treeSelection.size() > 1) {
                ArrayList<GroupTreeObject> userRoles = new ArrayList<GroupTreeObject>();
                int i = 0;
                while (i < this.m_treeSelection.size()) {
                    GroupTreeObject gto = this.m_treeSelection.get(i);
                    if (!(gto instanceof GroupTreeObjectLast)) {
                        userRoles.add(gto);
                    }
                    ++i;
                }
                if (userRoles.size() == 1) {
                    this.setText("Add User Role");
                } else if (userRoles.size() > 1) {
                    this.setText("Add User Roles");
                } else {
                    this.setEnabled(false);
                }
            } else {
                this.setEnabled(false);
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            UserTreeDialog.this.m_tableProvider.addUsers(this.m_treeSelection);
            UserTreeDialog.this.m_tableViewer.refresh();
        }
    }

    private class RemoveUserAction
    extends Action {
        private ArrayList<GroupTreeObject> m_tableSelection;

        public RemoveUserAction() {
            super("RemoveUserRole");
            this.m_tableSelection = null;
            this.setId("RemoveUserRole");
            this.setText("Remove User Role");
            this.m_tableSelection = UserTreeDialog.this.getTableSelection();
            if (this.m_tableSelection.size() == 1) {
                GroupTreeObject gto = this.m_tableSelection.get(0);
                if (gto instanceof GroupTreeObjectLast) {
                    this.setText("Remove User");
                } else {
                    this.setText("Remove User Role");
                }
            } else if (this.m_tableSelection.size() > 1) {
                this.setText("Remove Users/Roles");
            } else {
                this.setEnabled(false);
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            UserTreeDialog.this.m_tableProvider.removeUsers(this.m_tableSelection);
            UserTreeDialog.this.m_tableViewer.refresh();
        }
    }
}

