/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.graph;

import com.blixx.boom.gui.graph.GraphNode;
import com.blixx.shared.space.GCube;
import com.blixx.shared.space.Node;
import java.util.Comparator;
import java.util.List;
import org.eclipse.zest.layouts.Filter;
import org.eclipse.zest.layouts.InvalidLayoutConfiguration;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.LayoutEntity;
import org.eclipse.zest.layouts.LayoutRelationship;
import org.eclipse.zest.layouts.progress.ProgressListener;

public class BTreeLayout2
implements LayoutAlgorithm {
    public GCube m_cube = null;
    protected boolean layoutStopped = true;
    protected double m_entityAspectRatio = 0.0;
    protected Double m_heightOrig = null;

    public BTreeLayout2(GCube cube) {
        this.m_cube = cube;
    }

    public void setCube(GCube cube) {
        this.m_cube = cube;
    }

    public void addEntity(LayoutEntity entity) {
    }

    public void addProgressListener(ProgressListener listener) {
    }

    public void addRelationship(LayoutRelationship relationship) {
    }

    public void applyLayout(LayoutEntity[] entitiesToLayout, LayoutRelationship[] relationshipsToConsider, double x, double y, double width, double height, boolean asynchronous, boolean continuous) throws InvalidLayoutConfiguration {
        double scaleHeight = 1.0;
        if (this.m_heightOrig == null) {
            this.m_heightOrig = height;
        } else {
            scaleHeight = height / this.m_heightOrig;
        }
        this.layoutStopped = false;
        int maxElements = this.m_cube.getMaxElements();
        double height2 = 19.0;
        double width2 = 17.0;
        int shiftVertical = 50;
        int normalSize = 100;
        int maxElementsPossible = (int)(width / width2);
        LayoutEntity[] layoutEntityArray = entitiesToLayout;
        int n = entitiesToLayout.length;
        int n2 = 0;
        while (n2 < n) {
            LayoutEntity entity = layoutEntityArray[n2];
            Object obj = entity.getGraphData();
            if (obj instanceof GraphNode) {
                GraphNode gnode = (GraphNode)((Object)obj);
                if (!gnode.isDisposed()) {
                    Node node = (Node)gnode.getData();
                    double number = node.getx();
                    double level = node.gety();
                    int sizeOfLevel = this.m_cube.getSize((int)level);
                    double scale = (double)maxElementsPossible / (double)sizeOfLevel;
                    if (maxElementsPossible < maxElements) {
                        scale = (double)maxElementsPossible / (double)sizeOfLevel;
                    }
                    if (level > 999.0) {
                        level = this.m_cube.getRealSlices();
                        if (sizeOfLevel > maxElementsPossible) {
                            int shiftLevel = (int)(number / (double)maxElementsPossible);
                            level += 0.3 * (double)shiftLevel;
                            number -= (double)(shiftLevel * maxElementsPossible);
                            scale = (double)maxElementsPossible / (double)maxElementsPossible;
                            normalSize = 17;
                        }
                    }
                    if (scale > 1.0) {
                        double width3 = width2 * scale;
                        width3 = Math.min(width3, 100.0);
                        entity.setSizeInLayout(width3, height2);
                    } else {
                        entity.setSizeInLayout((double)normalSize, height2);
                    }
                    double start = (width2 + 1.0) / 2.0 * scale + number * (width2 + 1.0) * scale;
                    entity.setLocationInLayout(start += entity.getWidthInLayout() * node.getz(), level * (height2 + (double)shiftVertical * scaleHeight));
                }
            } else {
                obj.toString();
            }
            ++n2;
        }
        this.layoutStopped = true;
    }

    public double getEntityAspectRatio() {
        return 0.0;
    }

    public int getStyle() {
        return 1;
    }

    public boolean isRunning() {
        return !this.layoutStopped;
    }

    public void removeEntity(LayoutEntity entity) {
    }

    public void removeProgressListener(ProgressListener listener) {
    }

    public void removeRelationship(LayoutRelationship relationship) {
    }

    public void removeRelationships(List relationships) {
    }

    public void setComparator(Comparator comparator) {
    }

    public void setEntityAspectRatio(double ratio) {
        this.m_entityAspectRatio = ratio;
    }

    public void setFilter(Filter filter) {
    }

    public void setStyle(int style) {
    }

    public void stop() {
    }
}

