/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.graph;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.DelegatingLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.ScalableFreeformLayeredPane;
import org.eclipse.draw2d.geometry.Geometry;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class GConnection
extends Polyline
implements Connection {
    private static final Rectangle RECTANGLE_EMPTY = new Rectangle(1, 1, 1, 1);
    ConnectionAnchor source = null;
    ConnectionAnchor target = null;
    IFigure parent = null;
    PointList pointlist = new PointList(2);
    int width = 1;
    ScalableFreeformLayeredPane scp = null;
    ConnectionRouter connectionRouter = ConnectionRouter.NULL;

    public GConnection(IFigure parentF) {
        this.setLayoutManager((LayoutManager)new DelegatingLayout());
        this.pointlist.addPoint(new Point(0, 0));
        this.pointlist.addPoint(new Point(100, 100));
        this.bounds = new Rectangle(0, 0, 100, 100);
        this.parent = parentF;
        IFigure parentOfZestLayer = this.parent.getParent();
        if (parentOfZestLayer instanceof ScalableFreeformLayeredPane) {
            this.scp = (ScalableFreeformLayeredPane)parentOfZestLayer;
            this.scp.getScale();
        }
    }

    public ConnectionRouter getConnectionRouter() {
        return this.connectionRouter;
    }

    public PointList getPoints() {
        return this.pointlist;
    }

    public Object getRoutingConstraint() {
        if (this.getConnectionRouter() != null) {
            return this.getConnectionRouter().getConstraint((Connection)this);
        }
        return null;
    }

    public ConnectionAnchor getSourceAnchor() {
        this.invalidate();
        return this.source;
    }

    public ConnectionAnchor getTargetAnchor() {
        this.invalidate();
        return this.target;
    }

    public void setConnectionRouter(ConnectionRouter router) {
        this.connectionRouter = router;
    }

    public void setPoints(PointList list) {
        this.invalidate();
    }

    public void setRoutingConstraint(Object cons) {
        if (this.connectionRouter != null) {
            this.connectionRouter.setConstraint((Connection)this, cons);
        }
        this.revalidate();
    }

    public void setSourceAnchor(ConnectionAnchor anchor) {
        this.source = anchor;
        this.invalidate();
    }

    public void setTargetAnchor(ConnectionAnchor anchor) {
        this.target = anchor;
        this.invalidate();
    }

    public IFigure getParent() {
        return this.parent;
    }

    public void setParent(IFigure parent) {
        this.parent = parent;
    }

    protected void fillShape(Graphics g) {
        super.fillShape(g);
    }

    public void repaint() {
        this.invalidate();
        this.repaint(this.getBounds());
    }

    public void erase() {
        super.erase();
    }

    public void paint(Graphics graphics) {
        graphics.pushState();
        try {
            Point referencePoint = this.source.getReferencePoint();
            int delta = this.source.getOwner().getSize().height / 2;
            referencePoint.y += delta;
            this.pointlist.setPoint(referencePoint, 0);
            Point referencePoint2 = this.target.getReferencePoint();
            int delta2 = this.target.getOwner().getSize().height / 2;
            referencePoint2.y -= delta2;
            this.pointlist.setPoint(referencePoint2, 1);
            this.translateToRelative((Translatable)this.pointlist);
            graphics.setForegroundColor(this.getForegroundColor());
            graphics.drawPolygon(this.pointlist);
        }
        catch (Throwable throwable) {}
        graphics.popState();
    }

    public void revalidate() {
        this.invalidate();
        this.getUpdateManager().addInvalidFigure((IFigure)this);
    }

    public void invalidate() {
        this.setValid(false);
    }

    public void validate() {
        if (this.isValid()) {
            return;
        }
        try {
            Point referencePoint = Point.min((Point)this.source.getReferencePoint(), (Point)this.target.getReferencePoint());
            Point referencePoint2 = Point.max((Point)this.source.getReferencePoint(), (Point)this.target.getReferencePoint());
            this.bounds.setLocation(referencePoint);
            this.bounds.height = referencePoint2.y - referencePoint.y + 1;
            this.bounds.width = referencePoint2.x - referencePoint.x + 1;
            this.translateToRelative((Translatable)this.bounds);
            this.setValid(true);
            this.repaint();
        }
        catch (Throwable throwable) {}
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void setBounds(Rectangle rect) {
        super.setBounds(rect);
    }

    protected void layout() {
        super.layout();
    }

    public void setLineWidth(int w) {
    }

    public int getLineWidth() {
        return this.width;
    }

    public void setSize(int w, int h) {
        Rectangle bounds = this.getBounds();
        if (bounds.width == w && bounds.height == h) {
            return;
        }
        Rectangle r = new Rectangle(this.getBounds());
        r.setSize(w, h);
        this.setBounds(r);
    }

    public void setLocation(Point p) {
        if (this.getLocation().equals((Object)p)) {
            return;
        }
        Rectangle r = new Rectangle(this.getBounds());
        r.setLocation(p);
        this.setBounds(r);
    }

    protected boolean useLocalCoordinates() {
        return false;
    }

    public boolean containsPoint(int x, int y) {
        boolean c2 = false;
        boolean c1 = this.pointlist.getBounds().contains(x, y);
        if (c1) {
            c2 = Geometry.polylineContainsPoint((PointList)this.pointlist, (int)(x - 1), (int)(y - 1), (int)(this.width + 2));
        }
        return c2;
    }
}

