/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.graph;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.graph.GraphNode;
import com.blixx.shared.space.Node;
import com.blixx.shared.space.Separator;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ScaledGraphics;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class GraphLabel
extends Label {
    private Color borderColor;
    private int borderWidth;
    private int arcWidth;
    private GraphNode m_node;
    private boolean painting = false;

    public GraphLabel(GraphNode node) {
        this("", node);
    }

    public GraphLabel(String text, GraphNode node) {
        this("", null, node);
    }

    public GraphLabel(Image i, GraphNode node) {
        this("", i, node);
    }

    public GraphLabel(String text, Image i, GraphNode node) {
        this.m_node = node;
        this.initLabel();
        this.setText(text);
        this.setIcon(i);
        this.adjustBoundsToFit();
    }

    protected void initLabel() {
        super.setFont(Display.getDefault().getSystemFont());
        this.borderColor = ColorConstants.black;
        this.borderWidth = 0;
        this.arcWidth = 8;
        this.setLayoutManager((LayoutManager)new StackLayout());
        this.setBorder((Border)new MarginBorder(1));
    }

    public void setFont(Font f) {
        super.setFont(f);
        this.adjustBoundsToFit();
    }

    protected void adjustBoundsToFit() {
        Font font;
        int safeBorderWidth;
        String text = this.getNode().getName();
        int n = safeBorderWidth = this.borderWidth > 0 ? this.borderWidth : 1;
        if (text != null && (font = this.getFont()) != null) {
            Dimension minSize = FigureUtilities.getTextExtents((String)text, (Font)font);
            if (this.getIcon() != null) {
                org.eclipse.swt.graphics.Rectangle imageRect = this.getIcon().getBounds();
                int expandHeight = Math.max(imageRect.height - minSize.height, 0);
                minSize.expand(imageRect.width + 4, expandHeight);
            }
            minSize.expand(10 + 2 * safeBorderWidth, 4 + 2 * safeBorderWidth);
            this.setBounds(new Rectangle(this.getLocation(), minSize));
        }
    }

    public void paint(Graphics graphics) {
        if (this.m_node.isDisposed()) {
            return;
        }
        if (graphics instanceof ScaledGraphics) {
            ((ScaledGraphics)graphics).getAbsoluteScale();
        }
        Rectangle rect = this.getBounds().getCopy();
        rect.height /= 2;
        Rectangle bounds = this.getBounds();
        graphics.translate(bounds.x, bounds.y);
        Object obj = this.m_node.getData();
        if (obj instanceof Separator) {
            Separator sep = (Separator)obj;
            if (sep.getCube().isEditMode()) {
                if (this.m_node.getBackgroundColor() != null) {
                    graphics.setBackgroundColor(BMUI.color_light_yellow);
                }
                Rectangle rec = new Rectangle(1, 1, bounds.width, bounds.height);
                graphics.fillRectangle(rec);
                graphics.setForegroundColor(BMUI.color_black);
                graphics.drawRectangle(rec);
            }
        } else if (obj instanceof Node) {
            if (this.m_node.getBackgroundColor() != null) {
                Rectangle border = new Rectangle(1, 1, bounds.width, bounds.height);
                graphics.setBackgroundColor(this.m_node.getBackgroundColor());
                graphics.fillRectangle(border);
            }
            Node node = (Node)obj;
            Image icon = this.getIcon();
            if (icon == null) {
                icon = BMUI.IMAGE_FOLDER_CUT;
            }
            if (node.isStatusAvailable()) {
                graphics.setBackgroundColor(BMUI.getColor(node.getAvailability()));
                int start = 1;
                graphics.fillRectangle(start, 1, 5, 5);
                graphics.setBackgroundColor(BMUI.getColor(node.getKPI()));
                graphics.fillRectangle(start, 7, 5, 5);
                graphics.setBackgroundColor(BMUI.getColor(node.getOther()));
                graphics.fillRectangle(start, 13, 5, 5);
                graphics.drawImage(icon, new Point(start += 5, 1));
                start = BMUI.type_agt.equals(node.getType()) ? (start += icon.getBounds().width + 5) : (start += icon.getBounds().width);
                graphics.setForegroundColor(this.m_node.getForegroundColor());
                graphics.drawText(this.getNode().getName(), start, 1);
            } else {
                graphics.drawImage(icon, new Point(1, 1));
                graphics.setForegroundColor(this.m_node.getForegroundColor());
                graphics.drawText(this.getNode().getName(), icon.getBounds().width + 2, 1);
            }
        }
    }

    protected Color getBackgroundTextColor() {
        return this.getBackgroundColor();
    }

    public void invalidate() {
        if (!this.painting) {
            super.invalidate();
        }
    }

    public void setText(String s) {
        if (!s.equals("")) {
            super.setText(s);
        } else {
            super.setText("");
        }
        this.adjustBoundsToFit();
    }

    public void setIcon(Image image) {
        super.setIcon(image);
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color c) {
        this.borderColor = c;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int width) {
        this.borderWidth = width;
    }

    public int getArcWidth() {
        return this.arcWidth;
    }

    public void setArcWidth(int arcWidth) {
        this.arcWidth = arcWidth;
    }

    public void setBounds(Rectangle rect) {
        super.setBounds(rect);
    }

    public Node getNode() {
        if (this.m_node != null && !this.m_node.isDisposed()) {
            return (Node)this.m_node.getData();
        }
        return null;
    }
}

