/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.graph;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.graph.AddCustomizedIcon;
import com.blixx.boom.gui.graph.Graph;
import com.blixx.boom.gui.graph.GraphNode;
import com.blixx.shared.User;
import com.blixx.shared.space.Connection;
import com.blixx.shared.space.GCube;
import com.blixx.shared.space.Node;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.swt.graphics.Image;
import org.eclipse.zest.core.widgets.GraphConnection;
import org.eclipse.zest.core.widgets.IContainer;

public class GraphUtils {
    public static void initGraph(Graph g, GCube gcube) {
        HashMap<String, GraphNode> graphNodes = new HashMap<String, GraphNode>(gcube.m_nodes.size());
        Map<String, Node> nodes = gcube.getNodes();
        try {
            nodes.keySet().size();
            System.currentTimeMillis();
            for (String id : nodes.keySet()) {
                Node node = nodes.get(id);
                if (graphNodes.containsKey(id)) continue;
                GraphNode graphNode = GraphUtils.createGraphNode(g, node);
                graphNodes.put(id, graphNode);
            }
            Iterator it2 = graphNodes.keySet().iterator();
            System.currentTimeMillis();
            while (it2.hasNext()) {
                String id = (String)it2.next();
                GraphNode gn = (GraphNode)((Object)graphNodes.get(id));
                Node n = nodes.get(id);
                for (Connection conn : n.getTargets()) {
                    String targetID = conn.getTagetID();
                    GraphNode gnTarget = (GraphNode)((Object)graphNodes.get(targetID));
                    if (gnTarget == null) continue;
                    GraphConnection gconn = new GraphConnection(g, 0, gn, gnTarget);
                    gconn.setLineColor(BMUI.color_lightGrey);
                    gconn.setText(conn.getSubType());
                    gconn.setData(conn);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        g.commitAdded();
    }

    public static void initGraphOrig(org.eclipse.zest.core.widgets.Graph g, GCube gcube) {
        LinkedHashMap<String, org.eclipse.zest.core.widgets.GraphNode> graphNodes = new LinkedHashMap<String, org.eclipse.zest.core.widgets.GraphNode>(gcube.m_nodes.size());
        Map<String, Node> nodes = gcube.getNodes();
        try {
            for (String id : nodes.keySet()) {
                Node node = nodes.get(id);
                if (graphNodes.containsKey(id)) continue;
                org.eclipse.zest.core.widgets.GraphNode graphNode = GraphUtils.createGraphNodeOrig(g, node);
                graphNodes.put(id, graphNode);
            }
            for (String id : graphNodes.keySet()) {
                org.eclipse.zest.core.widgets.GraphNode gn = (org.eclipse.zest.core.widgets.GraphNode)((Object)graphNodes.get(id));
                Node n = nodes.get(id);
                for (Connection conn : n.getTargets()) {
                    String targetID = conn.getTagetID();
                    org.eclipse.zest.core.widgets.GraphNode gnTarget = (org.eclipse.zest.core.widgets.GraphNode)((Object)graphNodes.get(targetID));
                    if (gnTarget == null) continue;
                    GraphConnection gconn = new GraphConnection(g, 0, gn, gnTarget);
                    gconn.setLineColor(BMUI.color_lightGrey);
                    gconn.setData(conn);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        for (String key : gcube.getDataObjects().keySet()) {
            Object value = gcube.getDataObject(key);
            g.setData(key, value);
        }
        g.commitAdded();
    }

    public static GraphNode createGraphNode(Graph g, Node node) {
        GraphNode graphNode = new GraphNode((IContainer)g, 0, node.toString(), node);
        String type = node.getType();
        graphNode.setTooltip((IFigure)new Label(node.getName() + "\nType: " + type));
        graphNode.setData(node);
        if (node.getImgURL() != null && !node.getImgURL().isEmpty() && !node.getImgURL().equals("null")) {
            graphNode.setImage(GraphUtils.loadImage(node.getImgURL(), g, node.getCube(), graphNode, node));
        } else {
            graphNode.setImage(BMUI.IMAGE_MAP.get(type));
        }
        return graphNode;
    }

    private static Image loadImage(String imgURL, Graph graph, GCube cube, GraphNode parentG, Node node) {
        AddCustomizedIcon aci = new AddCustomizedIcon(graph, parentG, node);
        try {
            return aci.downloadImage(imgURL, null);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static org.eclipse.zest.core.widgets.GraphNode createGraphNodeOrig(org.eclipse.zest.core.widgets.Graph g, Node node) {
        org.eclipse.zest.core.widgets.GraphNode graphNode = new org.eclipse.zest.core.widgets.GraphNode((IContainer)g, 2, node.toString(), node);
        String type = node.getType();
        graphNode.setTooltip((IFigure)new Label(node.getName() + "\nType: " + type));
        graphNode.setSize(90.0, 16.0);
        graphNode.setData(node);
        if (type.equals(BMUI.type_user)) {
            Image image = BMUI.IMAGE_USER_OFF;
            try {
                User user = Repository.getInstance().getUserManager().getUserByLoginName(node.getName());
                if (user != null) {
                    image = Repository.getInstance().getUserManager().getUserImage(user);
                }
            }
            catch (Exception exception) {}
            graphNode.setImage(image);
        } else {
            graphNode.setImage(BMUI.IMAGE_MAP.get(type));
        }
        String active = node.getProperty("ACTIVE");
        if (active != null && active.equalsIgnoreCase("false")) {
            graphNode.setBackgroundColor(BMUI.color_light_red);
        }
        return graphNode;
    }

    public static GCube initGraphWithParents(Graph g, GCube gcube, String rootID, List<String> connType, List<String> connSubTypes) {
        GCube newCUBE = new GCube(false);
        try {
            HashMap<String, GraphNode> cache = new HashMap<String, GraphNode>();
            Node root = gcube.getNode(rootID).clone();
            root.gety();
            GraphNode rootNode = GraphUtils.createGraphNode(g, root);
            cache.put(root.getID(), rootNode);
            GraphUtils.processNode(g, gcube, connType, connSubTypes, root, rootNode, cache);
            for (String id : gcube.getConnections().keySet()) {
                if (!id.endsWith("@" + root.getID())) continue;
                Connection cc = gcube.getConnections().get(id).clone();
                Node parent = gcube.getNode(cc.getSourceID()).clone();
                GraphNode parentNode = GraphUtils.createGraphNode(g, parent);
                cache.put(parent.getID(), parentNode);
                GraphConnection gconn = new GraphConnection(g, 0, parentNode, rootNode);
                gconn.setData(cc);
            }
            for (GraphNode gn : cache.values()) {
                newCUBE.addNode((Node)gn.getData());
            }
            newCUBE.pack();
            g.commitAdded();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return newCUBE;
    }

    private static void processNode(Graph g, GCube gcube, List<String> connType, List<String> connSubTypes, Node root, GraphNode topNode, Map<String, GraphNode> graphNodes) throws CloneNotSupportedException {
        for (Connection conn : root.getTargets()) {
            String targetID;
            Node node;
            if (!connType.contains(conn.getType()) || connSubTypes.size() != 0 && !connSubTypes.contains(conn.getSubType()) || (node = gcube.getNode(targetID = conn.getTagetID())) == null) continue;
            Node target = node.clone();
            GraphNode next = null;
            if (!graphNodes.containsKey(targetID)) {
                next = GraphUtils.createGraphNode(g, target);
                graphNodes.put(targetID, next);
            } else {
                next = graphNodes.get(targetID);
            }
            GraphConnection gconn = new GraphConnection(g, 0, topNode, next);
            gconn.setData(conn);
            GraphUtils.processNode(g, gcube, connType, connSubTypes, target, next, graphNodes);
        }
    }
}

