/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.graph;

import org.eclipse.draw2d.EventDispatcher;
import org.eclipse.draw2d.GraphUpdateManager;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.SWTEventDispatcher;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class LWS
extends LightweightSystem {
    GraphUpdateManager um = null;
    Canvas innerCanvas = null;
    private EventDispatcher dispatcher;
    private int ignoreResize;

    public LWS() {
    }

    public LWS(Canvas c) {
        super(c);
        this.innerCanvas = c;
    }

    protected void addListeners() {
        EventHandler handler = new EventHandler();
        this.innerCanvas.addMouseListener((MouseListener)handler);
        this.innerCanvas.addMouseMoveListener((MouseMoveListener)handler);
        this.innerCanvas.addMouseTrackListener((MouseTrackListener)handler);
        this.innerCanvas.addTraverseListener((TraverseListener)handler);
        this.innerCanvas.addFocusListener((FocusListener)handler);
        this.innerCanvas.addDisposeListener((DisposeListener)handler);
        this.innerCanvas.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                LWS.this.controlResized();
            }
        });
        this.innerCanvas.addListener(9, new Listener(){

            public void handleEvent(Event e) {
                LWS.this.paint(e.gc);
            }
        });
    }

    public void paint(GC gc) {
        this.getUpdateManager().paint(gc);
    }

    public void setControl(Canvas c) {
        this.innerCanvas = c;
        super.setControl(c);
    }

    public GraphUpdateManager getUpdateManager() {
        if (this.um == null) {
            this.um = new GraphUpdateManager();
            this.um.setRoot(this.getRootFigure());
        }
        return this.um;
    }

    protected EventDispatcher getEventDispatcher() {
        if (this.dispatcher == null) {
            this.dispatcher = new SWTEventDispatcher();
        }
        return this.dispatcher;
    }

    public void setEventDispatcher(EventDispatcher dispatcher) {
        this.dispatcher = dispatcher;
        dispatcher.setRoot(this.getRootFigure());
        dispatcher.setControl((Control)this.innerCanvas);
    }

    protected void controlResized() {
        if (this.ignoreResize > 0) {
            return;
        }
        Rectangle r = new Rectangle(this.innerCanvas.getClientArea());
        r.setLocation(0, 0);
        this.getRootFigure().setBounds(r);
        this.getRootFigure().revalidate();
        this.getUpdateManager().performUpdate();
    }

    protected class EventHandler
    implements MouseMoveListener,
    MouseListener,
    KeyListener,
    TraverseListener,
    FocusListener,
    MouseTrackListener,
    Listener,
    DisposeListener {
        protected EventHandler() {
        }

        public void focusGained(FocusEvent e) {
            LWS.this.getEventDispatcher().dispatchFocusGained(e);
        }

        public void focusLost(FocusEvent e) {
            LWS.this.getEventDispatcher().dispatchFocusLost(e);
        }

        public void handleEvent(Event event) {
            if (event.type == 37) {
                LWS.this.getEventDispatcher().dispatchMouseWheelScrolled(event);
            }
        }

        public void keyPressed(KeyEvent e) {
            LWS.this.getEventDispatcher().dispatchKeyPressed(e);
        }

        public void keyReleased(KeyEvent e) {
            LWS.this.getEventDispatcher().dispatchKeyReleased(e);
        }

        public void keyTraversed(TraverseEvent e) {
            e.doit = true;
            LWS.this.getEventDispatcher().dispatchKeyTraversed(e);
        }

        public void mouseDoubleClick(MouseEvent e) {
            LWS.this.getEventDispatcher().dispatchMouseDoubleClicked(e);
        }

        public void mouseDown(MouseEvent e) {
            LWS.this.getEventDispatcher().dispatchMousePressed(e);
        }

        public void mouseEnter(MouseEvent e) {
            LWS.this.getEventDispatcher().dispatchMouseEntered(e);
        }

        public void mouseExit(MouseEvent e) {
            LWS.this.getEventDispatcher().dispatchMouseExited(e);
        }

        public void mouseHover(MouseEvent e) {
            LWS.this.getEventDispatcher().dispatchMouseHover(e);
        }

        public void mouseMove(MouseEvent e) {
            LWS.this.getEventDispatcher().dispatchMouseMoved(e);
        }

        public void mouseUp(MouseEvent e) {
            LWS.this.getEventDispatcher().dispatchMouseReleased(e);
        }

        public void widgetDisposed(DisposeEvent e) {
            LWS.this.getUpdateManager().dispose();
        }
    }
}

