/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.graph;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.graph.Graph;
import com.blixx.boom.gui.graph.GraphNode;
import com.blixx.boom.gui.graph.GraphUtils;
import com.blixx.shared.space.Connection;
import com.blixx.shared.space.GCube;
import com.blixx.shared.space.Node;
import java.util.UUID;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.zest.core.widgets.GraphConnection;

public class MapAddAction
extends Action {
    private GCube m_cube = null;
    GraphNode m_parentG = null;
    Node m_parent = null;
    Graph m_graph = null;
    String m_type = null;

    public MapAddAction(Graph graph, GCube cube, GraphNode parentG, Node parent, String type, String title) {
        super("addFolder" + title);
        this.setText(title);
        this.setId("AddNode" + title);
        this.m_cube = cube;
        this.m_graph = graph;
        this.m_parent = parent;
        this.m_parentG = parentG;
        this.m_type = type;
        if (this.m_parent == null || this.m_parent.gety() > 0.0 && this.m_parent.gety() >= (double)(this.m_cube.getRealSlices() - 1)) {
            this.setEnabled(false);
        }
    }

    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        double y = this.m_parent.gety() + 1.0;
        if (y >= (double)(this.m_cube.getRealSlices() - 1)) {
            this.m_cube.moveNodes(this.m_cube.getRealSlices() - 1, this.m_cube.getRealSlices());
        }
        double x = this.m_cube.getSize((int)y);
        double x1 = -1.0;
        if (this.m_parent.getTargets().size() > 0) {
            for (Connection c : this.m_parent.getTargets()) {
                String targetid = c.getTagetID();
                Node target = this.m_cube.getNode(targetid);
                if (target == null || !(Math.abs(target.gety() - y) < 1.0E-7)) continue;
                x1 = Math.max(target.getx(), x1);
            }
        }
        if (x1 >= 0.0) {
            x = x1 + 1.0;
        }
        double z = 0.0;
        String id = UUID.randomUUID().toString();
        InputDialog idd = new InputDialog(this.m_graph.getShell(), "Enter name", "Service name:", "", null);
        idd.setBlockOnOpen(true);
        idd.open();
        if (idd.getReturnCode() == 1) {
            return;
        }
        String name = idd.getValue();
        Node child = new Node(this.m_cube, id, x, y, z, name, this.m_type);
        this.m_cube.insertNode(child);
        GraphNode childG = GraphUtils.createGraphNode(this.m_graph, child);
        Connection con = this.m_parent.addTargetYplus(this.m_cube, child.getID(), "");
        GraphConnection gconn = new GraphConnection(this.m_graph, 0, this.m_parentG, childG);
        gconn.setLineColor(BMUI.color_lightGrey);
        if (con != null && con.getSubType() != null) {
            gconn.setText(con.getSubType());
        } else {
            gconn.setText("");
        }
        this.m_graph.commitAdded();
        this.m_graph.applyLayout();
        this.m_graph.getLightweightSystem().getUpdateManager().performUpdate();
    }
}

