/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.graph;

import com.blixx.boom.gui.dialogs.AttributeFilterDialog;
import com.blixx.boom.gui.graph.Graph;
import com.blixx.boom.gui.graph.GraphNode;
import com.blixx.shared.ext.ForwardFilter;
import com.blixx.shared.space.Connection;
import com.blixx.shared.space.GCube;
import java.util.Properties;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;
import org.eclipse.zest.core.widgets.GraphConnection;

public class MapAddFFilterAction
extends Action {
    private GCube m_cube = null;
    GraphNode m_parentG = null;
    GraphConnection m_connection = null;
    Graph m_graph = null;

    public MapAddFFilterAction(Graph graph, GCube cube, GraphConnection con) {
        super("EditFilterConnection");
        this.setText("Edit Filter");
        this.setId("EditFilterConnection");
        this.m_cube = cube;
        this.m_graph = graph;
        this.m_connection = con;
        if (this.m_connection == null || this.m_connection.isDisposed() || (Connection)this.m_connection.getData() == null) {
            this.setEnabled(false);
        }
    }

    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        Connection con = (Connection)this.m_connection.getData();
        AttributeFilterDialog ffd = new AttributeFilterDialog(Display.getDefault().getActiveShell(), con.getFilter());
        ffd.setBlockOnOpen(true);
        ffd.open();
        if (ffd.getReturnCode() == 0) {
            Properties p = new Properties();
            p.setProperty("FILTER_NUMBER", "1");
            p.setProperty("NAME", ffd.m_name);
            p.setProperty("DESCRIPTION", ffd.m_description);
            p.setProperty("ATTRIBUTE", ffd.m_attribute);
            p.setProperty("PATTERN", ffd.m_pattern);
            ForwardFilter ff = ForwardFilter.getInstance(p);
            con.setFilter(ff);
            this.m_connection.setData(con);
        }
        this.m_graph.applyLayout();
        this.m_graph.redraw();
    }
}

