/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.graph;

import com.blixx.boom.gui.graph.Graph;
import com.blixx.boom.gui.graph.GraphNode;
import com.blixx.shared.space.GCube;
import com.blixx.shared.space.Node;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.zest.core.widgets.GraphConnection;

public class MapDeleteAction
extends Action {
    private GCube m_cube = null;
    GraphNode m_parentG = null;
    Node m_parent = null;
    Graph m_graph = null;

    public MapDeleteAction(Graph graph, GCube cube, GraphNode parentG, Node parent) {
        super("deleteElement");
        this.setText("Delete Element");
        this.setId("DeleteElement");
        this.m_cube = cube;
        this.m_graph = graph;
        this.m_parent = parent;
        this.m_parentG = parentG;
        if (this.m_parent == null || this.m_cube == null || this.m_parent.gety() == 0.0 || this.m_parent.gety() >= (double)(this.m_cube.getRealSlices() - 1)) {
            this.setEnabled(false);
        }
    }

    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        int level = (int)this.m_parent.gety();
        this.m_cube.removeNode(this.m_parent, false);
        this.m_graph.getNodes().remove((Object)this.m_parentG);
        Set connectons = this.m_parentG.getSourceConnections().keySet();
        for (Object next : connectons) {
            if (next instanceof GraphConnection) {
                ((GraphConnection)((Object)next)).dispose();
            }
            this.m_graph.getConnections().remove(next);
        }
        connectons = this.m_parentG.getTargetConnections().keySet();
        for (Object next : connectons) {
            if (next instanceof GraphConnection) {
                ((GraphConnection)((Object)next)).dispose();
            }
            this.m_graph.getConnections().remove(next);
        }
        this.m_parentG.dispose();
        if (this.m_cube.getSize(level) == 0) {
            int i = level + 1;
            while (i < this.m_cube.getRealSlices()) {
                this.m_cube.moveNodes(i, i - 1);
                ++i;
            }
            this.m_cube.cleanLastLevel();
        }
        this.m_graph.applyLayout();
        this.m_graph.redraw();
    }
}

