/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.graph;

import com.blixx.boom.gui.graph.Graph;
import com.blixx.shared.space.Node;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.zest.core.widgets.GraphConnection;
import org.eclipse.zest.core.widgets.GraphItem;
import org.eclipse.zest.core.widgets.GraphNode;

public class MapImpactKPI
extends Action {
    private Graph m_graph = null;
    private GraphNode m_node = null;

    public MapImpactKPI(Graph graph, GraphNode node) {
        this.m_graph = graph;
        this.m_node = node;
        this.setText("Show impact (KPI)");
    }

    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.m_node == null || this.m_graph == null || this.m_graph.isDisposed() || this.m_node.isDisposed()) {
            return;
        }
        GraphNode root = this.m_node;
        ArrayList<GraphItem> toSelect = new ArrayList<GraphItem>();
        toSelect.add(root);
        Node node = (Node)this.m_node.getData();
        int status = node.getKPI();
        if (node.isStatusAvailable()) {
            this.processChildren(root, toSelect, status);
        }
        this.m_graph.setSelection(toSelect.toArray(new GraphItem[0]));
    }

    private void processChildren(GraphNode root, List<GraphItem> toSelect, int status) {
        Map connections = root.getTargetConnections();
        for (GraphConnection con : connections.keySet()) {
            GraphNode destination = con.getSource();
            Node destnode = (Node)destination.getData();
            if (!destnode.isStatusAvailable()) continue;
            toSelect.add(con);
            if (destnode.getKPI() != status) continue;
            toSelect.add(destination);
            this.processChildren(destination, toSelect, status);
        }
    }
}

