/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.graph;

import com.blixx.boom.gui.graph.BTreeLayout2;
import com.blixx.boom.gui.graph.Graph;
import com.blixx.shared.space.GCube;
import org.eclipse.jface.action.Action;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.DirectedGraphLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.HorizontalTreeLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.RadialLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.SpringLayoutAlgorithm;

public class MapLayoutSwitch
extends Action {
    private Graph m_graph = null;
    private GCube m_cube = null;
    int m_layout = 0;

    public MapLayoutSwitch(Graph graph, GCube cube, int layout) {
        this.m_graph = graph;
        this.m_cube = cube;
        this.m_layout = layout;
        switch (this.m_layout) {
            case 0: {
                this.setText("Tree Layout");
                this.setId("L" + layout);
                break;
            }
            case 1: {
                this.setText("Spring Layout");
                this.setId("L" + layout);
                break;
            }
            case 2: {
                this.setText("Radial Layout");
                this.setId("L" + layout);
                break;
            }
            case 3: {
                this.setText("Horizontal Layout");
                this.setId("L" + layout);
                break;
            }
            case 4: {
                this.setText("DirectedGraph Layout");
                this.setId("L" + layout);
                break;
            }
        }
    }

    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        switch (this.m_layout) {
            case 0: {
                this.m_graph.setLayoutAlgorithm(new BTreeLayout2(this.m_cube), true);
                break;
            }
            case 1: {
                this.m_graph.setLayoutAlgorithm((LayoutAlgorithm)new SpringLayoutAlgorithm(1), true);
                break;
            }
            case 2: {
                this.m_graph.setLayoutAlgorithm((LayoutAlgorithm)new RadialLayoutAlgorithm(1), true);
                break;
            }
            case 3: {
                this.m_graph.setLayoutAlgorithm((LayoutAlgorithm)new HorizontalTreeLayoutAlgorithm(1), true);
                break;
            }
            case 4: {
                this.m_graph.setLayoutAlgorithm((LayoutAlgorithm)new DirectedGraphLayoutAlgorithm(1), true);
                break;
            }
        }
    }
}

