/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.graph;

import com.blixx.boom.gui.graph.Graph;
import com.blixx.shared.SEventFwd;
import com.blixx.shared.ext.EventsAndStatus;
import com.blixx.shared.ext.IServiceStatus;
import com.blixx.shared.space.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.zest.core.widgets.GraphConnection;
import org.eclipse.zest.core.widgets.GraphItem;
import org.eclipse.zest.core.widgets.GraphNode;

public class MapRootCostAV
extends Action {
    private Graph m_graph = null;
    private GraphNode m_node = null;

    public MapRootCostAV(Graph graph, GraphNode node) {
        this.m_graph = graph;
        this.m_node = node;
        this.setText("Show root cause (Availability)");
    }

    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.m_node == null || this.m_graph == null || this.m_graph.isDisposed() || this.m_node.isDisposed()) {
            return;
        }
        GraphNode root = this.m_node;
        ArrayList<GraphItem> toSelect = new ArrayList<GraphItem>();
        toSelect.add(root);
        Node node = (Node)this.m_node.getData();
        if (node.isStatusAvailable()) {
            IServiceStatus iss = (IServiceStatus)node.getObject();
            Collection<SEventFwd> eventsOnTop = iss.getEvents().getEventsAV(iss.getStatusAV());
            this.processChildren(root, toSelect, iss, eventsOnTop, node.getAvailability());
        }
        this.m_graph.setSelection(toSelect.toArray(new GraphItem[0]));
    }

    private void processChildren(GraphNode root, List<GraphItem> toSelect, IServiceStatus iss, Collection<SEventFwd> eventsOnTop, int severityOnTop) {
        Map connections = root.getSourceConnections();
        for (GraphConnection con : connections.keySet()) {
            IServiceStatus issChild;
            EventsAndStatus events;
            GraphNode destination = con.getDestination();
            Node destnode = (Node)destination.getData();
            if (!destnode.isStatusAvailable() || destnode.getAvailability() < severityOnTop || (events = (issChild = (IServiceStatus)destnode.getObject()).getEvents()) == null || !events.containsOneOf(eventsOnTop)) continue;
            toSelect.add(con);
            toSelect.add(destination);
            this.processChildren(destination, toSelect, issChild, eventsOnTop, severityOnTop);
        }
    }
}

