/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.graph;

import com.blixx.boom.gui.graph.Graph;
import com.blixx.boom.gui.graph.GraphNode;
import com.blixx.boom.gui.graph.GraphUtils;
import com.blixx.shared.space.GCube;
import com.blixx.shared.space.Node;
import com.blixx.shared.space.Separator;
import org.eclipse.jface.action.Action;

public class MapShiftXAction
extends Action {
    private GCube m_cube = null;
    GraphNode m_parentG = null;
    Node m_parent = null;
    Graph m_graph = null;
    int m_inc = 0;

    public MapShiftXAction(Graph graph, GCube cube, GraphNode parentG, Node parent, int inc) {
        super("shift" + inc);
        if (inc < 0) {
            this.setText("Shift left");
            this.setAccelerator(0x1000003);
        } else {
            this.setText("Shift right");
            this.setAccelerator(0x1000004);
        }
        this.setId("Shift right " + inc);
        this.m_cube = cube;
        this.m_graph = graph;
        this.m_parent = parent;
        this.m_parentG = parentG;
        this.m_inc = inc;
        if (this.m_parent.gety() == 0.0 || this.m_parent.gety() >= (double)(this.m_cube.getRealSlices() - 1)) {
            this.setEnabled(false);
        }
    }

    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        Separator sep = this.m_cube.moveHorizontal(this.m_parent, this.m_inc);
        if (sep != null) {
            GraphUtils.createGraphNode(this.m_graph, sep);
            this.m_graph.commitAdded();
        }
        this.m_graph.applyLayout();
        this.m_graph.redraw();
    }
}

