/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.graph;

import com.blixx.boom.gui.graph.Graph;
import com.blixx.boom.gui.graph.GraphNode;
import com.blixx.boom.gui.graph.GraphUtils;
import com.blixx.shared.space.GCube;
import com.blixx.shared.space.Node;
import org.eclipse.jface.action.Action;
import org.eclipse.zest.core.widgets.GraphItem;

public class MapShiftYAction
extends Action {
    private GCube m_cube = null;
    GraphNode m_parentG = null;
    Node m_parent = null;
    Graph m_graph = null;
    int m_inc = 0;

    public MapShiftYAction(Graph graph, GCube cube, GraphNode parentG, Node parent, int inc) {
        super("shift" + inc);
        if (inc < 0) {
            this.setText("Shift up");
            this.setAccelerator(0x1000001);
        } else {
            this.setText("Shift down");
            this.setAccelerator(0x1000002);
        }
        this.setId("Shift upORdown " + inc);
        this.m_cube = cube;
        this.m_graph = graph;
        this.m_parent = parent;
        this.m_parentG = parentG;
        this.m_inc = inc;
        if (this.m_parent.gety() == 0.0 || this.m_parent.gety() >= (double)(this.m_cube.getRealSlices() - 1)) {
            this.setEnabled(false);
        }
    }

    public void run() {
        this.m_cube.moveNode(this.m_parent, this.m_inc);
        this.m_graph.clean();
        GraphUtils.initGraph(this.m_graph, this.m_cube);
        this.m_graph.applyLayout();
        GraphNode gn = this.m_graph.find(this.m_parent);
        this.m_graph.setSelection(new GraphItem[]{gn});
        this.m_graph.redraw();
    }
}

