/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.gui.graph;

import com.blixx.boom.engine.AgentCard;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.EventFilterGroup;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServiceDashBoard;
import com.blixx.boom.engine.ServiceDashBoardProvider;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.gui.dialogs.IRefreshable;
import com.blixx.boom.gui.graph.BTreeLayout2;
import com.blixx.boom.gui.graph.GraphUtils;
import com.blixx.boom.gui.graph.ServiceEditorTab;
import com.blixx.boom.gui.graph.ServiceTab;
import com.blixx.shared.space.GCube;
import com.blixx.shared.space.Node;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;

public class NodeGroupsView
extends ViewPart
implements IRefreshable,
SelectionListener {
    public static final String type_root = "root";
    public static final String type_service = "service";
    public static final String type_efg = "efg";
    public static final int VIEW_ID = 1010;
    public static final String ID = "com.blixx.boom.gui.graph.nodegroupsview";
    public static NodeGroupsView m_instance = null;
    private CTabFolder m_folder = null;
    private ServiceDashBoardProvider m_serviceProvider = null;

    public static NodeGroupsView getInstance() {
        return m_instance;
    }

    public void createPartControl(Composite parent) {
        if (Repository.getInstance().getRights(1010) < 2) {
            parent.setLayout((Layout)new GridLayout(2, false));
            Label l = new Label(parent, 0);
            l.setText(" Insufficient rights.");
            l.setForeground(BMUI.color_critical);
            Button close = new Button(parent, 8);
            close.setText("Close");
            close.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    NodeGroupsView.this.getSite().getPage().hideView(NodeGroupsView.this.getSite().getPage().findView(NodeGroupsView.ID));
                }
            });
            UIJob uiJob = new UIJob("Close Viewcom.blixx.boom.gui.graph.nodegroupsview"){

                @Override
                public IStatus runInUIThread(IProgressMonitor monitor) {
                    NodeGroupsView.this.getSite().getPage().hideView(NodeGroupsView.this.getSite().getPage().findView(NodeGroupsView.ID));
                    return Status.OK_STATUS;
                }
            };
            Repository.getUIJobManager().schedule(uiJob);
            return;
        }
        m_instance = this;
        this.m_serviceProvider = Repository.getInstance().getServiceDashBoardProvider();
        this.m_serviceProvider.loadCubeFromServer();
        this.createMapSection(parent);
        this.setTitleImage(BMUI.IMAGE_NG);
        this.m_serviceProvider.addRefreshable(this);
    }

    public void createMapSection(Composite parent) {
        try {
            this.m_folder = new CTabFolder(parent, 2816);
            this.m_folder.setSimple(true);
            this.m_folder.setBorderVisible(false);
            this.m_folder.setBackground(BMUI.color_unknown);
            this.m_folder.addSelectionListener((SelectionListener)this);
            GCube cube = this.createCube(new GCube(false));
            ServiceTab tab = new ServiceTab(this.m_folder, 0, cube);
            if (Repository.getInstance().getRights(1010) > 2) {
                ServiceEditorTab tabEdit = new ServiceEditorTab(this.m_folder, 0, null);
                tabEdit.setParentTreeView(this);
            }
            this.m_folder.setSelection((CTabItem)tab);
            this.refresh();
        }
        catch (Throwable throwable) {}
    }

    public void recreateCubeForAll() {
        CTabItem[] carr = this.m_folder.getItems();
        int i = 0;
        while (i < carr.length) {
            CTabItem ci = carr[i];
            if (ci instanceof ServiceTab && !(ci instanceof ServiceEditorTab)) {
                ServiceTab st = (ServiceTab)ci;
                this.createCube(st.getCube());
            }
            ++i;
        }
    }

    @Override
    public void refresh() {
        if (this.m_folder.isDisposed()) {
            return;
        }
        final ServiceTab tab = (ServiceTab)this.m_folder.getSelection();
        if (tab instanceof ServiceEditorTab) {
            return;
        }
        Collection<AgentCard> agentTree = Repository.getInstance().getAgentCards();
        if (agentTree.size() == 0) {
            UIJob uijob = new UIJob(Display.getDefault(), "createST"){

                @Override
                public IStatus runInUIThread(IProgressMonitor monitor) {
                    NodeGroupsView.this.refresh();
                    return Status.OK_STATUS;
                }
            };
            Repository.getUIJobManager().schedule(uijob);
            return;
        }
        if (tab.getGraph() == null || tab.getGraph().getNodes().size() == 0) {
            this.createCube(tab.getCube());
            tab.createGraph();
        } else {
            Job job = new Job("GCube update"){

                protected IStatus run(IProgressMonitor monitor) {
                    GCube nc = new GCube(false);
                    NodeGroupsView.this.createCube(nc);
                    if (tab.getCube().getConnections().size() != nc.getConnections().size() || tab.getCube().getNodes().size() != nc.getNodes().size()) {
                        tab.getCube().updateFrom(nc);
                        UIJob uijob = new UIJob(Display.getDefault(), "mergeGraph"){

                            @Override
                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                tab.getGraph().setVisible(false);
                                tab.getGraph().clean();
                                BTreeLayout2 layout = new BTreeLayout2(tab.getCube());
                                tab.getGraph().setLayoutAlgorithm(layout, true);
                                GraphUtils.initGraph(tab.getGraph(), tab.getCube());
                                tab.getGraph().setVisible(true);
                                return Status.OK_STATUS;
                            }
                        };
                        Repository.getUIJobManager().schedule(uijob);
                    } else {
                        tab.getCube().invalidateStatuses();
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        tab.getGraph().setVisible(false);
        tab.getGraph().setVisible(true);
    }

    private GCube createCube(GCube cube) {
        if (cube == null) {
            cube = new GCube(false);
        }
        cube.clear();
        this.m_serviceProvider.initCube(cube);
        Map<String, ServiceDashBoard> services = Repository.getInstance().getServiceDashBoardProvider().getServices();
        Iterator<Map.Entry<String, ServiceDashBoard>> its = services.entrySet().iterator();
        int x = -1;
        int x2 = -1;
        int y = cube.getRealSlices();
        while (its.hasNext()) {
            ServiceDashBoard sdb = its.next().getValue();
            Node node = new Node(cube, sdb.getID(), ++x, y, 0.0, sdb.getName(), type_service);
            node.setObject(sdb);
            cube.addNode(node);
            Map<String, EventFilterGroup> m2 = sdb.getFilters();
            for (String filterName : m2.keySet()) {
                EventFilterGroup efg = m2.get(filterName);
                Node node1 = new Node(cube, "Service:" + sdb.getName() + ":EFG:" + efg.getName(), ++x2, y + 1, 0.0, efg.getName(), type_efg);
                node1.setObject(efg);
                cube.addNode(node1);
                node.addTargetYplus(cube, node1.getID(), "contains");
                for (String agentID : efg.getImpactedAgents()) {
                    node1.addTargetYplus(cube, agentID, "related");
                }
            }
        }
        for (AgentCard ac : Repository.getInstance().getAgentCards()) {
            Node acnode = new Node(cube, ac.getAgentID(), -1.0, 0.0, 0.0, ac.toString(), BMUI.type_agt);
            acnode.setObject(ac);
            cube.addNode(acnode);
        }
        return cube;
    }

    public void setFocus() {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Object o = e.getSource();
        if (o instanceof CTabFolder) {
            CTabItem ci = this.m_folder.getSelection();
            if (ci instanceof ServiceEditorTab) {
                ServiceEditorTab set = (ServiceEditorTab)ci;
                set.m_graph.applyLayout();
            } else if (ci instanceof ServiceTab) {
                this.refresh();
            }
        }
    }
}

